/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.WordTag;
import edu.stanford.nlp.process.Morphology;
import edu.stanford.nlp.trees.DiskTreebank;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeVisitor;

public class WordStemmer
implements TreeVisitor {
    private Morphology morpha = new Morphology();

    public void visitTree(Tree t) {
        this.processTree(t, null);
    }

    private void processTree(Tree t, String tag) {
        if (t.isPreTerminal()) {
            tag = t.label().value();
        }
        if (t.isLeaf()) {
            WordTag wt = this.morpha.stem(t.label().value(), tag);
            t.label().setValue(wt.word());
        } else {
            for (Tree kid : t.children()) {
                this.processTree(kid, tag);
            }
        }
    }

    public static void main(String[] args) {
        DiskTreebank treebank = new DiskTreebank();
        treebank.loadPath(args[0]);
        WordStemmer ls = new WordStemmer();
        for (Tree tree : treebank) {
            ls.visitTree(tree);
            System.out.println(tree);
        }
    }
}

