/*
This file is part of Ext JS 3.4

Copyright (c) 2011-2013 Sencha Inc

Contact:  http://www.sencha.com/contact

GNU General Public License Usage
This file may be used under the terms of the GNU General Public License version 3.0 as
published by the Free Software Foundation and appearing in the file LICENSE included in the
packaging of this file.

Please review the following information to ensure the GNU General Public License version 3.0
requirements will be met: http://www.gnu.org/copyleft/gpl.html.

If you are unsure which license is appropriate for your use, please contact the sales department
at http://www.sencha.com/contact.

Build date: 2013-04-03 15:07:25
*/
Ext.data.JsonP.Ext_util_MixedCollection({"alternateClassNames":[],"aliases":{},"enum":null,"parentMixins":[],"tagname":"class","subclasses":["Ext.StoreMgr"],"extends":"Ext.util.Observable","uses":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='docClass'>Ext.util.Observable</a><div class='subclass '><strong>Ext.util.MixedCollection</strong></div></div><h4>Subclasses</h4><div class='dependency'><a href='#!/api/Ext.StoreMgr' rel='Ext.StoreMgr' class='docClass'>Ext.StoreMgr</a></div><h4>Files</h4><div class='dependency'><a href='source/MixedCollection.html#Ext-util-MixedCollection' target='_blank'>MixedCollection.js</a></div></pre><div class='doc-contents'><p>A Collection class that maintains both numeric indexes and keys and exposes events.</p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-allowFunctions' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.util.MixedCollection'>Ext.util.MixedCollection</span><br/><a href='source/MixedCollection.html#Ext-util-MixedCollection-cfg-allowFunctions' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.MixedCollection-cfg-allowFunctions' class='name expandable'>allowFunctions</a><span> : Boolean</span></div><div class='description'><div class='short'>Specify true if the addAll\nfunction should add function references to the collection. ...</div><div class='long'><p>Specify <tt>true</tt> if the <a href=\"#!/api/Ext.util.MixedCollection-method-addAll\" rel=\"Ext.util.MixedCollection-method-addAll\" class=\"docClass\">addAll</a>\nfunction should add function references to the collection. Defaults to\n<tt>false</tt>.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-listeners' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-cfg-listeners' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-cfg-listeners' class='name expandable'>listeners</a><span> : Object</span></div><div class='description'><div class='short'>(optional) A config object containing one or more event handlers to be added to this\nobject during initialization. ...</div><div class='long'><p>(optional) <p>A config object containing one or more event handlers to be added to this\nobject during initialization.  This should be a valid listeners config object as specified in the\n<a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a> example for attaching multiple handlers at once.</p></p>\n\n<br><p><b><u>DOM events from ExtJs <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Components</a></u></b></p>\n\n\n<br><p>While <i>some</i> ExtJs Component classes export selected DOM events (e.g. \"click\", \"mouseover\" etc), this\n\n\n<p>is usually only done when extra value can be added. For example the <a href=\"#!/api/Ext.DataView\" rel=\"Ext.DataView\" class=\"docClass\">DataView</a>'s\n<b><code><a href=\"#!/api/Ext.DataView-event-click\" rel=\"Ext.DataView-event-click\" class=\"docClass\">click</a></code></b> event passing the node clicked on. To access DOM\nevents directly from a Component's HTMLElement, listeners must be added to the <i><a href=\"#!/api/Ext.Component-method-getEl\" rel=\"Ext.Component-method-getEl\" class=\"docClass\">Element</a></i> after the Component\nhas been rendered. A plugin can simplify this step:</p>\n\n<pre><code>// Plugin is configured with a listeners config object.\n// The Component is appended to the argument list of all handler functions.\nExt.DomObserver = <a href=\"#!/api/Ext-method-extend\" rel=\"Ext-method-extend\" class=\"docClass\">Ext.extend</a>(Object, {\n    constructor: function(config) {\n        this.listeners = config.listeners ? config.listeners : config;\n    },\n\n    // Component passes itself into plugin&#39;s init method\n    init: function(c) {\n        var p, l = this.listeners;\n        for (p in l) {\n            if (<a href=\"#!/api/Ext-method-isFunction\" rel=\"Ext-method-isFunction\" class=\"docClass\">Ext.isFunction</a>(l[p])) {\n                l[p] = this.createHandler(l[p], c);\n            } else {\n                l[p].fn = this.createHandler(l[p].fn, c);\n            }\n        }\n\n        // Add the listeners to the Element immediately following the render call\n        c.render = c.render.<a href=\"#!/api/Function-method-createSequence\" rel=\"Function-method-createSequence\" class=\"docClass\">createSequence</a>(function() {\n            var e = c.getEl();\n            if (e) {\n                e.on(l);\n            }\n        });\n    },\n\n    createHandler: function(fn, c) {\n        return function(e) {\n            fn.call(this, e, c);\n        };\n    }\n});\n\nvar combo = new <a href=\"#!/api/Ext.form.ComboBox\" rel=\"Ext.form.ComboBox\" class=\"docClass\">Ext.form.ComboBox</a>({\n\n    // Collapse combo when its element is clicked on\n    plugins: [ new Ext.DomObserver({\n        click: function(evt, comp) {\n            comp.collapse();\n        }\n    })],\n    store: myStore,\n    typeAhead: true,\n    mode: 'local',\n    triggerAction: 'all'\n});\n</code></pre>\n\n\n<p></p></p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-constructor' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.util.MixedCollection'>Ext.util.MixedCollection</span><br/><a href='source/MixedCollection.html#Ext-util-MixedCollection-method-constructor' target='_blank' class='view-source'>view source</a></div><strong class='new-keyword'>new</strong><a href='#!/api/Ext.util.MixedCollection-method-constructor' class='name expandable'>Ext.util.MixedCollection</a>( <span class='pre'>allowFunctions, keyFn</span> ) : <a href=\"#!/api/Ext.util.MixedCollection\" rel=\"Ext.util.MixedCollection\" class=\"docClass\">Ext.util.MixedCollection</a></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>allowFunctions</span> : Boolean<div class='sub-desc'><p>Specify <tt>true</tt> if the <a href=\"#!/api/Ext.util.MixedCollection-method-addAll\" rel=\"Ext.util.MixedCollection-method-addAll\" class=\"docClass\">addAll</a>\nfunction should add function references to the collection. Defaults to\n<tt>false</tt>.</p>\n</div></li><li><span class='pre'>keyFn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>A function that can accept an item of the type(s) stored in this MixedCollection\nand return the key value for that item.  This is used when available to look up the key on items that\nwere passed without an explicit key parameter to a MixedCollection method.  Passing this parameter is\nequivalent to providing an implementation for the <a href=\"#!/api/Ext.util.MixedCollection-method-getKey\" rel=\"Ext.util.MixedCollection-method-getKey\" class=\"docClass\">getKey</a> method.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.util.MixedCollection\" rel=\"Ext.util.MixedCollection\" class=\"docClass\">Ext.util.MixedCollection</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-_sort' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.util.MixedCollection'>Ext.util.MixedCollection</span><br/><a href='source/MixedCollection.html#Ext-util-MixedCollection-method-_sort' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.MixedCollection-method-_sort' class='name expandable'>_sort</a>( <span class='pre'>property, [dir], [fn]</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>Performs the actual sorting based on a direction and a sorting function. ...</div><div class='long'><p>Performs the actual sorting based on a direction and a sorting function. Internally,\nthis creates a temporary array of all items in the MixedCollection, sorts it and then writes\nthe sorted array data back into this.items and this.keys</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>property</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>Property to sort by ('key', 'value', or 'index')</p>\n</div></li><li><span class='pre'>dir</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>Direction to sort 'ASC' or 'DESC'. Defaults to 'ASC'.</p>\n</div></li><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> (optional)<div class='sub-desc'><p>Comparison function that defines the sort order.\nDefaults to sorting by numeric value.</p>\n</div></li></ul></div></div></div><div id='method-add' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.util.MixedCollection'>Ext.util.MixedCollection</span><br/><a href='source/MixedCollection.html#Ext-util-MixedCollection-method-add' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.MixedCollection-method-add' class='name expandable'>add</a>( <span class='pre'>key, o</span> ) : Object</div><div class='description'><div class='short'>Adds an item to the collection. ...</div><div class='long'><p>Adds an item to the collection. Fires the <a href=\"#!/api/Ext.util.MixedCollection-method-add\" rel=\"Ext.util.MixedCollection-method-add\" class=\"docClass\">add</a> event when complete.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>key</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The key to associate with the item, or the new item.</p>\n\n\n<p>If a <a href=\"#!/api/Ext.util.MixedCollection-method-getKey\" rel=\"Ext.util.MixedCollection-method-getKey\" class=\"docClass\">getKey</a> implementation was specified for this MixedCollection,\nor if the key of the stored items is in a property called <tt><b>id</b></tt>,\nthe MixedCollection will be able to <i>derive</i> the key for the new item.\nIn this case just pass the new item in this parameter.</p>\n\n</div></li><li><span class='pre'>o</span> : Object<div class='sub-desc'><p>The item to add.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>The item added.</p>\n</div></li></ul></div></div></div><div id='method-addAll' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.util.MixedCollection'>Ext.util.MixedCollection</span><br/><a href='source/MixedCollection.html#Ext-util-MixedCollection-method-addAll' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.MixedCollection-method-addAll' class='name expandable'>addAll</a>( <span class='pre'>objs</span> )</div><div class='description'><div class='short'>Adds all elements of an Array or an Object to the collection. ...</div><div class='long'><p>Adds all elements of an Array or an Object to the collection.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objs</span> : Object/<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>An Object containing properties which will be added\nto the collection, or an Array of values, each of which are added to the collection.\nFunctions references will be added to the collection if <code><a href=\"#!/api/Ext.util.MixedCollection-cfg-allowFunctions\" rel=\"Ext.util.MixedCollection-cfg-allowFunctions\" class=\"docClass\">allowFunctions</a></code>\nhas been set to <tt>true</tt>.</p>\n</div></li></ul></div></div></div><div id='method-addEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-addEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-addEvents' class='name expandable'>addEvents</a>( <span class='pre'>o, Optional</span> )</div><div class='description'><div class='short'>Adds the specified events to the list of events which this Observable may fire. ...</div><div class='long'><p>Adds the specified events to the list of events which this Observable may fire.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>o</span> : Object|<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>Either an object with event names as properties with a value of <code>true</code>\nor the first event name string if multiple event names are being passed as separate parameters.</p>\n</div></li><li><span class='pre'>Optional</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">string</a><div class='sub-desc'><p>. Event name if multiple event names are being passed as separate parameters.\nUsage:</p>\n\n<pre><code>this.addEvents('storeloaded', 'storecleared');\n</code></pre>\n\n</div></li></ul></div></div></div><div id='method-addListener' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-addListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-addListener' class='name expandable'>addListener</a>( <span class='pre'>eventName, handler, [scope], [options]</span> )</div><div class='description'><div class='short'>Appends an event handler to this object. ...</div><div class='long'><p>Appends an event handler to this object.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the event to listen for.</p>\n</div></li><li><span class='pre'>handler</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The method the event invokes.</p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope (<code><b>this</b></code> reference) in which the handler function is executed.\n<b>If omitted, defaults to the object which fired the event.</b></p>\n</div></li><li><span class='pre'>options</span> : Object (optional)<div class='sub-desc'><p>An object containing handler configuration.\nproperties. This may contain any of the following properties:<ul>\n<li><b>scope</b> : Object<div class=\"sub-desc\">The scope (<code><b>this</b></code> reference) in which the handler function is executed.\n<b>If omitted, defaults to the object which fired the event.</b></div></li>\n<li><b>delay</b> : Number<div class=\"sub-desc\">The number of milliseconds to delay the invocation of the handler after the event fires.</div></li>\n<li><b>single</b> : Boolean<div class=\"sub-desc\">True to add a handler to handle just the next firing of the event, and then remove itself.</div></li>\n<li><b>buffer</b> : Number<div class=\"sub-desc\">Causes the handler to be scheduled to run in an <a href=\"#!/api/Ext.util.DelayedTask\" rel=\"Ext.util.DelayedTask\" class=\"docClass\">Ext.util.DelayedTask</a> delayed\nby the specified number of milliseconds. If the event fires again within that time, the original\nhandler is <em>not</em> invoked, but the new handler is scheduled in its place.</div></li>\n<li><b>target</b> : Observable<div class=\"sub-desc\">Only call the handler if the event was fired on the target Observable, <i>not</i>\nif the event was bubbled up from a child Observable.</div></li>\n</ul><br></p>\n\n<p>\n<b>Combining Options</b><br>\nUsing the options argument, it is possible to combine different types of listeners:<br>\n<br>\nA delayed, one-time listener.\n<pre><code>myDataView.on('click', this.onClick, this, {\nsingle: true,\ndelay: 100\n});</code></pre>\n<p>\n<b>Attaching multiple handlers in 1 call</b><br>\nThe method also allows for a single argument to be passed which is a config object containing properties\nwhich specify multiple handlers.\n<p>\n<pre><code>myGridPanel.on({\n'click' : {\n    fn: this.onClick,\n    scope: this,\n    delay: 100\n},\n'mouseover' : {\n    fn: this.onMouseOver,\n    scope: this\n},\n'mouseout' : {\n    fn: this.onMouseOut,\n    scope: this\n}\n});</code></pre>\n<p>\nOr a shorthand syntax:<br>\n<pre><code>myGridPanel.on({\n'click' : this.onClick,\n'mouseover' : this.onMouseOver,\n'mouseout' : this.onMouseOut,\n scope: this\n});</code></pre>\n\n</p></p></p></p></div></li></ul></div></div></div><div id='method-clear' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.util.MixedCollection'>Ext.util.MixedCollection</span><br/><a href='source/MixedCollection.html#Ext-util-MixedCollection-method-clear' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.MixedCollection-method-clear' class='name expandable'>clear</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Removes all items from the collection. ...</div><div class='long'><p>Removes all items from the collection.  Fires the <a href=\"#!/api/Ext.util.MixedCollection-method-clear\" rel=\"Ext.util.MixedCollection-method-clear\" class=\"docClass\">clear</a> event when complete.</p>\n</div></div></div><div id='method-clone' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.util.MixedCollection'>Ext.util.MixedCollection</span><br/><a href='source/MixedCollection.html#Ext-util-MixedCollection-method-clone' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.MixedCollection-method-clone' class='name expandable'>clone</a>( <span class='pre'></span> ) : MixedCollection</div><div class='description'><div class='short'>Creates a shallow copy of this collection ...</div><div class='long'><p>Creates a shallow copy of this collection</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>MixedCollection</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-contains' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.util.MixedCollection'>Ext.util.MixedCollection</span><br/><a href='source/MixedCollection.html#Ext-util-MixedCollection-method-contains' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.MixedCollection-method-contains' class='name expandable'>contains</a>( <span class='pre'>o</span> ) : Boolean</div><div class='description'><div class='short'>Returns true if the collection contains the passed Object as an item. ...</div><div class='long'><p>Returns true if the collection contains the passed Object as an item.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>o</span> : Object<div class='sub-desc'><p>The Object to look for in the collection.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>True if the collection contains the Object as an item.</p>\n</div></li></ul></div></div></div><div id='method-containsKey' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.util.MixedCollection'>Ext.util.MixedCollection</span><br/><a href='source/MixedCollection.html#Ext-util-MixedCollection-method-containsKey' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.MixedCollection-method-containsKey' class='name expandable'>containsKey</a>( <span class='pre'>key</span> ) : Boolean</div><div class='description'><div class='short'>Returns true if the collection contains the passed Object as a key. ...</div><div class='long'><p>Returns true if the collection contains the passed Object as a key.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>key</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The key to look for in the collection.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>True if the collection contains the Object as a key.</p>\n</div></li></ul></div></div></div><div id='method-createValueMatcher' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.util.MixedCollection'>Ext.util.MixedCollection</span><br/><a href='source/MixedCollection.html#Ext-util-MixedCollection-method-createValueMatcher' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.MixedCollection-method-createValueMatcher' class='name expandable'>createValueMatcher</a>( <span class='pre'>value, anyMatch, caseSensitive, exactMatch</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>Returns a regular expression based on the given value and matching options. ...</div><div class='long'><p>Returns a regular expression based on the given value and matching options. This is used internally for finding and filtering,\nand by <a href=\"#!/api/Ext.data.Store-method-filter\" rel=\"Ext.data.Store-method-filter\" class=\"docClass\">Ext.data.Store.filter</a></p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The value to create the regex for. This is escaped using <a href=\"#!/api/Ext-method-escapeRe\" rel=\"Ext-method-escapeRe\" class=\"docClass\">Ext.escapeRe</a></p>\n</div></li><li><span class='pre'>anyMatch</span> : Boolean<div class='sub-desc'><p>True to allow any match - no regex start/end line anchors will be added. Defaults to false</p>\n</div></li><li><span class='pre'>caseSensitive</span> : Boolean<div class='sub-desc'><p>True to make the regex case sensitive (adds 'i' switch to regex). Defaults to false.</p>\n</div></li><li><span class='pre'>exactMatch</span> : Boolean<div class='sub-desc'><p>True to force exact match (^ and $ characters added to the regex). Defaults to false. Ignored if anyMatch is true.</p>\n</div></li></ul></div></div></div><div id='method-each' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.util.MixedCollection'>Ext.util.MixedCollection</span><br/><a href='source/MixedCollection.html#Ext-util-MixedCollection-method-each' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.MixedCollection-method-each' class='name expandable'>each</a>( <span class='pre'>fn, [scope]</span> )</div><div class='description'><div class='short'>Executes the specified function once for every item in the collection, passing the following arguments:\n\n\nitem : Mixe...</div><div class='long'><p>Executes the specified function once for every item in the collection, passing the following arguments:</p>\n\n<div class=\"mdetail-params\"><ul>\n<li><b>item</b> : Mixed<p class=\"sub-desc\">The collection item</p></li>\n<li><b>index</b> : Number<p class=\"sub-desc\">The item's index</p></li>\n<li><b>length</b> : Number<p class=\"sub-desc\">The total number of items in the collection</p></li>\n</ul></div>\n\n\n<p>The function should return a boolean value. Returning false from the function will stop the iteration.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The function to execute for each item.</p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope (<code>this</code> reference) in which the function is executed. Defaults to the current item in the iteration.</p>\n</div></li></ul></div></div></div><div id='method-eachKey' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.util.MixedCollection'>Ext.util.MixedCollection</span><br/><a href='source/MixedCollection.html#Ext-util-MixedCollection-method-eachKey' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.MixedCollection-method-eachKey' class='name expandable'>eachKey</a>( <span class='pre'>fn, [scope]</span> )</div><div class='description'><div class='short'>Executes the specified function once for every key in the collection, passing each\nkey, and its associated item as th...</div><div class='long'><p>Executes the specified function once for every key in the collection, passing each\nkey, and its associated item as the first two parameters.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The function to execute for each item.</p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope (<code>this</code> reference) in which the function is executed. Defaults to the browser window.</p>\n</div></li></ul></div></div></div><div id='method-enableBubble' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable-more.html#Ext-util-Observable-method-enableBubble' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-enableBubble' class='name expandable'>enableBubble</a>( <span class='pre'>events</span> )</div><div class='description'><div class='short'>Enables events fired by this Observable to bubble up an owner hierarchy by calling\nthis.getBubbleTarget() if present. ...</div><div class='long'><p>Enables events fired by this Observable to bubble up an owner hierarchy by calling\n<code>this.getBubbleTarget()</code> if present. There is no implementation in the Observable base class.</p>\n\n\n<p>This is commonly used by Ext.Components to bubble events to owner Containers. See Ext.Component.getBubbleTarget. The default\nimplementation in <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> returns the Component's immediate owner. But if a known target is required, this can be overridden to\naccess the required target more quickly.</p>\n\n\n<p>Example:</p>\n\n\n<pre><code><a href=\"#!/api/Ext-method-override\" rel=\"Ext-method-override\" class=\"docClass\">Ext.override</a>(<a href=\"#!/api/Ext.form.Field\" rel=\"Ext.form.Field\" class=\"docClass\">Ext.form.Field</a>, {\n    //  Add functionality to Field&#39;s initComponent to enable the change event to bubble\n    initComponent : Ext.form.Field.prototype.initComponent.createSequence(function() {\n        this.enableBubble('change');\n    }),\n\n    //  We know that we want Field&#39;s events to bubble directly to the FormPanel.\n    getBubbleTarget : function() {\n        if (!this.formPanel) {\n            this.formPanel = this.findParentByType('form');\n        }\n        return this.formPanel;\n    }\n});\n\nvar myForm = new Ext.formPanel({\n    title: 'User Details',\n    items: [{\n        ...\n    }],\n    listeners: {\n        change: function() {\n            // Title goes red if form has been modified.\n            myForm.header.setStyle('color', 'red');\n        }\n    }\n});\n</code></pre>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>events</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>The event name to bubble, or an Array of event names.</p>\n</div></li></ul></div></div></div><div id='method-filter' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.util.MixedCollection'>Ext.util.MixedCollection</span><br/><a href='source/MixedCollection.html#Ext-util-MixedCollection-method-filter' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.MixedCollection-method-filter' class='name expandable'>filter</a>( <span class='pre'>property, value, [anyMatch], [caseSensitive]</span> ) : MixedCollection</div><div class='description'><div class='short'>Filter the objects in this collection by a specific property. ...</div><div class='long'><p>Filter the <i>objects</i> in this collection by a specific property.\nReturns a new collection that has been filtered.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>property</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>A property on your objects</p>\n</div></li><li><span class='pre'>value</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/RegExp<div class='sub-desc'><p>Either string that the property values\nshould start with or a RegExp to test against the property</p>\n</div></li><li><span class='pre'>anyMatch</span> : Boolean (optional)<div class='sub-desc'><p>True to match any part of the string, not just the beginning</p>\n</div></li><li><span class='pre'>caseSensitive</span> : Boolean (optional)<div class='sub-desc'><p>True for case sensitive comparison (defaults to False).</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>MixedCollection</span><div class='sub-desc'><p>The new filtered collection</p>\n</div></li></ul></div></div></div><div id='method-filterBy' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.util.MixedCollection'>Ext.util.MixedCollection</span><br/><a href='source/MixedCollection.html#Ext-util-MixedCollection-method-filterBy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.MixedCollection-method-filterBy' class='name expandable'>filterBy</a>( <span class='pre'>fn, [scope]</span> ) : MixedCollection</div><div class='description'><div class='short'>Filter by a function. ...</div><div class='long'><p>Filter by a function. Returns a <i>new</i> collection that has been filtered.\nThe passed function will be called with each object in the collection.\nIf the function returns true, the value is included otherwise it is filtered.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The function to be called, it will receive the args o (the object), k (the key)</p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope (<code>this</code> reference) in which the function is executed. Defaults to this MixedCollection.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>MixedCollection</span><div class='sub-desc'><p>The new filtered collection</p>\n</div></li></ul></div></div></div><div id='method-find' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.util.MixedCollection'>Ext.util.MixedCollection</span><br/><a href='source/MixedCollection.html#Ext-util-MixedCollection-method-find' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.MixedCollection-method-find' class='name expandable'>find</a>( <span class='pre'>fn, [scope]</span> ) : Object</div><div class='description'><div class='short'>Returns the first item in the collection which elicits a true return value from the\npassed selection function. ...</div><div class='long'><p>Returns the first item in the collection which elicits a true return value from the\npassed selection function.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The selection function to execute for each item.</p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope (<code>this</code> reference) in which the function is executed. Defaults to the browser window.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>The first item in the collection which returned true from the selection function.</p>\n</div></li></ul></div></div></div><div id='method-findIndex' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.util.MixedCollection'>Ext.util.MixedCollection</span><br/><a href='source/MixedCollection.html#Ext-util-MixedCollection-method-findIndex' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.MixedCollection-method-findIndex' class='name expandable'>findIndex</a>( <span class='pre'>property, value, [start], [anyMatch], [caseSensitive]</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Finds the index of the first matching object in this collection by a specific property/value. ...</div><div class='long'><p>Finds the index of the first matching object in this collection by a specific property/value.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>property</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of a property on your objects.</p>\n</div></li><li><span class='pre'>value</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/RegExp<div class='sub-desc'><p>A string that the property values\nshould start with or a RegExp to test against the property.</p>\n</div></li><li><span class='pre'>start</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> (optional)<div class='sub-desc'><p>The index to start searching at (defaults to 0).</p>\n</div></li><li><span class='pre'>anyMatch</span> : Boolean (optional)<div class='sub-desc'><p>True to match any part of the string, not just the beginning.</p>\n</div></li><li><span class='pre'>caseSensitive</span> : Boolean (optional)<div class='sub-desc'><p>True for case sensitive comparison.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>The matched index or -1</p>\n</div></li></ul></div></div></div><div id='method-findIndexBy' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.util.MixedCollection'>Ext.util.MixedCollection</span><br/><a href='source/MixedCollection.html#Ext-util-MixedCollection-method-findIndexBy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.MixedCollection-method-findIndexBy' class='name expandable'>findIndexBy</a>( <span class='pre'>fn, [scope], [start]</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Find the index of the first matching object in this collection by a function. ...</div><div class='long'><p>Find the index of the first matching object in this collection by a function.\nIf the function returns <i>true</i> it is considered a match.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The function to be called, it will receive the args o (the object), k (the key).</p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope (<code>this</code> reference) in which the function is executed. Defaults to this MixedCollection.</p>\n</div></li><li><span class='pre'>start</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> (optional)<div class='sub-desc'><p>The index to start searching at (defaults to 0).</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>The matched index or -1</p>\n</div></li></ul></div></div></div><div id='method-fireEvent' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-fireEvent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-fireEvent' class='name expandable'>fireEvent</a>( <span class='pre'>eventName, args</span> ) : Boolean</div><div class='description'><div class='short'>Fires the specified event with the passed parameters (minus the event name). ...</div><div class='long'><p>Fires the specified event with the passed parameters (minus the event name).</p>\n\n\n<p>An event may be set to bubble up an Observable parent hierarchy (See <a href=\"#!/api/Ext.Component-method-getBubbleTarget\" rel=\"Ext.Component-method-getBubbleTarget\" class=\"docClass\">Ext.Component.getBubbleTarget</a>)\nby calling <a href=\"#!/api/Ext.util.Observable-method-enableBubble\" rel=\"Ext.util.Observable-method-enableBubble\" class=\"docClass\">enableBubble</a>.</p>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the event to fire.</p>\n</div></li><li><span class='pre'>args</span> : Object...<div class='sub-desc'><p>Variable number of parameters are passed to handlers.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>returns false if any of the handlers return false otherwise it returns true.</p>\n</div></li></ul></div></div></div><div id='method-first' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.util.MixedCollection'>Ext.util.MixedCollection</span><br/><a href='source/MixedCollection.html#Ext-util-MixedCollection-method-first' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.MixedCollection-method-first' class='name expandable'>first</a>( <span class='pre'></span> ) : Object</div><div class='description'><div class='short'>Returns the first item in the collection. ...</div><div class='long'><p>Returns the first item in the collection.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>the first item in the collection..</p>\n</div></li></ul></div></div></div><div id='method-get' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.util.MixedCollection'>Ext.util.MixedCollection</span><br/><a href='source/MixedCollection.html#Ext-util-MixedCollection-method-get' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.MixedCollection-method-get' class='name expandable'>get</a>( <span class='pre'>key</span> ) : Object</div><div class='description'><div class='short'>This method calls item(). ...</div><div class='long'><p>This method calls <a href=\"#!/api/Ext.util.MixedCollection-method-item\" rel=\"Ext.util.MixedCollection-method-item\" class=\"docClass\">item()</a>.\nReturns the item associated with the passed key OR index. Key has priority\nover index.  This is the equivalent of calling <a href=\"#!/api/Ext.util.MixedCollection-method-key\" rel=\"Ext.util.MixedCollection-method-key\" class=\"docClass\">key</a> first, then if\nnothing matched calling <a href=\"#!/api/Ext.util.MixedCollection-method-itemAt\" rel=\"Ext.util.MixedCollection-method-itemAt\" class=\"docClass\">itemAt</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>key</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The key or index of the item.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>If the item is found, returns the item.  If the item was\nnot found, returns <tt>undefined</tt>. If an item was found, but is a Class,\nreturns <tt>null</tt>.</p>\n</div></li></ul></div></div></div><div id='method-getCount' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.util.MixedCollection'>Ext.util.MixedCollection</span><br/><a href='source/MixedCollection.html#Ext-util-MixedCollection-method-getCount' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.MixedCollection-method-getCount' class='name expandable'>getCount</a>( <span class='pre'></span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Returns the number of items in the collection. ...</div><div class='long'><p>Returns the number of items in the collection.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>the number of items in the collection.</p>\n</div></li></ul></div></div></div><div id='method-getKey' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.util.MixedCollection'>Ext.util.MixedCollection</span><br/><a href='source/MixedCollection.html#Ext-util-MixedCollection-method-getKey' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.MixedCollection-method-getKey' class='name expandable'>getKey</a>( <span class='pre'>item</span> ) : Object</div><div class='description'><div class='short'>MixedCollection has a generic way to fetch keys if you implement getKey. ...</div><div class='long'><p>MixedCollection has a generic way to fetch keys if you implement getKey.  The default implementation\nsimply returns <b><code>item.id</code></b> but you can provide your own implementation\nto return a different value as in the following examples:</p>\n\n<pre><code>// normal way\nvar mc = new <a href=\"#!/api/Ext.util.MixedCollection\" rel=\"Ext.util.MixedCollection\" class=\"docClass\">Ext.util.MixedCollection</a>();\nmc.add(someEl.dom.id, someEl);\nmc.add(otherEl.dom.id, otherEl);\n//and so on\n\n// using getKey\nvar mc = new <a href=\"#!/api/Ext.util.MixedCollection\" rel=\"Ext.util.MixedCollection\" class=\"docClass\">Ext.util.MixedCollection</a>();\nmc.getKey = function(el){\n   return el.dom.id;\n};\nmc.add(someEl);\nmc.add(otherEl);\n\n// or via the constructor\nvar mc = new <a href=\"#!/api/Ext.util.MixedCollection\" rel=\"Ext.util.MixedCollection\" class=\"docClass\">Ext.util.MixedCollection</a>(false, function(el){\n   return el.dom.id;\n});\nmc.add(someEl);\nmc.add(otherEl);\n</code></pre>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>item</span> : Object<div class='sub-desc'><p>The item for which to find the key.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>The key for the passed item.</p>\n</div></li></ul></div></div></div><div id='method-getRange' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.util.MixedCollection'>Ext.util.MixedCollection</span><br/><a href='source/MixedCollection.html#Ext-util-MixedCollection-method-getRange' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.MixedCollection-method-getRange' class='name expandable'>getRange</a>( <span class='pre'>[startIndex], [endIndex]</span> ) : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></div><div class='description'><div class='short'>Returns a range of items in this collection ...</div><div class='long'><p>Returns a range of items in this collection</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>startIndex</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> (optional)<div class='sub-desc'><p>The starting index. Defaults to 0.</p>\n</div></li><li><span class='pre'>endIndex</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> (optional)<div class='sub-desc'><p>The ending index. Defaults to the last item.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span><div class='sub-desc'><p>An array of items</p>\n</div></li></ul></div></div></div><div id='method-hasListener' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-hasListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-hasListener' class='name expandable'>hasListener</a>( <span class='pre'>eventName</span> ) : Boolean</div><div class='description'><div class='short'>Checks to see if this object has any listeners for a specified event ...</div><div class='long'><p>Checks to see if this object has any listeners for a specified event</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the event to check for</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>True if the event is being listened for, else false</p>\n</div></li></ul></div></div></div><div id='method-indexOf' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.util.MixedCollection'>Ext.util.MixedCollection</span><br/><a href='source/MixedCollection.html#Ext-util-MixedCollection-method-indexOf' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.MixedCollection-method-indexOf' class='name expandable'>indexOf</a>( <span class='pre'>o</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Returns index within the collection of the passed Object. ...</div><div class='long'><p>Returns index within the collection of the passed Object.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>o</span> : Object<div class='sub-desc'><p>The item to find the index of.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>index of the item. Returns -1 if not found.</p>\n</div></li></ul></div></div></div><div id='method-indexOfKey' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.util.MixedCollection'>Ext.util.MixedCollection</span><br/><a href='source/MixedCollection.html#Ext-util-MixedCollection-method-indexOfKey' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.MixedCollection-method-indexOfKey' class='name expandable'>indexOfKey</a>( <span class='pre'>key</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Returns index within the collection of the passed key. ...</div><div class='long'><p>Returns index within the collection of the passed key.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>key</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The key to find the index of.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>index of the key.</p>\n</div></li></ul></div></div></div><div id='method-insert' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.util.MixedCollection'>Ext.util.MixedCollection</span><br/><a href='source/MixedCollection.html#Ext-util-MixedCollection-method-insert' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.MixedCollection-method-insert' class='name expandable'>insert</a>( <span class='pre'>index, key, [o]</span> ) : Object</div><div class='description'><div class='short'>Inserts an item at the specified index in the collection. ...</div><div class='long'><p>Inserts an item at the specified index in the collection. Fires the <a href=\"#!/api/Ext.util.MixedCollection-method-add\" rel=\"Ext.util.MixedCollection-method-add\" class=\"docClass\">add</a> event when complete.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>index</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The index to insert the item at.</p>\n</div></li><li><span class='pre'>key</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The key to associate with the new item, or the item itself.</p>\n</div></li><li><span class='pre'>o</span> : Object (optional)<div class='sub-desc'><p>If the second parameter was a key, the new item.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>The item inserted.</p>\n</div></li></ul></div></div></div><div id='method-item' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.util.MixedCollection'>Ext.util.MixedCollection</span><br/><a href='source/MixedCollection.html#Ext-util-MixedCollection-method-item' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.MixedCollection-method-item' class='name expandable'>item</a>( <span class='pre'>key</span> ) : Object</div><div class='description'><div class='short'>Returns the item associated with the passed key OR index. ...</div><div class='long'><p>Returns the item associated with the passed key OR index.\nKey has priority over index.  This is the equivalent\nof calling <a href=\"#!/api/Ext.util.MixedCollection-method-key\" rel=\"Ext.util.MixedCollection-method-key\" class=\"docClass\">key</a> first, then if nothing matched calling <a href=\"#!/api/Ext.util.MixedCollection-method-itemAt\" rel=\"Ext.util.MixedCollection-method-itemAt\" class=\"docClass\">itemAt</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>key</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The key or index of the item.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>If the item is found, returns the item.  If the item was not found, returns <tt>undefined</tt>.\nIf an item was found, but is a Class, returns <tt>null</tt>.</p>\n</div></li></ul></div></div></div><div id='method-itemAt' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.util.MixedCollection'>Ext.util.MixedCollection</span><br/><a href='source/MixedCollection.html#Ext-util-MixedCollection-method-itemAt' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.MixedCollection-method-itemAt' class='name expandable'>itemAt</a>( <span class='pre'>index</span> ) : Object</div><div class='description'><div class='short'>Returns the item at the specified index. ...</div><div class='long'><p>Returns the item at the specified index.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>index</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The index of the item.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>The item at the specified index.</p>\n</div></li></ul></div></div></div><div id='method-key' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.util.MixedCollection'>Ext.util.MixedCollection</span><br/><a href='source/MixedCollection.html#Ext-util-MixedCollection-method-key' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.MixedCollection-method-key' class='name expandable'>key</a>( <span class='pre'>key</span> ) : Object</div><div class='description'><div class='short'>Returns the item associated with the passed key. ...</div><div class='long'><p>Returns the item associated with the passed key.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>key</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The key of the item.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>The item associated with the passed key.</p>\n</div></li></ul></div></div></div><div id='method-keySort' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.util.MixedCollection'>Ext.util.MixedCollection</span><br/><a href='source/MixedCollection.html#Ext-util-MixedCollection-method-keySort' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.MixedCollection-method-keySort' class='name expandable'>keySort</a>( <span class='pre'>[direction], [fn]</span> )</div><div class='description'><div class='short'>Sorts this collection by keys. ...</div><div class='long'><p>Sorts this collection by <b>key</b>s.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>direction</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>'ASC' or 'DESC'. Defaults to 'ASC'.</p>\n</div></li><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> (optional)<div class='sub-desc'><p>Comparison function that defines the sort order.\nDefaults to sorting by case insensitive string.</p>\n</div></li></ul></div></div></div><div id='method-last' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.util.MixedCollection'>Ext.util.MixedCollection</span><br/><a href='source/MixedCollection.html#Ext-util-MixedCollection-method-last' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.MixedCollection-method-last' class='name expandable'>last</a>( <span class='pre'></span> ) : Object</div><div class='description'><div class='short'>Returns the last item in the collection. ...</div><div class='long'><p>Returns the last item in the collection.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>the last item in the collection..</p>\n</div></li></ul></div></div></div><div id='method-on' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-on' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-on' class='name expandable'>on</a>( <span class='pre'>eventName, handler, [scope], [options]</span> )</div><div class='description'><div class='short'>Appends an event handler to this object (shorthand for addListener.) ...</div><div class='long'><p>Appends an event handler to this object (shorthand for <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a>.)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The type of event to listen for</p>\n</div></li><li><span class='pre'>handler</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The method the event invokes</p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope (<code><b>this</b></code> reference) in which the handler function is executed.\n<b>If omitted, defaults to the object which fired the event.</b></p>\n</div></li><li><span class='pre'>options</span> : Object (optional)<div class='sub-desc'><p>An object containing handler configuration.</p>\n</div></li></ul></div></div></div><div id='method-purgeListeners' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-purgeListeners' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-purgeListeners' class='name expandable'>purgeListeners</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Removes all listeners for this object ...</div><div class='long'><p>Removes all listeners for this object</p>\n</div></div></div><div id='method-relayEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable-more.html#Ext-util-Observable-method-relayEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-relayEvents' class='name expandable'>relayEvents</a>( <span class='pre'>o, events</span> )</div><div class='description'><div class='short'>Relays selected events from the specified Observable as if the events were fired by this. ...</div><div class='long'><p>Relays selected events from the specified Observable as if the events were fired by <tt><b>this</b></tt>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>o</span> : Object<div class='sub-desc'><p>The Observable whose events this object is to relay.</p>\n</div></li><li><span class='pre'>events</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>Array of event names to relay.</p>\n</div></li></ul></div></div></div><div id='method-remove' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.util.MixedCollection'>Ext.util.MixedCollection</span><br/><a href='source/MixedCollection.html#Ext-util-MixedCollection-method-remove' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.MixedCollection-method-remove' class='name expandable'>remove</a>( <span class='pre'>o</span> ) : Object</div><div class='description'><div class='short'>Remove an item from the collection. ...</div><div class='long'><p>Remove an item from the collection.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>o</span> : Object<div class='sub-desc'><p>The item to remove.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>The item removed or false if no item was removed.</p>\n</div></li></ul></div></div></div><div id='method-removeAt' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.util.MixedCollection'>Ext.util.MixedCollection</span><br/><a href='source/MixedCollection.html#Ext-util-MixedCollection-method-removeAt' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.MixedCollection-method-removeAt' class='name expandable'>removeAt</a>( <span class='pre'>index</span> ) : Object</div><div class='description'><div class='short'>Remove an item from a specified index in the collection. ...</div><div class='long'><p>Remove an item from a specified index in the collection. Fires the <a href=\"#!/api/Ext.util.MixedCollection-event-remove\" rel=\"Ext.util.MixedCollection-event-remove\" class=\"docClass\">remove</a> event when complete.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>index</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The index within the collection of the item to remove.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>The item removed or false if no item was removed.</p>\n</div></li></ul></div></div></div><div id='method-removeKey' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.util.MixedCollection'>Ext.util.MixedCollection</span><br/><a href='source/MixedCollection.html#Ext-util-MixedCollection-method-removeKey' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.MixedCollection-method-removeKey' class='name expandable'>removeKey</a>( <span class='pre'>key</span> ) : Object</div><div class='description'><div class='short'>Removed an item associated with the passed key fom the collection. ...</div><div class='long'><p>Removed an item associated with the passed key fom the collection.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>key</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The key of the item to remove.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>The item removed or false if no item was removed.</p>\n</div></li></ul></div></div></div><div id='method-removeListener' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-removeListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-removeListener' class='name expandable'>removeListener</a>( <span class='pre'>eventName, handler, [scope]</span> )</div><div class='description'><div class='short'>Removes an event handler. ...</div><div class='long'><p>Removes an event handler.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The type of event the handler was associated with.</p>\n</div></li><li><span class='pre'>handler</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The handler to remove. <b>This must be a reference to the function passed into the <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a> call.</b></p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope originally specified for the handler.</p>\n</div></li></ul></div></div></div><div id='method-reorder' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.util.MixedCollection'>Ext.util.MixedCollection</span><br/><a href='source/MixedCollection.html#Ext-util-MixedCollection-method-reorder' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.MixedCollection-method-reorder' class='name expandable'>reorder</a>( <span class='pre'>mapping</span> )</div><div class='description'><div class='short'>Reorders each of the items based on a mapping from old index to new index. ...</div><div class='long'><p>Reorders each of the items based on a mapping from old index to new index. Internally this\njust translates into a sort. The 'sort' event is fired whenever reordering has occured.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>mapping</span> : Object<div class='sub-desc'><p>Mapping from old item index to new item index</p>\n</div></li></ul></div></div></div><div id='method-replace' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.util.MixedCollection'>Ext.util.MixedCollection</span><br/><a href='source/MixedCollection.html#Ext-util-MixedCollection-method-replace' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.MixedCollection-method-replace' class='name expandable'>replace</a>( <span class='pre'>key, o</span> ) : Object</div><div class='description'><div class='short'>Replaces an item in the collection. ...</div><div class='long'><p>Replaces an item in the collection. Fires the <a href=\"#!/api/Ext.util.MixedCollection-method-replace\" rel=\"Ext.util.MixedCollection-method-replace\" class=\"docClass\">replace</a> event when complete.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>key</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The key associated with the item to replace, or the replacement item.</p>\n\n\n<p>If you supplied a <a href=\"#!/api/Ext.util.MixedCollection-method-getKey\" rel=\"Ext.util.MixedCollection-method-getKey\" class=\"docClass\">getKey</a> implementation for this MixedCollection, or if the key\nof your stored items is in a property called <tt><b>id</b></tt>, then the MixedCollection\nwill be able to <i>derive</i> the key of the replacement item. If you want to replace an item\nwith one having the same key value, then just pass the replacement item in this parameter.</p>\n\n</div></li><li><span class='pre'>o</span> : Object<div class='sub-desc'><p>{Object} o (optional) If the first parameter passed was a key, the item to associate\nwith that key.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>The new item.</p>\n</div></li></ul></div></div></div><div id='method-resumeEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-resumeEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-resumeEvents' class='name expandable'>resumeEvents</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Resume firing events. ...</div><div class='long'><p>Resume firing events. (see <a href=\"#!/api/Ext.util.Observable-method-suspendEvents\" rel=\"Ext.util.Observable-method-suspendEvents\" class=\"docClass\">suspendEvents</a>)\nIf events were suspended using the <tt><b>queueSuspended</b></tt> parameter, then all\nevents fired during event suspension will be sent to any listeners now.</p>\n</div></div></div><div id='method-sort' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.util.MixedCollection'>Ext.util.MixedCollection</span><br/><a href='source/MixedCollection.html#Ext-util-MixedCollection-method-sort' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.MixedCollection-method-sort' class='name expandable'>sort</a>( <span class='pre'>[direction], [fn]</span> )</div><div class='description'><div class='short'>Sorts this collection by item value with the passed comparison function. ...</div><div class='long'><p>Sorts this collection by <b>item</b> value with the passed comparison function.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>direction</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>'ASC' or 'DESC'. Defaults to 'ASC'.</p>\n</div></li><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> (optional)<div class='sub-desc'><p>Comparison function that defines the sort order.\nDefaults to sorting by numeric value.</p>\n</div></li></ul></div></div></div><div id='method-suspendEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-suspendEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-suspendEvents' class='name expandable'>suspendEvents</a>( <span class='pre'>queueSuspended</span> )</div><div class='description'><div class='short'>Suspend the firing of all events. ...</div><div class='long'><p>Suspend the firing of all events. (see <a href=\"#!/api/Ext.util.Observable-method-resumeEvents\" rel=\"Ext.util.Observable-method-resumeEvents\" class=\"docClass\">resumeEvents</a>)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>queueSuspended</span> : Boolean<div class='sub-desc'><p>Pass as true to queue up suspended events to be fired\nafter the <a href=\"#!/api/Ext.util.Observable-method-resumeEvents\" rel=\"Ext.util.Observable-method-resumeEvents\" class=\"docClass\">resumeEvents</a> call instead of discarding all suspended events;</p>\n</div></li></ul></div></div></div><div id='method-un' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-un' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-un' class='name expandable'>un</a>( <span class='pre'>eventName, handler, [scope]</span> )</div><div class='description'><div class='short'>Removes an event handler (shorthand for removeListener.) ...</div><div class='long'><p>Removes an event handler (shorthand for <a href=\"#!/api/Ext.util.Observable-method-removeListener\" rel=\"Ext.util.Observable-method-removeListener\" class=\"docClass\">removeListener</a>.)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The type of event the handler was associated with.</p>\n</div></li><li><span class='pre'>handler</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The handler to remove. <b>This must be a reference to the function passed into the <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a> call.</b></p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope originally specified for the handler.</p>\n</div></li></ul></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-event'>Events</h3><div class='subsection'><div id='event-add' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.util.MixedCollection'>Ext.util.MixedCollection</span><br/><a href='source/MixedCollection.html#Ext-util-MixedCollection-event-add' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.MixedCollection-event-add' class='name expandable'>add</a>( <span class='pre'>index, o, key</span> )</div><div class='description'><div class='short'>Fires when an item is added to the collection. ...</div><div class='long'><p>Fires when an item is added to the collection.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>index</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The index at which the item was added.</p>\n</div></li><li><span class='pre'>o</span> : Object<div class='sub-desc'><p>The item added.</p>\n</div></li><li><span class='pre'>key</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The key associated with the added item.</p>\n</div></li></ul></div></div></div><div id='event-clear' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.util.MixedCollection'>Ext.util.MixedCollection</span><br/><a href='source/MixedCollection.html#Ext-util-MixedCollection-event-clear' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.MixedCollection-event-clear' class='name expandable'>clear</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Fires when the collection is cleared. ...</div><div class='long'><p>Fires when the collection is cleared.</p>\n</div></div></div><div id='event-remove' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.util.MixedCollection'>Ext.util.MixedCollection</span><br/><a href='source/MixedCollection.html#Ext-util-MixedCollection-event-remove' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.MixedCollection-event-remove' class='name expandable'>remove</a>( <span class='pre'>o, [key]</span> )</div><div class='description'><div class='short'>Fires when an item is removed from the collection. ...</div><div class='long'><p>Fires when an item is removed from the collection.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>o</span> : Object<div class='sub-desc'><p>The item being removed.</p>\n</div></li><li><span class='pre'>key</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>The key associated with the removed item.</p>\n</div></li></ul></div></div></div><div id='event-replace' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.util.MixedCollection'>Ext.util.MixedCollection</span><br/><a href='source/MixedCollection.html#Ext-util-MixedCollection-event-replace' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.MixedCollection-event-replace' class='name expandable'>replace</a>( <span class='pre'>key, old, new</span> )</div><div class='description'><div class='short'>Fires when an item is replaced in the collection. ...</div><div class='long'><p>Fires when an item is replaced in the collection.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>key</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>he key associated with the new added.</p>\n</div></li><li><span class='pre'>old</span> : Object<div class='sub-desc'><p>The item being replaced.</p>\n</div></li><li><span class='pre'>new</span> : Object<div class='sub-desc'><p>The new item.</p>\n</div></li></ul></div></div></div></div></div></div></div>","superclasses":["Ext.util.Observable"],"meta":{},"requires":[],"html_meta":{},"statics":{"property":[],"cfg":[],"css_var":[],"method":[],"event":[],"css_mixin":[]},"files":[{"href":"MixedCollection.html#Ext-util-MixedCollection","filename":"MixedCollection.js"}],"linenr":1,"members":{"property":[],"cfg":[{"tagname":"cfg","owner":"Ext.util.MixedCollection","meta":{},"name":"allowFunctions","id":"cfg-allowFunctions"},{"tagname":"cfg","owner":"Ext.util.Observable","meta":{},"name":"listeners","id":"cfg-listeners"}],"css_var":[],"method":[{"tagname":"method","owner":"Ext.util.MixedCollection","meta":{},"name":"constructor","id":"method-constructor"},{"tagname":"method","owner":"Ext.util.MixedCollection","meta":{"private":true},"name":"_sort","id":"method-_sort"},{"tagname":"method","owner":"Ext.util.MixedCollection","meta":{},"name":"add","id":"method-add"},{"tagname":"method","owner":"Ext.util.MixedCollection","meta":{},"name":"addAll","id":"method-addAll"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"addEvents","id":"method-addEvents"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"addListener","id":"method-addListener"},{"tagname":"method","owner":"Ext.util.MixedCollection","meta":{},"name":"clear","id":"method-clear"},{"tagname":"method","owner":"Ext.util.MixedCollection","meta":{},"name":"clone","id":"method-clone"},{"tagname":"method","owner":"Ext.util.MixedCollection","meta":{},"name":"contains","id":"method-contains"},{"tagname":"method","owner":"Ext.util.MixedCollection","meta":{},"name":"containsKey","id":"method-containsKey"},{"tagname":"method","owner":"Ext.util.MixedCollection","meta":{"private":true},"name":"createValueMatcher","id":"method-createValueMatcher"},{"tagname":"method","owner":"Ext.util.MixedCollection","meta":{},"name":"each","id":"method-each"},{"tagname":"method","owner":"Ext.util.MixedCollection","meta":{},"name":"eachKey","id":"method-eachKey"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"enableBubble","id":"method-enableBubble"},{"tagname":"method","owner":"Ext.util.MixedCollection","meta":{},"name":"filter","id":"method-filter"},{"tagname":"method","owner":"Ext.util.MixedCollection","meta":{},"name":"filterBy","id":"method-filterBy"},{"tagname":"method","owner":"Ext.util.MixedCollection","meta":{},"name":"find","id":"method-find"},{"tagname":"method","owner":"Ext.util.MixedCollection","meta":{},"name":"findIndex","id":"method-findIndex"},{"tagname":"method","owner":"Ext.util.MixedCollection","meta":{},"name":"findIndexBy","id":"method-findIndexBy"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"fireEvent","id":"method-fireEvent"},{"tagname":"method","owner":"Ext.util.MixedCollection","meta":{},"name":"first","id":"method-first"},{"tagname":"method","owner":"Ext.util.MixedCollection","meta":{},"name":"get","id":"method-get"},{"tagname":"method","owner":"Ext.util.MixedCollection","meta":{},"name":"getCount","id":"method-getCount"},{"tagname":"method","owner":"Ext.util.MixedCollection","meta":{},"name":"getKey","id":"method-getKey"},{"tagname":"method","owner":"Ext.util.MixedCollection","meta":{},"name":"getRange","id":"method-getRange"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"hasListener","id":"method-hasListener"},{"tagname":"method","owner":"Ext.util.MixedCollection","meta":{},"name":"indexOf","id":"method-indexOf"},{"tagname":"method","owner":"Ext.util.MixedCollection","meta":{},"name":"indexOfKey","id":"method-indexOfKey"},{"tagname":"method","owner":"Ext.util.MixedCollection","meta":{},"name":"insert","id":"method-insert"},{"tagname":"method","owner":"Ext.util.MixedCollection","meta":{},"name":"item","id":"method-item"},{"tagname":"method","owner":"Ext.util.MixedCollection","meta":{},"name":"itemAt","id":"method-itemAt"},{"tagname":"method","owner":"Ext.util.MixedCollection","meta":{},"name":"key","id":"method-key"},{"tagname":"method","owner":"Ext.util.MixedCollection","meta":{},"name":"keySort","id":"method-keySort"},{"tagname":"method","owner":"Ext.util.MixedCollection","meta":{},"name":"last","id":"method-last"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"on","id":"method-on"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"purgeListeners","id":"method-purgeListeners"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"relayEvents","id":"method-relayEvents"},{"tagname":"method","owner":"Ext.util.MixedCollection","meta":{},"name":"remove","id":"method-remove"},{"tagname":"method","owner":"Ext.util.MixedCollection","meta":{},"name":"removeAt","id":"method-removeAt"},{"tagname":"method","owner":"Ext.util.MixedCollection","meta":{},"name":"removeKey","id":"method-removeKey"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"removeListener","id":"method-removeListener"},{"tagname":"method","owner":"Ext.util.MixedCollection","meta":{},"name":"reorder","id":"method-reorder"},{"tagname":"method","owner":"Ext.util.MixedCollection","meta":{},"name":"replace","id":"method-replace"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"resumeEvents","id":"method-resumeEvents"},{"tagname":"method","owner":"Ext.util.MixedCollection","meta":{},"name":"sort","id":"method-sort"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"suspendEvents","id":"method-suspendEvents"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"un","id":"method-un"}],"event":[{"tagname":"event","owner":"Ext.util.MixedCollection","meta":{},"name":"add","id":"event-add"},{"tagname":"event","owner":"Ext.util.MixedCollection","meta":{},"name":"clear","id":"event-clear"},{"tagname":"event","owner":"Ext.util.MixedCollection","meta":{},"name":"remove","id":"event-remove"},{"tagname":"event","owner":"Ext.util.MixedCollection","meta":{},"name":"replace","id":"event-replace"}],"css_mixin":[]},"inheritable":null,"private":null,"component":false,"name":"Ext.util.MixedCollection","singleton":false,"override":null,"inheritdoc":null,"id":"class-Ext.util.MixedCollection","mixins":[],"mixedInto":[]});