# Generated by default/object.tt
package Paws::Kendra::SalesforceStandardObjectConfiguration;
  use Moose;
  has DocumentDataFieldName => (is => 'ro', isa => 'Str', required => 1);
  has DocumentTitleFieldName => (is => 'ro', isa => 'Str');
  has FieldMappings => (is => 'ro', isa => 'ArrayRef[Paws::Kendra::DataSourceToIndexFieldMapping]');
  has Name => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Kendra::SalesforceStandardObjectConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Kendra::SalesforceStandardObjectConfiguration object:

  $service_obj->Method(Att1 => { DocumentDataFieldName => $value, ..., Name => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Kendra::SalesforceStandardObjectConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->DocumentDataFieldName

=head1 DESCRIPTION

Specifies configuration information for indexing a single standard
object.

=head1 ATTRIBUTES


=head2 B<REQUIRED> DocumentDataFieldName => Str

The name of the field in the standard object table that contains the
document contents.


=head2 DocumentTitleFieldName => Str

The name of the field in the standard object table that contains the
document title.


=head2 FieldMappings => ArrayRef[L<Paws::Kendra::DataSourceToIndexFieldMapping>]

One or more objects that map fields in the standard object to Amazon
Kendra index fields. The index field must exist before you can map a
Salesforce field to it.


=head2 B<REQUIRED> Name => Str

The name of the standard object.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Kendra>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

