package Faker::Plugin::EnUs::AddressNumber;

use 5.018;

use strict;
use warnings;

use Venus::Class 'base';

base 'Faker::Plugin::EnUs';

# METHODS

sub execute {
  my ($self, $data) = @_;

  return $self->process_markers(
    $self->faker->random->select(data_for_address_number()),
    'numbers',
  );
}

sub data_for_address_number {
  state $address_number = [
    '%####',
    '%####',
    '%###',
    '%##',
    '%#',
    '%',
  ]
}

1;



=head1 NAME

Faker::Plugin::EnUs::AddressNumber - Address Number

=cut

=head1 ABSTRACT

Address Number for Faker

=cut

=head1 SYNOPSIS

  package main;

  use Faker::Plugin::EnUs::AddressNumber;

  my $plugin = Faker::Plugin::EnUs::AddressNumber->new;

  # bless(..., "Faker::Plugin::EnUs::AddressNumber")

=cut

=head1 DESCRIPTION

This package provides methods for generating fake data for address number.

=encoding utf8

=cut

=head1 INHERITS

This package inherits behaviors from:

L<Faker::Plugin::EnUs>

=cut

=head1 METHODS

This package provides the following methods:

=cut

=head2 execute

  execute(HashRef $data) (Str)

The execute method returns a returns a random fake address number.

I<Since C<1.10>>

=over 4

=item execute example 1

  package main;

  use Faker::Plugin::EnUs::AddressNumber;

  my $plugin = Faker::Plugin::EnUs::AddressNumber->new;

  # bless(..., "Faker::Plugin::EnUs::AddressNumber")

  # my $result = $plugin->execute;

  # 8140;

  # my $result = $plugin->execute;

  # 5684;

  # my $result = $plugin->execute;

  # 57694;

=back

=cut

=head2 new

  new(HashRef $data) (Plugin)

The new method returns a new instance of the class.

I<Since C<1.10>>

=over 4

=item new example 1

  package main;

  use Faker::Plugin::EnUs::AddressNumber;

  my $plugin = Faker::Plugin::EnUs::AddressNumber->new;

  # bless(..., "Faker::Plugin::EnUs::AddressNumber")

=back

=cut