/*
This file is part of Ext JS 3.4

Copyright (c) 2011-2013 Sencha Inc

Contact:  http://www.sencha.com/contact

GNU General Public License Usage
This file may be used under the terms of the GNU General Public License version 3.0 as
published by the Free Software Foundation and appearing in the file LICENSE included in the
packaging of this file.

Please review the following information to ensure the GNU General Public License version 3.0
requirements will be met: http://www.gnu.org/copyleft/gpl.html.

If you are unsure which license is appropriate for your use, please contact the sales department
at http://www.sencha.com/contact.

Build date: 2013-04-03 15:07:25
*/
Ext.data.JsonP.Ext_data_Record({"alternateClassNames":[],"aliases":{},"enum":null,"parentMixins":[],"tagname":"class","subclasses":[],"extends":null,"uses":[],"html":"<div><pre class=\"hierarchy\"><h4>Files</h4><div class='dependency'><a href='source/Record.html#Ext-data-Record' target='_blank'>Record.js</a></div></pre><div class='doc-contents'><p>Instances of this class encapsulate both Record <em>definition</em> information, and Record\n<em>value</em> information for use in <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a> objects, or any code which needs\nto access Records cached in an <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a> object.</p>\n\n\n<p>Constructors for this class are generated by passing an Array of field definition objects to <a href=\"#!/api/Ext.data.Record-static-method-create\" rel=\"Ext.data.Record-static-method-create\" class=\"docClass\">create</a>.\nInstances are usually only created by Ext.data.Reader implementations when processing unformatted data\nobjects.</p>\n\n\n<p>Note that an instance of a Record class may only belong to one <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Store</a> at a time.\nIn order to copy data from one Store to another, use the <a href=\"#!/api/Ext.data.Record-method-copy\" rel=\"Ext.data.Record-method-copy\" class=\"docClass\">copy</a> method to create an exact\ncopy of the Record, and insert the new instance into the other Store.</p>\n\n\n<p>When serializing a Record for submission to the server, be aware that it contains many private\nproperties, and also a reference to its owning Store which in turn holds references to its Records.\nThis means that a whole Record may not be encoded using Ext.util.JSON.encode. Instead, use the\n<code><a href=\"#!/api/Ext.data.Record-property-data\" rel=\"Ext.data.Record-property-data\" class=\"docClass\">data</a></code> and <code><a href=\"#!/api/Ext.data.Record-method-id\" rel=\"Ext.data.Record-method-id\" class=\"docClass\">id</a></code> properties.</p>\n\n\n<p>Record objects generated by this constructor inherit all the methods of <a href=\"#!/api/Ext.data.Record\" rel=\"Ext.data.Record\" class=\"docClass\">Ext.data.Record</a> listed below.</p>\n\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-data' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Record'>Ext.data.Record</span><br/><a href='source/Record.html#Ext-data-Record-property-data' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Record-property-data' class='name expandable'>data</a><span> : Object</span></div><div class='description'><div class='short'>An object hash representing the data for this Record. ...</div><div class='long'><p>An object hash representing the data for this Record. Every field name in the Record definition\nis represented by a property of that name in this object. Note that unless you specified a field\nwith <a href=\"#!/api/Ext.data.Field-cfg-name\" rel=\"Ext.data.Field-cfg-name\" class=\"docClass\">name</a> \"id\" in the Record definition, this will <b>not</b> contain\nan <tt>id</tt> property.</p>\n</div></div></div><div id='property-dirty' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Record'>Ext.data.Record</span><br/><a href='source/Record.html#Ext-data-Record-property-dirty' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Record-property-dirty' class='name expandable'>dirty</a><span> : Boolean</span></div><div class='description'><div class='short'>Readonly flag - true if this Record has been modified. ...</div><div class='long'><p>Readonly flag - true if this Record has been modified.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='property-fields' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Record'>Ext.data.Record</span><br/><a href='source/Record.html#Ext-data-Record-property-fields' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Record-property-fields' class='name expandable'>fields</a><span> : <a href=\"#!/api/Ext.util.MixedCollection\" rel=\"Ext.util.MixedCollection\" class=\"docClass\">Ext.util.MixedCollection</a></span></div><div class='description'><div class='short'>This property is stored in the Record definition's prototype\n\n\nA MixedCollection containing the defined Fields for th...</div><div class='long'><p><b>This property is stored in the Record definition's <u>prototype</u></b></p>\n\n\n<p>A MixedCollection containing the defined <a href=\"#!/api/Ext.data.Field\" rel=\"Ext.data.Field\" class=\"docClass\">Field</a>s for this Record.  Read-only.</p>\n</div></div></div><div id='property-id' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Record'>Ext.data.Record</span><br/><a href='source/Record.html#Ext-data-Record-property-id' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Record-property-id' class='name not-expandable'>id</a><span> : Object</span></div><div class='description'><div class='short'><p>The unique ID of the Record as specified at construction time.</p>\n</div><div class='long'><p>The unique ID of the Record as specified at construction time.</p>\n</div></div></div><div id='property-json' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Record'>Ext.data.Record</span><br/><a href='source/Record.html#Ext-data-Record-property-json' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Record-property-json' class='name expandable'>json</a><span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>|Object</span></div><div class='description'><div class='short'>Only present if this Record was created by an ArrayReader or a JsonReader. ...</div><div class='long'><p><b>Only present if this Record was created by an <a href=\"#!/api/Ext.data.ArrayReader\" rel=\"Ext.data.ArrayReader\" class=\"docClass\">ArrayReader</a> or a <a href=\"#!/api/Ext.data.JsonReader\" rel=\"Ext.data.JsonReader\" class=\"docClass\">JsonReader</a></b>.</p>\n\n\n<p>The Array or object which was the source of the data for this Record.</p>\n\n</div></div></div><div id='property-modified' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Record'>Ext.data.Record</span><br/><a href='source/Record.html#Ext-data-Record-property-modified' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Record-property-modified' class='name expandable'>modified</a><span> : Object</span></div><div class='description'><div class='short'>This object contains a key and value storing the original values of all modified\nfields or is null if no fields have ...</div><div class='long'><p>This object contains a key and value storing the original values of all modified\nfields or is null if no fields have been modified.</p>\n</div></div></div><div id='property-node' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Record'>Ext.data.Record</span><br/><a href='source/Record.html#Ext-data-Record-property-node' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Record-property-node' class='name expandable'>node</a><span> : XMLElement</span></div><div class='description'><div class='short'>Only present if this Record was created by an XmlReader. ...</div><div class='long'><p><b>Only present if this Record was created by an <a href=\"#!/api/Ext.data.XmlReader\" rel=\"Ext.data.XmlReader\" class=\"docClass\">XmlReader</a></b>.</p>\n\n\n<p>The XML element which was the source of the data for this Record.</p>\n\n</div></div></div><div id='property-phantom' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Record'>Ext.data.Record</span><br/><a href='source/Record.html#Ext-data-Record-property-phantom' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Record-property-phantom' class='name expandable'>phantom</a><span> : Boolean</span></div><div class='description'><div class='short'>true when the record does not yet exist in a server-side database (see\nmarkDirty). ...</div><div class='long'><p><tt>true</tt> when the record does not yet exist in a server-side database (see\n<a href=\"#!/api/Ext.data.Record-method-markDirty\" rel=\"Ext.data.Record-method-markDirty\" class=\"docClass\">markDirty</a>).  Any record which has a real database pk set as its id property\nis NOT a phantom -- it's real.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='property-store' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Record'>Ext.data.Record</span><br/><a href='source/Record.html#Ext-data-Record-property-store' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Record-property-store' class='name not-expandable'>store</a><span> : <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a></span></div><div class='description'><div class='short'><p>The <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a> to which this Record belongs.</p>\n</div><div class='long'><p>The <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a> to which this Record belongs.</p>\n</div></div></div></div></div><div class='members-section'><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Instance Methods</h3><div id='method-constructor' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Record'>Ext.data.Record</span><br/><a href='source/Record.html#Ext-data-Record-method-constructor' target='_blank' class='view-source'>view source</a></div><strong class='new-keyword'>new</strong><a href='#!/api/Ext.data.Record-method-constructor' class='name expandable'>Ext.data.Record</a>( <span class='pre'>[data], [id]</span> ) : <a href=\"#!/api/Ext.data.Record\" rel=\"Ext.data.Record\" class=\"docClass\">Ext.data.Record</a></div><div class='description'><div class='short'>This constructor should not be used to create Record objects. ...</div><div class='long'><p>This constructor should not be used to create Record objects. Instead, use <a href=\"#!/api/Ext.data.Record-static-method-create\" rel=\"Ext.data.Record-static-method-create\" class=\"docClass\">create</a> to\ngenerate a subclass of <a href=\"#!/api/Ext.data.Record\" rel=\"Ext.data.Record\" class=\"docClass\">Ext.data.Record</a> configured with information about its constituent fields.<p>\n<p><b>The generated constructor has the same signature as this constructor.</b></p>\n\n</p></p><h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>data</span> : Object (optional)<div class='sub-desc'><p>An object, the properties of which provide values for the new Record's\nfields. If not specified the <code><a href=\"#!/api/Ext.data.Field-cfg-defaultValue\" rel=\"Ext.data.Field-cfg-defaultValue\" class=\"docClass\">defaultValue</a></code>\nfor each field will be assigned.</p>\n</div></li><li><span class='pre'>id</span> : Object (optional)<div class='sub-desc'><p>The id of the Record. The id is used by the\n<a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a> object which owns the Record to index its collection\nof Records (therefore this id should be unique within each store). If an\n<code>id</code> is not specified a <b><code><a href=\"#!/api/Ext.data.Record-property-phantom\" rel=\"Ext.data.Record-property-phantom\" class=\"docClass\">phantom</a></code></b>\nRecord will be created with an automatically generated id.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.data.Record\" rel=\"Ext.data.Record\" class=\"docClass\">Ext.data.Record</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-beginEdit' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Record'>Ext.data.Record</span><br/><a href='source/Record.html#Ext-data-Record-method-beginEdit' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Record-method-beginEdit' class='name expandable'>beginEdit</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Begin an edit. ...</div><div class='long'><p>Begin an edit. While in edit mode, no events (e.g.. the <code>update</code> event)\nare relayed to the containing store.\nSee also: <code><a href=\"#!/api/Ext.data.Record-method-endEdit\" rel=\"Ext.data.Record-method-endEdit\" class=\"docClass\">endEdit</a></code> and <code><a href=\"#!/api/Ext.data.Record-method-cancelEdit\" rel=\"Ext.data.Record-method-cancelEdit\" class=\"docClass\">cancelEdit</a></code>.</p>\n</div></div></div><div id='method-cancelEdit' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Record'>Ext.data.Record</span><br/><a href='source/Record.html#Ext-data-Record-method-cancelEdit' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Record-method-cancelEdit' class='name expandable'>cancelEdit</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Cancels all changes made in the current edit operation. ...</div><div class='long'><p>Cancels all changes made in the current edit operation.</p>\n</div></div></div><div id='method-commit' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Record'>Ext.data.Record</span><br/><a href='source/Record.html#Ext-data-Record-method-commit' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Record-method-commit' class='name expandable'>commit</a>( <span class='pre'>[silent]</span> )</div><div class='description'><div class='short'>Usually called by the Ext.data.Store which owns the Record. ...</div><div class='long'><p>Usually called by the <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a> which owns the Record.\nCommits all changes made to the Record since either creation, or the last commit operation.</p>\n\n<p>Developers should subscribe to the <a href=\"#!/api/Ext.data.Store-event-update\" rel=\"Ext.data.Store-event-update\" class=\"docClass\">Ext.data.Store.update</a> event\nto have their code notified of commit operations.</p>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>silent</span> : Boolean (optional)<div class='sub-desc'><p>True to skip notification of the owning\nstore of the change (defaults to false)</p>\n</div></li></ul></div></div></div><div id='method-copy' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Record'>Ext.data.Record</span><br/><a href='source/Record.html#Ext-data-Record-method-copy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Record-method-copy' class='name expandable'>copy</a>( <span class='pre'>[id]</span> ) : Record</div><div class='description'><div class='short'>Creates a copy (clone) of this Record. ...</div><div class='long'><p>Creates a copy (clone) of this Record.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>id</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>A new Record id, defaults to the id\nof the record being copied. See <code><a href=\"#!/api/Ext.data.Record-method-id\" rel=\"Ext.data.Record-method-id\" class=\"docClass\">id</a></code>.\nTo generate a phantom record with a new id use:</p>\n\n<pre><code>var rec = record.copy(); // clone the record\n<a href=\"#!/api/Ext.data.Record-method-id\" rel=\"Ext.data.Record-method-id\" class=\"docClass\">Ext.data.Record.id</a>(rec); // automatically generate a unique sequential id\n</code></pre>\n\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Record</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-endEdit' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Record'>Ext.data.Record</span><br/><a href='source/Record.html#Ext-data-Record-method-endEdit' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Record-method-endEdit' class='name expandable'>endEdit</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>End an edit. ...</div><div class='long'><p>End an edit. If any data was modified, the containing store is notified\n(ie, the store's <code>update</code> event will fire).</p>\n</div></div></div><div id='method-get' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Record'>Ext.data.Record</span><br/><a href='source/Record.html#Ext-data-Record-method-get' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Record-method-get' class='name expandable'>get</a>( <span class='pre'>name</span> ) : Object</div><div class='description'><div class='short'>Get the value of the named field. ...</div><div class='long'><p>Get the value of the <a href=\"#!/api/Ext.data.Field-cfg-name\" rel=\"Ext.data.Field-cfg-name\" class=\"docClass\">named field</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.data.Field-cfg-name\" rel=\"Ext.data.Field-cfg-name\" class=\"docClass\">name of the field</a> to get the value of.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>The value of the field.</p>\n</div></li></ul></div></div></div><div id='method-getChanges' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Record'>Ext.data.Record</span><br/><a href='source/Record.html#Ext-data-Record-method-getChanges' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Record-method-getChanges' class='name expandable'>getChanges</a>( <span class='pre'></span> ) : Object</div><div class='description'><div class='short'>Gets a hash of only the fields that have been modified since this Record was created or commited. ...</div><div class='long'><p>Gets a hash of only the fields that have been modified since this Record was created or commited.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>Object</p>\n</div></li></ul></div></div></div><div id='method-id' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Record'>Ext.data.Record</span><br/><a href='source/Record.html#Ext-data-Record-method-id' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Record-method-id' class='name expandable'>id</a>( <span class='pre'>rec</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Generates a sequential id. ...</div><div class='long'><p>Generates a sequential id. This method is typically called when a record is <a href=\"#!/api/Ext.data.Record-static-method-create\" rel=\"Ext.data.Record-static-method-create\" class=\"docClass\">create</a>d\nand no id has been specified. The returned id takes the form:\n<tt>&#123;PREFIX}-&#123;AUTO_ID}</tt>.<div class=\"mdetail-params\"><ul>\n<li><b><tt>PREFIX</tt></b> : String<p class=\"sub-desc\"><tt>Ext.data.Record.PREFIX</tt>\n(defaults to <tt>'ext-record'</tt>)</p></li>\n<li><b><tt>AUTO_ID</tt></b> : String<p class=\"sub-desc\"><tt><a href=\"#!/api/Ext.data.Record\" rel=\"Ext.data.Record\" class=\"docClass\">Ext.data.Record</a>.AUTO_ID</tt>\n(defaults to <tt>1</tt> initially)</p></li>\n</ul></div></p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>rec</span> : Record<div class='sub-desc'><p>The record being created.  The record does not exist, it's a <a href=\"#!/api/Ext.data.Record-property-phantom\" rel=\"Ext.data.Record-property-phantom\" class=\"docClass\">phantom</a>.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>auto-generated string id, <tt>\"ext-record-i++'</tt>;</p>\n</div></li></ul></div></div></div><div id='method-isModified' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Record'>Ext.data.Record</span><br/><a href='source/Record.html#Ext-data-Record-method-isModified' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Record-method-isModified' class='name expandable'>isModified</a>( <span class='pre'>fieldName</span> ) : Boolean</div><div class='description'><div class='short'>Returns true if the passed field name has been modified\nsince the load or last commit. ...</div><div class='long'><p>Returns <tt>true</tt> if the passed field name has been <code><a href=\"#!/api/Ext.data.Record-property-modified\" rel=\"Ext.data.Record-property-modified\" class=\"docClass\">modified</a></code>\nsince the load or last commit.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fieldName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>Ext.data.Field#name</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isValid' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Record'>Ext.data.Record</span><br/><a href='source/Record.html#Ext-data-Record-method-isValid' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Record-method-isValid' class='name expandable'>isValid</a>( <span class='pre'></span> ) : Boolean</div><div class='description'><div class='short'>By default returns false if any field within the\nrecord configured with Ext.data.Field.allowBlank = false returns\ntru...</div><div class='long'><p>By default returns <tt>false</tt> if any <a href=\"#!/api/Ext.data.Field\" rel=\"Ext.data.Field\" class=\"docClass\">field</a> within the\nrecord configured with <tt><a href=\"#!/api/Ext.data.Field-cfg-allowBlank\" rel=\"Ext.data.Field-cfg-allowBlank\" class=\"docClass\">Ext.data.Field.allowBlank</a> = false</tt> returns\n<tt>true</tt> from an <a href=\"#!/api/Ext\" rel=\"Ext\" class=\"docClass\">Ext</a>.<a href=\"#!/api/Ext-method-isEmpty\" rel=\"Ext-method-isEmpty\" class=\"docClass\">isempty</a> test.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-markDirty' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Record'>Ext.data.Record</span><br/><a href='source/Record.html#Ext-data-Record-method-markDirty' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Record-method-markDirty' class='name expandable'>markDirty</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Marks this Record as dirty. ...</div><div class='long'><p>Marks this <b>Record</b> as <code><a href=\"#!/api/Ext.data.Record-property-dirty\" rel=\"Ext.data.Record-property-dirty\" class=\"docClass\">dirty</a></code>.  This method\nis used interally when adding <code><a href=\"#!/api/Ext.data.Record-property-phantom\" rel=\"Ext.data.Record-property-phantom\" class=\"docClass\">phantom</a></code> records to a\n<a href=\"#!/api/Ext.data.Store-cfg-writer\" rel=\"Ext.data.Store-cfg-writer\" class=\"docClass\">writer enabled store</a>.</p>\n\n\n<br><p>Marking a record <code><a href=\"#!/api/Ext.data.Record-property-dirty\" rel=\"Ext.data.Record-property-dirty\" class=\"docClass\">dirty</a></code> causes the phantom to\n\n\n<p>be returned by <a href=\"#!/api/Ext.data.Store-method-getModifiedRecords\" rel=\"Ext.data.Store-method-getModifiedRecords\" class=\"docClass\">Ext.data.Store.getModifiedRecords</a> where it will\nhave a create action composed for it during <a href=\"#!/api/Ext.data.Store-method-save\" rel=\"Ext.data.Store-method-save\" class=\"docClass\">store save</a>\noperations.</p></p>\n</div></div></div><div id='method-reject' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Record'>Ext.data.Record</span><br/><a href='source/Record.html#Ext-data-Record-method-reject' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Record-method-reject' class='name expandable'>reject</a>( <span class='pre'>[silent]</span> )</div><div class='description'><div class='short'>Usually called by the Ext.data.Store which owns the Record. ...</div><div class='long'><p>Usually called by the <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a> which owns the Record.\nRejects all changes made to the Record since either creation, or the last commit operation.\nModified fields are reverted to their original values.</p>\n\n<p>Developers should subscribe to the <a href=\"#!/api/Ext.data.Store-event-update\" rel=\"Ext.data.Store-event-update\" class=\"docClass\">Ext.data.Store.update</a> event\nto have their code notified of reject operations.</p>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>silent</span> : Boolean (optional)<div class='sub-desc'><p>True to skip notification of the owning\nstore of the change (defaults to false)</p>\n</div></li></ul></div></div></div><div id='method-set' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Record'>Ext.data.Record</span><br/><a href='source/Record.html#Ext-data-Record-method-set' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Record-method-set' class='name expandable'>set</a>( <span class='pre'>name, value</span> )</div><div class='description'><div class='short'>Set the named field to the specified value. ...</div><div class='long'><p>Set the <a href=\"#!/api/Ext.data.Field-cfg-name\" rel=\"Ext.data.Field-cfg-name\" class=\"docClass\">named field</a> to the specified value.  For example:</p>\n\n<pre><code>// record has a field named 'firstname'\nvar Employee = <a href=\"#!/api/Ext.data.Record\" rel=\"Ext.data.Record\" class=\"docClass\">Ext.data.Record</a>.<a href=\"#!/api/Ext.data.Record-static-method-create\" rel=\"Ext.data.Record-static-method-create\" class=\"docClass\">create</a>([\n    {name: 'firstname'},\n    ...\n]);\n\n// update the 2nd record in the store:\nvar rec = myStore.<a href=\"#!/api/Ext.data.Store-method-getAt\" rel=\"Ext.data.Store-method-getAt\" class=\"docClass\">getAt</a>(1);\n\n// set the value (shows dirty flag):\nrec.set('firstname', 'Betty');\n\n// commit the change (removes dirty flag):\nrec.<a href=\"#!/api/Ext.data.Record-method-commit\" rel=\"Ext.data.Record-method-commit\" class=\"docClass\">commit</a>();\n\n// update the record in the store, bypass setting dirty flag,\n// and do not store the change in the <a href=\"#!/api/Ext.data.Store-method-getModifiedRecords\" rel=\"Ext.data.Store-method-getModifiedRecords\" class=\"docClass\">modified records</a>\nrec.<a href=\"#!/api/Ext.data.Record-property-data\" rel=\"Ext.data.Record-property-data\" class=\"docClass\">data</a>['firstname'] = 'Wilma'; // updates record, but not the view\nrec.<a href=\"#!/api/Ext.data.Record-method-commit\" rel=\"Ext.data.Record-method-commit\" class=\"docClass\">commit</a>(); // updates the view\n</code></pre>\n\n\n<p><b>Notes</b>:<div class=\"mdetail-params\"><ul>\n<li>If the store has a writer and <code>autoSave=true</code>, each set()\nwill execute an XHR to the server.</li>\n<li>Use <code><a href=\"#!/api/Ext.data.Record-method-beginEdit\" rel=\"Ext.data.Record-method-beginEdit\" class=\"docClass\">beginEdit</a></code> to prevent the store's <code>update</code>\nevent firing while using set().</li>\n<li>Use <code><a href=\"#!/api/Ext.data.Record-method-endEdit\" rel=\"Ext.data.Record-method-endEdit\" class=\"docClass\">endEdit</a></code> to have the store's <code>update</code>\nevent fire.</li>\n</ul></div></p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The <a href=\"#!/api/Ext.data.Field-cfg-name\" rel=\"Ext.data.Field-cfg-name\" class=\"docClass\">name of the field</a> to set.</p>\n</div></li><li><span class='pre'>value</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/Object/<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>The value to set the field to.</p>\n</div></li></ul></div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Static Methods</h3><div id='static-method-create' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Record'>Ext.data.Record</span><br/><a href='source/Record.html#Ext-data-Record-static-method-create' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Record-static-method-create' class='name expandable'>create</a>( <span class='pre'>o</span> ) : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><strong class='static signature' >static</strong></div><div class='description'><div class='short'>Generate a constructor for a specific Record layout. ...</div><div class='long'><p>Generate a constructor for a specific Record layout.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>o</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>An Array of <b><a href=\"#!/api/Ext.data.Field\" rel=\"Ext.data.Field\" class=\"docClass\">Field</a></b> definition objects.\nThe constructor generated by this method may be used to create new Record instances. The data\nobject must contain properties named after the <a href=\"#!/api/Ext.data.Field\" rel=\"Ext.data.Field\" class=\"docClass\">field</a>\n<b><tt><a href=\"#!/api/Ext.data.Field-cfg-name\" rel=\"Ext.data.Field-cfg-name\" class=\"docClass\">Ext.data.Field.name</a>s</tt></b>.  Example usage:</p>\n\n<pre><code>// create a Record constructor from a description of the fields\nvar TopicRecord = <a href=\"#!/api/Ext.data.Record-static-method-create\" rel=\"Ext.data.Record-static-method-create\" class=\"docClass\">Ext.data.Record.create</a>([ // creates a subclass of <a href=\"#!/api/Ext.data.Record\" rel=\"Ext.data.Record\" class=\"docClass\">Ext.data.Record</a>\n    {<a href=\"#!/api/Ext.data.Field-cfg-name\" rel=\"Ext.data.Field-cfg-name\" class=\"docClass\">name</a>: 'title', <a href=\"#!/api/Ext.data.Field-cfg-mapping\" rel=\"Ext.data.Field-cfg-mapping\" class=\"docClass\">mapping</a>: 'topic_title'},\n    {name: 'author', mapping: 'username', allowBlank: false},\n    {name: 'totalPosts', mapping: 'topic_replies', type: 'int'},\n    {name: 'lastPost', mapping: 'post_time', type: 'date'},\n    {name: 'lastPoster', mapping: 'user2'},\n    {name: 'excerpt', mapping: 'post_text', allowBlank: false},\n    // In the simplest case, if no properties other than <tt>name</tt> are required,\n    // a field definition may consist of just a String for the field name.\n    'signature'\n]);\n\n// create Record instance\nvar myNewRecord = new TopicRecord(\n    {\n        title: 'Do my job please',\n        author: 'noobie',\n        totalPosts: 1,\n        lastPost: new Date(),\n        lastPoster: 'Animal',\n        excerpt: 'No way dude!',\n        signature: ''\n    },\n    id // optionally specify the id of the record otherwise one is auto-assigned\n);\nmyStore.<a href=\"#!/api/Ext.data.Store-event-add\" rel=\"Ext.data.Store-event-add\" class=\"docClass\">add</a>(myNewRecord);\n</code></pre>\n\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a></span><div class='sub-desc'><p>A constructor which is used to create new Records according\nto the definition. The constructor has the same signature as Record.</p>\n</div></li></ul></div></div></div></div></div></div></div>","superclasses":[],"meta":{},"requires":[],"html_meta":{},"statics":{"property":[],"cfg":[],"css_var":[],"method":[{"tagname":"method","owner":"Ext.data.Record","meta":{"static":true},"name":"create","id":"static-method-create"}],"event":[],"css_mixin":[]},"files":[{"href":"Record.html#Ext-data-Record","filename":"Record.js"}],"linenr":1,"members":{"property":[{"tagname":"property","owner":"Ext.data.Record","meta":{},"name":"data","id":"property-data"},{"tagname":"property","owner":"Ext.data.Record","meta":{},"name":"dirty","id":"property-dirty"},{"tagname":"property","owner":"Ext.data.Record","meta":{},"name":"fields","id":"property-fields"},{"tagname":"property","owner":"Ext.data.Record","meta":{},"name":"id","id":"property-id"},{"tagname":"property","owner":"Ext.data.Record","meta":{},"name":"json","id":"property-json"},{"tagname":"property","owner":"Ext.data.Record","meta":{},"name":"modified","id":"property-modified"},{"tagname":"property","owner":"Ext.data.Record","meta":{},"name":"node","id":"property-node"},{"tagname":"property","owner":"Ext.data.Record","meta":{},"name":"phantom","id":"property-phantom"},{"tagname":"property","owner":"Ext.data.Record","meta":{},"name":"store","id":"property-store"}],"cfg":[],"css_var":[],"method":[{"tagname":"method","owner":"Ext.data.Record","meta":{},"name":"constructor","id":"method-constructor"},{"tagname":"method","owner":"Ext.data.Record","meta":{},"name":"beginEdit","id":"method-beginEdit"},{"tagname":"method","owner":"Ext.data.Record","meta":{},"name":"cancelEdit","id":"method-cancelEdit"},{"tagname":"method","owner":"Ext.data.Record","meta":{},"name":"commit","id":"method-commit"},{"tagname":"method","owner":"Ext.data.Record","meta":{},"name":"copy","id":"method-copy"},{"tagname":"method","owner":"Ext.data.Record","meta":{},"name":"endEdit","id":"method-endEdit"},{"tagname":"method","owner":"Ext.data.Record","meta":{},"name":"get","id":"method-get"},{"tagname":"method","owner":"Ext.data.Record","meta":{},"name":"getChanges","id":"method-getChanges"},{"tagname":"method","owner":"Ext.data.Record","meta":{},"name":"id","id":"method-id"},{"tagname":"method","owner":"Ext.data.Record","meta":{},"name":"isModified","id":"method-isModified"},{"tagname":"method","owner":"Ext.data.Record","meta":{},"name":"isValid","id":"method-isValid"},{"tagname":"method","owner":"Ext.data.Record","meta":{},"name":"markDirty","id":"method-markDirty"},{"tagname":"method","owner":"Ext.data.Record","meta":{},"name":"reject","id":"method-reject"},{"tagname":"method","owner":"Ext.data.Record","meta":{},"name":"set","id":"method-set"}],"event":[],"css_mixin":[]},"inheritable":null,"private":null,"component":false,"name":"Ext.data.Record","singleton":false,"override":null,"inheritdoc":null,"id":"class-Ext.data.Record","mixins":[],"mixedInto":[]});