# Generated by default/object.tt
package Paws::LexModels::Slot;
  use Moose;
  has DefaultValueSpec => (is => 'ro', isa => 'Paws::LexModels::SlotDefaultValueSpec', request_name => 'defaultValueSpec', traits => ['NameInRequest']);
  has Description => (is => 'ro', isa => 'Str', request_name => 'description', traits => ['NameInRequest']);
  has Name => (is => 'ro', isa => 'Str', request_name => 'name', traits => ['NameInRequest'], required => 1);
  has ObfuscationSetting => (is => 'ro', isa => 'Str', request_name => 'obfuscationSetting', traits => ['NameInRequest']);
  has Priority => (is => 'ro', isa => 'Int', request_name => 'priority', traits => ['NameInRequest']);
  has ResponseCard => (is => 'ro', isa => 'Str', request_name => 'responseCard', traits => ['NameInRequest']);
  has SampleUtterances => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'sampleUtterances', traits => ['NameInRequest']);
  has SlotConstraint => (is => 'ro', isa => 'Str', request_name => 'slotConstraint', traits => ['NameInRequest'], required => 1);
  has SlotType => (is => 'ro', isa => 'Str', request_name => 'slotType', traits => ['NameInRequest']);
  has SlotTypeVersion => (is => 'ro', isa => 'Str', request_name => 'slotTypeVersion', traits => ['NameInRequest']);
  has ValueElicitationPrompt => (is => 'ro', isa => 'Paws::LexModels::Prompt', request_name => 'valueElicitationPrompt', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::LexModels::Slot

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LexModels::Slot object:

  $service_obj->Method(Att1 => { DefaultValueSpec => $value, ..., ValueElicitationPrompt => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LexModels::Slot object:

  $result = $service_obj->Method(...);
  $result->Att1->DefaultValueSpec

=head1 DESCRIPTION

Identifies the version of a specific slot.

=head1 ATTRIBUTES


=head2 DefaultValueSpec => L<Paws::LexModels::SlotDefaultValueSpec>

A list of default values for the slot. Default values are used when
Amazon Lex hasn't determined a value for a slot. You can specify
default values from context variables, session attributes, and defined
values.


=head2 Description => Str

A description of the slot.


=head2 B<REQUIRED> Name => Str

The name of the slot.


=head2 ObfuscationSetting => Str

Determines whether a slot is obfuscated in conversation logs and stored
utterances. When you obfuscate a slot, the value is replaced by the
slot name in curly braces ({}). For example, if the slot name is
"full_name", obfuscated values are replaced with "{full_name}". For
more information, see Slot Obfuscation
(https://docs.aws.amazon.com/lex/latest/dg/how-obfuscate.html).


=head2 Priority => Int

Directs Amazon Lex the order in which to elicit this slot value from
the user. For example, if the intent has two slots with priorities 1
and 2, AWS Amazon Lex first elicits a value for the slot with priority
1.

If multiple slots share the same priority, the order in which Amazon
Lex elicits values is arbitrary.


=head2 ResponseCard => Str

A set of possible responses for the slot type used by text-based
clients. A user chooses an option from the response card, instead of
using text to reply.


=head2 SampleUtterances => ArrayRef[Str|Undef]

If you know a specific pattern with which users might respond to an
Amazon Lex request for a slot value, you can provide those utterances
to improve accuracy. This is optional. In most cases, Amazon Lex is
capable of understanding user utterances.


=head2 B<REQUIRED> SlotConstraint => Str

Specifies whether the slot is required or optional.


=head2 SlotType => Str

The type of the slot, either a custom slot type that you defined or one
of the built-in slot types.


=head2 SlotTypeVersion => Str

The version of the slot type.


=head2 ValueElicitationPrompt => L<Paws::LexModels::Prompt>

The prompt that Amazon Lex uses to elicit the slot value from the user.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LexModels>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

