use Mojo::Base -strict;

use Test::More;
use Mojolicious::Lite;
use Test::Mojo;

plugin 'StaticLog';

# A minimal Mojolicious program by default will render a .txt static file.
# Prove that on doing so, a correct 'Static' line appears in the app's logfile.

get '/' => sub { shift->render(text => 'dynamic content') };

my $t = Test::Mojo->new;

# log-intercept technique as seen in mainstream mojo tests..
my $log = '';
$t->app->log->on(message => sub { $log .= pop });

# static rendering working like normal..
$t->get_ok('/one-eyed.txt')->status_is(200);

# this is the exact log line we expect..
my $msg_re = qr[Static 200    151 /one-eyed.txt];

$ENV{MOJO_LOG_LEVEL} = 'info';  $log = ''; $t->get_ok('/one-eyed.txt');
unlike $log, $msg_re, 'The "Static" message is not generated above "debug" log level';

$ENV{MOJO_LOG_LEVEL} = 'debug'; $log = ''; $t->get_ok('/one-eyed.txt');
like   $log, $msg_re, 'The expected "Static" line was generated by the log facility';

done_testing();

