use 5.008005;
use ExtUtils::MakeMaker;

# You might need to set this if your openssl headers and libs anre in an unusual place:
my $openssl_prefix = $ENV{OPENSSL_PREFIX} || '/usr';

# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.
WriteMakefile(
    NAME              => 'Crypt::OpenSSL::EC',
    VERSION_FROM      => 'lib/Crypt/OpenSSL/EC.pm',
    PREREQ_PM         => { 'Crypt::OpenSSL::Bignum' => 0.04,
                          }, 
    ($] >= 5.005 ?     ## Add these new keywords supported since 5.005
      (ABSTRACT_FROM  => 'lib/Crypt/OpenSSL/EC.pm', # retrieve abstract from module
       AUTHOR         => 'Mike McCauley <mikem@airspayce.com>') : ()),
    LIBS              => ["-L$openssl_prefix/lib -lcrypto"], # e.g., '-lm'
    DEFINE            => '-DPERL5 -DOPENSSL_NO_KRB5',
    INC               => "-I. -I$openssl_prefix/include", 
);
if  (eval {require ExtUtils::Constant; 1}) {
  # If you edit these definitions to change the constants used by this module,
  # you will need to use the generated const-c.inc and const-xs.inc
  # files to replace their "fallback" counterparts before distributing your
  # changes.
  my @names = (qw(EC_F_COMPUTE_WNAF EC_F_D2I_ECPARAMETERS
		 EC_F_D2I_ECPKPARAMETERS EC_F_D2I_ECPRIVATEKEY
		 EC_F_DO_EC_KEY_PRINT EC_F_ECKEY_PARAM2TYPE
		 EC_F_ECKEY_PARAM_DECODE EC_F_ECKEY_PRIV_DECODE
		 EC_F_ECKEY_PRIV_ENCODE EC_F_ECKEY_PUB_DECODE
		 EC_F_ECKEY_PUB_ENCODE EC_F_ECKEY_TYPE2PARAM
		 EC_F_ECPARAMETERS_PRINT EC_F_ECPARAMETERS_PRINT_FP
		 EC_F_ECPKPARAMETERS_PRINT EC_F_ECPKPARAMETERS_PRINT_FP
		 EC_F_ECP_NIST_MOD_192 EC_F_ECP_NIST_MOD_224
		 EC_F_ECP_NIST_MOD_256 EC_F_ECP_NIST_MOD_521
		 EC_F_EC_ASN1_GROUP2CURVE EC_F_EC_ASN1_GROUP2FIELDID
		 EC_F_EC_ASN1_GROUP2PARAMETERS EC_F_EC_ASN1_GROUP2PKPARAMETERS
		 EC_F_EC_ASN1_PARAMETERS2GROUP EC_F_EC_ASN1_PKPARAMETERS2GROUP
		 EC_F_EC_EX_DATA_SET_DATA
		 EC_F_EC_GF2M_MONTGOMERY_POINT_MULTIPLY
		 EC_F_EC_GF2M_SIMPLE_GROUP_CHECK_DISCRIMINANT
		 EC_F_EC_GF2M_SIMPLE_GROUP_SET_CURVE
		 EC_F_EC_GF2M_SIMPLE_OCT2POINT EC_F_EC_GF2M_SIMPLE_POINT2OCT
		 EC_F_EC_GF2M_SIMPLE_POINT_GET_AFFINE_COORDINATES
		 EC_F_EC_GF2M_SIMPLE_POINT_SET_AFFINE_COORDINATES
		 EC_F_EC_GF2M_SIMPLE_SET_COMPRESSED_COORDINATES
		 EC_F_EC_GFP_MONT_FIELD_DECODE EC_F_EC_GFP_MONT_FIELD_ENCODE
		 EC_F_EC_GFP_MONT_FIELD_MUL EC_F_EC_GFP_MONT_FIELD_SET_TO_ONE
		 EC_F_EC_GFP_MONT_FIELD_SQR EC_F_EC_GFP_MONT_GROUP_SET_CURVE
		 EC_F_EC_GFP_MONT_GROUP_SET_CURVE_GFP
		 EC_F_EC_GFP_NIST_FIELD_MUL EC_F_EC_GFP_NIST_FIELD_SQR
		 EC_F_EC_GFP_NIST_GROUP_SET_CURVE
		 EC_F_EC_GFP_SIMPLE_GROUP_CHECK_DISCRIMINANT
		 EC_F_EC_GFP_SIMPLE_GROUP_SET_CURVE
		 EC_F_EC_GFP_SIMPLE_GROUP_SET_CURVE_GFP
		 EC_F_EC_GFP_SIMPLE_GROUP_SET_GENERATOR
		 EC_F_EC_GFP_SIMPLE_MAKE_AFFINE EC_F_EC_GFP_SIMPLE_OCT2POINT
		 EC_F_EC_GFP_SIMPLE_POINT2OCT
		 EC_F_EC_GFP_SIMPLE_POINTS_MAKE_AFFINE
		 EC_F_EC_GFP_SIMPLE_POINT_GET_AFFINE_COORDINATES
		 EC_F_EC_GFP_SIMPLE_POINT_GET_AFFINE_COORDINATES_GFP
		 EC_F_EC_GFP_SIMPLE_POINT_SET_AFFINE_COORDINATES
		 EC_F_EC_GFP_SIMPLE_POINT_SET_AFFINE_COORDINATES_GFP
		 EC_F_EC_GFP_SIMPLE_SET_COMPRESSED_COORDINATES
		 EC_F_EC_GFP_SIMPLE_SET_COMPRESSED_COORDINATES_GFP
		 EC_F_EC_GROUP_CHECK EC_F_EC_GROUP_CHECK_DISCRIMINANT
		 EC_F_EC_GROUP_COPY EC_F_EC_GROUP_GET0_GENERATOR
		 EC_F_EC_GROUP_GET_COFACTOR EC_F_EC_GROUP_GET_CURVE_GF2M
		 EC_F_EC_GROUP_GET_CURVE_GFP EC_F_EC_GROUP_GET_DEGREE
		 EC_F_EC_GROUP_GET_ORDER EC_F_EC_GROUP_GET_PENTANOMIAL_BASIS
		 EC_F_EC_GROUP_GET_TRINOMIAL_BASIS EC_F_EC_GROUP_NEW
		 EC_F_EC_GROUP_NEW_BY_CURVE_NAME EC_F_EC_GROUP_NEW_FROM_DATA
		 EC_F_EC_GROUP_PRECOMPUTE_MULT EC_F_EC_GROUP_SET_CURVE_GF2M
		 EC_F_EC_GROUP_SET_CURVE_GFP EC_F_EC_GROUP_SET_EXTRA_DATA
		 EC_F_EC_GROUP_SET_GENERATOR EC_F_EC_KEY_CHECK_KEY
		 EC_F_EC_KEY_COPY EC_F_EC_KEY_GENERATE_KEY EC_F_EC_KEY_NEW
		 EC_F_EC_KEY_PRINT EC_F_EC_KEY_PRINT_FP
		 EC_F_EC_POINTS_MAKE_AFFINE EC_F_EC_POINT_ADD EC_F_EC_POINT_CMP
		 EC_F_EC_POINT_COPY EC_F_EC_POINT_DBL
		 EC_F_EC_POINT_GET_AFFINE_COORDINATES_GF2M
		 EC_F_EC_POINT_GET_AFFINE_COORDINATES_GFP
		 EC_F_EC_POINT_GET_JPROJECTIVE_COORDINATES_GFP
		 EC_F_EC_POINT_INVERT EC_F_EC_POINT_IS_AT_INFINITY
		 EC_F_EC_POINT_IS_ON_CURVE EC_F_EC_POINT_MAKE_AFFINE
		 EC_F_EC_POINT_MUL EC_F_EC_POINT_NEW EC_F_EC_POINT_OCT2POINT
		 EC_F_EC_POINT_POINT2OCT
		 EC_F_EC_POINT_SET_AFFINE_COORDINATES_GF2M
		 EC_F_EC_POINT_SET_AFFINE_COORDINATES_GFP
		 EC_F_EC_POINT_SET_COMPRESSED_COORDINATES_GF2M
		 EC_F_EC_POINT_SET_COMPRESSED_COORDINATES_GFP
		 EC_F_EC_POINT_SET_JPROJECTIVE_COORDINATES_GFP
		 EC_F_EC_POINT_SET_TO_INFINITY EC_F_EC_PRE_COMP_DUP
		 EC_F_EC_PRE_COMP_NEW EC_F_EC_WNAF_MUL
		 EC_F_EC_WNAF_PRECOMPUTE_MULT EC_F_I2D_ECPARAMETERS
		 EC_F_I2D_ECPKPARAMETERS EC_F_I2D_ECPRIVATEKEY
		 EC_F_I2O_ECPUBLICKEY EC_F_O2I_ECPUBLICKEY
		 EC_F_OLD_EC_PRIV_DECODE EC_F_PKEY_EC_CTRL
		 EC_F_PKEY_EC_CTRL_STR EC_F_PKEY_EC_DERIVE EC_F_PKEY_EC_KEYGEN
		 EC_F_PKEY_EC_PARAMGEN EC_F_PKEY_EC_SIGN EC_PKEY_NO_PARAMETERS
		 EC_PKEY_NO_PUBKEY EC_R_ASN1_ERROR EC_R_ASN1_UNKNOWN_FIELD
		 EC_R_BUFFER_TOO_SMALL EC_R_D2I_ECPKPARAMETERS_FAILURE
		 EC_R_DECODE_ERROR EC_R_DISCRIMINANT_IS_ZERO
		 EC_R_EC_GROUP_NEW_BY_NAME_FAILURE EC_R_FIELD_TOO_LARGE
		 EC_R_GROUP2PKPARAMETERS_FAILURE
		 EC_R_I2D_ECPKPARAMETERS_FAILURE EC_R_INCOMPATIBLE_OBJECTS
		 EC_R_INVALID_ARGUMENT EC_R_INVALID_COMPRESSED_POINT
		 EC_R_INVALID_COMPRESSION_BIT EC_R_INVALID_CURVE
		 EC_R_INVALID_DIGEST_TYPE EC_R_INVALID_ENCODING
		 EC_R_INVALID_FIELD EC_R_INVALID_FORM EC_R_INVALID_GROUP_ORDER
		 EC_R_INVALID_PENTANOMIAL_BASIS EC_R_INVALID_PRIVATE_KEY
		 EC_R_INVALID_TRINOMIAL_BASIS EC_R_KEYS_NOT_SET
		 EC_R_MISSING_PARAMETERS EC_R_MISSING_PRIVATE_KEY
		 EC_R_NOT_A_NIST_PRIME EC_R_NOT_A_SUPPORTED_NIST_PRIME
		 EC_R_NOT_IMPLEMENTED EC_R_NOT_INITIALIZED EC_R_NO_FIELD_MOD
		 EC_R_NO_PARAMETERS_SET EC_R_PASSED_NULL_PARAMETER
		 EC_R_PKPARAMETERS2GROUP_FAILURE EC_R_POINT_AT_INFINITY
		 EC_R_POINT_IS_NOT_ON_CURVE EC_R_SLOT_FULL
		 EC_R_UNDEFINED_GENERATOR EC_R_UNDEFINED_ORDER
		 EC_R_UNKNOWN_GROUP EC_R_UNKNOWN_ORDER EC_R_UNSUPPORTED_FIELD
		 EC_R_WRONG_ORDER EVP_PKEY_CTRL_EC_PARAMGEN_CURVE_NID
		 OPENSSL_ECC_MAX_FIELD_BITS OPENSSL_EC_NAMED_CURVE),
              {name=>"POINT_CONVERSION_COMPRESSED", macro=>"1"},
              {name=>"POINT_CONVERSION_HYBRID", macro=>"1"},
              {name=>"POINT_CONVERSION_UNCOMPRESSED", macro=>"1"});
  ExtUtils::Constant::WriteConstants(
                                     NAME         => 'Crypt::OpenSSL::EC',
                                     NAMES        => \@names,
                                     DEFAULT_TYPE => 'IV',
                                     C_FILE       => 'const-c.inc',
                                     XS_FILE      => 'const-xs.inc',
                                  );

}
else {
  use File::Copy;
  use File::Spec;
  foreach my $file ('const-c.inc', 'const-xs.inc') {
    my $fallback = File::Spec->catfile('fallback', $file);
    copy ($fallback, $file) or die "Can't copy $fallback to $file: $!";
  }
}
