# ABSTRACT: Chromium Policy class

use v5.36;
use Object::Pad ':experimental';

package Chrome::Policy::Chromium;
class Chrome::Policy::Chromium :isa(Chrome::Policy);
use Path::Tiny;
field $policy_path :reader = path '/etc/chromium/policies';
field $managed_policy_path :reader { $self -> policy_path -> child( 'managed' ) };
field $binary_path :reader = path '/opt/google/chrome/google-chrome';

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Chrome::Policy::Chromium - Chromium Policy class

=head1 VERSION

version 0.230350

=head1 AUTHOR

Elvin Aslanov <rwp.primary@gmail.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2023 by Elvin Aslanov.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
