# Generated by default/object.tt
package Paws::AccessAnalyzer::SecretsManagerSecretConfiguration;
  use Moose;
  has KmsKeyId => (is => 'ro', isa => 'Str', request_name => 'kmsKeyId', traits => ['NameInRequest']);
  has SecretPolicy => (is => 'ro', isa => 'Str', request_name => 'secretPolicy', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AccessAnalyzer::SecretsManagerSecretConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AccessAnalyzer::SecretsManagerSecretConfiguration object:

  $service_obj->Method(Att1 => { KmsKeyId => $value, ..., SecretPolicy => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AccessAnalyzer::SecretsManagerSecretConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->KmsKeyId

=head1 DESCRIPTION

The configuration for a Secrets Manager secret. For more information,
see CreateSecret
(https://docs.aws.amazon.com/secretsmanager/latest/apireference/API_CreateSecret.html).

You can propose a configuration for a new secret or an existing secret
that you own by specifying the secret policy and optional KMS
encryption key. If the configuration is for an existing secret and you
do not specify the secret policy, the access preview uses the existing
policy for the secret. If the access preview is for a new resource and
you do not specify the policy, the access preview assumes a secret
without a policy. To propose deletion of an existing policy, you can
specify an empty string. If the proposed configuration is for a new
secret and you do not specify the KMS key ID, the access preview uses
the default CMK of the AWS account. If you specify an empty string for
the KMS key ID, the access preview uses the default CMK of the AWS
account. For more information about secret policy limits, see Quotas
for AWS Secrets Manager.
(https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_limits.html).

=head1 ATTRIBUTES


=head2 KmsKeyId => Str

The proposed ARN, key ID, or alias of the AWS KMS customer master key
(CMK).


=head2 SecretPolicy => Str

The proposed resource policy defining who can access or manage the
secret.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AccessAnalyzer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

