# Generated by default/object.tt
package Paws::IoTSiteWise::BatchPutAssetPropertyError;
  use Moose;
  has ErrorCode => (is => 'ro', isa => 'Str', request_name => 'errorCode', traits => ['NameInRequest'], required => 1);
  has ErrorMessage => (is => 'ro', isa => 'Str', request_name => 'errorMessage', traits => ['NameInRequest'], required => 1);
  has Timestamps => (is => 'ro', isa => 'ArrayRef[Paws::IoTSiteWise::TimeInNanos]', request_name => 'timestamps', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoTSiteWise::BatchPutAssetPropertyError

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoTSiteWise::BatchPutAssetPropertyError object:

  $service_obj->Method(Att1 => { ErrorCode => $value, ..., Timestamps => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoTSiteWise::BatchPutAssetPropertyError object:

  $result = $service_obj->Method(...);
  $result->Att1->ErrorCode

=head1 DESCRIPTION

Contains error information from updating a batch of asset property
values.

=head1 ATTRIBUTES


=head2 B<REQUIRED> ErrorCode => Str

The error code.


=head2 B<REQUIRED> ErrorMessage => Str

The associated error message.


=head2 B<REQUIRED> Timestamps => ArrayRef[L<Paws::IoTSiteWise::TimeInNanos>]

A list of timestamps for each error, if any.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoTSiteWise>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

