(function(){Vue.component("convos-connection-settings",{props:["user"],data:function(){return{advancedSettings:false,connection:null,defaultNick:this.user.email.split("@")[0].replace(/\W+/g,"_"),errors:[],nick:"",onConnectCommands:"",server:"",tls:null,tls_verify:true,password:"",username:"",wantedState:""};},watch:{'advancedSettings':function(v,o){if(v)autosize(this.$refs.occ.$els.input);},'settings.main':function(v,o){this.updateForm();}},methods:{humanState:function(){if(this.connection.state=='queued')return'Connecting...';if(this.connection.getDialog("").frozen)return this.connection.getDialog("").frozen;return'State: '+this.connection.state.ucFirst();},removeConnection:function(){var self=this;this.connection.remove(function(err){if(err)return self.errors=err;self.settings.main="#connection";});},saveConnection:function(){var self=this;var connection=this.connection;var attrs={url:new Url("irc://"+this.server)};if(this.nick)attrs.url.param("nick",this.nick);if(this.tls!==null)attrs.url.param("tls",this.tls?1:0);if(this.tls)attrs.url.param("tls_verify",this.tls_verify?1:0);attrs.on_connect_commands=this.onConnectCommands.split(/\n/).map(function(str){return str.trim();});attrs.url.user=this.username;attrs.url.pass=this.password;attrs.wanted_state=this.wantedState;attrs.url=attrs.url.toString();this.errors=[];connection.save(attrs,function(err){if(err)return self.errors=err;self.deleted=false;self.updateForm(this);self.user.ensureDialog({connection_id:this.connection_id,dialog_id:"",name:this.connection_id});self.settings.main=this==connection?"#chat/"+this.connection_id+"/":"#create-dialog";});},updateForm:function(){var url,dialog=this.user.activeDialog();if(DEBUG.info)console.log("[editConnection]",dialog?dialog.connection_id:"New connection");this.connection=dialog?dialog.connection():new Convos.Connection({user:this.user});this.errors=[];this.onConnectCommands=this.connection.on_connect_commands.join("\n");this.wantedState=this.connection.wanted_state||"connected";url=new Url(this.connection.url||"//0.0.0.0");this.nick=url.param("nick")||this.defaultNick;this.password=url.pass||"";this.server=url.host||this.settings.default_server||"";this.tls=this.connection.url?url.param("tls"):null;this.tls_verify=this.connection.url?Boolean(parseInt(url.param("tls_verify"))):true;this.username=url.user||"";if(url.port)this.server+=":"+url.port;}},created:function(){this.updateForm();},template:"<form autocomplete=\"off\" class=\"convos-connection-settings\" @submit.prevent>\n    <div class=\"row\" v-if=\"user.connections.length\">\n      <div class=\"col s12\">\n        <h5 v-if=\"connection.url\">Edit {{connection.name}}</h5>\n        <h4 v-if=\"!connection.url\">Add connection</h4>\n      </div>\n    </div>\n    <div class=\"row\" v-if=\"!user.connections.length\">\n      <div class=\"col s12\">\n        <h4>Welcome to Convos!</h4>\n        <p>\n          Convos is the simplest way to use IRC. It is always online,\n          and accessible in your web browser, both on desktop and mobile.\n        </p>\n        <p>\n          Before you can start chatting, you need to create a connection.\n          <template v-if=\"settings.forced_irc_server\">\n          This installation of Convos is locked to a specific \"Server\",\n          so just hit \"Create\" to start chatting.\n          </template>\n          <template v-else>\n          \"Server\" below has a default value, but you can change it to\n          <a href=\"http://www.irchelp.org/networks/\" target=\"_blank\">any server</a>\n          you want. Once a server is entered, you can hit \"Create\" to start chatting.\n          Note that Convos automatically detects if the server supports TLS/SSL on the\n          port provided.\n          </template>\n        </p>\n      </div>\n    </div>\n    <template v-if=\"connection.url\">\n      <div class=\"row\">\n        <md-input :value.sync=\"server\" placeholder=\"Example: chat.freenode.net:6697\" :readonly=\"settings.forced_irc_server\" cols=\"s12\" name=\"server\">Server</md-input>\n      </div>\n      <div class=\"row\">\n        <md-select :value.sync=\"wantedState\" label=\"Wanted state\">\n          <md-option value=\"connected\" :selected=\"'connected' == wantedState\">Connected</md-option>\n          <md-option value=\"disconnected\" :selected=\"'disconnected' == wantedState\">Disconnected</md-option>\n        </md-select>\n      </div>\n      <div class=\"row\">\n        <md-input :value.sync=\"nick\" :placeholder=\"defaultNick\">Nick</md-input>\n      </div>\n      <div class=\"row\">\n        <div class=\"col s12\">\n          <input type=\"checkbox\" class=\"filled-in\" id=\"form_tls\" v-model=\"tls\">\n          <label for=\"form_tls\">Secure connection (TLS)</label>\n          <template v-if=\"tls\">\n            <input type=\"checkbox\" class=\"filled-in\" id=\"form_tls_verify\" v-model=\"tls_verify\">\n            <label for=\"form_tls_verify\">Verify certificate (TLS)</label>\n          </template>\n        </div>\n      </div>\n    </template>\n    <template v-if=\"!connection.url\">\n      <div class=\"row\">\n        <md-input :value.sync=\"server\" placeholder=\"Example: chat.freenode.net:6697\" :readonly=\"settings.forced_irc_server\" cols=\"s6\" name=\"server\">Server</md-input>\n        <md-input :value.sync=\"nick\" placeholder=\"Example: jan_henning\" cols=\"s6\">Nick</md-input>\n      </div>\n    </template>\n    <div class=\"row\">\n      <div class=\"col s12\">\n        <input type=\"checkbox\" class=\"filled-in\" id=\"form_advanced_settings\" v-model=\"advancedSettings\">\n        <label for=\"form_advanced_settings\">Advanced settings...</label>\n      </div>\n    </div>\n    <template v-if=\"advancedSettings\">\n      <div class=\"row\">\n        <md-input :value.sync=\"username\" cols=\"s6\">Username</md-input>\n        <md-input :value.sync=\"password\" cols=\"s6\" type=\"password\" :readonly=\"settings.forced_irc_server\">Password</md-input>\n      </div>\n      <div class=\"row on-connect-commands\">\n        <md-textarea v-ref:occ :value.sync=\"onConnectCommands\" placeholder=\"/msg NickServ identify supersecret\">On Connect Commands (one per line)</md-textarea>\n      </div>\n    </template>\n    <div class=\"row\" v-if=\"errors.length\">\n      <div class=\"col s12\"><div class=\"alert\">{{errors[0].message}}</div></div>\n    </div>\n    <div class=\"row\">\n      <div class=\"col s12\">\n        <button type=\"submit\" @click=\"saveConnection\" class=\"btn waves-effect waves-light\">{{connection.url ? \"Save\" : \"Create\"}}</button>\n        <a href=\"#delete\" @click.prevent=\"removeConnection\" class=\"btn-delete\" v-if=\"connection.url\">Delete</a>\n        <p v-if=\"connection.url\">{{humanState()}}</p>\n      </div>\n    </div>\n  </form>\n"})})();