/*
 * Decompiled with CFR 0.152.
 */
package com.vizdom.util;

import com.vizdom.util.CharacterEncoder;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

class CharacterEncoderWriter
extends Writer {
    private CharacterEncoder mEncoder;
    private OutputStream mOutputStream;

    CharacterEncoderWriter(OutputStream anOutputStream, CharacterEncoder anEncoder) {
        this.mEncoder = anEncoder;
        this.mOutputStream = anOutputStream;
    }

    private void mEnsureValid() throws IOException {
        if (this.mOutputStream == null || this.mEncoder == null) {
            throw new IOException();
        }
    }

    @Override
    public void write(char[] aCharacterBuffer, int anOffset, int aLength) throws IOException {
        this.mEnsureValid();
        if (aCharacterBuffer == null) {
            throw new NullPointerException();
        }
        if (anOffset < 0 || aLength < 0 || anOffset + aLength > aCharacterBuffer.length) {
            throw new IndexOutOfBoundsException();
        }
        if (aLength == 0) {
            return;
        }
        byte[] b = this.mEncoder.gConvert(aCharacterBuffer, anOffset, aLength);
        this.mOutputStream.write(b);
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        this.mEnsureValid();
        this.mOutputStream.close();
        this.mOutputStream = null;
        this.mEncoder = null;
    }
}

