# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl Audio-GSM.t'

#########################

# change 'tests => 2' to 'tests => last_test_to_print';

use Test::More (tests => 6);
BEGIN { use_ok('Audio::GSM') };


my $fail = 0;
foreach my $constname (qw(
	GSM_MAGIC GSM_MAJOR GSM_MINOR GSM_OPT_FAST GSM_OPT_FRAME_CHAIN
	GSM_OPT_FRAME_INDEX GSM_OPT_LTP_CUT GSM_OPT_VERBOSE GSM_OPT_WAV49
	GSM_PATCHLEVEL NeedFunctionPrototypes)) {
  next if (eval "my \$a = $constname; 1");
  if ($@ =~ /^Your vendor has not defined Audio::GSM macro $constname/) {
    print "# pass: $@";
  } else {
    print "# fail: $@";
    $fail = 1;
  }

}

ok( $fail == 0 , 'Constants' );
#########################

# Insert your test code below, the Test::More module is use()ed here so read
# its man page ( perldoc Test::More ) for help writing this test script.

my $gsm = new_ok('Audio::GSM');
ok(
   $gsm->option(GSM_OPT_WAV49) == 0
   && $gsm->option(GSM_OPT_WAV49, 0) == 0
   && $gsm->option(GSM_OPT_WAV49, 1) == 0
   && $gsm->option(GSM_OPT_WAV49, 1) == 1
   && $gsm->option(GSM_OPT_WAV49) == 1,
   'option'
);
my $gsmData = pack('H*', '0fe68ecd8282f52449922409c3660449922419a506244992248907072449922409');
my $pcmData = pack('H*', '002a882bf829f82db82b1029282c00294026d828a8255822102558245823f0272027d825402a4829d827302c182b9829d02da02c082b383120328832803800391839e03e283f203fc044f844c844384440459046b046b84600473847f84680463847d8465046d0464846b84528468845f8446045c04420448844e0434843a84300436842c84228429041f0415041c04020418840f03f5840c03f303f983f003f703e003f683ed83d483eb83d303da83d183d983c103d803c003c783ce83b683bd83b503bd03a503bc83a483ac83a403ac839403ac0394039c0393839c0384039b8384038c8384038c8375838d8376037d0375037e0367037f0368036103798362836b8364836d8357036003690352836b8355035f03580351835b0354035d83478350835a0343835c8346834003598343034d0346034f83398342834c8335033');
is($gsm->decode($gsmData), pack('H*', '002a882bf829f82db82b1029282c00294026d828a8255822102558245823f0272027d825402a4829d827302c182b9829d02da02c082b383120328832803800391839e03e283f203fc044f844c844384440459046b046b84600473847f84680463847d8465046d0464846b84528468845f8446045c04420448844e0434843a84300436842c84228429041f0415041c04020418840f03f5840c03f303f983f003f703e003f683ed83d483eb83d303da83d183d983c103d803c003c783ce83b683bd83b503bd03a503bc83a483ac83a403ac839403ac0394039c0393839c0384039b8384038c8384038c8375838d8376037d0375037e0367037f0368036103798362836b8364836d8357036003690352836b8355035f03580351835b0354035d83478350835a0343835c8346834003598343034d0346034f83398342834c8335033'), 'decode');
is($gsm->encode($pcmData), pack('H*', 'c0604b5d2cf049bf8d24499230644890dcb66d5162c072dbb66d7860d076dbb66d'), 'encode');
