# NAME

App::Greple::xlate - ενότητα υποστήριξης μετάφρασης για το greple

# SYNOPSIS

    greple -Mxlate::deepl --xlate pattern target-file

# VERSION

Version 0.16

# DESCRIPTION

Η ενότητα **Greple** **xlate** βρίσκει μπλοκ κειμένου και τα αντικαθιστά με το μεταφρασμένο κείμενο. Επί του παρόντος, μόνο η υπηρεσία DeepL υποστηρίζεται από την ενότητα **xlate::deepl**.

Αν θέλετε να μεταφράσετε κανονικό μπλοκ κειμένου σε έγγραφο στυλ [pod](https://metacpan.org/pod/pod), χρησιμοποιήστε την εντολή **greple** με την ενότητα `xlate::deepl` και `perl` ως εξής:

    greple -Mxlate::deepl -Mperl --pod --re '^(\w.*\n)+' --all foo.pm

Το πρότυπο `^(\w.*\n)+` σημαίνει διαδοχικές γραμμές που αρχίζουν με αλφαριθμητικό γράμμα. Αυτή η εντολή δείχνει την περιοχή που πρέπει να μεταφραστεί. Η επιλογή **--all** χρησιμοποιείται για την παραγωγή ολόκληρου του κειμένου.

<div>
    <p>
    <img width="750" src="https://raw.githubusercontent.com/kaz-utashiro/App-Greple-xlate/main/images/select-area.png">
    </p>
</div>

Στη συνέχεια, προσθέστε την επιλογή `--xlate` για να μεταφράσετε την επιλεγμένη περιοχή. Θα τα βρει και θα τα αντικαταστήσει με την έξοδο της εντολής **deepl**.

Από προεπιλογή, το πρωτότυπο και το μεταφρασμένο κείμενο εκτυπώνονται σε μορφή "δείκτη σύγκρουσης" συμβατή με το [git(1)](http://man.he.net/man1/git). Χρησιμοποιώντας τη μορφή `ifdef`, μπορείτε να λάβετε εύκολα το επιθυμητό τμήμα με την εντολή [unifdef(1)](http://man.he.net/man1/unifdef). Η μορφή μπορεί να καθοριστεί με την επιλογή **--xlate-format**.

<div>
    <p>
    <img width="750" src="https://raw.githubusercontent.com/kaz-utashiro/App-Greple-xlate/main/images/format-conflict.png">
    </p>
</div>

Αν θέλετε να μεταφράσετε ολόκληρο το κείμενο, χρησιμοποιήστε την επιλογή **--match-entire**. Αυτή είναι μια σύντομη διαδρομή για να καθορίσετε το μοτίβο που ταιριάζει με ολόκληρο το κείμενο `(?s).*`.

# OPTIONS

- **--xlate**
- **--xlate-color**
- **--xlate-fold**
- **--xlate-fold-width**=_n_ (Default: 70)

    Προκαλέστε τη διαδικασία μετάφρασης για κάθε περιοχή που ταιριάζει.

    Χωρίς αυτή την επιλογή, η **greple** συμπεριφέρεται ως κανονική εντολή αναζήτησης. Έτσι, μπορείτε να ελέγξετε ποιο τμήμα του αρχείου θα αποτελέσει αντικείμενο της μετάφρασης πριν από την επίκληση της πραγματικής εργασίας.

    Το αποτέλεσμα της εντολής πηγαίνει στην τυπική έξοδο, οπότε ανακατευθύνετε σε αρχείο αν είναι απαραίτητο, ή σκεφτείτε να χρησιμοποιήσετε την ενότητα [App::Greple::update](https://metacpan.org/pod/App%3A%3AGreple%3A%3Aupdate).

    Η επιλογή **--xlate** καλεί την επιλογή **--xlate-color** με την επιλογή **--color=never**.

    Με την επιλογή **--xlate-fold**, το μετατρεπόμενο κείμενο διπλώνεται κατά το καθορισμένο πλάτος. Το προεπιλεγμένο πλάτος είναι 70 και μπορεί να οριστεί με την επιλογή **--xlate-fold-width**. Τέσσερις στήλες είναι δεσμευμένες για τη λειτουργία run-in, οπότε κάθε γραμμή μπορεί να περιέχει 74 χαρακτήρες το πολύ.

- **--xlate-engine**=_engine_

    Καθορίστε τη μηχανή μετάφρασης που θα χρησιμοποιηθεί. Δεν χρειάζεται να χρησιμοποιήσετε αυτή την επιλογή επειδή η ενότητα `xlate::deepl` τη δηλώνει ως `--xlate-engine=deepl`.

- **--xlate-labor**
- **--xlabor**

    Αντί να καλείτε μηχανή μετάφρασης, αναμένεται να εργαστείτε για. Μετά την προετοιμασία του προς μετάφραση κειμένου, αντιγράφονται στο πρόχειρο. Αναμένεται να τα επικολλήσετε στη φόρμα, να αντιγράψετε το αποτέλεσμα στο πρόχειρο και να πατήσετε return.

- **--xlate-to** (Default: `EN-US`)

    Καθορίστε τη γλώσσα-στόχο. Μπορείτε να λάβετε τις διαθέσιμες γλώσσες με την εντολή `deepl languages` όταν χρησιμοποιείτε τη μηχανή **DeepL**.

- **--xlate-format**=_format_ (Default: `conflict`)

    Καθορίστε τη μορφή εξόδου για το αρχικό και το μεταφρασμένο κείμενο.

    - **conflict**, **cm**

        Εκτυπώστε το πρωτότυπο και το μεταφρασμένο κείμενο σε μορφή δείκτη σύγκρουσης [git(1)](http://man.he.net/man1/git).

            <<<<<<< ORIGINAL
            original text
            =======
            translated Japanese text
            >>>>>>> JA

        Μπορείτε να ανακτήσετε το αρχικό αρχείο με την επόμενη εντολή [sed(1)](http://man.he.net/man1/sed).

            sed -e '/^<<<<<<< /d' -e '/^=======$/,/^>>>>>>> /d'

    - **ifdef**

        Εκτύπωση πρωτότυπου και μεταφρασμένου κειμένου σε μορφή [cpp(1)](http://man.he.net/man1/cpp) `#ifdef`.

            #ifdef ORIGINAL
            original text
            #endif
            #ifdef JA
            translated Japanese text
            #endif

        Μπορείτε να ανακτήσετε μόνο το ιαπωνικό κείμενο με την εντολή **unifdef**:

            unifdef -UORIGINAL -DJA foo.ja.pm

    - **space**

        Εκτύπωση του πρωτότυπου και του μεταφρασμένου κειμένου χωρισμένα με μία μόνο κενή γραμμή.

    - **xtxt**

        Εάν η μορφή είναι `xtxt` (μεταφρασμένο κείμενο) ή άγνωστη, εκτυπώνεται μόνο το μεταφρασμένο κείμενο.

- **--xlate-maxlen**=_chars_ (Default: 0)

    Καθορίστε το μέγιστο μήκος του κειμένου που θα αποστέλλεται στο API ταυτόχρονα. Η προεπιλεγμένη τιμή ορίζεται όπως για την υπηρεσία δωρεάν λογαριασμού: 128K για το API (**--xlate**) και 5000 για τη διεπαφή πρόχειρου (**--xlate-labor**). Μπορεί να μπορείτε να αλλάξετε αυτές τις τιμές αν χρησιμοποιείτε την υπηρεσία Pro.

- **--**\[**no-**\]**xlate-progress** (Default: True)

    Δείτε το αποτέλεσμα της μετάφρασης σε πραγματικό χρόνο στην έξοδο STDERR.

- **--match-entire**

    Ορίστε ολόκληρο το κείμενο του αρχείου ως περιοχή-στόχο.

# CACHE OPTIONS

Η ενότητα **xlate** μπορεί να αποθηκεύσει το αποθηκευμένο κείμενο της μετάφρασης για κάθε αρχείο και να το διαβάσει πριν από την εκτέλεση, ώστε να εξαλειφθεί η επιβάρυνση από την ερώτηση στον διακομιστή. Με την προεπιλεγμένη στρατηγική κρυφής μνήμης `auto`, διατηρεί τα δεδομένα της κρυφής μνήμης μόνο όταν το αρχείο κρυφής μνήμης υπάρχει για το αρχείο-στόχο.

- --cache-clear

    Η επιλογή **--cache-clear** μπορεί να χρησιμοποιηθεί για να ξεκινήσει η διαχείριση της κρυφής μνήμης ή για να ανανεωθούν όλα τα υπάρχοντα δεδομένα της κρυφής μνήμης. Μόλις εκτελεστεί με αυτή την επιλογή, θα δημιουργηθεί ένα νέο αρχείο cache αν δεν υπάρχει και στη συνέχεια θα διατηρηθεί αυτόματα.

- --xlate-cache=_strategy_
    - `auto` (Default)

        Διατήρηση του αρχείου κρυφής μνήμης εάν υπάρχει.

    - `create`

        Δημιουργεί κενό αρχείο κρυφής μνήμης και τερματίζει.

    - `always`, `yes`, `1`

        Διατηρεί την κρυφή μνήμη ούτως ή άλλως εφόσον ο στόχος είναι κανονικό αρχείο.

    - `clear`

        Καθαρίστε πρώτα τα δεδομένα της κρυφής μνήμης.

    - `never`, `no`, `0`

        Δεν χρησιμοποιεί ποτέ το αρχείο κρυφής μνήμης ακόμη και αν υπάρχει.

    - `accumulate`

        Σύμφωνα με την προεπιλεγμένη συμπεριφορά, τα αχρησιμοποίητα δεδομένα αφαιρούνται από το αρχείο προσωρινής αποθήκευσης. Αν δεν θέλετε να τα αφαιρέσετε και να τα διατηρήσετε στο αρχείο, χρησιμοποιήστε το `accumulate`.

# ENVIRONMENT

- DEEPL\_AUTH\_KEY

    Ορίστε το κλειδί ελέγχου ταυτότητας για την υπηρεσία DeepL.

# INSTALL

## CPANMINUS

    $ cpanm App::Greple::xlate

# SEE ALSO

[App::Greple::xlate](https://metacpan.org/pod/App%3A%3AGreple%3A%3Axlate)

- [https://github.com/DeepLcom/deepl-python](https://github.com/DeepLcom/deepl-python)

    DeepL βιβλιοθήκη Python και εντολή CLI.

- [App::Greple](https://metacpan.org/pod/App%3A%3AGreple)

    Ανατρέξτε στο εγχειρίδιο **greple** για λεπτομέρειες σχετικά με το μοτίβο κειμένου-στόχου. Χρησιμοποιήστε τις επιλογές **--inside**, **--outside**, **--include**, **--exclude** για να περιορίσετε την περιοχή αντιστοίχισης.

- [App::Greple::update](https://metacpan.org/pod/App%3A%3AGreple%3A%3Aupdate)

    Μπορείτε να χρησιμοποιήσετε την ενότητα `-Mupdate` για να τροποποιήσετε αρχεία με βάση το αποτέλεσμα της εντολής **greple**.

- [App::sdif](https://metacpan.org/pod/App%3A%3Asdif)

    Χρησιμοποιήστε την εντολή **sdif** για να εμφανίσετε τη μορφή του δείκτη σύγκρουσης δίπλα-δίπλα με την επιλογή **-V**.

# AUTHOR

Kazumasa Utashiro

# LICENSE

Copyright © 2023 Kazumasa Utashiro.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.
