use Eirotic;
use XML::Tag::html5bp;
use Exporter 'import';
our @EXPORT = qw< html5bp >;

# sub charset :prototype(;$) ($charset = "utf-8" ) { qq(<meta charset="$charset">) }
# sub meta_equiv ($k, $v) { qq(<meta http-equiv="$k" content="$v">) }
# sub nocp :prototype() { qq(<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">) }

our %defaults =
( html     => +{qw( class no-js lang en )}
, charset  => 'utf-8'
, body_def => +{}
);

sub html5bp {

    my %my;
    @my{qw( title content )} = (shift, pop);

    %my = ( %defaults
        , @_
        , %my );

    '<!doctype html>'
    , html { $my{html},
        
        head
            { qq(<meta charset="$my{charset}">)
            , qq(<title>$my{title}</title>) 
            , qq(<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">)
            , qq(<meta name="description" content="">)
            , qq(<meta name="viewport" content="width=device-width, initial-scale=1">)
            , qq(<link rel="apple-touch-icon" href="apple-touch-icon.png">)
            , '<style>body{padding-top:50px;padding-bottom:20px;}</style>'
            , ( map import_css, qw(
                css/bootstrap.min.css
                css/bootstrap-theme.min.css
                css/main.css ) ) },

        body {

            '<!--[if lt IE 8]>'
            , '<p class="browserupgrade">You are using an <strong>outdated</strong> browser.'
            , 'Please <a href="http://browsehappy.com/">upgrade your browser</a> to improve your experience.</p>'
            , '<![endif]-->'
            , $my{content}()
        }

    }
}

1;

__END__ 
        modernizr js/vendor/modernizr-2.8.3-respond-1.4.2.min.js

    <nav class="navbar navbar-inverse navbar-fixed-top" role="navigation">
      <div class="container">
        <div class="navbar-header">
          <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#navbar" aria-expanded="false" aria-controls="navbar">
            <span class="sr-only">Toggle navigation</span>
            <span class="icon-bar"></span>
            <span class="icon-bar"></span>
            <span class="icon-bar"></span>
          </button>
          <a class="navbar-brand" href="#">Project name</a>
        </div>
        <div id="navbar" class="navbar-collapse collapse">
          <form class="navbar-form navbar-right" role="form">
            <div class="form-group">
              <input type="text" placeholder="Email" class="form-control">
            </div>
            <div class="form-group">
              <input type="password" placeholder="Password" class="form-control">
            </div>
            <button type="submit" class="btn btn-success">Sign in</button>
          </form>
        </div><!--/.navbar-collapse -->
      </div>
    </nav>

    <!-- Main jumbotron for a primary marketing message or call to action -->
    <div class="jumbotron">
      <div class="container">
        <h1>Hello, world!</h1>
        <p>This is a template for a simple marketing or informational website. It includes a large callout called a jumbotron and three supporting pieces of content. Use it as a starting point to create something more unique.</p>
        <p><a class="btn btn-primary btn-lg" href="#" role="button">Learn more &raquo;</a></p>
      </div>
    </div>

    <div class="container">
      <!-- Example row of columns -->
      <div class="row">
        <div class="col-md-4">
          <h2>Heading</h2>
          <p>Donec id elit non mi porta gravida at eget metus. Fusce dapibus, tellus ac cursus commodo, tortor mauris condimentum nibh, ut fermentum massa justo sit amet risus. Etiam porta sem malesuada magna mollis euismod. Donec sed odio dui. </p>
          <p><a class="btn btn-default" href="#" role="button">View details &raquo;</a></p>
        </div>
        <div class="col-md-4">
          <h2>Heading</h2>
          <p>Donec id elit non mi porta gravida at eget metus. Fusce dapibus, tellus ac cursus commodo, tortor mauris condimentum nibh, ut fermentum massa justo sit amet risus. Etiam porta sem malesuada magna mollis euismod. Donec sed odio dui. </p>
          <p><a class="btn btn-default" href="#" role="button">View details &raquo;</a></p>
       </div>
        <div class="col-md-4">
          <h2>Heading</h2>
          <p>Donec sed odio dui. Cras justo odio, dapibus ac facilisis in, egestas eget quam. Vestibulum id ligula porta felis euismod semper. Fusce dapibus, tellus ac cursus commodo, tortor mauris condimentum nibh, ut fermentum massa justo sit amet risus.</p>
          <p><a class="btn btn-default" href="#" role="button">View details &raquo;</a></p>
        </div>
      </div>

      <hr>

      <footer>
        <p>&copy; Company 2015</p>
      </footer>
    </div> <!-- /container -->        <script src="//ajax.googleapis.com/ajax/libs/jquery/1.11.2/jquery.min.js"></script>
        <script>window.jQuery || document.write('<script src="js/vendor/jquery-1.11.2.min.js"><\/script>')</script>

        <script src="js/vendor/bootstrap.min.js"></script>

        <script src="js/main.js"></script>
    </body>
</html>
