
package ZooZ::DefaultArgs;
$ZooZ::DefaultArgs::VERSION = '1.9.1';
use strict;

our %defaultWidgetArgs = (
			  'Image' => sub {
			    return {-image => 'image-zooz'};
			  },
			  'Label' => sub {
			    my $n = shift;
			    return {-text => $n};
			  },
			  'Button' => sub {
			    my $n = shift;
			    return {-text => $n};
			  },
			  'Checkbutton' => sub {
			    my $n = shift;
			    return {-text => $n};
			  },
			  'Radiobutton' => sub {
			    my $n = shift;
			    return {-text => $n};
			  },
			  'Labelframe' => sub {
			    my $n = shift;
			    return {-text     => $n };
			  },
			  Optionmenu => sub {
			    return {-textvariable => undef};
			  },
			  #			  Frame        => sub {  # Pane .. really
			  #			    return {
			  #				    #-gridded => 'xy',
			  #				    -sticky  => 'nsew',
			  #				    -width   => 200,
			  #				    -height  => 200,
			  #				   },
			  #			},
			 );

our %defaultPlacementArgs = (
			     Frame => {
				       -sticky => 'nsew',
				      },
			    );

sub getDefaultWidgetArgs {
  my ($class, $w, $n) = @_;

  return exists $defaultWidgetArgs{$w} ?
    $defaultWidgetArgs{$w}->($n) : {};
}

sub getDefaultPlacementArgs {
  my ($class, $w) = @_;

  return exists $defaultPlacementArgs{$w} ?
    $defaultPlacementArgs{$w} : {};
}

__END__

=pod

=encoding UTF-8

=head1 NAME

ZooZ::DefaultArgs

=head1 VERSION

version 1.9.1

=head1 AUTHOR

Ala Qumsieh, faraco <skelic3@gmail.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2004-2005, 2018 by Ala Qumsieh, faraco.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
