use strict;
use warnings;

package App::Embra::Plugin::Zilla::WrapLog;
$App::Embra::Plugin::Zilla::WrapLog::VERSION = '0.001'; # TRIAL
# ABSTRACT: wraps embra logger to suit dzil plugins

use Method::Signatures;
use Moo;

with 'App::Embra::Role::Logging';

my %_log_level_map = (
    log => 'info',
    log_debug => 'debug',
    log_fatal => 'fatal',
);

has '_wrap_logger' => (
    is => 'lazy',
    handles => \%_log_level_map,
    default => method { $self->logger },
);

has 'proxy_prefix' => (
    is => 'ro',
    required => 1,
);

around 'log_prefix' => func( $orig, $self ) {
    $self->proxy_prefix;
};

while( my ($w, $r) = each %_log_level_map ) {
    around $w => func( $orig, $self, $log_msg ) {
        $self->logger->$r( $self->log_prefix . $log_msg );
    };
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

App::Embra::Plugin::Zilla::WrapLog - wraps embra logger to suit dzil plugins

=head1 VERSION

version 0.001

=head1 AUTHOR

Daniel Holz <dgholz@gmail.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Daniel Holz.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
