package # M - memory/mapping
	M;  # Hide from PAUSE

use utf8;
use strict;
use warnings;


our $num2month =  {
	'01' => 'january',   '02' => 'febrary',    '03' => 'march',
	'04' => 'april',     '05' => 'may',        '06' => 'june',
	'07' => 'july',      '08' => 'august',     '09' => 'september',
	'10' => 'october',   '11' => 'november',   '12' => 'december',

	1 => 'january',   2 => 'febrary',   3 => 'march',
	4 => 'april',     5 => 'may',       6 => 'june',
	7 => 'july',      8 => 'august',    9 => 'september',
};

our $mon2num =  {
	jan => '01', feb => '02', mar => '03', apr => '04',
	may => '05', jun => '06', jul => '07', aug => '08',
	sep => '09', oct => '10', nov => '11', dec => '12',
};



1;

=encoding utf8

=head1 NAME

M - Stands for memory/mapping


=head1 SYNOPSIS

  use M;

  my $name =  $M::num2month->{ '01' };  # january
  my $num  =  $M::mon2num->{ jan };     # 01


=head1 DESCRIPTION

M contains small, shared lookup tables or could be used to cache things.


=head1 DATA

=head2 $num2month

Hash reference mapping month numbers to lowercase month names.

It contains keys in both zero-padded string form (C<'01'>) and numeric form
(C<1>).


=head2 $mon2num

Hash reference mapping 3-letter lowercase month abbreviations (C<jan>, C<feb>,
...) to zero-padded month numbers (C<'01'> .. C<'12'>).


=head1 SEE ALSO

L<A>, L<C>, L<I>, L<L>, L<M>, L<S>, L<T>, L<U>.

=cut
