# Generated by default/object.tt
package Paws::GreengrassV2::ComponentDeploymentSpecification;
  use Moose;
  has ComponentVersion => (is => 'ro', isa => 'Str', request_name => 'componentVersion', traits => ['NameInRequest']);
  has ConfigurationUpdate => (is => 'ro', isa => 'Paws::GreengrassV2::ComponentConfigurationUpdate', request_name => 'configurationUpdate', traits => ['NameInRequest']);
  has RunWith => (is => 'ro', isa => 'Paws::GreengrassV2::ComponentRunWith', request_name => 'runWith', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::GreengrassV2::ComponentDeploymentSpecification

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GreengrassV2::ComponentDeploymentSpecification object:

  $service_obj->Method(Att1 => { ComponentVersion => $value, ..., RunWith => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GreengrassV2::ComponentDeploymentSpecification object:

  $result = $service_obj->Method(...);
  $result->Att1->ComponentVersion

=head1 DESCRIPTION

Contains information about a component to deploy.

=head1 ATTRIBUTES


=head2 ComponentVersion => Str

The version of the component.


=head2 ConfigurationUpdate => L<Paws::GreengrassV2::ComponentConfigurationUpdate>

The configuration updates to deploy for the component. You can define
I<reset> updates and I<merge> updates. A reset updates the keys that
you specify to the default configuration for the component. A merge
updates the core device's component configuration with the keys and
values that you specify. The AWS IoT Greengrass Core software applies
reset updates before it applies merge updates. For more information,
see Update component configurations
(https://docs.aws.amazon.com/greengrass/v2/developerguide/update-component-configurations.html)
in the I<AWS IoT Greengrass V2 Developer Guide>.


=head2 RunWith => L<Paws::GreengrassV2::ComponentRunWith>

The system user and group that the AWS IoT Greengrass Core software
uses to run component processes on the core device. If you omit this
parameter, the AWS IoT Greengrass Core software uses the system user
and group that you configure for the core device. For more information,
see Configure the user and group that run components
(https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-user)
in the I<AWS IoT Greengrass V2 Developer Guide>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GreengrassV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

