# Generated by default/object.tt
package Paws::AppMesh::GatewayRouteSpec;
  use Moose;
  has GrpcRoute => (is => 'ro', isa => 'Paws::AppMesh::GrpcGatewayRoute', request_name => 'grpcRoute', traits => ['NameInRequest']);
  has Http2Route => (is => 'ro', isa => 'Paws::AppMesh::HttpGatewayRoute', request_name => 'http2Route', traits => ['NameInRequest']);
  has HttpRoute => (is => 'ro', isa => 'Paws::AppMesh::HttpGatewayRoute', request_name => 'httpRoute', traits => ['NameInRequest']);
  has Priority => (is => 'ro', isa => 'Int', request_name => 'priority', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AppMesh::GatewayRouteSpec

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AppMesh::GatewayRouteSpec object:

  $service_obj->Method(Att1 => { GrpcRoute => $value, ..., Priority => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AppMesh::GatewayRouteSpec object:

  $result = $service_obj->Method(...);
  $result->Att1->GrpcRoute

=head1 DESCRIPTION

An object that represents a gateway route specification. Specify one
gateway route type.

=head1 ATTRIBUTES


=head2 GrpcRoute => L<Paws::AppMesh::GrpcGatewayRoute>

An object that represents the specification of a gRPC gateway route.


=head2 Http2Route => L<Paws::AppMesh::HttpGatewayRoute>

An object that represents the specification of an HTTP/2 gateway route.


=head2 HttpRoute => L<Paws::AppMesh::HttpGatewayRoute>

An object that represents the specification of an HTTP gateway route.


=head2 Priority => Int

The ordering of the gateway routes spec.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AppMesh>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

