#!/usr/bin/perl

package eBay::API::XML::Call::GetCharities;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetCharities.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetCharities

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetCharities inherits from the L<eBay::API::XML::BaseCall> class

=cut

use eBay::API::XML::BaseCall;
our @ISA = ("eBay::API::XML::BaseCall");

use eBay::API::XML::Call::GetCharities::GetCharitiesRequestType;
use eBay::API::XML::Call::GetCharities::GetCharitiesResponseType;


=head1 Subroutines:

=cut

sub getApiCallName {
   return 'GetCharities';
}
sub getRequestDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetCharities::GetCharitiesRequestType';
}
sub getResponseDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetCharities::GetCharitiesResponseType';
}

#
# input properties
#

=head2 setCharityDomain()

Domain (mission area) that a nonprofit charity organization
belongs to. Nonprofit charity organizations may belong to multiple
mission areas. Meaning of input values differs depending on the
site. See GetCharities in the API Developer's Guide for the meaning
of each input/output value. CharityDomain input value must be valid for
that SiteID.

  RequiredInput: No
#    Argument: 'xs:int'

=cut
       
sub setCharityDomain {
   my $self   = shift;
   my $sCharityDomain = shift;
   $self->getRequestDataType()->setCharityDomain($sCharityDomain);
}

=head2 setCharityID()

A unique identification number assigned by eBay to registered nonprofit
charity organizations.

  RequiredInput: No
#    Argument: 'xs:string'

=cut
       
sub setCharityID {
   my $self   = shift;
   my $sCharityID = shift;
   $self->getRequestDataType()->setCharityID($sCharityID);
}

=head2 setCharityName()

A name assigned to a specified nonprofit
organization. Accepts full charity nonprofit name
or partial name as input. For example, enter a
CharityName of "heart" (case-insensitive) to
return all charity nonprofits that start with
"heart." Use with a MatchType value of "Contains"
to return all charity nonprofits that contain the
string "heart."

MaxLength: 150

  RequiredInput: No
#    Argument: 'xs:string'

=cut
       
sub setCharityName {
   my $self   = shift;
   my $sCharityName = shift;
   $self->getRequestDataType()->setCharityName($sCharityName);
}

=head2 setCharityRegion()

Region that the nonprofit charity organization is associated
with. A specific nonprofit charity organization may be associated
with only one region. Meaning of input values differs depending on
the site. See GetCharities in the API Developer's Guide for the meaning
of each input/output value. CharityRegion input value must be
valid for that SiteID.

  RequiredInput: No
#    Argument: 'xs:int'

=cut
       
sub setCharityRegion {
   my $self   = shift;
   my $sCharityRegion = shift;
   $self->getRequestDataType()->setCharityRegion($sCharityRegion);
}

=head2 setFeatured()

Used to decide if the search is only for featured charities.
A value of true will search for only featured charities.

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut
       
sub setFeatured {
   my $self   = shift;
   my $sFeatured = shift;
   $self->getRequestDataType()->setFeatured($sFeatured);
}

=head2 setIncludeDescription()

Used with Query to search for charity nonprofit
organizations. A value of true will search the Mission field as
well as the CharityName field for a string specified in Query.

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut
       
sub setIncludeDescription {
   my $self   = shift;
   my $sIncludeDescription = shift;
   $self->getRequestDataType()->setIncludeDescription($sIncludeDescription);
}

=head2 setMatchType()

Indicates the type of string matching to use when a value is submitted in
CharityName. If no value is specified, default behavior is "StartsWith."
Does not apply to Query.

  RequiredInput: No
#    Argument: 'ns:StringMatchCodeType'

=cut
       
sub setMatchType {
   my $self   = shift;
   my $sMatchType = shift;
   $self->getRequestDataType()->setMatchType($sMatchType);
}

=head2 setQuery()

Accepts a case-insensitive string used to
find a nonprofit charity organization. Default
behavior is to search the CharityName field. Use
with an IncludeDescription value of true to
include the Mission field in the search.

MaxLength: 350 (characters)

  RequiredInput: No
#    Argument: 'xs:string'

=cut
       
sub setQuery {
   my $self   = shift;
   my $sQuery = shift;
   $self->getRequestDataType()->setQuery($sQuery);
}



#
# output properties
#

=head2 getCharity()

Contains information about charity nonprofit organizations that
meet the criteria specified in the request. One Charity node is
returned for each applicable nonprofit charity organization. The
CharityID value is returned as an id attribute of this node. If no
nonprofit charity organization is applicable, this node is not
returned.

  Returned: Conditionally
#    Returns: reference to an array  
                      of 'ns:CharityInfoType'

=cut
       
sub getCharity {
   my $self = shift;
   return $self->getResponseDataType()->getCharity();
}





1;   
