# astro-ads

Perl interface to the Harvard Astrophysics Data System (ADS) abstract service


## Getting Started

1. You'll need an API key from NASA ADS labs. Sign up for the newest version of ADS search at https://ui.adsabs.harvard.edu, visit account settings and generate a new API token. The official documentation is available at https://github.com/adsabs/adsabs-dev-api

2. When you get your API key, save it to a file called ~/.ads/dev_key or save it as an environment variable named ADS_DEV_KEY

3. From a terminal type `cpan install Astro::ADS`



## Acknowledgements

I've been cribbing documentation from Andy Casey's [notes](https://github.com/adsabs/ads)

# Authors

Re-write for ADS Bumblebee by [Boyd Duffee](https://github.com/duffee)

Originally written by Alasdair Allan
<aa@astro.ex.ac.uk>, of the University of Exeter Astrophysics Group
(http://www.astro.ex.ac.uk/) as part of his work for the eSTAR project
with Tim Jenness <timj@jach.hawaii.edu> of the Joint Astronomy Centre (JAC)
in Hawaii.


# Terms and Conditions

Use of this library implies acceptance of the terms and conditions of use
of the Astrophysical Data Service (ADS) Abstract Service, for full details
see http://adswww.harvard.edu/use.html

# License

Astro::ADS is licensed under the MIT licence. 
