use strict;
use warnings;
use Test::More;
use UUID ();


UUID::generate(my $bin1);

UUID::copy(my $bin2, $bin1);
ok 1;

done_testing;
__END__

is $bin1, $bin2, 'vanilla';


#### legacy

my ($save1, $save2);

# make sure we get back a null if src isnt sane
$bin1 = 'x';
UUID::copy( $bin2, $bin1 );
ok UUID::is_null( $bin2 );
$bin1 = 'another really really really long sting';
UUID::copy( $bin2, $bin1 );
ok UUID::is_null( $bin2 );

# sane copy
UUID::generate( $bin1 );
$bin2 = '1234567890123456';
UUID::copy( $bin2, $bin1 );
is UUID::compare( $bin1, $bin2 ), 0;

# make sure we get back the same scalar we passed in
$bin1 = '1234567890123456';
UUID::generate( $bin2 );
$save1 = \$bin2;
UUID::copy( $bin2, $bin1 );
$save2 = \$bin2;
is $save1, $save2;
is $$save1, $$save2;

done_testing;
