/*    BiDi.xs
 *
 *    $Id: BiDi.xs,v 1.1 2001/02/12 03:54:52 bstell Exp $
 *
 *    Copyright (c) 2000 Brian Stell
 *
 *    This package is free software and is provided ``as is'' without
 *    express or implied warranty. It may be used, redistributed and/or
 *    modified under the terms of the Perl Artistic License
 *    (see http://www.perl.com/perl/misc/Artistic.html)
 *
 */

extern "C" {
#include <stdio.h>
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
}

#include  "picu/picu_debug.h"
#include  "picu/picu_utf8.h"
#include  "picu/picu_util.h"
#include  "unicode/bidi.h"

static int debugLevel = 0;

MODULE = ICU::BiDi    PACKAGE = ICU::BiDi

# This requires xsubpp version 1.925 or greater
REQUIRE: 1.925

void
BiDi::DESTROY()
    CODE:
        DEBUG100("BiDi::DESTROY()");
        delete THIS;

int
BiDi::isInverse()
    CODE:
        RETVAL = THIS->isInverse();
    OUTPUT:
        RETVAL

BiDi *
BiDi::new(svr_status=0)
        SV *svr_status;
    PREINIT:
        UErrorCode status = U_ZERO_ERROR;
    CODE:
        if (svr_status) {
            if (!SVIsIntRef(svr_status)) {
                Perl_croak(aTHX_ "ICU::BiDi->new: "
                           "status must be an integer reference");
            }
            status = (UErrorCode)SvIV(SvRV(svr_status));
            RETVAL = new BiDi(status);
            sv_setiv(SvRV(svr_status), (IV)status);
        }
        else {
            RETVAL = new BiDi;
        }
    OUTPUT:
        RETVAL

void
BiDi::setInverse(isInverse)
        int isInverse;
    CODE:
	DEBUG100("isInverse = %d", isInverse);
        THIS->setInverse(isInverse);

int
setDebugLevel(...)
    CODE:
        RETVAL = debugLevel; // return old value
        if (items > 1) {
            Perl_croak(aTHX_ "Usage: ICU::BiDi::setDebugLevel"
                             "([new_debug_level])");
        }
        else if (items == 1) {
            debugLevel = SvIV(ST(0));
        }
        DEBUG100("debugLevel = %d", debugLevel);
    OUTPUT:
        RETVAL

