use strict;
use warnings;
use Test::More;
use Digest::JH qw(jh_384 jh_384_hex);

my $len = 0;

while (my $line = <DATA>) {
    chomp $line;
    my ($msg, $digest) = split '\|', $line, 2;
    my $data = pack 'H*', $msg;
    $digest = lc $digest;

    if ($len and not $len % 8) {
        my $md = Digest::JH->new(384)->add($data)->hexdigest;
        is($md, $digest, "new/add/hexdigest: $len bits of $msg");
        is(
            jh_384_hex($data), $digest,
            "jh_384_hex: $len bits of $msg"
        );
        ok(
            jh_384($data) eq pack('H*', $digest),
            "jh_384: $len bits of $msg"
        );
    }

    my $md = Digest::JH->new(384)->add_bits($data, $len)
        ->hexdigest;
    is($md, $digest, "new/add_bits/hexdigest: $len bits of $msg");
}
continue { $len++ }

done_testing;

__DATA__
00|2fe5f71b1b3290d3c017fb3c1a4d02a5cbeb03a0476481e25082434a881994b0ff99e078d2c16b105ad069b569315328
00|3cdd9cced9655cf4942c62dd03370186d890156a2ab54bcbfc91f4ca1c84a5f1901164a4b3fea90f762bba6483a8a093
C0|ef9bf23cbbd9fd7d725c46cfc1fa88f3df5eeab55b558fdacdb0bc7bc4f177a8850a4333e5baab96e9dfb915c28499ae
C0|46ae1baca789f910a6b8ba983444bfc3f390a80acb5e26452f8d5de3b2fd931756f42cad1df56f11cce0c7780dd1d971
80|f839c08b9444514f611f5b57ef2e7f37a40e18f8762c07e3ae49933505c0813ea4222ae50a64b23f9f67cd1f31eb3d94
48|7e21841a901a5e96d1d6c085bc7ed6eeb5f5ba273b8c4eebe4e42098afbaac6bb8be9cd046ef95b1d52fa2657469b59a
50|5aafcb068190e9f4a440a6741d8a4952b393edec52deb2d3d6a4ae1cc1e46f2ea44b7a1376f9850968937b289fabe134
98|66062469fc31d64b6f4a9a501599c09abd71423d1aadb3e70d1a5ef39ad16c7437d1a02c0f3049aa5327dfc388276189
CC|ccfa3732089cb4d49af04daa865cb2376bfa264e527b5eb8486cd09b3fb9a8019140a1ca9df7539efbb3a3118d8e0584
9800|b049daaa7fde22b70535b6baeb0aff5af3140e7711efd2457cb167d43865c1a066aa379d4ea706f06fbe9b01ed3b0e20
9D40|c7acbfe0e6ba678a713b591761edc152dc3c1727fce4d3a95a6e0ad2dc3ffa43f7ecba50175a3eba9d3600d91dd3d22e
AA80|b2b76fb2a3b4a5f787d7450f41fd6d10e111a40f5d5f43497a626dec4045a3efe3fd0f25cf76d58ee2303576803a418b
9830|e1241926ced974fcb709394d37c7a3b0ea2b60cdd178faf36ba2850d384ebdbf2520b4b5a97a5d5bdc0551edf641e390
5030|3f713e61cf1742f3dfef396408e1d0dd8c6daf860494a8d2a687f3c351c35c1e2d274dbb7c58198285416bd37bb96a03
4D24|0c4d94b40113dd34bc31913db56ec9523692b13346c9e7e88f3a7a8e38fcd2da9992c445784219f0987dd0ba0d4043f6
CBDE|50c864543b827d2ca28b7c5a6d81506ea50de4e077c84dc78c36f83bf5c4f2686cf2888ef1482edb22350fcf6794e588
41FB|5cd8bead6785a56e184f388c2edeae5502ff59b82d214f472c378ac33e451cc16bc91feeb7b7702718431e7c8550be85
4FF400|642e221b8ced73a936a898e6dbe1b9e78fc0f16671cb035ae4793f635012f1ed705f0bb302eb2a367ae824c3421c797f
FD0440|7c80af3f6315a79ee7c217546cded44e836f252454cde1abdf517a2ffb8bff2dec58171fd41d9bb81cf6f551db03daa1
424D00|7f2dca0f6f3773af2ab7e430eec74710837aabc5a145b483a9553ccd0564d6f44a9d6d7f6392a88cdbe0d5b70ec3e5c8
3FDEE0|cf8bc2c3923117f7b381d4d04de208dcb44129a84a32892277df69a1f0c6c7d658c7ee3ccd92f395a617d3f2bba42391
335768|18b0b7b7ac2d098f5d02ec6f729941f14c526b2a30d5b63bf35a982b53befc5a568a49fd4a98bf7c2d0d7a338a9b5af9
051E7C|2fe1c5c3bdca87d7adb2b45c30b692ceee66d7eadd37b7bcb8b03d1a08e321931c02ebe387b5fb5837eee3b4dcbf9982
717F8C|04baee81d2e19917808f3de5021ec9448ab32e2e52ef1b7798718e1d8b2d93bde520c16b10bd1b3665575fd09c4bd11b
1F877C|05d72081179c4f5e839c88cc991ed7e8625bcc5f1a61a23588e57ea7656dc372fadfacb0626e0d48fd819de3ee96c3ea
EB35CF80|0a8094d9261cef8e7b6dd25c0bb9a1e973317b97b26cb830b0f197fdd890aca88985db8bf3b4542d5e5e9d23845e4445
B406C480|01498fa5901d72a96cf00c48bd297a511519a56d2de58dbb4ff43f43e4e3aceb78e1d2035a6e8b689c63f4a2e4cc469a
CEE88040|2a68984d090350917859cdb5559b849994d3645359424b33bc83248ea753a4fca550a332816573b4bc96bbe081a85dc9
C584DB70|2462fb81166919175953653467c4feb61afc0f468de93a88ae40de9b058704c4017e2f1fb141e72ee2441122a997e953
53587BC8|99bae52a656f7dca13a10a082c50e1f1abee0fe0cbc6d3e793e0426807f5595172f945944bd5b502d64408e4d4105b4a
69A305B0|30f4d281f863ed728198ad5c0d632e97b495496790263e1628529505801d8ce01d3da4c62b9cad81d81393a791968ce1
C9375ECE|7ca27ad988fecea60ca8657f96a6e2cc32837b3e0ea398a552259cb065928fabc02f295ae1bbacea5758f0bd7257a55c
C1ECFDFC|ab94a321da66a0c1385fde960c1a9196a5f3e2d0c68c0778a66f2a663498227c067ba167f99b56cad5e0234723c3ce5e
8D73E8A280|840ebd58151c05aaec049011cd19f072e7c6bef3131ae4b539f9dab733e38e305e15009f49fa72d9f5e3c7bf9bb0e0c6
06F2522080|f3bf34b214a395e1d9c82ce406ee9f723cdd981aed8359e06346ece70f5041a9f617b90508c2cd2ccdb44bac11ec3047
3EF6C36F20|a59fdbc9b3012c72f5aefa6dad3c7c8719657d76212dc3fe7a0dc58c17ba99426299bd85c4b5a6e2f331ad30a950ac67
0127A1D340|6fb84001394751dbed8bef95d2e70fbd9f994af9b72c2f3c0c1abeb31f7be4672f6bdd62fe94a4a46a3bd983d73a25c2
6A6AB6C210|7252cb74f33c28e672249725905a4876f80b782328655b1d36aad5c973d13f7f6af5337c5dcdc0eca43dadf9c478f1d6
AF3175E160|81ef47527ed9b98037707a3f890abc5593ee0ccc8b91199a016b319b2fdcc38ef95e33a70252bb6e48a1117e8da73501
B66609ED86|d92dcbfa6be94c2f2dfdd136cdf89a2a6fa18bb790b0739a083127dcf0c9a9eedb41e11d8df42ce995bbede53022ea28
21F134AC57|4687363ae0d1bd0b57797f7f98b6860f16478a2d4ce3e3892b2c9deed97c5c2efcb86e09ae7bbc397316451e1ee4b200
3DC2AADFFC80|826de43ec7366ffc00c10bea88682cab2a28f517cd8327782b502fc33cfed611db44f4a52b31c538c814912b5d51e7af
9202736D2240|11a2593bdfef12c31b7037ce38f844bbd0d4bba27a09f661d21f7303b922af6cfd37cb24663307add0ce5fe25e8af7f6
F219BD629820|34a0d8f6cdd6f1d9e7f637dd33e284158f7aa0d8476f4f002acc1e2e7b4f4b036209730c2f1d5ad58da27113172b7108
F3511EE2C4B0|b3826d4404709211b8e34cb6c5d168b5163ab0dcf04423878f9d7df8aba15dee70899267e8f757d3a77625a568d24a56
3ECAB6BF7720|9ccd6274f7e91266a6f2d6b8761f0b2665f439042b42656a20bfa3f380660a6ee2b6b086fe92b65d83df4c6519f6d8f6
CD62F688F498|14452cdcbccfab904ec934ba25882fa133ba4bed680e410493155a7a052f61937cba8f89d658f23bb787f11cbb5d0fa5
C2CBAA33A9F8|87b859a38d67b26a5eade50b768834d0a31308cce9a98197e3429a180a297568a11e2f289596a25fe66ba2f14392bbe3
C6F50BB74E29|b34fa483ff2797884855e7271570b41a261e7984658a6a79f6f120b2804b8288369f1e55f782a41352044afaf53eb2b6
79F1B4CCC62A00|a7c2a3e46b3cc257756da5e6bd2b4529c09d99703d6a00b5e923d263d4bca12e10f49ab5d1aec07e4064bd75cdc1f206
