/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.tiny;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tree.NamespaceNode;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.PrependAxisIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.tree.tiny.AncestorIterator;
import net.sf.saxon.tree.tiny.AttributeIterator;
import net.sf.saxon.tree.tiny.DescendantIterator;
import net.sf.saxon.tree.tiny.FollowingIterator;
import net.sf.saxon.tree.tiny.PrecedingIterator;
import net.sf.saxon.tree.tiny.PrecedingSiblingIterator;
import net.sf.saxon.tree.tiny.SiblingIterator;
import net.sf.saxon.tree.tiny.TinyAttributeImpl;
import net.sf.saxon.tree.tiny.TinyDocumentImpl;
import net.sf.saxon.tree.tiny.TinyParentNodeImpl;
import net.sf.saxon.tree.tiny.TinyTree;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.type.SchemaType;

public abstract class TinyNodeImpl
implements NodeInfo {
    protected TinyTree tree;
    protected int nodeNr;
    protected TinyNodeImpl parent = null;
    public static final char[] NODE_LETTER = new char[]{'x', 'e', 'a', 't', 'x', 'x', 'x', 'p', 'c', 'r', 'x', 'x', 'x', 'n'};

    public TreeInfo getTreeInfo() {
        return this.tree;
    }

    public NodeInfo head() {
        return this;
    }

    public UnfailingIterator iterate() {
        return SingletonIterator.makeIterator(this);
    }

    public CharSequence getStringValueCS() {
        return this.getStringValue();
    }

    public SchemaType getSchemaType() {
        return null;
    }

    public int getColumnNumber() {
        return this.tree.getColumnNumber(this.nodeNr);
    }

    public String getPublicId() {
        return null;
    }

    public void setSystemId(String uri) {
        this.tree.setSystemId(this.nodeNr, uri);
    }

    protected void setParentNode(TinyNodeImpl parent) {
        this.parent = parent;
    }

    public boolean isSameNodeInfo(NodeInfo other) {
        return this == other || other instanceof TinyNodeImpl && this.tree == ((TinyNodeImpl)other).tree && this.nodeNr == ((TinyNodeImpl)other).nodeNr && this.getNodeKind() == other.getNodeKind();
    }

    public boolean equals(Object other) {
        return other instanceof NodeInfo && this.isSameNodeInfo((NodeInfo)other);
    }

    public int hashCode() {
        return (int)(this.tree.getDocumentNumber() & 0x3FFL) << 20 ^ this.nodeNr ^ this.getNodeKind() << 14;
    }

    public String getSystemId() {
        return this.tree.getSystemId(this.nodeNr);
    }

    public String getBaseURI() {
        return this.getParent().getBaseURI();
    }

    public int getLineNumber() {
        return this.tree.getLineNumber(this.nodeNr);
    }

    public Location saveLocation() {
        return this;
    }

    protected long getSequenceNumber() {
        return (long)this.nodeNr << 32;
    }

    public final int compareOrder(NodeInfo other) {
        long a = this.getSequenceNumber();
        if (other instanceof TinyNodeImpl) {
            long b = ((TinyNodeImpl)other).getSequenceNumber();
            if (a < b) {
                return -1;
            }
            if (a > b) {
                return 1;
            }
            return 0;
        }
        return 0 - other.compareOrder(this);
    }

    public int comparePosition(NodeInfo other) {
        if (other instanceof TinyNodeImpl && !(other instanceof TinyAttributeImpl)) {
            TinyNodeImpl a = this;
            TinyNodeImpl b = (TinyNodeImpl)other;
            if (a.isSameNodeInfo(b)) {
                return 12;
            }
            if (a.isAncestorOrSelf(b)) {
                return 0;
            }
            if (b.isAncestorOrSelf(a)) {
                return 4;
            }
            if (a.compareOrder(b) < 0) {
                return 10;
            }
            return 6;
        }
        throw new UnsupportedOperationException();
    }

    public final boolean hasFingerprint() {
        return true;
    }

    public int getFingerprint() {
        int nc = this.tree.nameCode[this.nodeNr];
        if (nc == -1) {
            return -1;
        }
        return nc & 0xFFFFF;
    }

    public String getPrefix() {
        int code = this.tree.nameCode[this.nodeNr];
        if (code < 0) {
            return "";
        }
        if (!NamePool.isPrefixed(code)) {
            return "";
        }
        return this.tree.prefixPool.getPrefix(code >> 20);
    }

    public String getURI() {
        int code = this.tree.nameCode[this.nodeNr];
        if (code < 0) {
            return "";
        }
        return this.tree.getNamePool().getURI(code & 0xFFFFF);
    }

    public String getDisplayName() {
        int code = this.tree.nameCode[this.nodeNr];
        if (code < 0) {
            return "";
        }
        if (NamePool.isPrefixed(code)) {
            return this.getPrefix() + ":" + this.getLocalPart();
        }
        return this.getLocalPart();
    }

    public String getLocalPart() {
        int code = this.tree.nameCode[this.nodeNr];
        if (code < 0) {
            return "";
        }
        return this.tree.getNamePool().getLocalName(code);
    }

    public AxisIterator iterateAxis(byte axisNumber) {
        if (axisNumber == 3) {
            if (this.hasChildNodes()) {
                return new SiblingIterator(this.tree, this, null, true);
            }
            return EmptyIterator.OfNodes.THE_INSTANCE;
        }
        return this.iterateAxis(axisNumber, AnyNodeTest.getInstance());
    }

    public AxisIterator iterateAxis(byte axisNumber, NodeTest nodeTest) {
        int type = this.getNodeKind();
        switch (axisNumber) {
            case 0: {
                return new AncestorIterator(this, nodeTest);
            }
            case 1: {
                AncestorIterator ancestors = new AncestorIterator(this, nodeTest);
                if (nodeTest.matchesNode(this)) {
                    return new PrependAxisIterator(this, ancestors);
                }
                return ancestors;
            }
            case 2: {
                if (type != 1) {
                    return EmptyIterator.OfNodes.THE_INSTANCE;
                }
                if (this.tree.alpha[this.nodeNr] < 0) {
                    return EmptyIterator.OfNodes.THE_INSTANCE;
                }
                return new AttributeIterator(this.tree, this.nodeNr, nodeTest);
            }
            case 3: {
                if (this.hasChildNodes()) {
                    return new SiblingIterator(this.tree, this, nodeTest, true);
                }
                return EmptyIterator.OfNodes.THE_INSTANCE;
            }
            case 4: {
                if (type == 9 && nodeTest instanceof NameTest && nodeTest.getPrimitiveType() == 1) {
                    return ((TinyDocumentImpl)this).getAllElements(nodeTest.getFingerprint());
                }
                if (this.hasChildNodes()) {
                    return new DescendantIterator(this.tree, this, nodeTest);
                }
                return EmptyIterator.OfNodes.THE_INSTANCE;
            }
            case 5: {
                if (this.hasChildNodes()) {
                    DescendantIterator descendants = new DescendantIterator(this.tree, this, nodeTest);
                    if (nodeTest.matchesNode(this)) {
                        return new PrependAxisIterator(this, descendants);
                    }
                    return descendants;
                }
                return Navigator.filteredSingleton(this, nodeTest);
            }
            case 6: {
                if (type == 2 || type == 13) {
                    return new FollowingIterator(this.tree, (TinyNodeImpl)this.getParent(), nodeTest, true);
                }
                if (this.tree.depth[this.nodeNr] == 0) {
                    return EmptyIterator.OfNodes.THE_INSTANCE;
                }
                return new FollowingIterator(this.tree, this, nodeTest, false);
            }
            case 7: {
                if (type == 2 || type == 13 || this.tree.depth[this.nodeNr] == 0) {
                    return EmptyIterator.OfNodes.THE_INSTANCE;
                }
                return new SiblingIterator(this.tree, this, nodeTest, false);
            }
            case 8: {
                if (type != 1) {
                    return EmptyIterator.OfNodes.THE_INSTANCE;
                }
                return NamespaceNode.makeIterator(this, nodeTest);
            }
            case 9: {
                NodeInfo parent = this.getParent();
                return Navigator.filteredSingleton(parent, nodeTest);
            }
            case 10: {
                if (type == 2 || type == 13) {
                    return new PrecedingIterator(this.tree, (TinyNodeImpl)this.getParent(), nodeTest, false);
                }
                if (this.tree.depth[this.nodeNr] == 0) {
                    return EmptyIterator.OfNodes.THE_INSTANCE;
                }
                return new PrecedingIterator(this.tree, this, nodeTest, false);
            }
            case 11: {
                if (type == 2 || type == 13 || this.tree.depth[this.nodeNr] == 0) {
                    return EmptyIterator.OfNodes.THE_INSTANCE;
                }
                return new PrecedingSiblingIterator(this.tree, this, nodeTest);
            }
            case 12: {
                return Navigator.filteredSingleton(this, nodeTest);
            }
            case 13: {
                if (type == 9) {
                    return EmptyIterator.OfNodes.THE_INSTANCE;
                }
                if (type == 2 || type == 13) {
                    TinyNodeImpl el = (TinyNodeImpl)this.getParent();
                    return new PrependAxisIterator(el, new PrecedingIterator(this.tree, el, nodeTest, true));
                }
                return new PrecedingIterator(this.tree, this, nodeTest, true);
            }
        }
        throw new IllegalArgumentException("Unknown axis number " + axisNumber);
    }

    public NodeInfo getParent() {
        if (this.parent != null) {
            return this.parent;
        }
        int p = TinyNodeImpl.getParentNodeNr(this.tree, this.nodeNr);
        this.parent = p == -1 ? null : this.tree.getNode(p);
        return this.parent;
    }

    static int getParentNodeNr(TinyTree tree, int nodeNr) {
        if (tree.depth[nodeNr] == 0) {
            return -1;
        }
        int p = tree.next[nodeNr];
        while (p > nodeNr) {
            if (tree.nodeKind[p] == 12) {
                return tree.alpha[p];
            }
            p = tree.next[p];
        }
        return p;
    }

    public boolean hasChildNodes() {
        return false;
    }

    public String getAttributeValue(String uri, String local) {
        return null;
    }

    public NodeInfo getRoot() {
        return this.nodeNr == 0 ? this : this.tree.getRootNode();
    }

    public Configuration getConfiguration() {
        return this.tree.getConfiguration();
    }

    public NamePool getNamePool() {
        return this.tree.getNamePool();
    }

    public NamespaceBinding[] getDeclaredNamespaces(NamespaceBinding[] buffer) {
        return null;
    }

    public void generateId(FastStringBuffer buffer) {
        buffer.append("d");
        buffer.append(Long.toString(this.tree.getDocumentNumber()));
        buffer.append(NODE_LETTER[this.getNodeKind()]);
        buffer.append(Integer.toString(this.nodeNr));
    }

    public boolean isAncestorOrSelf(TinyNodeImpl d) {
        if (this.tree != d.tree) {
            return false;
        }
        int dn = d.nodeNr;
        if (d instanceof TinyAttributeImpl) {
            if (this instanceof TinyAttributeImpl) {
                return this.nodeNr == dn;
            }
            dn = this.tree.attParent[dn];
        }
        if (this instanceof TinyAttributeImpl) {
            return false;
        }
        if (this.nodeNr > dn) {
            return false;
        }
        if (this.nodeNr == dn) {
            return true;
        }
        if (!(this instanceof TinyParentNodeImpl)) {
            return false;
        }
        if (this.tree.depth[this.nodeNr] >= this.tree.depth[dn]) {
            return false;
        }
        int n = this.nodeNr;
        while (true) {
            int nextSib;
            if ((nextSib = this.tree.next[n]) < 0 || nextSib > dn) {
                return true;
            }
            if (this.tree.depth[nextSib] == 0) {
                return true;
            }
            if (nextSib >= n) break;
            n = nextSib;
        }
        return false;
    }

    public boolean isId() {
        return false;
    }

    public boolean isIdref() {
        return false;
    }

    public boolean isNilled() {
        return this.tree.isNilled(this.nodeNr);
    }

    public boolean isStreamed() {
        return false;
    }

    public TinyTree getTree() {
        return this.tree;
    }

    public int getNodeNumber() {
        return this.nodeNr;
    }
}

