# Generated by default/object.tt
package Paws::LicenseManager::License;
  use Moose;
  has Beneficiary => (is => 'ro', isa => 'Str');
  has ConsumptionConfiguration => (is => 'ro', isa => 'Paws::LicenseManager::ConsumptionConfiguration');
  has CreateTime => (is => 'ro', isa => 'Str');
  has Entitlements => (is => 'ro', isa => 'ArrayRef[Paws::LicenseManager::Entitlement]');
  has HomeRegion => (is => 'ro', isa => 'Str');
  has Issuer => (is => 'ro', isa => 'Paws::LicenseManager::IssuerDetails');
  has LicenseArn => (is => 'ro', isa => 'Str');
  has LicenseMetadata => (is => 'ro', isa => 'ArrayRef[Paws::LicenseManager::Metadata]');
  has LicenseName => (is => 'ro', isa => 'Str');
  has ProductName => (is => 'ro', isa => 'Str');
  has ProductSKU => (is => 'ro', isa => 'Str');
  has Status => (is => 'ro', isa => 'Str');
  has Validity => (is => 'ro', isa => 'Paws::LicenseManager::DatetimeRange');
  has Version => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::LicenseManager::License

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LicenseManager::License object:

  $service_obj->Method(Att1 => { Beneficiary => $value, ..., Version => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LicenseManager::License object:

  $result = $service_obj->Method(...);
  $result->Att1->Beneficiary

=head1 DESCRIPTION

Software license that is managed in AWS License Manager.

=head1 ATTRIBUTES


=head2 Beneficiary => Str

License beneficiary.


=head2 ConsumptionConfiguration => L<Paws::LicenseManager::ConsumptionConfiguration>

Configuration for consumption of the license.


=head2 CreateTime => Str

License creation time.


=head2 Entitlements => ArrayRef[L<Paws::LicenseManager::Entitlement>]

License entitlements.


=head2 HomeRegion => Str

Home Region of the license.


=head2 Issuer => L<Paws::LicenseManager::IssuerDetails>

License issuer.


=head2 LicenseArn => Str

Amazon Resource Name (ARN) of the license.


=head2 LicenseMetadata => ArrayRef[L<Paws::LicenseManager::Metadata>]

License metadata.


=head2 LicenseName => Str

License name.


=head2 ProductName => Str

Product name.


=head2 ProductSKU => Str

Product SKU.


=head2 Status => Str

License status.


=head2 Validity => L<Paws::LicenseManager::DatetimeRange>

Date and time range during which the license is valid, in ISO8601-UTC
format.


=head2 Version => Str

License version.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LicenseManager>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

