# Generated by default/object.tt
package Paws::Transfer::DescribedServer;
  use Moose;
  has Arn => (is => 'ro', isa => 'Str', required => 1);
  has Certificate => (is => 'ro', isa => 'Str');
  has Domain => (is => 'ro', isa => 'Str');
  has EndpointDetails => (is => 'ro', isa => 'Paws::Transfer::EndpointDetails');
  has EndpointType => (is => 'ro', isa => 'Str');
  has HostKeyFingerprint => (is => 'ro', isa => 'Str');
  has IdentityProviderDetails => (is => 'ro', isa => 'Paws::Transfer::IdentityProviderDetails');
  has IdentityProviderType => (is => 'ro', isa => 'Str');
  has LoggingRole => (is => 'ro', isa => 'Str');
  has ProtocolDetails => (is => 'ro', isa => 'Paws::Transfer::ProtocolDetails');
  has Protocols => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has SecurityPolicyName => (is => 'ro', isa => 'Str');
  has ServerId => (is => 'ro', isa => 'Str');
  has State => (is => 'ro', isa => 'Str');
  has Tags => (is => 'ro', isa => 'ArrayRef[Paws::Transfer::Tag]');
  has UserCount => (is => 'ro', isa => 'Int');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Transfer::DescribedServer

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Transfer::DescribedServer object:

  $service_obj->Method(Att1 => { Arn => $value, ..., UserCount => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Transfer::DescribedServer object:

  $result = $service_obj->Method(...);
  $result->Att1->Arn

=head1 DESCRIPTION

Describes the properties of a file transfer protocol-enabled server
that was specified.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Arn => Str

Specifies the unique Amazon Resource Name (ARN) of the server.


=head2 Certificate => Str

Specifies the ARN of the Amazon Web ServicesCertificate Manager (ACM)
certificate. Required when C<Protocols> is set to C<FTPS>.


=head2 Domain => Str

Specifies the domain of the storage system that is used for file
transfers.


=head2 EndpointDetails => L<Paws::Transfer::EndpointDetails>

The virtual private cloud (VPC) endpoint settings that are configured
for your server. When you host your endpoint within your VPC, you can
make it accessible only to resources within your VPC, or you can attach
Elastic IP addresses and make it accessible to clients over the
internet. Your VPC's default security groups are automatically assigned
to your endpoint.


=head2 EndpointType => Str

Defines the type of endpoint that your server is connected to. If your
server is connected to a VPC endpoint, your server isn't accessible
over the public internet.


=head2 HostKeyFingerprint => Str

Specifies the Base64-encoded SHA256 fingerprint of the server's host
key. This value is equivalent to the output of the C<ssh-keygen -l -f
my-new-server-key> command.


=head2 IdentityProviderDetails => L<Paws::Transfer::IdentityProviderDetails>

Specifies information to call a customer-supplied authentication API.
This field is not populated when the C<IdentityProviderType> of a
server is C<AWS_DIRECTORY_SERVICE> or C<SERVICE_MANAGED>.


=head2 IdentityProviderType => Str

Specifies the mode of authentication for a server. The default value is
C<SERVICE_MANAGED>, which allows you to store and access user
credentials within the Amazon Web Services Transfer Family service.

Use C<AWS_DIRECTORY_SERVICE> to provide access to Active Directory
groups in Amazon Web Services Managed Active Directory or Microsoft
Active Directory in your on-premises environment or in Amazon Web
Services using AD Connectors. This option also requires you to provide
a Directory ID using the C<IdentityProviderDetails> parameter.

Use the C<API_GATEWAY> value to integrate with an identity provider of
your choosing. The C<API_GATEWAY> setting requires you to provide an
API Gateway endpoint URL to call for authentication using the
C<IdentityProviderDetails> parameter.


=head2 LoggingRole => Str

Specifies the Amazon Resource Name (ARN) of the Amazon Web Services
Identity and Access Management (IAM) role that allows a server to turn
on Amazon CloudWatch logging for Amazon S3 or Amazon EFS events. When
set, user activity can be viewed in your CloudWatch logs.


=head2 ProtocolDetails => L<Paws::Transfer::ProtocolDetails>

The protocol settings that are configured for your server.

Use the C<PassiveIp> parameter to indicate passive mode. Enter a single
dotted-quad IPv4 address, such as the external IP address of a
firewall, router, or load balancer.


=head2 Protocols => ArrayRef[Str|Undef]

Specifies the file transfer protocol or protocols over which your file
transfer protocol client can connect to your server's endpoint. The
available protocols are:

=over

=item *

C<SFTP> (Secure Shell (SSH) File Transfer Protocol): File transfer over
SSH

=item *

C<FTPS> (File Transfer Protocol Secure): File transfer with TLS
encryption

=item *

C<FTP> (File Transfer Protocol): Unencrypted file transfer

=back



=head2 SecurityPolicyName => Str

Specifies the name of the security policy that is attached to the
server.


=head2 ServerId => Str

Specifies the unique system-assigned identifier for a server that you
instantiate.


=head2 State => Str

Specifies the condition of a server for the server that was described.
A value of C<ONLINE> indicates that the server can accept jobs and
transfer files. A C<State> value of C<OFFLINE> means that the server
cannot perform file transfer operations.

The states of C<STARTING> and C<STOPPING> indicate that the server is
in an intermediate state, either not fully able to respond, or not
fully offline. The values of C<START_FAILED> or C<STOP_FAILED> can
indicate an error condition.


=head2 Tags => ArrayRef[L<Paws::Transfer::Tag>]

Specifies the key-value pairs that you can use to search for and group
servers that were assigned to the server that was described.


=head2 UserCount => Int

Specifies the number of users that are assigned to a server you
specified with the C<ServerId>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Transfer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

