# Generated by default/object.tt
package Paws::LookoutMetrics::CsvFormatDescriptor;
  use Moose;
  has Charset => (is => 'ro', isa => 'Str');
  has ContainsHeader => (is => 'ro', isa => 'Bool');
  has Delimiter => (is => 'ro', isa => 'Str');
  has FileCompression => (is => 'ro', isa => 'Str');
  has HeaderList => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has QuoteSymbol => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::LookoutMetrics::CsvFormatDescriptor

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LookoutMetrics::CsvFormatDescriptor object:

  $service_obj->Method(Att1 => { Charset => $value, ..., QuoteSymbol => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LookoutMetrics::CsvFormatDescriptor object:

  $result = $service_obj->Method(...);
  $result->Att1->Charset

=head1 DESCRIPTION

Contains information about how a source CSV data file should be
analyzed.

=head1 ATTRIBUTES


=head2 Charset => Str

The character set in which the source CSV file is written.


=head2 ContainsHeader => Bool

Whether or not the source CSV file contains a header.


=head2 Delimiter => Str

The character used to delimit the source CSV file.


=head2 FileCompression => Str

The level of compression of the source CSV file.


=head2 HeaderList => ArrayRef[Str|Undef]

A list of the source CSV file's headers, if any.


=head2 QuoteSymbol => Str

The character used as a quote character.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LookoutMetrics>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

