#============================================================= -*-Perl-*-
#
# Lemplate::Grammar
#
# DESCRIPTION
#   Grammar file for the Template Toolkit language containing token
#   definitions and parser state/rules tables generated by Parse::Yapp.
#
# AUTHOR
#   Ingy döt Net   <ingy@cpan.org>
#
# ORIGINAL AUTHOR
#   Andy Wardley   <abw@kfs.org>
#
# COPYRIGHT
#   Copyright (C) 2006-2008 Ingy döt Net.
#   Copyright (C) 1996-2000 Andy Wardley.
#   Copyright (C) 1998-2000 Canon Research Centre Europe Ltd.
#
#   This module is free software; you can redistribute it and/or
#   modify it under the same terms as Perl itself.
#
#------------------------------------------------------------------------
#
# NOTE: this module is constructed from the parser/Grammar.pm.skel
# file by running the parser/yc script.  You only need to do this if
# you have modified the grammar in the parser/Parser.yp file and need
# to-recompile it.  See the README in the 'parser' directory for more
# information (sub-directory of the Lemplate distribution).
#
#========================================================================

package Lemplate::Grammar;

require 5.004;

use strict;
use vars qw( $VERSION );

$VERSION  = '0.14';

my (@RESERVED, %CMPOP, $LEXTABLE, $RULES, $STATES);
my ($factory, $rawstart);


#========================================================================
# Reserved words, comparison and binary operators
#========================================================================

@RESERVED = qw( 
	GET CALL SET DEFAULT INSERT INCLUDE PROCESS WRAPPER BLOCK END
	USE RAW PLUGIN FILTER MACRO JAVASCRIPT TO STEP AND OR NOT DIV MOD
	IF UNLESS ELSE ELSIF FOR NEXT WHILE SWITCH CASE META IN
	TRY THROW CATCH FINAL LAST RETURN STOP CLEAR VIEW DEBUG
    );

# for historical reasons, != and == are converted to ne and eq to perform 
# stringwise comparison (mainly because it doesn't generate "non-numerical 
# comparison" warnings which != and == can) but the others (e.g. < > <= >=)
# are not converted to their stringwise equivalents.  I added 'gt' et al, 
# briefly for v2.04d and then took them out again in 2.04e.

%CMPOP = qw( 
    != ~=
    == ==
    <  <
    >  >
    >= >=
    <= <=
);


#========================================================================
# Lexer Token Table
#========================================================================

# lookup table used by lexer is initialised with special-cases
$LEXTABLE = {
    'FOREACH' => 'FOR',
    'BREAK'   => 'LAST',
    '&&'      => 'AND',
    '||'      => 'OR',
    '!'       => 'NOT',
    '|'	      => 'FILTER',
    '.'       => 'DOT',
    '_'       => 'CAT',
    '..'      => 'TO',
#    ':'       => 'MACRO',
    '='       => 'ASSIGN',
    '=>'      => 'ASSIGN',
#    '->'      => 'ARROW',
    ','       => 'COMMA',
    '\\'      => 'REF',
    'and'     => 'AND',		# explicitly specified so that qw( and or
    'or'      => 'OR',		# not ) can always be used in lower case, 
    'not'     => 'NOT',		# regardless of ANYCASE flag
    'mod'     => 'MOD',
    'div'     => 'DIV',
};

# localise the temporary variables needed to complete lexer table
{ 
#    my @tokens = qw< ( ) [ ] { } ${ $ / ; : ? >;
    my @tokens = qw< ( ) [ ] { } ${ $ + / ; : ? >;
    my @cmpop  = keys %CMPOP;
#    my @binop  = qw( + - * % );              # '/' above, in @tokens
    my @binop  = qw( - * % );              # '+' and '/' above, in @tokens

    # fill lexer table, slice by slice, with reserved words and operators
    @$LEXTABLE{ @RESERVED, @cmpop, @binop, @tokens } 
	= ( @RESERVED, ('CMPOP') x @cmpop, ('BINOP') x @binop, @tokens );
}


#========================================================================
# CLASS METHODS
#========================================================================

sub new {
    my $class = shift;
    bless {
	LEXTABLE => $LEXTABLE,
	STATES   => $STATES,
	RULES    => $RULES,
    }, $class;
}

# update method to set package-scoped $factory lexical 
sub install_factory {
    my ($self, $new_factory) = @_;
    $factory = $new_factory;
}


#========================================================================
# States
#========================================================================

$STATES = [
	{#State 0
		ACTIONS => {
			'FILTER' => 1,
			'INSERT' => 2,
			'CALL' => 37,
			"[" => 36,
			'IDENT' => 3,
			'LITERAL' => 4,
			'WHILE' => 5,
			'META' => 38,
			"(" => 40,
			'NUMBER' => 43,
			'LAST' => 6,
			"{" => 8,
			'SET' => 45,
			'MACRO' => 44,
			"\${" => 9,
			'PROCESS' => 50,
			'CLEAR' => 11,
			'perl' => 12,
			'JAVASCRIPT' => 53,
			'BLOCK' => 52,
			'FOR' => 55,
			'rawperl' => 54,
			'VIEW' => 56,
			'USE' => 57,
			"\"" => 18,
			'STOP' => 20,
			'NOT' => 22,
			'SWITCH' => 60,
			'REF' => 62,
			'IF' => 64,
			"\$" => 63,
			'TEXT' => 65,
			'RETURN' => 66,
			'DEFAULT' => 67,
			'DEBUG' => 26,
			'WRAPPER' => 27,
			'NEXT' => 29,
			";" => -19,
			'UNLESS' => 30,
			'THROW' => 31,
			'GET' => 32,
			'INCLUDE' => 33,
			'RAW' => 35,
			'TRY' => 75
		},
		DEFAULT => -3,
		GOTOS => {
			'try' => 58,
			'wrapper' => 19,
			'defblockname' => 61,
			'setlist' => 59,
			'raw' => 21,
			'ident' => 23,
			'condition' => 25,
			'atomdir' => 24,
			'defblock' => 28,
			'template' => 68,
			'chunks' => 69,
			'javascript' => 71,
			'sterm' => 70,
			'use' => 34,
			'node' => 74,
			'statement' => 73,
			'expr' => 72,
			'chunk' => 39,
			'atomexpr' => 42,
			'term' => 41,
			'lterm' => 46,
			'block' => 7,
			'switch' => 10,
			'macro' => 49,
			'view' => 48,
			'filter' => 47,
			'assign' => 51,
			'anonblock' => 14,
			'capture' => 13,
			'directive' => 17,
			'item' => 16,
			'loop' => 15
		}
	},
	{#State 1
		ACTIONS => {
			'IDENT' => 80,
			"\$" => 84,
			'LITERAL' => 79,
			'FILENAME' => 82,
			"\${" => 9,
			"\"" => 77,
			'NUMBER' => 87
		},
		GOTOS => {
			'filepart' => 83,
			'lvalue' => 85,
			'lnameargs' => 76,
			'names' => 78,
			'name' => 88,
			'item' => 81,
			'filename' => 86,
			'nameargs' => 89
		}
	},
	{#State 2
		ACTIONS => {
			'LITERAL' => 90,
			"\$" => 94,
			'IDENT' => 91,
			'FILENAME' => 82,
			"\"" => 92,
			'NUMBER' => 87
		},
		GOTOS => {
			'filename' => 86,
			'nameargs' => 93,
			'name' => 88,
			'names' => 78,
			'filepart' => 83
		}
	},
	{#State 3
		DEFAULT => -131
	},
	{#State 4
		ACTIONS => {
			'ASSIGN' => 95
		},
		DEFAULT => -113
	},
	{#State 5
		ACTIONS => {
			"\$" => 63,
			'REF' => 62,
			"{" => 8,
			'NUMBER' => 43,
			'LITERAL' => 96,
			"[" => 36,
			'IDENT' => 3,
			"\"" => 18,
			"\${" => 9,
			"(" => 40,
			'NOT' => 22
		},
		GOTOS => {
			'term' => 41,
			'sterm' => 70,
			'ident' => 97,
			'lterm' => 46,
			'item' => 16,
			'node' => 74,
			'expr' => 98
		}
	},
	{#State 6
		DEFAULT => -41
	},
	{#State 7
		DEFAULT => -1
	},
	{#State 8
		ACTIONS => {
			"\$" => 63,
			'LITERAL' => 102,
			'IDENT' => 3,
			"\${" => 9
		},
		DEFAULT => -120,
		GOTOS => {
			'item' => 103,
			'hash' => 100,
			'param' => 101,
			'params' => 99
		}
	},
	{#State 9
		ACTIONS => {
			"\"" => 18,
			'REF' => 62,
			"\${" => 9,
			"\$" => 63,
			'LITERAL' => 96,
			'IDENT' => 3,
			'NUMBER' => 43
		},
		GOTOS => {
			'item' => 16,
			'node' => 74,
			'sterm' => 104,
			'ident' => 97
		}
	},
	{#State 10
		DEFAULT => -23
	},
	{#State 11
		DEFAULT => -40
	},
	{#State 12
		DEFAULT => -27
	},
	{#State 13
		DEFAULT => -11
	},
	{#State 14
		DEFAULT => -10
	},
	{#State 15
		DEFAULT => -24
	},
	{#State 16
		ACTIONS => {
			"(" => 105
		},
		DEFAULT => -129
	},
	{#State 17
		DEFAULT => -8
	},
	{#State 18
		DEFAULT => -177,
		GOTOS => {
			'quoted' => 106
		}
	},
	{#State 19
		DEFAULT => -44
	},
	{#State 20
		DEFAULT => -39
	},
	{#State 21
		DEFAULT => -14
	},
	{#State 22
		ACTIONS => {
			"\"" => 18,
			"\${" => 9,
			'LITERAL' => 96,
			"[" => 36,
			'IDENT' => 3,
			'NOT' => 22,
			"(" => 40,
			'REF' => 62,
			"\$" => 63,
			"{" => 8,
			'NUMBER' => 43
		},
		GOTOS => {
			'expr' => 107,
			'node' => 74,
			'lterm' => 46,
			'item' => 16,
			'ident' => 97,
			'term' => 41,
			'sterm' => 70
		}
	},
	{#State 23
		ACTIONS => {
			'DOT' => 108,
			'ASSIGN' => 109
		},
		DEFAULT => -110
	},
	{#State 24
		ACTIONS => {
			";" => -21
		},
		DEFAULT => -29
	},
	{#State 25
		DEFAULT => -22
	},
	{#State 26
		ACTIONS => {
			'IDENT' => 91,
			"\$" => 94,
			'LITERAL' => 90,
			"\"" => 92,
			'FILENAME' => 82,
			'NUMBER' => 87
		},
		GOTOS => {
			'nameargs' => 110,
			'filename' => 86,
			'name' => 88,
			'names' => 78,
			'filepart' => 83
		}
	},
	{#State 27
		ACTIONS => {
			'NUMBER' => 87,
			"\"" => 92,
			'FILENAME' => 82,
			'IDENT' => 91,
			'LITERAL' => 90,
			"\$" => 94
		},
		GOTOS => {
			'filename' => 86,
			'nameargs' => 111,
			'name' => 88,
			'names' => 78,
			'filepart' => 83
		}
	},
	{#State 28
		DEFAULT => -9
	},
	{#State 29
		DEFAULT => -42
	},
	{#State 30
		ACTIONS => {
			"{" => 8,
			'NUMBER' => 43,
			"\$" => 63,
			'REF' => 62,
			"(" => 40,
			'NOT' => 22,
			'LITERAL' => 96,
			"[" => 36,
			'IDENT' => 3,
			"\"" => 18,
			"\${" => 9
		},
		GOTOS => {
			'node' => 74,
			'item' => 16,
			'lterm' => 46,
			'expr' => 112,
			'ident' => 97,
			'sterm' => 70,
			'term' => 41
		}
	},
	{#State 31
		ACTIONS => {
			'FILENAME' => 82,
			"\"" => 92,
			'IDENT' => 91,
			"\$" => 94,
			'LITERAL' => 90,
			'NUMBER' => 87
		},
		GOTOS => {
			'names' => 78,
			'filepart' => 83,
			'nameargs' => 113,
			'filename' => 86,
			'name' => 88
		}
	},
	{#State 32
		ACTIONS => {
			'IDENT' => 3,
			"[" => 36,
			'LITERAL' => 96,
			"\${" => 9,
			"\"" => 18,
			"(" => 40,
			'NOT' => 22,
			"\$" => 63,
			'REF' => 62,
			'NUMBER' => 43,
			"{" => 8
		},
		GOTOS => {
			'node' => 74,
			'item' => 16,
			'lterm' => 46,
			'expr' => 114,
			'ident' => 97,
			'sterm' => 70,
			'term' => 41
		}
	},
	{#State 33
		ACTIONS => {
			'NUMBER' => 87,
			'FILENAME' => 82,
			"\"" => 92,
			"\$" => 94,
			'LITERAL' => 90,
			'IDENT' => 91
		},
		GOTOS => {
			'name' => 88,
			'nameargs' => 115,
			'filename' => 86,
			'filepart' => 83,
			'names' => 78
		}
	},
	{#State 34
		DEFAULT => -13
	},
	{#State 35
		ACTIONS => {
			'LITERAL' => 79,
			"\$" => 84,
			'IDENT' => 80,
			'FILENAME' => 82,
			"\${" => 9,
			"\"" => 77,
			'NUMBER' => 87
		},
		GOTOS => {
			'names' => 78,
			'lnameargs' => 116,
			'lvalue' => 85,
			'nameargs' => 89,
			'filename' => 86,
			'item' => 81,
			'name' => 88,
			'filepart' => 83
		}
	},
	{#State 36
		ACTIONS => {
			"\"" => 18,
			"\${" => 9,
			"]" => 119,
			'LITERAL' => 96,
			'IDENT' => 3,
			"[" => 36,
			"{" => 8,
			'NUMBER' => 43,
			'REF' => 62,
			"\$" => 63
		},
		GOTOS => {
			'item' => 16,
			'lterm' => 46,
			'node' => 74,
			'sterm' => 118,
			'term' => 121,
			'list' => 120,
			'ident' => 97,
			'range' => 117
		}
	},
	{#State 37
		ACTIONS => {
			'NUMBER' => 43,
			"{" => 8,
			"\$" => 63,
			'REF' => 62,
			"(" => 40,
			'NOT' => 22,
			'IDENT' => 3,
			"[" => 36,
			'LITERAL' => 96,
			"\"" => 18,
			"\${" => 9
		},
		GOTOS => {
			'sterm' => 70,
			'term' => 41,
			'ident' => 97,
			'lterm' => 46,
			'item' => 16,
			'node' => 74,
			'expr' => 122
		}
	},
	{#State 38
		ACTIONS => {
			'IDENT' => 125
		},
		GOTOS => {
			'metadata' => 124,
			'meta' => 123
		}
	},
	{#State 39
		DEFAULT => -5
	},
	{#State 40
		ACTIONS => {
			"\"" => 18,
			"\${" => 9,
			'LITERAL' => 4,
			'IDENT' => 3,
			"[" => 36,
			'NOT' => 22,
			"(" => 40,
			'REF' => 62,
			"\$" => 63,
			"{" => 8,
			'NUMBER' => 43
		},
		GOTOS => {
			'expr' => 127,
			'node' => 74,
			'lterm' => 46,
			'item' => 16,
			'ident' => 126,
			'sterm' => 70,
			'term' => 41,
			'assign' => 128
		}
	},
	{#State 41
		DEFAULT => -147
	},
	{#State 42
		ACTIONS => {
			'WHILE' => 130,
			'WRAPPER' => 132,
			'FOR' => 133,
			'UNLESS' => 131,
			'IF' => 134,
			'FILTER' => 129
		}
	},
	{#State 43
		DEFAULT => -114
	},
	{#State 44
		ACTIONS => {
			'IDENT' => 135
		}
	},
	{#State 45
		ACTIONS => {
			"\$" => 63,
			'LITERAL' => 137,
			'IDENT' => 3,
			"\${" => 9
		},
		GOTOS => {
			'ident' => 138,
			'node' => 74,
			'item' => 16,
			'assign' => 51,
			'setlist' => 136
		}
	},
	{#State 46
		DEFAULT => -104
	},
	{#State 47
		DEFAULT => -45
	},
	{#State 48
		DEFAULT => -15
	},
	{#State 49
		DEFAULT => -12
	},
	{#State 50
		ACTIONS => {
			'IDENT' => 91,
			"\$" => 94,
			'LITERAL' => 90,
			"\"" => 92,
			'FILENAME' => 82,
			'NUMBER' => 87
		},
		GOTOS => {
			'names' => 78,
			'filepart' => 83,
			'filename' => 86,
			'nameargs' => 139,
			'name' => 88
		}
	},
	{#State 51
		DEFAULT => -150
	},
	{#State 52
		ACTIONS => {
			'NUMBER' => 87,
			'LITERAL' => 143,
			'IDENT' => 144,
			'FILENAME' => 82
		},
		DEFAULT => -88,
		GOTOS => {
			'metadata' => 145,
			'blockname' => 142,
			'blockargs' => 140,
			'filename' => 141,
			'filepart' => 83,
			'meta' => 123
		}
	},
	{#State 53
		ACTIONS => {
			";" => 146
		}
	},
	{#State 54
		DEFAULT => -16
	},
	{#State 55
		ACTIONS => {
			'NUMBER' => 43,
			"{" => 8,
			"\$" => 63,
			'REF' => 62,
			'IDENT' => 148,
			"[" => 36,
			'LITERAL' => 96,
			"\${" => 9,
			"\"" => 18
		},
		GOTOS => {
			'node' => 74,
			'item' => 16,
			'lterm' => 46,
			'ident' => 97,
			'loopvar' => 149,
			'term' => 147,
			'sterm' => 70
		}
	},
	{#State 56
		ACTIONS => {
			'NUMBER' => 87,
			'FILENAME' => 82,
			"\"" => 92,
			"\$" => 94,
			'LITERAL' => 90,
			'IDENT' => 91
		},
		GOTOS => {
			'filename' => 86,
			'nameargs' => 150,
			'name' => 88,
			'names' => 78,
			'filepart' => 83
		}
	},
	{#State 57
		ACTIONS => {
			'NUMBER' => 87,
			'LITERAL' => 79,
			"\$" => 84,
			'IDENT' => 80,
			"\${" => 9,
			"\"" => 77,
			'FILENAME' => 82
		},
		GOTOS => {
			'filepart' => 83,
			'filename' => 86,
			'nameargs' => 89,
			'name' => 88,
			'item' => 81,
			'names' => 78,
			'lnameargs' => 151,
			'lvalue' => 85
		}
	},
	{#State 58
		DEFAULT => -25
	},
	{#State 59
		ACTIONS => {
			'COMMA' => 153,
			"\${" => 9,
			'IDENT' => 3,
			'LITERAL' => 137,
			"\$" => 63
		},
		DEFAULT => -20,
		GOTOS => {
			'assign' => 152,
			'item' => 16,
			'node' => 74,
			'ident' => 138
		}
	},
	{#State 60
		ACTIONS => {
			"\$" => 63,
			'REF' => 62,
			'NUMBER' => 43,
			"{" => 8,
			'IDENT' => 3,
			"[" => 36,
			'LITERAL' => 96,
			"\"" => 18,
			"\${" => 9,
			"(" => 40,
			'NOT' => 22
		},
		GOTOS => {
			'ident' => 97,
			'term' => 41,
			'sterm' => 70,
			'node' => 74,
			'lterm' => 46,
			'item' => 16,
			'expr' => 154
		}
	},
	{#State 61
		ACTIONS => {
			'IDENT' => 125
		},
		DEFAULT => -88,
		GOTOS => {
			'blockargs' => 155,
			'metadata' => 145,
			'meta' => 123
		}
	},
	{#State 62
		ACTIONS => {
			"\${" => 9,
			'IDENT' => 3,
			"\$" => 63
		},
		GOTOS => {
			'ident' => 156,
			'node' => 74,
			'item' => 16
		}
	},
	{#State 63
		ACTIONS => {
			'IDENT' => 157
		}
	},
	{#State 64
		ACTIONS => {
			"(" => 40,
			'NOT' => 22,
			"[" => 36,
			'IDENT' => 3,
			'LITERAL' => 96,
			"\${" => 9,
			"\"" => 18,
			'NUMBER' => 43,
			"{" => 8,
			"\$" => 63,
			'REF' => 62
		},
		GOTOS => {
			'term' => 41,
			'sterm' => 70,
			'ident' => 97,
			'item' => 16,
			'lterm' => 46,
			'node' => 74,
			'expr' => 158
		}
	},
	{#State 65
		DEFAULT => -6
	},
	{#State 66
		DEFAULT => -38
	},
	{#State 67
		ACTIONS => {
			"\${" => 9,
			'LITERAL' => 137,
			"\$" => 63,
			'IDENT' => 3
		},
		GOTOS => {
			'ident' => 138,
			'item' => 16,
			'node' => 74,
			'setlist' => 159,
			'assign' => 51
		}
	},
	{#State 68
		ACTIONS => {
			'' => 160
		}
	},
	{#State 69
		ACTIONS => {
			'VIEW' => 56,
			'rawperl' => 54,
			'FOR' => 55,
			'JAVASCRIPT' => 53,
			'BLOCK' => 52,
			'perl' => 12,
			'CLEAR' => 11,
			'PROCESS' => 50,
			"\${" => 9,
			'NUMBER' => 43,
			'LAST' => 6,
			'SET' => 45,
			"{" => 8,
			'MACRO' => 44,
			'WHILE' => 5,
			'META' => 38,
			"(" => 40,
			'IDENT' => 3,
			"[" => 36,
			'CALL' => 37,
			'LITERAL' => 4,
			'FILTER' => 1,
			'INSERT' => 2,
			'TRY' => 75,
			'RAW' => 35,
			'INCLUDE' => 33,
			'NEXT' => 29,
			";" => -19,
			'THROW' => 31,
			'UNLESS' => 30,
			'GET' => 32,
			'WRAPPER' => 27,
			'DEFAULT' => 67,
			'DEBUG' => 26,
			'RETURN' => 66,
			'TEXT' => 65,
			'IF' => 64,
			"\$" => 63,
			'REF' => 62,
			'NOT' => 22,
			'SWITCH' => 60,
			'STOP' => 20,
			'USE' => 57,
			"\"" => 18
		},
		DEFAULT => -2,
		GOTOS => {
			'expr' => 72,
			'loop' => 15,
			'statement' => 73,
			'item' => 16,
			'use' => 34,
			'directive' => 17,
			'node' => 74,
			'sterm' => 70,
			'capture' => 13,
			'javascript' => 71,
			'anonblock' => 14,
			'assign' => 51,
			'defblock' => 28,
			'view' => 48,
			'filter' => 47,
			'macro' => 49,
			'atomdir' => 24,
			'switch' => 10,
			'condition' => 25,
			'lterm' => 46,
			'term' => 41,
			'atomexpr' => 42,
			'ident' => 23,
			'raw' => 21,
			'setlist' => 59,
			'chunk' => 161,
			'defblockname' => 61,
			'wrapper' => 19,
			'try' => 58
		}
	},
	{#State 70
		DEFAULT => -105
	},
	{#State 71
		DEFAULT => -26
	},
	{#State 72
		ACTIONS => {
			'CMPOP' => 162,
			"?" => 163,
			"+" => 166,
			'MOD' => 170,
			'AND' => 164,
			"/" => 167,
			'BINOP' => 165,
			'OR' => 169,
			'CAT' => 168,
			";" => -17,
			'DIV' => 171
		},
		DEFAULT => -28
	},
	{#State 73
		ACTIONS => {
			";" => 172
		}
	},
	{#State 74
		DEFAULT => -128
	},
	{#State 75
		ACTIONS => {
			";" => 173
		}
	},
	{#State 76
		ACTIONS => {
			";" => 174
		}
	},
	{#State 77
		DEFAULT => -177,
		GOTOS => {
			'quoted' => 175
		}
	},
	{#State 78
		ACTIONS => {
			"(" => 178,
			"+" => 176
		},
		DEFAULT => -157,
		GOTOS => {
			'args' => 177
		}
	},
	{#State 79
		ACTIONS => {
			'ASSIGN' => -162
		},
		DEFAULT => -170
	},
	{#State 80
		ACTIONS => {
			'ASSIGN' => -131
		},
		DEFAULT => -174
	},
	{#State 81
		DEFAULT => -160
	},
	{#State 82
		DEFAULT => -173
	},
	{#State 83
		DEFAULT => -172
	},
	{#State 84
		ACTIONS => {
			"\$" => 63,
			'IDENT' => 179,
			"\${" => 9
		},
		GOTOS => {
			'node' => 74,
			'item' => 16,
			'ident' => 180
		}
	},
	{#State 85
		ACTIONS => {
			'ASSIGN' => 181
		}
	},
	{#State 86
		ACTIONS => {
			'DOT' => 182
		},
		DEFAULT => -169
	},
	{#State 87
		DEFAULT => -175
	},
	{#State 88
		DEFAULT => -167
	},
	{#State 89
		DEFAULT => -159
	},
	{#State 90
		DEFAULT => -170
	},
	{#State 91
		DEFAULT => -174
	},
	{#State 92
		DEFAULT => -177,
		GOTOS => {
			'quoted' => 183
		}
	},
	{#State 93
		DEFAULT => -34
	},
	{#State 94
		ACTIONS => {
			"\${" => 9,
			"\$" => 63,
			'IDENT' => 3
		},
		GOTOS => {
			'ident' => 180,
			'node' => 74,
			'item' => 16
		}
	},
	{#State 95
		ACTIONS => {
			"\$" => 63,
			'REF' => 62,
			"{" => 8,
			'NUMBER' => 43,
			'LITERAL' => 96,
			"[" => 36,
			'IDENT' => 3,
			"\${" => 9,
			"\"" => 18,
			"(" => 40,
			'NOT' => 22
		},
		GOTOS => {
			'ident' => 97,
			'term' => 41,
			'sterm' => 70,
			'node' => 74,
			'item' => 16,
			'lterm' => 46,
			'expr' => 184
		}
	},
	{#State 96
		DEFAULT => -113
	},
	{#State 97
		ACTIONS => {
			'DOT' => 108
		},
		DEFAULT => -110
	},
	{#State 98
		ACTIONS => {
			'DIV' => 171,
			'AND' => 164,
			"/" => 167,
			'MOD' => 170,
			'BINOP' => 165,
			"?" => 163,
			'OR' => 169,
			'CMPOP' => 162,
			";" => 185,
			'CAT' => 168,
			"+" => 166
		}
	},
	{#State 99
		ACTIONS => {
			'LITERAL' => 102,
			"\$" => 63,
			'IDENT' => 3,
			"\${" => 9,
			'COMMA' => 187
		},
		DEFAULT => -119,
		GOTOS => {
			'param' => 186,
			'item' => 103
		}
	},
	{#State 100
		ACTIONS => {
			"}" => 188
		}
	},
	{#State 101
		DEFAULT => -123
	},
	{#State 102
		ACTIONS => {
			'ASSIGN' => 189
		}
	},
	{#State 103
		ACTIONS => {
			'ASSIGN' => 190
		}
	},
	{#State 104
		ACTIONS => {
			"}" => 191
		}
	},
	{#State 105
		DEFAULT => -157,
		GOTOS => {
			'args' => 192
		}
	},
	{#State 106
		ACTIONS => {
			"\"" => 196,
			"\${" => 9,
			"\$" => 63,
			";" => 194,
			'IDENT' => 3,
			'TEXT' => 197
		},
		GOTOS => {
			'node' => 74,
			'item' => 16,
			'quotable' => 193,
			'ident' => 195
		}
	},
	{#State 107
		ACTIONS => {
			'DIV' => 171,
			'BINOP' => 165,
			'MOD' => 170,
			'CMPOP' => 162,
			'CAT' => 168,
			"/" => 167,
			"+" => 166
		},
		DEFAULT => -143
	},
	{#State 108
		ACTIONS => {
			"\${" => 9,
			'IDENT' => 3,
			"\$" => 63,
			'NUMBER' => 198
		},
		GOTOS => {
			'node' => 199,
			'item' => 16
		}
	},
	{#State 109
		ACTIONS => {
			'FOR' => 55,
			'BLOCK' => 200,
			'JAVASCRIPT' => 53,
			'perl' => 12,
			"\${" => 9,
			'CLEAR' => 11,
			'PROCESS' => 50,
			'SET' => 45,
			"{" => 8,
			'LAST' => 6,
			'NUMBER' => 43,
			"(" => 40,
			'WHILE' => 5,
			'INSERT' => 2,
			'FILTER' => 1,
			'LITERAL' => 4,
			"[" => 36,
			'IDENT' => 3,
			'CALL' => 37,
			'INCLUDE' => 33,
			'TRY' => 75,
			'GET' => 32,
			'UNLESS' => 30,
			'THROW' => 31,
			'NEXT' => 29,
			'WRAPPER' => 27,
			'DEBUG' => 26,
			'DEFAULT' => 67,
			'RETURN' => 66,
			'REF' => 62,
			'IF' => 64,
			"\$" => 63,
			'SWITCH' => 60,
			'NOT' => 22,
			"\"" => 18,
			'STOP' => 20
		},
		GOTOS => {
			'lterm' => 46,
			'term' => 41,
			'atomexpr' => 42,
			'ident' => 126,
			'setlist' => 59,
			'wrapper' => 19,
			'try' => 58,
			'expr' => 201,
			'loop' => 15,
			'item' => 16,
			'mdir' => 202,
			'directive' => 203,
			'node' => 74,
			'sterm' => 70,
			'javascript' => 71,
			'assign' => 51,
			'filter' => 47,
			'atomdir' => 24,
			'switch' => 10,
			'condition' => 25
		}
	},
	{#State 110
		DEFAULT => -43
	},
	{#State 111
		ACTIONS => {
			";" => 204
		}
	},
	{#State 112
		ACTIONS => {
			"/" => 167,
			'MOD' => 170,
			'AND' => 164,
			'DIV' => 171,
			'CAT' => 168,
			";" => 205,
			"+" => 166,
			"?" => 163,
			'CMPOP' => 162,
			'OR' => 169,
			'BINOP' => 165
		}
	},
	{#State 113
		DEFAULT => -37
	},
	{#State 114
		ACTIONS => {
			'CAT' => 168,
			'OR' => 169,
			'BINOP' => 165,
			'DIV' => 171,
			"+" => 166,
			"?" => 163,
			'CMPOP' => 162,
			"/" => 167,
			'AND' => 164,
			'MOD' => 170
		},
		DEFAULT => -30
	},
	{#State 115
		DEFAULT => -35
	},
	{#State 116
		DEFAULT => -76
	},
	{#State 117
		ACTIONS => {
			"]" => 206
		}
	},
	{#State 118
		ACTIONS => {
			'TO' => 207
		},
		DEFAULT => -105
	},
	{#State 119
		DEFAULT => -108
	},
	{#State 120
		ACTIONS => {
			"[" => 36,
			'IDENT' => 3,
			"]" => 208,
			'LITERAL' => 96,
			"\"" => 18,
			"\${" => 9,
			'COMMA' => 209,
			"\$" => 63,
			'REF' => 62,
			'NUMBER' => 43,
			"{" => 8
		},
		GOTOS => {
			'node' => 74,
			'item' => 16,
			'lterm' => 46,
			'ident' => 97,
			'term' => 210,
			'sterm' => 70
		}
	},
	{#State 121
		DEFAULT => -117
	},
	{#State 122
		ACTIONS => {
			'AND' => 164,
			'MOD' => 170,
			"/" => 167,
			'CMPOP' => 162,
			"?" => 163,
			"+" => 166,
			'DIV' => 171,
			'OR' => 169,
			'CAT' => 168,
			'BINOP' => 165
		},
		DEFAULT => -31
	},
	{#State 123
		DEFAULT => -100
	},
	{#State 124
		ACTIONS => {
			'COMMA' => 211,
			'IDENT' => 125
		},
		DEFAULT => -18,
		GOTOS => {
			'meta' => 212
		}
	},
	{#State 125
		ACTIONS => {
			'ASSIGN' => 213
		}
	},
	{#State 126
		ACTIONS => {
			'DOT' => 108,
			'ASSIGN' => 214
		},
		DEFAULT => -110
	},
	{#State 127
		ACTIONS => {
			'BINOP' => 165,
			"?" => 163,
			'CMPOP' => 162,
			'OR' => 169,
			'CAT' => 168,
			"+" => 166,
			'DIV' => 171,
			")" => 215,
			"/" => 167,
			'MOD' => 170,
			'AND' => 164
		}
	},
	{#State 128
		ACTIONS => {
			")" => 216
		}
	},
	{#State 129
		ACTIONS => {
			'NUMBER' => 87,
			'IDENT' => 80,
			"\$" => 84,
			'LITERAL' => 79,
			"\${" => 9,
			'FILENAME' => 82,
			"\"" => 77
		},
		GOTOS => {
			'names' => 78,
			'lnameargs' => 217,
			'lvalue' => 85,
			'nameargs' => 89,
			'filename' => 86,
			'item' => 81,
			'name' => 88,
			'filepart' => 83
		}
	},
	{#State 130
		ACTIONS => {
			'NUMBER' => 43,
			"{" => 8,
			"\$" => 63,
			'REF' => 62,
			"(" => 40,
			'NOT' => 22,
			'IDENT' => 3,
			"[" => 36,
			'LITERAL' => 96,
			"\${" => 9,
			"\"" => 18
		},
		GOTOS => {
			'term' => 41,
			'sterm' => 70,
			'ident' => 97,
			'expr' => 218,
			'item' => 16,
			'lterm' => 46,
			'node' => 74
		}
	},
	{#State 131
		ACTIONS => {
			'REF' => 62,
			"\$" => 63,
			"{" => 8,
			'NUMBER' => 43,
			"\${" => 9,
			"\"" => 18,
			'LITERAL' => 96,
			"[" => 36,
			'IDENT' => 3,
			'NOT' => 22,
			"(" => 40
		},
		GOTOS => {
			'item' => 16,
			'lterm' => 46,
			'node' => 74,
			'expr' => 219,
			'term' => 41,
			'sterm' => 70,
			'ident' => 97
		}
	},
	{#State 132
		ACTIONS => {
			'NUMBER' => 87,
			'IDENT' => 91,
			"\$" => 94,
			'LITERAL' => 90,
			"\"" => 92,
			'FILENAME' => 82
		},
		GOTOS => {
			'nameargs' => 220,
			'filename' => 86,
			'name' => 88,
			'names' => 78,
			'filepart' => 83
		}
	},
	{#State 133
		ACTIONS => {
			"[" => 36,
			'IDENT' => 148,
			'LITERAL' => 96,
			"\"" => 18,
			"\${" => 9,
			'NUMBER' => 43,
			"{" => 8,
			"\$" => 63,
			'REF' => 62
		},
		GOTOS => {
			'item' => 16,
			'lterm' => 46,
			'node' => 74,
			'sterm' => 70,
			'term' => 147,
			'ident' => 97,
			'loopvar' => 221
		}
	},
	{#State 134
		ACTIONS => {
			"\"" => 18,
			"\${" => 9,
			'LITERAL' => 96,
			'IDENT' => 3,
			"[" => 36,
			'NOT' => 22,
			"(" => 40,
			'REF' => 62,
			"\$" => 63,
			"{" => 8,
			'NUMBER' => 43
		},
		GOTOS => {
			'expr' => 222,
			'item' => 16,
			'lterm' => 46,
			'node' => 74,
			'term' => 41,
			'sterm' => 70,
			'ident' => 97
		}
	},
	{#State 135
		ACTIONS => {
			'INSERT' => 2,
			'FILTER' => 1,
			'LITERAL' => 4,
			"[" => 36,
			'CALL' => 37,
			'IDENT' => 3,
			"(" => 223,
			'WHILE' => 5,
			'SET' => 45,
			"{" => 8,
			'NUMBER' => 43,
			'LAST' => 6,
			"\${" => 9,
			'CLEAR' => 11,
			'PROCESS' => 50,
			'perl' => 12,
			'BLOCK' => 200,
			'JAVASCRIPT' => 53,
			'FOR' => 55,
			"\"" => 18,
			'STOP' => 20,
			'SWITCH' => 60,
			'NOT' => 22,
			'REF' => 62,
			'IF' => 64,
			"\$" => 63,
			'RETURN' => 66,
			'DEBUG' => 26,
			'DEFAULT' => 67,
			'WRAPPER' => 27,
			'THROW' => 31,
			'GET' => 32,
			'UNLESS' => 30,
			'NEXT' => 29,
			'INCLUDE' => 33,
			'TRY' => 75
		},
		GOTOS => {
			'term' => 41,
			'ident' => 126,
			'atomexpr' => 42,
			'lterm' => 46,
			'try' => 58,
			'wrapper' => 19,
			'setlist' => 59,
			'javascript' => 71,
			'sterm' => 70,
			'item' => 16,
			'mdir' => 225,
			'node' => 74,
			'directive' => 203,
			'expr' => 224,
			'loop' => 15,
			'switch' => 10,
			'condition' => 25,
			'filter' => 47,
			'atomdir' => 24,
			'assign' => 51
		}
	},
	{#State 136
		ACTIONS => {
			'LITERAL' => 137,
			'IDENT' => 3,
			"\${" => 9,
			'COMMA' => 153,
			"\$" => 63
		},
		DEFAULT => -32,
		GOTOS => {
			'item' => 16,
			'node' => 74,
			'assign' => 152,
			'ident' => 138
		}
	},
	{#State 137
		ACTIONS => {
			'ASSIGN' => 95
		}
	},
	{#State 138
		ACTIONS => {
			'ASSIGN' => 214,
			'DOT' => 108
		}
	},
	{#State 139
		DEFAULT => -36
	},
	{#State 140
		ACTIONS => {
			";" => 226
		}
	},
	{#State 141
		ACTIONS => {
			'DOT' => 182
		},
		DEFAULT => -85
	},
	{#State 142
		DEFAULT => -84
	},
	{#State 143
		DEFAULT => -86
	},
	{#State 144
		ACTIONS => {
			'ASSIGN' => 213
		},
		DEFAULT => -174
	},
	{#State 145
		ACTIONS => {
			'IDENT' => 125,
			'COMMA' => 211
		},
		DEFAULT => -87,
		GOTOS => {
			'meta' => 212
		}
	},
	{#State 146
		DEFAULT => -79,
		GOTOS => {
			'@4-2' => 227
		}
	},
	{#State 147
		DEFAULT => -157,
		GOTOS => {
			'args' => 228
		}
	},
	{#State 148
		ACTIONS => {
			'IN' => 230,
			'ASSIGN' => 229
		},
		DEFAULT => -131
	},
	{#State 149
		ACTIONS => {
			";" => 231
		}
	},
	{#State 150
		ACTIONS => {
			";" => 232
		}
	},
	{#State 151
		DEFAULT => -75
	},
	{#State 152
		DEFAULT => -148
	},
	{#State 153
		DEFAULT => -149
	},
	{#State 154
		ACTIONS => {
			'DIV' => 171,
			"/" => 167,
			'AND' => 164,
			'MOD' => 170,
			'BINOP' => 165,
			"?" => 163,
			'CMPOP' => 162,
			'OR' => 169,
			'CAT' => 168,
			";" => 233,
			"+" => 166
		}
	},
	{#State 155
		ACTIONS => {
			";" => 234
		}
	},
	{#State 156
		ACTIONS => {
			'DOT' => 108
		},
		DEFAULT => -111
	},
	{#State 157
		DEFAULT => -133
	},
	{#State 158
		ACTIONS => {
			'AND' => 164,
			'MOD' => 170,
			"/" => 167,
			'DIV' => 171,
			";" => 235,
			'CAT' => 168,
			"+" => 166,
			"?" => 163,
			'CMPOP' => 162,
			'OR' => 169,
			'BINOP' => 165
		}
	},
	{#State 159
		ACTIONS => {
			"\$" => 63,
			'IDENT' => 3,
			'LITERAL' => 137,
			"\${" => 9,
			'COMMA' => 153
		},
		DEFAULT => -33,
		GOTOS => {
			'assign' => 152,
			'node' => 74,
			'item' => 16,
			'ident' => 138
		}
	},
	{#State 160
		DEFAULT => 0
	},
	{#State 161
		DEFAULT => -4
	},
	{#State 162
		ACTIONS => {
			'IDENT' => 3,
			"[" => 36,
			'LITERAL' => 96,
			"\${" => 9,
			"\"" => 18,
			"(" => 40,
			'NOT' => 22,
			"\$" => 63,
			'REF' => 62,
			'NUMBER' => 43,
			"{" => 8
		},
		GOTOS => {
			'node' => 74,
			'lterm' => 46,
			'item' => 16,
			'expr' => 236,
			'ident' => 97,
			'term' => 41,
			'sterm' => 70
		}
	},
	{#State 163
		ACTIONS => {
			"(" => 40,
			'NOT' => 22,
			'LITERAL' => 96,
			'IDENT' => 3,
			"[" => 36,
			"\${" => 9,
			"\"" => 18,
			"{" => 8,
			'NUMBER' => 43,
			"\$" => 63,
			'REF' => 62
		},
		GOTOS => {
			'node' => 74,
			'item' => 16,
			'lterm' => 46,
			'expr' => 237,
			'ident' => 97,
			'term' => 41,
			'sterm' => 70
		}
	},
	{#State 164
		ACTIONS => {
			"\"" => 18,
			"\${" => 9,
			'LITERAL' => 96,
			'IDENT' => 3,
			"[" => 36,
			'NOT' => 22,
			"(" => 40,
			'REF' => 62,
			"\$" => 63,
			"{" => 8,
			'NUMBER' => 43
		},
		GOTOS => {
			'node' => 74,
			'lterm' => 46,
			'item' => 16,
			'expr' => 238,
			'ident' => 97,
			'sterm' => 70,
			'term' => 41
		}
	},
	{#State 165
		ACTIONS => {
			'NUMBER' => 43,
			"{" => 8,
			'REF' => 62,
			"\$" => 63,
			'NOT' => 22,
			"(" => 40,
			"\"" => 18,
			"\${" => 9,
			"[" => 36,
			'IDENT' => 3,
			'LITERAL' => 96
		},
		GOTOS => {
			'node' => 74,
			'lterm' => 46,
			'item' => 16,
			'expr' => 239,
			'ident' => 97,
			'sterm' => 70,
			'term' => 41
		}
	},
	{#State 166
		ACTIONS => {
			"{" => 8,
			'NUMBER' => 43,
			'REF' => 62,
			"\$" => 63,
			'NOT' => 22,
			"(" => 40,
			"\"" => 18,
			"\${" => 9,
			'LITERAL' => 96,
			'IDENT' => 3,
			"[" => 36
		},
		GOTOS => {
			'item' => 16,
			'lterm' => 46,
			'node' => 74,
			'expr' => 240,
			'sterm' => 70,
			'term' => 41,
			'ident' => 97
		}
	},
	{#State 167
		ACTIONS => {
			"(" => 40,
			'NOT' => 22,
			'LITERAL' => 96,
			"[" => 36,
			'IDENT' => 3,
			"\${" => 9,
			"\"" => 18,
			"{" => 8,
			'NUMBER' => 43,
			"\$" => 63,
			'REF' => 62
		},
		GOTOS => {
			'sterm' => 70,
			'term' => 41,
			'ident' => 97,
			'expr' => 241,
			'lterm' => 46,
			'item' => 16,
			'node' => 74
		}
	},
	{#State 168
		ACTIONS => {
			'NOT' => 22,
			"(" => 40,
			"\${" => 9,
			"\"" => 18,
			'LITERAL' => 96,
			"[" => 36,
			'IDENT' => 3,
			"{" => 8,
			'NUMBER' => 43,
			'REF' => 62,
			"\$" => 63
		},
		GOTOS => {
			'sterm' => 70,
			'term' => 41,
			'ident' => 97,
			'expr' => 242,
			'lterm' => 46,
			'item' => 16,
			'node' => 74
		}
	},
	{#State 169
		ACTIONS => {
			"(" => 40,
			'NOT' => 22,
			'IDENT' => 3,
			"[" => 36,
			'LITERAL' => 96,
			"\${" => 9,
			"\"" => 18,
			'NUMBER' => 43,
			"{" => 8,
			"\$" => 63,
			'REF' => 62
		},
		GOTOS => {
			'ident' => 97,
			'sterm' => 70,
			'term' => 41,
			'expr' => 243,
			'node' => 74,
			'lterm' => 46,
			'item' => 16
		}
	},
	{#State 170
		ACTIONS => {
			'NOT' => 22,
			"(" => 40,
			"\"" => 18,
			"\${" => 9,
			'LITERAL' => 96,
			"[" => 36,
			'IDENT' => 3,
			"{" => 8,
			'NUMBER' => 43,
			'REF' => 62,
			"\$" => 63
		},
		GOTOS => {
			'term' => 41,
			'sterm' => 70,
			'ident' => 97,
			'item' => 16,
			'lterm' => 46,
			'node' => 74,
			'expr' => 244
		}
	},
	{#State 171
		ACTIONS => {
			"{" => 8,
			'NUMBER' => 43,
			"\$" => 63,
			'REF' => 62,
			"(" => 40,
			'NOT' => 22,
			'LITERAL' => 96,
			"[" => 36,
			'IDENT' => 3,
			"\"" => 18,
			"\${" => 9
		},
		GOTOS => {
			'term' => 41,
			'sterm' => 70,
			'ident' => 97,
			'expr' => 245,
			'item' => 16,
			'lterm' => 46,
			'node' => 74
		}
	},
	{#State 172
		DEFAULT => -7
	},
	{#State 173
		ACTIONS => {
			'NEXT' => 29,
			";" => -19,
			'THROW' => 31,
			'UNLESS' => 30,
			'GET' => 32,
			'RAW' => 35,
			'TRY' => 75,
			'INCLUDE' => 33,
			'DEFAULT' => 67,
			'DEBUG' => 26,
			'WRAPPER' => 27,
			"\$" => 63,
			'IF' => 64,
			'REF' => 62,
			'RETURN' => 66,
			'TEXT' => 65,
			'STOP' => 20,
			'USE' => 57,
			"\"" => 18,
			'NOT' => 22,
			'SWITCH' => 60,
			'JAVASCRIPT' => 53,
			'BLOCK' => 52,
			'VIEW' => 56,
			'rawperl' => 54,
			'FOR' => 55,
			'CLEAR' => 11,
			'PROCESS' => 50,
			"\${" => 9,
			'perl' => 12,
			'LAST' => 6,
			'NUMBER' => 43,
			"{" => 8,
			'MACRO' => 44,
			'SET' => 45,
			'IDENT' => 3,
			"[" => 36,
			'CALL' => 37,
			'LITERAL' => 4,
			'FILTER' => 1,
			'INSERT' => 2,
			'WHILE' => 5,
			'META' => 38,
			"(" => 40
		},
		DEFAULT => -3,
		GOTOS => {
			'ident' => 23,
			'atomexpr' => 42,
			'term' => 41,
			'lterm' => 46,
			'block' => 246,
			'try' => 58,
			'wrapper' => 19,
			'defblockname' => 61,
			'chunk' => 39,
			'setlist' => 59,
			'raw' => 21,
			'javascript' => 71,
			'anonblock' => 14,
			'sterm' => 70,
			'capture' => 13,
			'node' => 74,
			'use' => 34,
			'directive' => 17,
			'item' => 16,
			'statement' => 73,
			'loop' => 15,
			'expr' => 72,
			'condition' => 25,
			'switch' => 10,
			'atomdir' => 24,
			'macro' => 49,
			'view' => 48,
			'filter' => 47,
			'defblock' => 28,
			'assign' => 51,
			'chunks' => 69
		}
	},
	{#State 174
		ACTIONS => {
			'REF' => 62,
			'IF' => 64,
			"\$" => 63,
			'TEXT' => 65,
			'RETURN' => 66,
			"\"" => 18,
			'USE' => 57,
			'STOP' => 20,
			'SWITCH' => 60,
			'NOT' => 22,
			'GET' => 32,
			";" => -19,
			'UNLESS' => 30,
			'THROW' => 31,
			'NEXT' => 29,
			'INCLUDE' => 33,
			'TRY' => 75,
			'RAW' => 35,
			'DEBUG' => 26,
			'DEFAULT' => 67,
			'WRAPPER' => 27,
			"{" => 8,
			'SET' => 45,
			'MACRO' => 44,
			'NUMBER' => 43,
			'LAST' => 6,
			'INSERT' => 2,
			'FILTER' => 1,
			'LITERAL' => 4,
			'CALL' => 37,
			'IDENT' => 3,
			"[" => 36,
			"(" => 40,
			'WHILE' => 5,
			'META' => 38,
			'BLOCK' => 52,
			'JAVASCRIPT' => 53,
			'rawperl' => 54,
			'FOR' => 55,
			'VIEW' => 56,
			"\${" => 9,
			'CLEAR' => 11,
			'PROCESS' => 50,
			'perl' => 12
		},
		DEFAULT => -3,
		GOTOS => {
			'chunk' => 39,
			'defblockname' => 61,
			'raw' => 21,
			'setlist' => 59,
			'try' => 58,
			'wrapper' => 19,
			'lterm' => 46,
			'block' => 247,
			'ident' => 23,
			'atomexpr' => 42,
			'term' => 41,
			'defblock' => 28,
			'assign' => 51,
			'chunks' => 69,
			'condition' => 25,
			'switch' => 10,
			'macro' => 49,
			'atomdir' => 24,
			'view' => 48,
			'filter' => 47,
			'use' => 34,
			'node' => 74,
			'directive' => 17,
			'statement' => 73,
			'item' => 16,
			'loop' => 15,
			'expr' => 72,
			'javascript' => 71,
			'anonblock' => 14,
			'sterm' => 70,
			'capture' => 13
		}
	},
	{#State 175
		ACTIONS => {
			'TEXT' => 197,
			"\${" => 9,
			"\"" => 248,
			";" => 194,
			"\$" => 63,
			'IDENT' => 3
		},
		GOTOS => {
			'quotable' => 193,
			'ident' => 195,
			'node' => 74,
			'item' => 16
		}
	},
	{#State 176
		ACTIONS => {
			'NUMBER' => 87,
			"\"" => 92,
			'FILENAME' => 82,
			'IDENT' => 91,
			'LITERAL' => 90
		},
		GOTOS => {
			'filepart' => 83,
			'filename' => 86,
			'name' => 249
		}
	},
	{#State 177
		ACTIONS => {
			'COMMA' => 254,
			"\${" => 9,
			"(" => 40,
			'NOT' => 22,
			'IDENT' => 3,
			"[" => 36,
			'LITERAL' => 250,
			"\"" => 18,
			'NUMBER' => 43,
			"{" => 8,
			"\$" => 63,
			'REF' => 62
		},
		DEFAULT => -164,
		GOTOS => {
			'expr' => 255,
			'item' => 252,
			'lterm' => 46,
			'node' => 74,
			'sterm' => 70,
			'term' => 41,
			'ident' => 253,
			'param' => 251
		}
	},
	{#State 178
		DEFAULT => -157,
		GOTOS => {
			'args' => 256
		}
	},
	{#State 179
		ACTIONS => {
			'ASSIGN' => -133
		},
		DEFAULT => -131
	},
	{#State 180
		ACTIONS => {
			'DOT' => 108
		},
		DEFAULT => -157,
		GOTOS => {
			'args' => 257
		}
	},
	{#State 181
		ACTIONS => {
			'NUMBER' => 87,
			'LITERAL' => 90,
			"\$" => 94,
			'IDENT' => 91,
			'FILENAME' => 82,
			"\"" => 92
		},
		GOTOS => {
			'filename' => 86,
			'nameargs' => 258,
			'name' => 88,
			'names' => 78,
			'filepart' => 83
		}
	},
	{#State 182
		ACTIONS => {
			'FILENAME' => 82,
			'IDENT' => 91,
			'NUMBER' => 87
		},
		GOTOS => {
			'filepart' => 259
		}
	},
	{#State 183
		ACTIONS => {
			"\$" => 63,
			";" => 194,
			'IDENT' => 3,
			"\"" => 260,
			"\${" => 9,
			'TEXT' => 197
		},
		GOTOS => {
			'ident' => 195,
			'quotable' => 193,
			'node' => 74,
			'item' => 16
		}
	},
	{#State 184
		ACTIONS => {
			"+" => 166,
			'CMPOP' => 162,
			"?" => 163,
			'MOD' => 170,
			'AND' => 164,
			"/" => 167,
			'CAT' => 168,
			'OR' => 169,
			'BINOP' => 165,
			'DIV' => 171
		},
		DEFAULT => -152
	},
	{#State 185
		DEFAULT => -61,
		GOTOS => {
			'@2-3' => 261
		}
	},
	{#State 186
		DEFAULT => -121
	},
	{#State 187
		DEFAULT => -122
	},
	{#State 188
		DEFAULT => -109
	},
	{#State 189
		ACTIONS => {
			"{" => 8,
			'NUMBER' => 43,
			"\$" => 63,
			'REF' => 62,
			"(" => 40,
			'NOT' => 22,
			'LITERAL' => 96,
			"[" => 36,
			'IDENT' => 3,
			"\"" => 18,
			"\${" => 9
		},
		GOTOS => {
			'expr' => 262,
			'lterm' => 46,
			'item' => 16,
			'node' => 74,
			'sterm' => 70,
			'term' => 41,
			'ident' => 97
		}
	},
	{#State 190
		ACTIONS => {
			'IDENT' => 3,
			"[" => 36,
			'LITERAL' => 96,
			"\${" => 9,
			"\"" => 18,
			"(" => 40,
			'NOT' => 22,
			"\$" => 63,
			'REF' => 62,
			'NUMBER' => 43,
			"{" => 8
		},
		GOTOS => {
			'item' => 16,
			'lterm' => 46,
			'node' => 74,
			'expr' => 263,
			'term' => 41,
			'sterm' => 70,
			'ident' => 97
		}
	},
	{#State 191
		DEFAULT => -132
	},
	{#State 192
		ACTIONS => {
			'NUMBER' => 43,
			"{" => 8,
			'REF' => 62,
			"\$" => 63,
			'COMMA' => 254,
			'NOT' => 22,
			"(" => 40,
			")" => 264,
			"\"" => 18,
			"\${" => 9,
			"[" => 36,
			'IDENT' => 3,
			'LITERAL' => 250
		},
		GOTOS => {
			'param' => 251,
			'term' => 41,
			'sterm' => 70,
			'ident' => 253,
			'expr' => 255,
			'lterm' => 46,
			'item' => 252,
			'node' => 74
		}
	},
	{#State 193
		DEFAULT => -176
	},
	{#State 194
		DEFAULT => -180
	},
	{#State 195
		ACTIONS => {
			'DOT' => 108
		},
		DEFAULT => -178
	},
	{#State 196
		DEFAULT => -112
	},
	{#State 197
		DEFAULT => -179
	},
	{#State 198
		DEFAULT => -127
	},
	{#State 199
		DEFAULT => -126
	},
	{#State 200
		ACTIONS => {
			";" => 265
		}
	},
	{#State 201
		ACTIONS => {
			"\${" => -151,
			'COMMA' => -151,
			'DIV' => 171,
			";" => -151,
			'CAT' => 168,
			'OR' => 169,
			'BINOP' => 165,
			'IDENT' => -151,
			'LITERAL' => -151,
			"/" => 167,
			'MOD' => 170,
			'AND' => 164,
			"+" => 166,
			"\$" => -151,
			'CMPOP' => 162,
			"?" => 163
		},
		DEFAULT => -28
	},
	{#State 202
		DEFAULT => -90
	},
	{#State 203
		DEFAULT => -93
	},
	{#State 204
		ACTIONS => {
			'INCLUDE' => 33,
			'RAW' => 35,
			'TRY' => 75,
			'NEXT' => 29,
			'GET' => 32,
			";" => -19,
			'UNLESS' => 30,
			'THROW' => 31,
			'WRAPPER' => 27,
			'DEFAULT' => 67,
			'DEBUG' => 26,
			'TEXT' => 65,
			'RETURN' => 66,
			'REF' => 62,
			"\$" => 63,
			'IF' => 64,
			'NOT' => 22,
			'SWITCH' => 60,
			'USE' => 57,
			"\"" => 18,
			'STOP' => 20,
			'FOR' => 55,
			'rawperl' => 54,
			'VIEW' => 56,
			'BLOCK' => 52,
			'JAVASCRIPT' => 53,
			'perl' => 12,
			"\${" => 9,
			'PROCESS' => 50,
			'CLEAR' => 11,
			'LAST' => 6,
			'NUMBER' => 43,
			'SET' => 45,
			"{" => 8,
			'MACRO' => 44,
			'WHILE' => 5,
			'META' => 38,
			"(" => 40,
			'FILTER' => 1,
			'INSERT' => 2,
			'IDENT' => 3,
			'CALL' => 37,
			"[" => 36,
			'LITERAL' => 4
		},
		DEFAULT => -3,
		GOTOS => {
			'condition' => 25,
			'switch' => 10,
			'atomdir' => 24,
			'macro' => 49,
			'filter' => 47,
			'view' => 48,
			'defblock' => 28,
			'assign' => 51,
			'chunks' => 69,
			'anonblock' => 14,
			'javascript' => 71,
			'capture' => 13,
			'sterm' => 70,
			'use' => 34,
			'node' => 74,
			'directive' => 17,
			'item' => 16,
			'statement' => 73,
			'loop' => 15,
			'expr' => 72,
			'try' => 58,
			'wrapper' => 19,
			'defblockname' => 61,
			'chunk' => 39,
			'raw' => 21,
			'setlist' => 59,
			'ident' => 23,
			'atomexpr' => 42,
			'term' => 41,
			'lterm' => 46,
			'block' => 266
		}
	},
	{#State 205
		ACTIONS => {
			'FOR' => 55,
			'rawperl' => 54,
			'VIEW' => 56,
			'JAVASCRIPT' => 53,
			'BLOCK' => 52,
			'perl' => 12,
			"\${" => 9,
			'PROCESS' => 50,
			'CLEAR' => 11,
			'LAST' => 6,
			'NUMBER' => 43,
			"{" => 8,
			'SET' => 45,
			'MACRO' => 44,
			'WHILE' => 5,
			'META' => 38,
			"(" => 40,
			'FILTER' => 1,
			'INSERT' => 2,
			'IDENT' => 3,
			'CALL' => 37,
			"[" => 36,
			'LITERAL' => 4,
			'INCLUDE' => 33,
			'TRY' => 75,
			'RAW' => 35,
			'NEXT' => 29,
			";" => -19,
			'THROW' => 31,
			'UNLESS' => 30,
			'GET' => 32,
			'WRAPPER' => 27,
			'DEFAULT' => 67,
			'DEBUG' => 26,
			'TEXT' => 65,
			'RETURN' => 66,
			'REF' => 62,
			'IF' => 64,
			"\$" => 63,
			'NOT' => 22,
			'SWITCH' => 60,
			'USE' => 57,
			"\"" => 18,
			'STOP' => 20
		},
		DEFAULT => -3,
		GOTOS => {
			'capture' => 13,
			'sterm' => 70,
			'javascript' => 71,
			'anonblock' => 14,
			'expr' => 72,
			'loop' => 15,
			'item' => 16,
			'statement' => 73,
			'directive' => 17,
			'use' => 34,
			'node' => 74,
			'filter' => 47,
			'view' => 48,
			'atomdir' => 24,
			'macro' => 49,
			'switch' => 10,
			'condition' => 25,
			'chunks' => 69,
			'assign' => 51,
			'defblock' => 28,
			'term' => 41,
			'atomexpr' => 42,
			'ident' => 23,
			'block' => 267,
			'lterm' => 46,
			'wrapper' => 19,
			'try' => 58,
			'setlist' => 59,
			'raw' => 21,
			'chunk' => 39,
			'defblockname' => 61
		}
	},
	{#State 206
		DEFAULT => -107
	},
	{#State 207
		ACTIONS => {
			'NUMBER' => 43,
			'LITERAL' => 96,
			"\$" => 63,
			'IDENT' => 3,
			"\${" => 9,
			'REF' => 62,
			"\"" => 18
		},
		GOTOS => {
			'node' => 74,
			'item' => 16,
			'ident' => 97,
			'sterm' => 268
		}
	},
	{#State 208
		DEFAULT => -106
	},
	{#State 209
		DEFAULT => -116
	},
	{#State 210
		DEFAULT => -115
	},
	{#State 211
		DEFAULT => -99
	},
	{#State 212
		DEFAULT => -98
	},
	{#State 213
		ACTIONS => {
			'NUMBER' => 271,
			'LITERAL' => 270,
			"\"" => 269
		}
	},
	{#State 214
		ACTIONS => {
			'NOT' => 22,
			"(" => 40,
			"\${" => 9,
			"\"" => 18,
			'IDENT' => 3,
			"[" => 36,
			'LITERAL' => 96,
			'NUMBER' => 43,
			"{" => 8,
			'REF' => 62,
			"\$" => 63
		},
		GOTOS => {
			'ident' => 97,
			'sterm' => 70,
			'term' => 41,
			'expr' => 272,
			'node' => 74,
			'lterm' => 46,
			'item' => 16
		}
	},
	{#State 215
		DEFAULT => -146
	},
	{#State 216
		DEFAULT => -145
	},
	{#State 217
		DEFAULT => -82
	},
	{#State 218
		ACTIONS => {
			'DIV' => 171,
			'MOD' => 170,
			'AND' => 164,
			"/" => 167,
			'BINOP' => 165,
			'CAT' => 168,
			"+" => 166,
			"?" => 163,
			'OR' => 169,
			'CMPOP' => 162
		},
		DEFAULT => -63
	},
	{#State 219
		ACTIONS => {
			'BINOP' => 165,
			"+" => 166,
			'CAT' => 168,
			'CMPOP' => 162,
			'OR' => 169,
			"?" => 163,
			'DIV' => 171,
			'MOD' => 170,
			'AND' => 164,
			"/" => 167
		},
		DEFAULT => -49
	},
	{#State 220
		DEFAULT => -68
	},
	{#State 221
		DEFAULT => -60
	},
	{#State 222
		ACTIONS => {
			'DIV' => 171,
			'MOD' => 170,
			'AND' => 164,
			"/" => 167,
			'BINOP' => 165,
			"+" => 166,
			'CAT' => 168,
			'CMPOP' => 162,
			'OR' => 169,
			"?" => 163
		},
		DEFAULT => -47
	},
	{#State 223
		ACTIONS => {
			"[" => 36,
			'IDENT' => 274,
			'LITERAL' => 4,
			"\${" => 9,
			"\"" => 18,
			"(" => 40,
			'NOT' => 22,
			"\$" => 63,
			'REF' => 62,
			'NUMBER' => 43,
			"{" => 8
		},
		GOTOS => {
			'margs' => 273,
			'assign' => 128,
			'expr' => 127,
			'node' => 74,
			'lterm' => 46,
			'item' => 16,
			'ident' => 126,
			'sterm' => 70,
			'term' => 41
		}
	},
	{#State 224
		ACTIONS => {
			'BINOP' => 165,
			'CAT' => 168,
			'OR' => 169,
			'DIV' => 171,
			"+" => 166,
			'CMPOP' => 162,
			"?" => 163,
			"/" => 167,
			'MOD' => 170,
			'AND' => 164
		},
		DEFAULT => -28
	},
	{#State 225
		DEFAULT => -92
	},
	{#State 226
		ACTIONS => {
			'REF' => 62,
			'IF' => 64,
			"\$" => 63,
			'TEXT' => 65,
			'RETURN' => 66,
			'USE' => 57,
			"\"" => 18,
			'STOP' => 20,
			'NOT' => 22,
			'SWITCH' => 60,
			'NEXT' => 29,
			'THROW' => 31,
			";" => -19,
			'UNLESS' => 30,
			'GET' => 32,
			'INCLUDE' => 33,
			'RAW' => 35,
			'TRY' => 75,
			'DEFAULT' => 67,
			'DEBUG' => 26,
			'WRAPPER' => 27,
			'LAST' => 6,
			'NUMBER' => 43,
			'SET' => 45,
			'MACRO' => 44,
			"{" => 8,
			'FILTER' => 1,
			'INSERT' => 2,
			'IDENT' => 3,
			'CALL' => 37,
			"[" => 36,
			'LITERAL' => 4,
			'META' => 38,
			'WHILE' => 5,
			"(" => 40,
			'JAVASCRIPT' => 53,
			'BLOCK' => 52,
			'rawperl' => 54,
			'FOR' => 55,
			'VIEW' => 56,
			"\${" => 9,
			'PROCESS' => 50,
			'CLEAR' => 11,
			'perl' => 12
		},
		DEFAULT => -3,
		GOTOS => {
			'defblock' => 28,
			'chunks' => 69,
			'assign' => 51,
			'switch' => 10,
			'condition' => 25,
			'view' => 48,
			'filter' => 47,
			'atomdir' => 24,
			'macro' => 49,
			'statement' => 73,
			'item' => 16,
			'use' => 34,
			'node' => 74,
			'directive' => 17,
			'expr' => 72,
			'loop' => 15,
			'javascript' => 71,
			'anonblock' => 14,
			'sterm' => 70,
			'capture' => 13,
			'chunk' => 39,
			'defblockname' => 61,
			'setlist' => 59,
			'raw' => 21,
			'try' => 58,
			'wrapper' => 19,
			'lterm' => 46,
			'block' => 275,
			'term' => 41,
			'ident' => 23,
			'atomexpr' => 42
		}
	},
	{#State 227
		ACTIONS => {
			'FILTER' => 1,
			'INSERT' => 2,
			"[" => 36,
			'IDENT' => 3,
			'CALL' => 37,
			'LITERAL' => 4,
			'WHILE' => 5,
			'META' => 38,
			"(" => 40,
			'LAST' => 6,
			'NUMBER' => 43,
			"{" => 8,
			'SET' => 45,
			'MACRO' => 44,
			"\${" => 9,
			'CLEAR' => 11,
			'PROCESS' => 50,
			'perl' => 12,
			'BLOCK' => 52,
			'JAVASCRIPT' => 53,
			'FOR' => 55,
			'rawperl' => 54,
			'VIEW' => 56,
			'USE' => 57,
			"\"" => 18,
			'STOP' => 20,
			'NOT' => 22,
			'SWITCH' => 60,
			'REF' => 62,
			'IF' => 64,
			"\$" => 63,
			'TEXT' => 65,
			'RETURN' => 66,
			'DEFAULT' => 67,
			'DEBUG' => 26,
			'WRAPPER' => 27,
			'NEXT' => 29,
			";" => -19,
			'UNLESS' => 30,
			'GET' => 32,
			'THROW' => 31,
			'INCLUDE' => 33,
			'TRY' => 75,
			'RAW' => 35
		},
		DEFAULT => -3,
		GOTOS => {
			'javascript' => 71,
			'anonblock' => 14,
			'capture' => 13,
			'sterm' => 70,
			'item' => 16,
			'statement' => 73,
			'node' => 74,
			'use' => 34,
			'directive' => 17,
			'expr' => 72,
			'loop' => 15,
			'switch' => 10,
			'condition' => 25,
			'view' => 48,
			'filter' => 47,
			'macro' => 49,
			'atomdir' => 24,
			'defblock' => 28,
			'chunks' => 69,
			'assign' => 51,
			'term' => 41,
			'atomexpr' => 42,
			'ident' => 23,
			'lterm' => 46,
			'block' => 276,
			'try' => 58,
			'wrapper' => 19,
			'chunk' => 39,
			'defblockname' => 61,
			'raw' => 21,
			'setlist' => 59
		}
	},
	{#State 228
		ACTIONS => {
			"[" => 36,
			'IDENT' => 3,
			'LITERAL' => 250,
			"\${" => 9,
			"\"" => 18,
			"(" => 40,
			'COMMA' => 254,
			'NOT' => 22,
			"\$" => 63,
			'REF' => 62,
			'NUMBER' => 43,
			"{" => 8
		},
		DEFAULT => -66,
		GOTOS => {
			'param' => 251,
			'node' => 74,
			'lterm' => 46,
			'item' => 252,
			'expr' => 255,
			'ident' => 253,
			'term' => 41,
			'sterm' => 70
		}
	},
	{#State 229
		ACTIONS => {
			"\"" => 18,
			"\${" => 9,
			'LITERAL' => 96,
			'IDENT' => 3,
			"[" => 36,
			'REF' => 62,
			"\$" => 63,
			"{" => 8,
			'NUMBER' => 43
		},
		GOTOS => {
			'ident' => 97,
			'term' => 277,
			'sterm' => 70,
			'node' => 74,
			'item' => 16,
			'lterm' => 46
		}
	},
	{#State 230
		ACTIONS => {
			"\"" => 18,
			"\${" => 9,
			'LITERAL' => 96,
			'IDENT' => 3,
			"[" => 36,
			'REF' => 62,
			"\$" => 63,
			"{" => 8,
			'NUMBER' => 43
		},
		GOTOS => {
			'ident' => 97,
			'term' => 278,
			'sterm' => 70,
			'node' => 74,
			'lterm' => 46,
			'item' => 16
		}
	},
	{#State 231
		DEFAULT => -58,
		GOTOS => {
			'@1-3' => 279
		}
	},
	{#State 232
		DEFAULT => -77,
		GOTOS => {
			'@3-3' => 280
		}
	},
	{#State 233
		ACTIONS => {
			'DEFAULT' => 67,
			'DEBUG' => 26,
			'WRAPPER' => 27,
			'NEXT' => 29,
			'GET' => 32,
			";" => -19,
			'THROW' => 31,
			'UNLESS' => 30,
			'INCLUDE' => 33,
			'TRY' => 75,
			'RAW' => 35,
			'USE' => 57,
			"\"" => 18,
			'STOP' => 20,
			'NOT' => 22,
			'SWITCH' => 60,
			'REF' => 62,
			"\$" => 63,
			'IF' => 64,
			'TEXT' => 65,
			'RETURN' => 66,
			"\${" => 9,
			'CLEAR' => 11,
			'PROCESS' => 50,
			'perl' => 12,
			'JAVASCRIPT' => 53,
			'BLOCK' => 52,
			'FOR' => 55,
			'rawperl' => 54,
			'VIEW' => 56,
			'FILTER' => 1,
			'INSERT' => 2,
			'IDENT' => 3,
			"[" => 36,
			'CALL' => 37,
			'LITERAL' => 4,
			'META' => 38,
			'WHILE' => 5,
			"(" => 40,
			'NUMBER' => 43,
			'LAST' => 6,
			'MACRO' => 44,
			'SET' => 45,
			"{" => 8
		},
		DEFAULT => -3,
		GOTOS => {
			'assign' => 51,
			'chunks' => 69,
			'defblock' => 28,
			'macro' => 49,
			'atomdir' => 24,
			'filter' => 47,
			'view' => 48,
			'condition' => 25,
			'switch' => 10,
			'loop' => 15,
			'expr' => 72,
			'use' => 34,
			'node' => 74,
			'directive' => 17,
			'statement' => 73,
			'item' => 16,
			'capture' => 13,
			'sterm' => 70,
			'anonblock' => 14,
			'javascript' => 71,
			'setlist' => 59,
			'raw' => 21,
			'chunk' => 39,
			'defblockname' => 61,
			'wrapper' => 19,
			'try' => 58,
			'block' => 281,
			'lterm' => 46,
			'atomexpr' => 42,
			'ident' => 23,
			'term' => 41
		}
	},
	{#State 234
		ACTIONS => {
			'TRY' => 75,
			'RAW' => 35,
			'INCLUDE' => 33,
			'NEXT' => 29,
			'GET' => 32,
			";" => -19,
			'UNLESS' => 30,
			'THROW' => 31,
			'WRAPPER' => 27,
			'DEFAULT' => 67,
			'DEBUG' => 26,
			'RETURN' => 66,
			'TEXT' => 65,
			"\$" => 63,
			'IF' => 64,
			'REF' => 62,
			'NOT' => 22,
			'SWITCH' => 60,
			'STOP' => 20,
			'USE' => 57,
			"\"" => 18,
			'VIEW' => 56,
			'FOR' => 55,
			'rawperl' => 54,
			'BLOCK' => 52,
			'JAVASCRIPT' => 53,
			'perl' => 12,
			'PROCESS' => 50,
			'CLEAR' => 11,
			"\${" => 9,
			'LAST' => 6,
			'NUMBER' => 43,
			'SET' => 45,
			'MACRO' => 44,
			"{" => 8,
			'META' => 38,
			'WHILE' => 5,
			"(" => 40,
			'CALL' => 37,
			"[" => 36,
			'IDENT' => 3,
			'LITERAL' => 4,
			'FILTER' => 1,
			'INSERT' => 2
		},
		DEFAULT => -3,
		GOTOS => {
			'statement' => 73,
			'use' => 34,
			'node' => 74,
			'expr' => 72,
			'javascript' => 71,
			'sterm' => 70,
			'defblock' => 28,
			'template' => 282,
			'chunks' => 69,
			'condition' => 25,
			'atomdir' => 24,
			'ident' => 23,
			'defblockname' => 61,
			'raw' => 21,
			'setlist' => 59,
			'try' => 58,
			'wrapper' => 19,
			'item' => 16,
			'directive' => 17,
			'loop' => 15,
			'anonblock' => 14,
			'capture' => 13,
			'assign' => 51,
			'switch' => 10,
			'filter' => 47,
			'view' => 48,
			'macro' => 49,
			'lterm' => 46,
			'block' => 7,
			'term' => 41,
			'atomexpr' => 42,
			'chunk' => 39
		}
	},
	{#State 235
		ACTIONS => {
			'INCLUDE' => 33,
			'RAW' => 35,
			'TRY' => 75,
			'NEXT' => 29,
			";" => -19,
			'GET' => 32,
			'UNLESS' => 30,
			'THROW' => 31,
			'WRAPPER' => 27,
			'DEFAULT' => 67,
			'DEBUG' => 26,
			'TEXT' => 65,
			'RETURN' => 66,
			'REF' => 62,
			'IF' => 64,
			"\$" => 63,
			'NOT' => 22,
			'SWITCH' => 60,
			'USE' => 57,
			"\"" => 18,
			'STOP' => 20,
			'rawperl' => 54,
			'FOR' => 55,
			'VIEW' => 56,
			'BLOCK' => 52,
			'JAVASCRIPT' => 53,
			'perl' => 12,
			"\${" => 9,
			'CLEAR' => 11,
			'PROCESS' => 50,
			'LAST' => 6,
			'NUMBER' => 43,
			"{" => 8,
			'MACRO' => 44,
			'SET' => 45,
			'META' => 38,
			'WHILE' => 5,
			"(" => 40,
			'FILTER' => 1,
			'INSERT' => 2,
			'IDENT' => 3,
			"[" => 36,
			'CALL' => 37,
			'LITERAL' => 4
		},
		DEFAULT => -3,
		GOTOS => {
			'chunk' => 39,
			'defblockname' => 61,
			'raw' => 21,
			'setlist' => 59,
			'try' => 58,
			'wrapper' => 19,
			'lterm' => 46,
			'block' => 283,
			'atomexpr' => 42,
			'ident' => 23,
			'term' => 41,
			'defblock' => 28,
			'assign' => 51,
			'chunks' => 69,
			'condition' => 25,
			'switch' => 10,
			'atomdir' => 24,
			'macro' => 49,
			'filter' => 47,
			'view' => 48,
			'use' => 34,
			'node' => 74,
			'directive' => 17,
			'statement' => 73,
			'item' => 16,
			'loop' => 15,
			'expr' => 72,
			'anonblock' => 14,
			'javascript' => 71,
			'capture' => 13,
			'sterm' => 70
		}
	},
	{#State 236
		ACTIONS => {
			'MOD' => 170,
			'DIV' => 171,
			'BINOP' => 165,
			"/" => 167,
			"+" => 166
		},
		DEFAULT => -139
	},
	{#State 237
		ACTIONS => {
			'BINOP' => 165,
			'CMPOP' => 162,
			'OR' => 169,
			"?" => 163,
			"+" => 166,
			'CAT' => 168,
			":" => 284,
			'DIV' => 171,
			'AND' => 164,
			'MOD' => 170,
			"/" => 167
		}
	},
	{#State 238
		ACTIONS => {
			'CAT' => 168,
			"/" => 167,
			"+" => 166,
			'DIV' => 171,
			'BINOP' => 165,
			'MOD' => 170,
			'CMPOP' => 162
		},
		DEFAULT => -141
	},
	{#State 239
		ACTIONS => {
			"/" => 167,
			"+" => 166,
			'DIV' => 171,
			'MOD' => 170
		},
		DEFAULT => -134
	},
	{#State 240
		ACTIONS => {
			"/" => 167,
			'MOD' => 170,
			'DIV' => 171
		},
		DEFAULT => -136
	},
	{#State 241
		ACTIONS => {
			'MOD' => 170,
			'DIV' => 171
		},
		DEFAULT => -135
	},
	{#State 242
		ACTIONS => {
			'CMPOP' => 162,
			'MOD' => 170,
			'BINOP' => 165,
			'DIV' => 171,
			"+" => 166,
			"/" => 167
		},
		DEFAULT => -140
	},
	{#State 243
		ACTIONS => {
			'BINOP' => 165,
			'DIV' => 171,
			'CMPOP' => 162,
			'MOD' => 170,
			'CAT' => 168,
			"+" => 166,
			"/" => 167
		},
		DEFAULT => -142
	},
	{#State 244
		DEFAULT => -138
	},
	{#State 245
		ACTIONS => {
			'MOD' => 170
		},
		DEFAULT => -137
	},
	{#State 246
		ACTIONS => {
			'FINAL' => 285,
			'CATCH' => 287
		},
		DEFAULT => -74,
		GOTOS => {
			'final' => 286
		}
	},
	{#State 247
		ACTIONS => {
			'END' => 288
		}
	},
	{#State 248
		ACTIONS => {
			'ASSIGN' => -161
		},
		DEFAULT => -168
	},
	{#State 249
		DEFAULT => -166
	},
	{#State 250
		ACTIONS => {
			'ASSIGN' => 189
		},
		DEFAULT => -113
	},
	{#State 251
		DEFAULT => -154
	},
	{#State 252
		ACTIONS => {
			"(" => 105,
			'ASSIGN' => 190
		},
		DEFAULT => -129
	},
	{#State 253
		ACTIONS => {
			'DOT' => 108,
			'ASSIGN' => 289
		},
		DEFAULT => -110
	},
	{#State 254
		DEFAULT => -156
	},
	{#State 255
		ACTIONS => {
			'DIV' => 171,
			'BINOP' => 165,
			'OR' => 169,
			'CAT' => 168,
			'MOD' => 170,
			"/" => 167,
			'AND' => 164,
			"?" => 163,
			'CMPOP' => 162,
			"+" => 166
		},
		DEFAULT => -153
	},
	{#State 256
		ACTIONS => {
			"(" => 40,
			'NOT' => 22,
			'COMMA' => 254,
			'LITERAL' => 250,
			"[" => 36,
			'IDENT' => 3,
			"\"" => 18,
			"\${" => 9,
			")" => 290,
			"{" => 8,
			'NUMBER' => 43,
			"\$" => 63,
			'REF' => 62
		},
		GOTOS => {
			'param' => 251,
			'node' => 74,
			'lterm' => 46,
			'item' => 252,
			'expr' => 255,
			'ident' => 253,
			'sterm' => 70,
			'term' => 41
		}
	},
	{#State 257
		ACTIONS => {
			"\"" => 18,
			'IDENT' => 3,
			"[" => 36,
			'LITERAL' => 250,
			'NOT' => 22,
			"(" => 40,
			'REF' => 62,
			"\$" => 63,
			'NUMBER' => 43,
			"{" => 8,
			"\${" => 9,
			'COMMA' => 254
		},
		DEFAULT => -163,
		GOTOS => {
			'ident' => 253,
			'sterm' => 70,
			'term' => 41,
			'node' => 74,
			'lterm' => 46,
			'item' => 252,
			'expr' => 255,
			'param' => 251
		}
	},
	{#State 258
		DEFAULT => -158
	},
	{#State 259
		DEFAULT => -171
	},
	{#State 260
		DEFAULT => -168
	},
	{#State 261
		ACTIONS => {
			'INCLUDE' => 33,
			'TRY' => 75,
			'RAW' => 35,
			'NEXT' => 29,
			";" => -19,
			'GET' => 32,
			'THROW' => 31,
			'UNLESS' => 30,
			'WRAPPER' => 27,
			'DEFAULT' => 67,
			'DEBUG' => 26,
			'TEXT' => 65,
			'RETURN' => 66,
			'REF' => 62,
			'IF' => 64,
			"\$" => 63,
			'NOT' => 22,
			'SWITCH' => 60,
			'USE' => 57,
			"\"" => 18,
			'STOP' => 20,
			'FOR' => 55,
			'rawperl' => 54,
			'VIEW' => 56,
			'JAVASCRIPT' => 53,
			'BLOCK' => 52,
			'perl' => 12,
			"\${" => 9,
			'CLEAR' => 11,
			'PROCESS' => 50,
			'NUMBER' => 43,
			'LAST' => 6,
			"{" => 8,
			'SET' => 45,
			'MACRO' => 44,
			'META' => 38,
			'WHILE' => 5,
			"(" => 40,
			'FILTER' => 1,
			'INSERT' => 2,
			"[" => 36,
			'IDENT' => 3,
			'CALL' => 37,
			'LITERAL' => 4
		},
		DEFAULT => -3,
		GOTOS => {
			'assign' => 51,
			'chunks' => 69,
			'defblock' => 28,
			'macro' => 49,
			'atomdir' => 24,
			'filter' => 47,
			'view' => 48,
			'condition' => 25,
			'switch' => 10,
			'loop' => 15,
			'expr' => 72,
			'use' => 34,
			'node' => 74,
			'directive' => 17,
			'statement' => 73,
			'item' => 16,
			'capture' => 13,
			'sterm' => 70,
			'javascript' => 71,
			'anonblock' => 14,
			'raw' => 21,
			'setlist' => 59,
			'defblockname' => 61,
			'chunk' => 39,
			'wrapper' => 19,
			'try' => 58,
			'block' => 291,
			'lterm' => 46,
			'ident' => 23,
			'atomexpr' => 42,
			'term' => 41
		}
	},
	{#State 262
		ACTIONS => {
			'OR' => 169,
			'CAT' => 168,
			"+" => 166,
			"/" => 167,
			'BINOP' => 165,
			'DIV' => 171,
			"?" => 163,
			'CMPOP' => 162,
			'AND' => 164,
			'MOD' => 170
		},
		DEFAULT => -124
	},
	{#State 263
		ACTIONS => {
			'DIV' => 171,
			'BINOP' => 165,
			'MOD' => 170,
			'AND' => 164,
			'CMPOP' => 162,
			"?" => 163,
			'OR' => 169,
			'CAT' => 168,
			"/" => 167,
			"+" => 166
		},
		DEFAULT => -125
	},
	{#State 264
		DEFAULT => -130
	},
	{#State 265
		ACTIONS => {
			'NOT' => 22,
			'SWITCH' => 60,
			'STOP' => 20,
			'USE' => 57,
			"\"" => 18,
			'RETURN' => 66,
			'TEXT' => 65,
			"\$" => 63,
			'IF' => 64,
			'REF' => 62,
			'WRAPPER' => 27,
			'DEFAULT' => 67,
			'DEBUG' => 26,
			'TRY' => 75,
			'RAW' => 35,
			'INCLUDE' => 33,
			'NEXT' => 29,
			";" => -19,
			'GET' => 32,
			'UNLESS' => 30,
			'THROW' => 31,
			'META' => 38,
			'WHILE' => 5,
			"(" => 40,
			"[" => 36,
			'IDENT' => 3,
			'CALL' => 37,
			'LITERAL' => 4,
			'FILTER' => 1,
			'INSERT' => 2,
			'LAST' => 6,
			'NUMBER' => 43,
			"{" => 8,
			'MACRO' => 44,
			'SET' => 45,
			'perl' => 12,
			'PROCESS' => 50,
			'CLEAR' => 11,
			"\${" => 9,
			'VIEW' => 56,
			'rawperl' => 54,
			'FOR' => 55,
			'JAVASCRIPT' => 53,
			'BLOCK' => 52
		},
		DEFAULT => -3,
		GOTOS => {
			'atomexpr' => 42,
			'ident' => 23,
			'term' => 41,
			'lterm' => 46,
			'block' => 292,
			'try' => 58,
			'wrapper' => 19,
			'defblockname' => 61,
			'chunk' => 39,
			'raw' => 21,
			'setlist' => 59,
			'javascript' => 71,
			'anonblock' => 14,
			'capture' => 13,
			'sterm' => 70,
			'node' => 74,
			'directive' => 17,
			'use' => 34,
			'item' => 16,
			'statement' => 73,
			'loop' => 15,
			'expr' => 72,
			'condition' => 25,
			'switch' => 10,
			'atomdir' => 24,
			'macro' => 49,
			'view' => 48,
			'filter' => 47,
			'defblock' => 28,
			'assign' => 51,
			'chunks' => 69
		}
	},
	{#State 266
		ACTIONS => {
			'END' => 293
		}
	},
	{#State 267
		ACTIONS => {
			'ELSE' => 294,
			'ELSIF' => 295
		},
		DEFAULT => -52,
		GOTOS => {
			'else' => 296
		}
	},
	{#State 268
		DEFAULT => -118
	},
	{#State 269
		ACTIONS => {
			'TEXT' => 297
		}
	},
	{#State 270
		DEFAULT => -101
	},
	{#State 271
		DEFAULT => -103
	},
	{#State 272
		ACTIONS => {
			'AND' => 164,
			'MOD' => 170,
			"/" => 167,
			"+" => 166,
			"?" => 163,
			'CMPOP' => 162,
			'DIV' => 171,
			'CAT' => 168,
			'OR' => 169,
			'BINOP' => 165
		},
		DEFAULT => -151
	},
	{#State 273
		ACTIONS => {
			'IDENT' => 298,
			")" => 299,
			'COMMA' => 300
		}
	},
	{#State 274
		ACTIONS => {
			'IDENT' => -97,
			")" => -97,
			'COMMA' => -97
		},
		DEFAULT => -131
	},
	{#State 275
		ACTIONS => {
			'END' => 301
		}
	},
	{#State 276
		ACTIONS => {
			'END' => 302
		}
	},
	{#State 277
		DEFAULT => -157,
		GOTOS => {
			'args' => 303
		}
	},
	{#State 278
		DEFAULT => -157,
		GOTOS => {
			'args' => 304
		}
	},
	{#State 279
		ACTIONS => {
			'NUMBER' => 43,
			'LAST' => 6,
			"{" => 8,
			'MACRO' => 44,
			'SET' => 45,
			'WHILE' => 5,
			'META' => 38,
			"(" => 40,
			'FILTER' => 1,
			'INSERT' => 2,
			"[" => 36,
			'IDENT' => 3,
			'CALL' => 37,
			'LITERAL' => 4,
			'FOR' => 55,
			'rawperl' => 54,
			'VIEW' => 56,
			'BLOCK' => 52,
			'JAVASCRIPT' => 53,
			'perl' => 12,
			"\${" => 9,
			'PROCESS' => 50,
			'CLEAR' => 11,
			'TEXT' => 65,
			'RETURN' => 66,
			'REF' => 62,
			"\$" => 63,
			'IF' => 64,
			'NOT' => 22,
			'SWITCH' => 60,
			'USE' => 57,
			"\"" => 18,
			'STOP' => 20,
			'INCLUDE' => 33,
			'RAW' => 35,
			'TRY' => 75,
			'NEXT' => 29,
			'UNLESS' => 30,
			";" => -19,
			'THROW' => 31,
			'GET' => 32,
			'WRAPPER' => 27,
			'DEFAULT' => 67,
			'DEBUG' => 26
		},
		DEFAULT => -3,
		GOTOS => {
			'javascript' => 71,
			'anonblock' => 14,
			'sterm' => 70,
			'capture' => 13,
			'directive' => 17,
			'use' => 34,
			'node' => 74,
			'item' => 16,
			'statement' => 73,
			'loop' => 15,
			'expr' => 72,
			'condition' => 25,
			'switch' => 10,
			'atomdir' => 24,
			'macro' => 49,
			'filter' => 47,
			'view' => 48,
			'defblock' => 28,
			'assign' => 51,
			'chunks' => 69,
			'atomexpr' => 42,
			'ident' => 23,
			'term' => 41,
			'lterm' => 46,
			'block' => 305,
			'try' => 58,
			'wrapper' => 19,
			'chunk' => 39,
			'defblockname' => 61,
			'raw' => 21,
			'setlist' => 59
		}
	},
	{#State 280
		ACTIONS => {
			"\${" => 9,
			'PROCESS' => 50,
			'CLEAR' => 11,
			'perl' => 12,
			'BLOCK' => 52,
			'JAVASCRIPT' => 53,
			'rawperl' => 54,
			'FOR' => 55,
			'VIEW' => 56,
			'FILTER' => 1,
			'INSERT' => 2,
			'CALL' => 37,
			"[" => 36,
			'IDENT' => 3,
			'LITERAL' => 4,
			'WHILE' => 5,
			'META' => 38,
			"(" => 40,
			'NUMBER' => 43,
			'LAST' => 6,
			'SET' => 45,
			'MACRO' => 44,
			"{" => 8,
			'DEFAULT' => 67,
			'DEBUG' => 26,
			'WRAPPER' => 27,
			'NEXT' => 29,
			";" => -19,
			'UNLESS' => 30,
			'GET' => 32,
			'THROW' => 31,
			'INCLUDE' => 33,
			'TRY' => 75,
			'RAW' => 35,
			'USE' => 57,
			"\"" => 18,
			'STOP' => 20,
			'NOT' => 22,
			'SWITCH' => 60,
			'REF' => 62,
			'IF' => 64,
			"\$" => 63,
			'TEXT' => 65,
			'RETURN' => 66
		},
		DEFAULT => -3,
		GOTOS => {
			'wrapper' => 19,
			'try' => 58,
			'setlist' => 59,
			'raw' => 21,
			'chunk' => 39,
			'defblockname' => 61,
			'atomexpr' => 42,
			'ident' => 23,
			'term' => 41,
			'block' => 306,
			'lterm' => 46,
			'atomdir' => 24,
			'macro' => 49,
			'view' => 48,
			'filter' => 47,
			'condition' => 25,
			'switch' => 10,
			'assign' => 51,
			'chunks' => 69,
			'defblock' => 28,
			'sterm' => 70,
			'capture' => 13,
			'javascript' => 71,
			'anonblock' => 14,
			'loop' => 15,
			'expr' => 72,
			'node' => 74,
			'use' => 34,
			'directive' => 17,
			'item' => 16,
			'statement' => 73
		}
	},
	{#State 281
		ACTIONS => {
			'CASE' => 307
		},
		DEFAULT => -57,
		GOTOS => {
			'case' => 308
		}
	},
	{#State 282
		ACTIONS => {
			'END' => 309
		}
	},
	{#State 283
		ACTIONS => {
			'ELSIF' => 295,
			'ELSE' => 294
		},
		DEFAULT => -52,
		GOTOS => {
			'else' => 310
		}
	},
	{#State 284
		ACTIONS => {
			'NUMBER' => 43,
			"{" => 8,
			"\$" => 63,
			'REF' => 62,
			"(" => 40,
			'NOT' => 22,
			'IDENT' => 3,
			"[" => 36,
			'LITERAL' => 96,
			"\"" => 18,
			"\${" => 9
		},
		GOTOS => {
			'term' => 41,
			'sterm' => 70,
			'ident' => 97,
			'expr' => 311,
			'lterm' => 46,
			'item' => 16,
			'node' => 74
		}
	},
	{#State 285
		ACTIONS => {
			";" => 312
		}
	},
	{#State 286
		ACTIONS => {
			'END' => 313
		}
	},
	{#State 287
		ACTIONS => {
			'NUMBER' => 87,
			";" => 314,
			'DEFAULT' => 316,
			'IDENT' => 91,
			'FILENAME' => 82
		},
		GOTOS => {
			'filepart' => 83,
			'filename' => 315
		}
	},
	{#State 288
		DEFAULT => -81
	},
	{#State 289
		ACTIONS => {
			'LITERAL' => 96,
			'IDENT' => 3,
			"[" => 36,
			"\"" => 18,
			"\${" => 9,
			"(" => 40,
			'NOT' => 22,
			"\$" => 63,
			'REF' => 62,
			"{" => 8,
			'NUMBER' => 43
		},
		GOTOS => {
			'ident' => 97,
			'term' => 41,
			'sterm' => 70,
			'node' => 74,
			'lterm' => 46,
			'item' => 16,
			'expr' => 317
		}
	},
	{#State 290
		DEFAULT => -165
	},
	{#State 291
		ACTIONS => {
			'END' => 318
		}
	},
	{#State 292
		ACTIONS => {
			'END' => 319
		}
	},
	{#State 293
		DEFAULT => -67
	},
	{#State 294
		ACTIONS => {
			";" => 320
		}
	},
	{#State 295
		ACTIONS => {
			'NUMBER' => 43,
			"{" => 8,
			'REF' => 62,
			"\$" => 63,
			'NOT' => 22,
			"(" => 40,
			"\"" => 18,
			"\${" => 9,
			'IDENT' => 3,
			"[" => 36,
			'LITERAL' => 96
		},
		GOTOS => {
			'ident' => 97,
			'term' => 41,
			'sterm' => 70,
			'expr' => 321,
			'node' => 74,
			'item' => 16,
			'lterm' => 46
		}
	},
	{#State 296
		ACTIONS => {
			'END' => 322
		}
	},
	{#State 297
		ACTIONS => {
			"\"" => 323
		}
	},
	{#State 298
		DEFAULT => -95
	},
	{#State 299
		ACTIONS => {
			'BLOCK' => 200,
			'JAVASCRIPT' => 53,
			'FOR' => 55,
			'CLEAR' => 11,
			'PROCESS' => 50,
			"\${" => 9,
			'perl' => 12,
			'LAST' => 6,
			'NUMBER' => 43,
			"{" => 8,
			'SET' => 45,
			'IDENT' => 3,
			'CALL' => 37,
			"[" => 36,
			'LITERAL' => 4,
			'FILTER' => 1,
			'INSERT' => 2,
			'WHILE' => 5,
			"(" => 40,
			'NEXT' => 29,
			'GET' => 32,
			'UNLESS' => 30,
			'THROW' => 31,
			'TRY' => 75,
			'INCLUDE' => 33,
			'DEFAULT' => 67,
			'DEBUG' => 26,
			'WRAPPER' => 27,
			"\$" => 63,
			'IF' => 64,
			'REF' => 62,
			'RETURN' => 66,
			'STOP' => 20,
			"\"" => 18,
			'NOT' => 22,
			'SWITCH' => 60
		},
		GOTOS => {
			'sterm' => 70,
			'javascript' => 71,
			'loop' => 15,
			'expr' => 224,
			'directive' => 203,
			'node' => 74,
			'item' => 16,
			'mdir' => 324,
			'atomdir' => 24,
			'filter' => 47,
			'condition' => 25,
			'switch' => 10,
			'assign' => 51,
			'ident' => 126,
			'atomexpr' => 42,
			'term' => 41,
			'lterm' => 46,
			'wrapper' => 19,
			'try' => 58,
			'setlist' => 59
		}
	},
	{#State 300
		DEFAULT => -96
	},
	{#State 301
		DEFAULT => -89
	},
	{#State 302
		DEFAULT => -80
	},
	{#State 303
		ACTIONS => {
			'NOT' => 22,
			'COMMA' => 254,
			"(" => 40,
			"\${" => 9,
			"\"" => 18,
			'IDENT' => 3,
			"[" => 36,
			'LITERAL' => 250,
			'NUMBER' => 43,
			"{" => 8,
			'REF' => 62,
			"\$" => 63
		},
		DEFAULT => -64,
		GOTOS => {
			'param' => 251,
			'expr' => 255,
			'lterm' => 46,
			'item' => 252,
			'node' => 74,
			'sterm' => 70,
			'term' => 41,
			'ident' => 253
		}
	},
	{#State 304
		ACTIONS => {
			'REF' => 62,
			"\$" => 63,
			'NUMBER' => 43,
			"{" => 8,
			"\"" => 18,
			"\${" => 9,
			'IDENT' => 3,
			"[" => 36,
			'LITERAL' => 250,
			'COMMA' => 254,
			'NOT' => 22,
			"(" => 40
		},
		DEFAULT => -65,
		GOTOS => {
			'param' => 251,
			'term' => 41,
			'sterm' => 70,
			'ident' => 253,
			'item' => 252,
			'lterm' => 46,
			'node' => 74,
			'expr' => 255
		}
	},
	{#State 305
		ACTIONS => {
			'END' => 325
		}
	},
	{#State 306
		ACTIONS => {
			'END' => 326
		}
	},
	{#State 307
		ACTIONS => {
			"{" => 8,
			'NUMBER' => 43,
			'REF' => 62,
			";" => 329,
			"\$" => 63,
			"\${" => 9,
			"\"" => 18,
			'LITERAL' => 96,
			"[" => 36,
			'IDENT' => 3,
			'DEFAULT' => 328
		},
		GOTOS => {
			'ident' => 97,
			'sterm' => 70,
			'term' => 327,
			'node' => 74,
			'lterm' => 46,
			'item' => 16
		}
	},
	{#State 308
		ACTIONS => {
			'END' => 330
		}
	},
	{#State 309
		DEFAULT => -83
	},
	{#State 310
		ACTIONS => {
			'END' => 331
		}
	},
	{#State 311
		ACTIONS => {
			'MOD' => 170,
			'AND' => 164,
			"?" => 163,
			'CMPOP' => 162,
			'DIV' => 171,
			'BINOP' => 165,
			"/" => 167,
			"+" => 166,
			'CAT' => 168,
			'OR' => 169
		},
		DEFAULT => -144
	},
	{#State 312
		ACTIONS => {
			'FOR' => 55,
			'rawperl' => 54,
			'VIEW' => 56,
			'BLOCK' => 52,
			'JAVASCRIPT' => 53,
			'perl' => 12,
			"\${" => 9,
			'CLEAR' => 11,
			'PROCESS' => 50,
			'LAST' => 6,
			'NUMBER' => 43,
			"{" => 8,
			'MACRO' => 44,
			'SET' => 45,
			'META' => 38,
			'WHILE' => 5,
			"(" => 40,
			'FILTER' => 1,
			'INSERT' => 2,
			'IDENT' => 3,
			'CALL' => 37,
			"[" => 36,
			'LITERAL' => 4,
			'INCLUDE' => 33,
			'TRY' => 75,
			'RAW' => 35,
			'NEXT' => 29,
			'THROW' => 31,
			";" => -19,
			'GET' => 32,
			'UNLESS' => 30,
			'WRAPPER' => 27,
			'DEFAULT' => 67,
			'DEBUG' => 26,
			'TEXT' => 65,
			'RETURN' => 66,
			'REF' => 62,
			'IF' => 64,
			"\$" => 63,
			'NOT' => 22,
			'SWITCH' => 60,
			'USE' => 57,
			"\"" => 18,
			'STOP' => 20
		},
		DEFAULT => -3,
		GOTOS => {
			'wrapper' => 19,
			'try' => 58,
			'setlist' => 59,
			'raw' => 21,
			'defblockname' => 61,
			'chunk' => 39,
			'atomexpr' => 42,
			'ident' => 23,
			'term' => 41,
			'block' => 332,
			'lterm' => 46,
			'macro' => 49,
			'atomdir' => 24,
			'filter' => 47,
			'view' => 48,
			'condition' => 25,
			'switch' => 10,
			'assign' => 51,
			'chunks' => 69,
			'defblock' => 28,
			'capture' => 13,
			'sterm' => 70,
			'anonblock' => 14,
			'javascript' => 71,
			'loop' => 15,
			'expr' => 72,
			'directive' => 17,
			'node' => 74,
			'use' => 34,
			'item' => 16,
			'statement' => 73
		}
	},
	{#State 313
		DEFAULT => -69
	},
	{#State 314
		ACTIONS => {
			'JAVASCRIPT' => 53,
			'BLOCK' => 52,
			'FOR' => 55,
			'rawperl' => 54,
			'VIEW' => 56,
			"\${" => 9,
			'PROCESS' => 50,
			'CLEAR' => 11,
			'perl' => 12,
			'NUMBER' => 43,
			'LAST' => 6,
			"{" => 8,
			'SET' => 45,
			'MACRO' => 44,
			'FILTER' => 1,
			'INSERT' => 2,
			'CALL' => 37,
			'IDENT' => 3,
			"[" => 36,
			'LITERAL' => 4,
			'META' => 38,
			'WHILE' => 5,
			"(" => 40,
			'NEXT' => 29,
			";" => -19,
			'THROW' => 31,
			'GET' => 32,
			'UNLESS' => 30,
			'INCLUDE' => 33,
			'RAW' => 35,
			'TRY' => 75,
			'DEFAULT' => 67,
			'DEBUG' => 26,
			'WRAPPER' => 27,
			'REF' => 62,
			"\$" => 63,
			'IF' => 64,
			'TEXT' => 65,
			'RETURN' => 66,
			'USE' => 57,
			"\"" => 18,
			'STOP' => 20,
			'NOT' => 22,
			'SWITCH' => 60
		},
		DEFAULT => -3,
		GOTOS => {
			'statement' => 73,
			'item' => 16,
			'node' => 74,
			'directive' => 17,
			'use' => 34,
			'expr' => 72,
			'loop' => 15,
			'anonblock' => 14,
			'javascript' => 71,
			'capture' => 13,
			'sterm' => 70,
			'defblock' => 28,
			'chunks' => 69,
			'assign' => 51,
			'switch' => 10,
			'condition' => 25,
			'filter' => 47,
			'view' => 48,
			'atomdir' => 24,
			'macro' => 49,
			'lterm' => 46,
			'block' => 333,
			'term' => 41,
			'atomexpr' => 42,
			'ident' => 23,
			'defblockname' => 61,
			'chunk' => 39,
			'setlist' => 59,
			'raw' => 21,
			'try' => 58,
			'wrapper' => 19
		}
	},
	{#State 315
		ACTIONS => {
			'DOT' => 182,
			";" => 334
		}
	},
	{#State 316
		ACTIONS => {
			";" => 335
		}
	},
	{#State 317
		ACTIONS => {
			'DIV' => 171,
			'CAT' => 168,
			'OR' => 169,
			'BINOP' => 165,
			"/" => 167,
			'AND' => 164,
			'MOD' => 170,
			"+" => 166,
			'CMPOP' => 162,
			"?" => 163
		},
		DEFAULT => -155
	},
	{#State 318
		DEFAULT => -62
	},
	{#State 319
		DEFAULT => -94
	},
	{#State 320
		ACTIONS => {
			'perl' => 12,
			"\${" => 9,
			'CLEAR' => 11,
			'PROCESS' => 50,
			'FOR' => 55,
			'rawperl' => 54,
			'VIEW' => 56,
			'JAVASCRIPT' => 53,
			'BLOCK' => 52,
			"(" => 40,
			'META' => 38,
			'WHILE' => 5,
			'INSERT' => 2,
			'FILTER' => 1,
			'LITERAL' => 4,
			'IDENT' => 3,
			'CALL' => 37,
			"[" => 36,
			"{" => 8,
			'SET' => 45,
			'MACRO' => 44,
			'LAST' => 6,
			'NUMBER' => 43,
			'WRAPPER' => 27,
			'DEBUG' => 26,
			'DEFAULT' => 67,
			'INCLUDE' => 33,
			'TRY' => 75,
			'RAW' => 35,
			'UNLESS' => 30,
			";" => -19,
			'THROW' => 31,
			'GET' => 32,
			'NEXT' => 29,
			'SWITCH' => 60,
			'NOT' => 22,
			"\"" => 18,
			'USE' => 57,
			'STOP' => 20,
			'TEXT' => 65,
			'RETURN' => 66,
			'REF' => 62,
			'IF' => 64,
			"\$" => 63
		},
		DEFAULT => -3,
		GOTOS => {
			'anonblock' => 14,
			'javascript' => 71,
			'sterm' => 70,
			'capture' => 13,
			'statement' => 73,
			'item' => 16,
			'use' => 34,
			'directive' => 17,
			'node' => 74,
			'expr' => 72,
			'loop' => 15,
			'switch' => 10,
			'condition' => 25,
			'view' => 48,
			'filter' => 47,
			'macro' => 49,
			'atomdir' => 24,
			'defblock' => 28,
			'chunks' => 69,
			'assign' => 51,
			'term' => 41,
			'atomexpr' => 42,
			'ident' => 23,
			'lterm' => 46,
			'block' => 336,
			'try' => 58,
			'wrapper' => 19,
			'defblockname' => 61,
			'chunk' => 39,
			'setlist' => 59,
			'raw' => 21
		}
	},
	{#State 321
		ACTIONS => {
			'CAT' => 168,
			";" => 337,
			"+" => 166,
			"?" => 163,
			'CMPOP' => 162,
			'OR' => 169,
			'BINOP' => 165,
			'AND' => 164,
			"/" => 167,
			'MOD' => 170,
			'DIV' => 171
		}
	},
	{#State 322
		DEFAULT => -48
	},
	{#State 323
		DEFAULT => -102
	},
	{#State 324
		DEFAULT => -91
	},
	{#State 325
		DEFAULT => -59
	},
	{#State 326
		DEFAULT => -78
	},
	{#State 327
		ACTIONS => {
			";" => 338
		}
	},
	{#State 328
		ACTIONS => {
			";" => 339
		}
	},
	{#State 329
		ACTIONS => {
			'RETURN' => 66,
			'TEXT' => 65,
			"\$" => 63,
			'IF' => 64,
			'REF' => 62,
			'NOT' => 22,
			'SWITCH' => 60,
			'STOP' => 20,
			'USE' => 57,
			"\"" => 18,
			'TRY' => 75,
			'RAW' => 35,
			'INCLUDE' => 33,
			'NEXT' => 29,
			";" => -19,
			'THROW' => 31,
			'GET' => 32,
			'UNLESS' => 30,
			'WRAPPER' => 27,
			'DEFAULT' => 67,
			'DEBUG' => 26,
			'NUMBER' => 43,
			'LAST' => 6,
			"{" => 8,
			'MACRO' => 44,
			'SET' => 45,
			'WHILE' => 5,
			'META' => 38,
			"(" => 40,
			'IDENT' => 3,
			"[" => 36,
			'CALL' => 37,
			'LITERAL' => 4,
			'FILTER' => 1,
			'INSERT' => 2,
			'VIEW' => 56,
			'rawperl' => 54,
			'FOR' => 55,
			'JAVASCRIPT' => 53,
			'BLOCK' => 52,
			'perl' => 12,
			'PROCESS' => 50,
			'CLEAR' => 11,
			"\${" => 9
		},
		DEFAULT => -3,
		GOTOS => {
			'setlist' => 59,
			'raw' => 21,
			'chunk' => 39,
			'defblockname' => 61,
			'wrapper' => 19,
			'try' => 58,
			'block' => 340,
			'lterm' => 46,
			'atomexpr' => 42,
			'ident' => 23,
			'term' => 41,
			'assign' => 51,
			'chunks' => 69,
			'defblock' => 28,
			'atomdir' => 24,
			'macro' => 49,
			'view' => 48,
			'filter' => 47,
			'condition' => 25,
			'switch' => 10,
			'loop' => 15,
			'expr' => 72,
			'directive' => 17,
			'node' => 74,
			'use' => 34,
			'statement' => 73,
			'item' => 16,
			'sterm' => 70,
			'capture' => 13,
			'anonblock' => 14,
			'javascript' => 71
		}
	},
	{#State 330
		DEFAULT => -53
	},
	{#State 331
		DEFAULT => -46
	},
	{#State 332
		DEFAULT => -73
	},
	{#State 333
		ACTIONS => {
			'FINAL' => 285,
			'CATCH' => 287
		},
		DEFAULT => -74,
		GOTOS => {
			'final' => 341
		}
	},
	{#State 334
		ACTIONS => {
			'MACRO' => 44,
			'SET' => 45,
			"{" => 8,
			'LAST' => 6,
			'NUMBER' => 43,
			'INSERT' => 2,
			'FILTER' => 1,
			'LITERAL' => 4,
			'IDENT' => 3,
			'CALL' => 37,
			"[" => 36,
			"(" => 40,
			'WHILE' => 5,
			'META' => 38,
			'JAVASCRIPT' => 53,
			'BLOCK' => 52,
			'rawperl' => 54,
			'FOR' => 55,
			'VIEW' => 56,
			"\${" => 9,
			'CLEAR' => 11,
			'PROCESS' => 50,
			'perl' => 12,
			'REF' => 62,
			'IF' => 64,
			"\$" => 63,
			'TEXT' => 65,
			'RETURN' => 66,
			"\"" => 18,
			'USE' => 57,
			'STOP' => 20,
			'SWITCH' => 60,
			'NOT' => 22,
			";" => -19,
			'THROW' => 31,
			'UNLESS' => 30,
			'GET' => 32,
			'NEXT' => 29,
			'INCLUDE' => 33,
			'TRY' => 75,
			'RAW' => 35,
			'DEBUG' => 26,
			'DEFAULT' => 67,
			'WRAPPER' => 27
		},
		DEFAULT => -3,
		GOTOS => {
			'term' => 41,
			'ident' => 23,
			'atomexpr' => 42,
			'block' => 342,
			'lterm' => 46,
			'wrapper' => 19,
			'try' => 58,
			'raw' => 21,
			'setlist' => 59,
			'chunk' => 39,
			'defblockname' => 61,
			'capture' => 13,
			'sterm' => 70,
			'javascript' => 71,
			'anonblock' => 14,
			'expr' => 72,
			'loop' => 15,
			'statement' => 73,
			'item' => 16,
			'node' => 74,
			'directive' => 17,
			'use' => 34,
			'filter' => 47,
			'view' => 48,
			'atomdir' => 24,
			'macro' => 49,
			'switch' => 10,
			'condition' => 25,
			'chunks' => 69,
			'assign' => 51,
			'defblock' => 28
		}
	},
	{#State 335
		ACTIONS => {
			'VIEW' => 56,
			'rawperl' => 54,
			'FOR' => 55,
			'JAVASCRIPT' => 53,
			'BLOCK' => 52,
			'perl' => 12,
			'PROCESS' => 50,
			'CLEAR' => 11,
			"\${" => 9,
			'LAST' => 6,
			'NUMBER' => 43,
			'MACRO' => 44,
			'SET' => 45,
			"{" => 8,
			'META' => 38,
			'WHILE' => 5,
			"(" => 40,
			"[" => 36,
			'CALL' => 37,
			'IDENT' => 3,
			'LITERAL' => 4,
			'FILTER' => 1,
			'INSERT' => 2,
			'RAW' => 35,
			'TRY' => 75,
			'INCLUDE' => 33,
			'NEXT' => 29,
			";" => -19,
			'UNLESS' => 30,
			'THROW' => 31,
			'GET' => 32,
			'WRAPPER' => 27,
			'DEFAULT' => 67,
			'DEBUG' => 26,
			'RETURN' => 66,
			'TEXT' => 65,
			'IF' => 64,
			"\$" => 63,
			'REF' => 62,
			'NOT' => 22,
			'SWITCH' => 60,
			'STOP' => 20,
			'USE' => 57,
			"\"" => 18
		},
		DEFAULT => -3,
		GOTOS => {
			'term' => 41,
			'atomexpr' => 42,
			'ident' => 23,
			'lterm' => 46,
			'block' => 343,
			'try' => 58,
			'wrapper' => 19,
			'defblockname' => 61,
			'chunk' => 39,
			'raw' => 21,
			'setlist' => 59,
			'javascript' => 71,
			'anonblock' => 14,
			'capture' => 13,
			'sterm' => 70,
			'item' => 16,
			'statement' => 73,
			'node' => 74,
			'directive' => 17,
			'use' => 34,
			'expr' => 72,
			'loop' => 15,
			'switch' => 10,
			'condition' => 25,
			'filter' => 47,
			'view' => 48,
			'atomdir' => 24,
			'macro' => 49,
			'defblock' => 28,
			'chunks' => 69,
			'assign' => 51
		}
	},
	{#State 336
		DEFAULT => -51
	},
	{#State 337
		ACTIONS => {
			'INSERT' => 2,
			'FILTER' => 1,
			'LITERAL' => 4,
			'CALL' => 37,
			'IDENT' => 3,
			"[" => 36,
			"(" => 40,
			'WHILE' => 5,
			'META' => 38,
			"{" => 8,
			'SET' => 45,
			'MACRO' => 44,
			'LAST' => 6,
			'NUMBER' => 43,
			"\${" => 9,
			'CLEAR' => 11,
			'PROCESS' => 50,
			'perl' => 12,
			'BLOCK' => 52,
			'JAVASCRIPT' => 53,
			'rawperl' => 54,
			'FOR' => 55,
			'VIEW' => 56,
			"\"" => 18,
			'USE' => 57,
			'STOP' => 20,
			'SWITCH' => 60,
			'NOT' => 22,
			'REF' => 62,
			"\$" => 63,
			'IF' => 64,
			'TEXT' => 65,
			'RETURN' => 66,
			'DEBUG' => 26,
			'DEFAULT' => 67,
			'WRAPPER' => 27,
			'UNLESS' => 30,
			";" => -19,
			'GET' => 32,
			'THROW' => 31,
			'NEXT' => 29,
			'INCLUDE' => 33,
			'TRY' => 75,
			'RAW' => 35
		},
		DEFAULT => -3,
		GOTOS => {
			'condition' => 25,
			'switch' => 10,
			'atomdir' => 24,
			'macro' => 49,
			'view' => 48,
			'filter' => 47,
			'defblock' => 28,
			'assign' => 51,
			'chunks' => 69,
			'javascript' => 71,
			'anonblock' => 14,
			'capture' => 13,
			'sterm' => 70,
			'directive' => 17,
			'node' => 74,
			'use' => 34,
			'statement' => 73,
			'item' => 16,
			'loop' => 15,
			'expr' => 72,
			'try' => 58,
			'wrapper' => 19,
			'chunk' => 39,
			'defblockname' => 61,
			'raw' => 21,
			'setlist' => 59,
			'ident' => 23,
			'atomexpr' => 42,
			'term' => 41,
			'lterm' => 46,
			'block' => 344
		}
	},
	{#State 338
		ACTIONS => {
			'FOR' => 55,
			'rawperl' => 54,
			'VIEW' => 56,
			'JAVASCRIPT' => 53,
			'BLOCK' => 52,
			'perl' => 12,
			"\${" => 9,
			'CLEAR' => 11,
			'PROCESS' => 50,
			'NUMBER' => 43,
			'LAST' => 6,
			"{" => 8,
			'MACRO' => 44,
			'SET' => 45,
			'META' => 38,
			'WHILE' => 5,
			"(" => 40,
			'FILTER' => 1,
			'INSERT' => 2,
			"[" => 36,
			'IDENT' => 3,
			'CALL' => 37,
			'LITERAL' => 4,
			'INCLUDE' => 33,
			'RAW' => 35,
			'TRY' => 75,
			'NEXT' => 29,
			";" => -19,
			'UNLESS' => 30,
			'THROW' => 31,
			'GET' => 32,
			'WRAPPER' => 27,
			'DEFAULT' => 67,
			'DEBUG' => 26,
			'TEXT' => 65,
			'RETURN' => 66,
			'REF' => 62,
			'IF' => 64,
			"\$" => 63,
			'NOT' => 22,
			'SWITCH' => 60,
			'USE' => 57,
			"\"" => 18,
			'STOP' => 20
		},
		DEFAULT => -3,
		GOTOS => {
			'view' => 48,
			'filter' => 47,
			'atomdir' => 24,
			'macro' => 49,
			'switch' => 10,
			'condition' => 25,
			'chunks' => 69,
			'assign' => 51,
			'defblock' => 28,
			'sterm' => 70,
			'capture' => 13,
			'javascript' => 71,
			'anonblock' => 14,
			'expr' => 72,
			'loop' => 15,
			'statement' => 73,
			'item' => 16,
			'directive' => 17,
			'use' => 34,
			'node' => 74,
			'wrapper' => 19,
			'try' => 58,
			'raw' => 21,
			'setlist' => 59,
			'chunk' => 39,
			'defblockname' => 61,
			'term' => 41,
			'ident' => 23,
			'atomexpr' => 42,
			'block' => 345,
			'lterm' => 46
		}
	},
	{#State 339
		ACTIONS => {
			'JAVASCRIPT' => 53,
			'BLOCK' => 52,
			'rawperl' => 54,
			'FOR' => 55,
			'VIEW' => 56,
			"\${" => 9,
			'PROCESS' => 50,
			'CLEAR' => 11,
			'perl' => 12,
			'LAST' => 6,
			'NUMBER' => 43,
			'MACRO' => 44,
			'SET' => 45,
			"{" => 8,
			'FILTER' => 1,
			'INSERT' => 2,
			"[" => 36,
			'IDENT' => 3,
			'CALL' => 37,
			'LITERAL' => 4,
			'META' => 38,
			'WHILE' => 5,
			"(" => 40,
			'NEXT' => 29,
			'GET' => 32,
			";" => -19,
			'THROW' => 31,
			'UNLESS' => 30,
			'INCLUDE' => 33,
			'RAW' => 35,
			'TRY' => 75,
			'DEFAULT' => 67,
			'DEBUG' => 26,
			'WRAPPER' => 27,
			'REF' => 62,
			"\$" => 63,
			'IF' => 64,
			'TEXT' => 65,
			'RETURN' => 66,
			'USE' => 57,
			"\"" => 18,
			'STOP' => 20,
			'NOT' => 22,
			'SWITCH' => 60
		},
		DEFAULT => -3,
		GOTOS => {
			'ident' => 23,
			'atomexpr' => 42,
			'term' => 41,
			'lterm' => 46,
			'block' => 346,
			'try' => 58,
			'wrapper' => 19,
			'chunk' => 39,
			'defblockname' => 61,
			'raw' => 21,
			'setlist' => 59,
			'anonblock' => 14,
			'javascript' => 71,
			'capture' => 13,
			'sterm' => 70,
			'node' => 74,
			'use' => 34,
			'directive' => 17,
			'item' => 16,
			'statement' => 73,
			'loop' => 15,
			'expr' => 72,
			'condition' => 25,
			'switch' => 10,
			'atomdir' => 24,
			'macro' => 49,
			'view' => 48,
			'filter' => 47,
			'defblock' => 28,
			'assign' => 51,
			'chunks' => 69
		}
	},
	{#State 340
		DEFAULT => -56
	},
	{#State 341
		DEFAULT => -72
	},
	{#State 342
		ACTIONS => {
			'CATCH' => 287,
			'FINAL' => 285
		},
		DEFAULT => -74,
		GOTOS => {
			'final' => 347
		}
	},
	{#State 343
		ACTIONS => {
			'CATCH' => 287,
			'FINAL' => 285
		},
		DEFAULT => -74,
		GOTOS => {
			'final' => 348
		}
	},
	{#State 344
		ACTIONS => {
			'ELSIF' => 295,
			'ELSE' => 294
		},
		DEFAULT => -52,
		GOTOS => {
			'else' => 349
		}
	},
	{#State 345
		ACTIONS => {
			'CASE' => 307
		},
		DEFAULT => -57,
		GOTOS => {
			'case' => 350
		}
	},
	{#State 346
		DEFAULT => -55
	},
	{#State 347
		DEFAULT => -70
	},
	{#State 348
		DEFAULT => -71
	},
	{#State 349
		DEFAULT => -50
	},
	{#State 350
		DEFAULT => -54
	}
]; 


#========================================================================
# Rules
#========================================================================

$RULES = [
	[#Rule 0
		 '$start', 2, undef
	],
	[#Rule 1
		 'template', 1,
sub
#line 68 "Parser.yp"
{ $factory->template($_[1])           }
	],
	[#Rule 2
		 'block', 1,
sub
#line 71 "Parser.yp"
{ $factory->block($_[1])              }
	],
	[#Rule 3
		 'block', 0,
sub
#line 72 "Parser.yp"
{ $factory->block()                   }
	],
	[#Rule 4
		 'chunks', 2,
sub
#line 75 "Parser.yp"
{ push(@{$_[1]}, $_[2]) 
					if defined $_[2]; $_[1]           }
	],
	[#Rule 5
		 'chunks', 1,
sub
#line 77 "Parser.yp"
{ defined $_[1] ? [ $_[1] ] : [ ]     }
	],
	[#Rule 6
		 'chunk', 1,
sub
#line 80 "Parser.yp"
{ $factory->textblock($_[1])          }
	],
	[#Rule 7
		 'chunk', 2,
sub
#line 81 "Parser.yp"
{ return '' unless $_[1];
                           $_[0]->location() . $_[1];
                         }
	],
	[#Rule 8
		 'statement', 1, undef
	],
	[#Rule 9
		 'statement', 1, undef
	],
	[#Rule 10
		 'statement', 1, undef
	],
	[#Rule 11
		 'statement', 1, undef
	],
	[#Rule 12
		 'statement', 1, undef
	],
	[#Rule 13
		 'statement', 1, undef
	],
	[#Rule 14
		 'statement', 1, undef
	],
	[#Rule 15
		 'statement', 1, undef
	],
	[#Rule 16
		 'statement', 1, undef
	],
	[#Rule 17
		 'statement', 1,
sub
#line 95 "Parser.yp"
{ $factory->get($_[1])                }
	],
	[#Rule 18
		 'statement', 2,
sub
#line 96 "Parser.yp"
{ $_[0]->add_metadata($_[2]);         }
	],
	[#Rule 19
		 'statement', 0, undef
	],
	[#Rule 20
		 'directive', 1,
sub
#line 100 "Parser.yp"
{ $factory->set($_[1])                }
	],
	[#Rule 21
		 'directive', 1, undef
	],
	[#Rule 22
		 'directive', 1, undef
	],
	[#Rule 23
		 'directive', 1, undef
	],
	[#Rule 24
		 'directive', 1, undef
	],
	[#Rule 25
		 'directive', 1, undef
	],
	[#Rule 26
		 'directive', 1, undef
	],
	[#Rule 27
		 'directive', 1, undef
	],
	[#Rule 28
		 'atomexpr', 1,
sub
#line 115 "Parser.yp"
{ $factory->get($_[1])                }
	],
	[#Rule 29
		 'atomexpr', 1, undef
	],
	[#Rule 30
		 'atomdir', 2,
sub
#line 119 "Parser.yp"
{ $factory->get($_[2])                }
	],
	[#Rule 31
		 'atomdir', 2,
sub
#line 120 "Parser.yp"
{ $factory->call($_[2])               }
	],
	[#Rule 32
		 'atomdir', 2,
sub
#line 121 "Parser.yp"
{ $factory->set($_[2])                }
	],
	[#Rule 33
		 'atomdir', 2,
sub
#line 122 "Parser.yp"
{ $factory->default($_[2])            }
	],
	[#Rule 34
		 'atomdir', 2,
sub
#line 123 "Parser.yp"
{ $factory->insert($_[2])             }
	],
	[#Rule 35
		 'atomdir', 2,
sub
#line 124 "Parser.yp"
{ $factory->include($_[2])            }
	],
	[#Rule 36
		 'atomdir', 2,
sub
#line 125 "Parser.yp"
{ $factory->process($_[2])            }
	],
	[#Rule 37
		 'atomdir', 2,
sub
#line 126 "Parser.yp"
{ $factory->throw($_[2])              }
	],
	[#Rule 38
		 'atomdir', 1,
sub
#line 127 "Parser.yp"
{ $factory->return()                  }
	],
	[#Rule 39
		 'atomdir', 1,
sub
#line 128 "Parser.yp"
{ $factory->stop()                    }
	],
	[#Rule 40
		 'atomdir', 1,
sub
#line 129 "Parser.yp"
{ $factory->clear()                   }
	],
	[#Rule 41
		 'atomdir', 1,
sub
#line 130 "Parser.yp"
{ $factory->break()                   }
	],
	[#Rule 42
		 'atomdir', 1,
sub
#line 131 "Parser.yp"
{ $factory->next()                    }
	],
	[#Rule 43
		 'atomdir', 2,
sub
#line 132 "Parser.yp"
{ if ($_[2]->[0]->[0] =~ /^'(on|off)'$/) {
				          $_[0]->{ DEBUG_DIRS } = ($1 eq 'on');
					  $factory->debug($_[2]);
				      }
				      else {
					  $_[0]->{ DEBUG_DIRS } ? $factory->debug($_[2]) : '';
				      }
				    }
	],
	[#Rule 44
		 'atomdir', 1, undef
	],
	[#Rule 45
		 'atomdir', 1, undef
	],
	[#Rule 46
		 'condition', 6,
sub
#line 145 "Parser.yp"
{ $factory->if(@_[2, 4, 5])           }
	],
	[#Rule 47
		 'condition', 3,
sub
#line 146 "Parser.yp"
{ $factory->if(@_[3, 1])              }
	],
	[#Rule 48
		 'condition', 6,
sub
#line 148 "Parser.yp"
{ $factory->if("tt2_not($_[2])", @_[4, 5])  }
	],
	[#Rule 49
		 'condition', 3,
sub
#line 149 "Parser.yp"
{ $factory->if("tt2_not($_[3])", $_[1])     }
	],
	[#Rule 50
		 'else', 5,
sub
#line 153 "Parser.yp"
{ unshift(@{$_[5]}, [ @_[2, 4] ]);
				      $_[5];                              }
	],
	[#Rule 51
		 'else', 3,
sub
#line 155 "Parser.yp"
{ [ $_[3] ]                           }
	],
	[#Rule 52
		 'else', 0,
sub
#line 156 "Parser.yp"
{ [ undef ]                           }
	],
	[#Rule 53
		 'switch', 6,
sub
#line 160 "Parser.yp"
{ $factory->switch(@_[2, 5])          }
	],
	[#Rule 54
		 'case', 5,
sub
#line 164 "Parser.yp"
{ unshift(@{$_[5]}, [ @_[2, 4] ]); 
				      $_[5];                              }
	],
	[#Rule 55
		 'case', 4,
sub
#line 166 "Parser.yp"
{ [ $_[4] ]                           }
	],
	[#Rule 56
		 'case', 3,
sub
#line 167 "Parser.yp"
{ [ $_[3] ]                           }
	],
	[#Rule 57
		 'case', 0,
sub
#line 168 "Parser.yp"
{ [ undef ]                           }
	],
	[#Rule 58
		 '@1-3', 0,
sub
#line 171 "Parser.yp"
{ $_[0]->{ INFOR }++                  }
	],
	[#Rule 59
		 'loop', 6,
sub
#line 172 "Parser.yp"
{ $_[0]->{ INFOR }--;
				      $factory->foreach(@{$_[2]}, $_[5])  }
	],
	[#Rule 60
		 'loop', 3,
sub
#line 176 "Parser.yp"
{ $factory->foreach(@{$_[3]}, $_[1])  }
	],
	[#Rule 61
		 '@2-3', 0,
sub
#line 177 "Parser.yp"
{ $_[0]->{ INWHILE }++                }
	],
	[#Rule 62
		 'loop', 6,
sub
#line 178 "Parser.yp"
{ $_[0]->{ INWHILE }--;
                                      $factory->while(@_[2, 5])           }
	],
	[#Rule 63
		 'loop', 3,
sub
#line 180 "Parser.yp"
{ $factory->while(@_[3, 1])           }
	],
	[#Rule 64
		 'loopvar', 4,
sub
#line 183 "Parser.yp"
{ [ @_[1, 3, 4] ]                     }
	],
	[#Rule 65
		 'loopvar', 4,
sub
#line 184 "Parser.yp"
{ [ @_[1, 3, 4] ]                     }
	],
	[#Rule 66
		 'loopvar', 2,
sub
#line 185 "Parser.yp"
{ [ 0, @_[1, 2] ]                     }
	],
	[#Rule 67
		 'wrapper', 5,
sub
#line 189 "Parser.yp"
{ $factory->wrapper(@_[2, 4])         }
	],
	[#Rule 68
		 'wrapper', 3,
sub
#line 191 "Parser.yp"
{ $factory->wrapper(@_[3, 1])         }
	],
	[#Rule 69
		 'try', 5,
sub
#line 195 "Parser.yp"
{ $factory->try(@_[3, 4])             }
	],
	[#Rule 70
		 'final', 5,
sub
#line 199 "Parser.yp"
{ unshift(@{$_[5]}, [ @_[2,4] ]);
				      $_[5];                              }
	],
	[#Rule 71
		 'final', 5,
sub
#line 202 "Parser.yp"
{ unshift(@{$_[5]}, [ undef, $_[4] ]);
				      $_[5];                              }
	],
	[#Rule 72
		 'final', 4,
sub
#line 205 "Parser.yp"
{ unshift(@{$_[4]}, [ undef, $_[3] ]);
				      $_[4];                              }
	],
	[#Rule 73
		 'final', 3,
sub
#line 207 "Parser.yp"
{ [ $_[3] ]                           }
	],
	[#Rule 74
		 'final', 0,
sub
#line 208 "Parser.yp"
{ [ 0 ] }
	],
	[#Rule 75
		 'use', 2,
sub
#line 211 "Parser.yp"
{ $factory->use($_[2])                }
	],
	[#Rule 76
		 'raw', 2,
sub
#line 214 "Parser.yp"
{ $factory->raw($_[2])                }
	],
	[#Rule 77
		 '@3-3', 0,
sub
#line 217 "Parser.yp"
{ $_[0]->push_defblock();		  }
	],
	[#Rule 78
		 'view', 6,
sub
#line 218 "Parser.yp"
{ $factory->view(@_[2,5], 
						     $_[0]->pop_defblock) }
	],
	[#Rule 79
		 '@4-2', 0,
sub
#line 222 "Parser.yp"
{ ${$_[0]->{ INJAVASCRIPT }}++;             }
	],
	[#Rule 80
		 'javascript', 5,
sub
#line 223 "Parser.yp"
{ ${$_[0]->{ INJAVASCRIPT }}--;
				      $_[0]->{ EVAL_JAVASCRIPT } 
				      ? $factory->javascript($_[4])             
				      : $factory->no_javascript();              }
	],
	[#Rule 81
		 'filter', 5,
sub
#line 230 "Parser.yp"
{ $factory->filter(@_[2,4])           }
	],
	[#Rule 82
		 'filter', 3,
sub
#line 232 "Parser.yp"
{ $factory->filter(@_[3,1])           }
	],
	[#Rule 83
		 'defblock', 5,
sub
#line 237 "Parser.yp"
{ my $name = join('/', @{ $_[0]->{ DEFBLOCKS } });
				      pop(@{ $_[0]->{ DEFBLOCKS } });
				      $_[0]->define_block($name, $_[4]); 
				      undef
				    }
	],
	[#Rule 84
		 'defblockname', 2,
sub
#line 244 "Parser.yp"
{ push(@{ $_[0]->{ DEFBLOCKS } }, $_[2]);
				      $_[2];
				    }
	],
	[#Rule 85
		 'blockname', 1, undef
	],
	[#Rule 86
		 'blockname', 1,
sub
#line 250 "Parser.yp"
{ $_[1] =~ s/^'(.*)'$/$1/; $_[1]      }
	],
	[#Rule 87
		 'blockargs', 1, undef
	],
	[#Rule 88
		 'blockargs', 0, undef
	],
	[#Rule 89
		 'anonblock', 5,
sub
#line 258 "Parser.yp"
{ local $" = ', ';
				      print STDERR "experimental block args: [@{ $_[2] }]\n"
					  if $_[2];
				      $factory->anon_block($_[4])         }
	],
	[#Rule 90
		 'capture', 3,
sub
#line 264 "Parser.yp"
{ $factory->capture(@_[1, 3])         }
	],
	[#Rule 91
		 'macro', 6,
sub
#line 268 "Parser.yp"
{ $factory->macro(@_[2, 6, 4])        }
	],
	[#Rule 92
		 'macro', 3,
sub
#line 269 "Parser.yp"
{ $factory->macro(@_[2, 3])           }
	],
	[#Rule 93
		 'mdir', 1, undef
	],
	[#Rule 94
		 'mdir', 4,
sub
#line 273 "Parser.yp"
{ $_[3]                               }
	],
	[#Rule 95
		 'margs', 2,
sub
#line 276 "Parser.yp"
{ push(@{$_[1]}, $_[2]); $_[1]        }
	],
	[#Rule 96
		 'margs', 2,
sub
#line 277 "Parser.yp"
{ $_[1]                               }
	],
	[#Rule 97
		 'margs', 1,
sub
#line 278 "Parser.yp"
{ [ $_[1] ]                           }
	],
	[#Rule 98
		 'metadata', 2,
sub
#line 281 "Parser.yp"
{ push(@{$_[1]}, @{$_[2]}); $_[1]     }
	],
	[#Rule 99
		 'metadata', 2, undef
	],
	[#Rule 100
		 'metadata', 1, undef
	],
	[#Rule 101
		 'meta', 3,
sub
#line 286 "Parser.yp"
{ for ($_[3]) { s/^'//; s/'$//; 
						       s/\\'/'/g  }; 
					 [ @_[1,3] ] }
	],
	[#Rule 102
		 'meta', 5,
sub
#line 289 "Parser.yp"
{ [ @_[1,4] ] }
	],
	[#Rule 103
		 'meta', 3,
sub
#line 290 "Parser.yp"
{ [ @_[1,3] ] }
	],
	[#Rule 104
		 'term', 1, undef
	],
	[#Rule 105
		 'term', 1, undef
	],
	[#Rule 106
		 'lterm', 3,
sub
#line 302 "Parser.yp"
{ "{ $_[2] }"                         }
	],
	[#Rule 107
		 'lterm', 3,
sub
#line 303 "Parser.yp"
{ "{ $_[2] }"                         }
	],
	[#Rule 108
		 'lterm', 2,
sub
#line 304 "Parser.yp"
{ "{ }"                               }
	],
	[#Rule 109
		 'lterm', 3,
sub
#line 305 "Parser.yp"
{ "{ $_[2]  }"                        }
	],
	[#Rule 110
		 'sterm', 1,
sub
#line 308 "Parser.yp"
{ $factory->ident($_[1])              }
	],
	[#Rule 111
		 'sterm', 2,
sub
#line 309 "Parser.yp"
{ $factory->identref($_[2])           }
	],
	[#Rule 112
		 'sterm', 3,
sub
#line 310 "Parser.yp"
{ $factory->quoted($_[2])             }
	],
	[#Rule 113
		 'sterm', 1, undef
	],
	[#Rule 114
		 'sterm', 1, undef
	],
	[#Rule 115
		 'list', 2,
sub
#line 315 "Parser.yp"
{ "$_[1], $_[2]"                      }
	],
	[#Rule 116
		 'list', 2, undef
	],
	[#Rule 117
		 'list', 1, undef
	],
	[#Rule 118
		 'range', 3,
sub
#line 320 "Parser.yp"
{ $_[1] . '..' . $_[3]                }
	],
	[#Rule 119
		 'hash', 1, undef
	],
	[#Rule 120
		 'hash', 0,
sub
#line 325 "Parser.yp"
{ "" }
	],
	[#Rule 121
		 'params', 2,
sub
#line 328 "Parser.yp"
{ "$_[1], $_[2]"                      }
	],
	[#Rule 122
		 'params', 2, undef
	],
	[#Rule 123
		 'params', 1, undef
	],
	[#Rule 124
		 'param', 3,
sub
#line 333 "Parser.yp"
{ "[$_[1]] = $_[3]"                    }
	],
	[#Rule 125
		 'param', 3,
sub
#line 334 "Parser.yp"
{ "[$_[1]] = $_[3]"                    }
	],
	[#Rule 126
		 'ident', 3,
sub
#line 337 "Parser.yp"
{ push(@{$_[1]}, @{$_[3]}); $_[1]     }
	],
	[#Rule 127
		 'ident', 3,
sub
#line 338 "Parser.yp"
{ push(@{$_[1]}, 
					   map {($_, 0)} split(/\./, $_[3]));
				      $_[1];			          }
	],
	[#Rule 128
		 'ident', 1, undef
	],
	[#Rule 129
		 'node', 1,
sub
#line 344 "Parser.yp"
{ [ $_[1], 0 ]                        }
	],
	[#Rule 130
		 'node', 4,
sub
#line 345 "Parser.yp"
{ [ $_[1], $factory->args($_[3]) ]    }
	],
	[#Rule 131
		 'item', 1,
sub
#line 348 "Parser.yp"
{ "'$_[1]'"                           }
	],
	[#Rule 132
		 'item', 3,
sub
#line 349 "Parser.yp"
{ $_[2]                               }
	],
	[#Rule 133
		 'item', 2,
sub
#line 350 "Parser.yp"
{ $_[0]->{ V1DOLLAR }
				       ? "'$_[2]'" 
				       : $factory->ident(["'$_[2]'", 0])  }
	],
	[#Rule 134
		 'expr', 3,
sub
#line 355 "Parser.yp"
{ "$_[1] $_[2] $_[3]"                 }
	],
	[#Rule 135
		 'expr', 3,
sub
#line 356 "Parser.yp"
{ "$_[1] $_[2] $_[3]"                 }
	],
	[#Rule 136
		 'expr', 3,
sub
#line 357 "Parser.yp"
{ "$_[1] $_[2] $_[3]"                 }
	],
	[#Rule 137
		 'expr', 3,
sub
#line 358 "Parser.yp"
{ "math_floor($_[1] / $_[3])"         }
	],
	[#Rule 138
		 'expr', 3,
sub
#line 359 "Parser.yp"
{ "$_[1] % $_[3]"                     }
	],
	[#Rule 139
		 'expr', 3,
sub
#line 360 "Parser.yp"
{ "$_[1] $CMPOP{ $_[2] } $_[3]"       }
	],
	[#Rule 140
		 'expr', 3,
sub
#line 361 "Parser.yp"
{ "$_[1] .. $_[3]"                    }
	],
	[#Rule 141
		 'expr', 3,
sub
#line 362 "Parser.yp"
{ "tt2_true($_[1]) and tt2_true($_[3])"                   }
	],
	[#Rule 142
		 'expr', 3,
sub
#line 363 "Parser.yp"
{ "tt2_true($_[1]) or tt2_true($_[3])"                    }
	],
	[#Rule 143
		 'expr', 2,
sub
#line 364 "Parser.yp"
{ "tt2_not($_[2])"                         }
	],
	[#Rule 144
		 'expr', 5,
sub
#line 365 "Parser.yp"
{ "tt2_true($_[1]) and $_[3] or $_[5]"          }
	],
	[#Rule 145
		 'expr', 3,
sub
#line 366 "Parser.yp"
{ $factory->assign(@{$_[2]})          }
	],
	[#Rule 146
		 'expr', 3,
sub
#line 367 "Parser.yp"
{ "($_[2])"                           }
	],
	[#Rule 147
		 'expr', 1, undef
	],
	[#Rule 148
		 'setlist', 2,
sub
#line 371 "Parser.yp"
{ push(@{$_[1]}, @{$_[2]}); $_[1]     }
	],
	[#Rule 149
		 'setlist', 2, undef
	],
	[#Rule 150
		 'setlist', 1, undef
	],
	[#Rule 151
		 'assign', 3,
sub
#line 377 "Parser.yp"
{ [ $_[1], $_[3] ]                    }
	],
	[#Rule 152
		 'assign', 3,
sub
#line 378 "Parser.yp"
{ [ @_[1,3] ]                         }
	],
	[#Rule 153
		 'args', 2,
sub
#line 385 "Parser.yp"
{ push(@{$_[1]}, $_[2]); $_[1]        }
	],
	[#Rule 154
		 'args', 2,
sub
#line 386 "Parser.yp"
{ push(@{$_[1]->[0]}, $_[2]); $_[1]   }
	],
	[#Rule 155
		 'args', 4,
sub
#line 387 "Parser.yp"
{ push(@{$_[1]->[0]}, "'', " . 
				      $factory->assign(@_[2,4])); $_[1]  }
	],
	[#Rule 156
		 'args', 2,
sub
#line 389 "Parser.yp"
{ $_[1]                               }
	],
	[#Rule 157
		 'args', 0,
sub
#line 390 "Parser.yp"
{ [ [ ] ]                             }
	],
	[#Rule 158
		 'lnameargs', 3,
sub
#line 400 "Parser.yp"
{ push(@{$_[3]}, $_[1]); $_[3]        }
	],
	[#Rule 159
		 'lnameargs', 1, undef
	],
	[#Rule 160
		 'lvalue', 1, undef
	],
	[#Rule 161
		 'lvalue', 3,
sub
#line 405 "Parser.yp"
{ $factory->quoted($_[2])             }
	],
	[#Rule 162
		 'lvalue', 1, undef
	],
	[#Rule 163
		 'nameargs', 3,
sub
#line 409 "Parser.yp"
{ [ [$factory->ident($_[2])], $_[3] ]   }
	],
	[#Rule 164
		 'nameargs', 2,
sub
#line 410 "Parser.yp"
{ [ @_[1,2] ] }
	],
	[#Rule 165
		 'nameargs', 4,
sub
#line 411 "Parser.yp"
{ [ @_[1,3] ] }
	],
	[#Rule 166
		 'names', 3,
sub
#line 414 "Parser.yp"
{ push(@{$_[1]}, $_[3]); $_[1] }
	],
	[#Rule 167
		 'names', 1,
sub
#line 415 "Parser.yp"
{ [ $_[1] ]                    }
	],
	[#Rule 168
		 'name', 3,
sub
#line 418 "Parser.yp"
{ $factory->quoted($_[2])  }
	],
	[#Rule 169
		 'name', 1,
sub
#line 419 "Parser.yp"
{ "'$_[1]'" }
	],
	[#Rule 170
		 'name', 1, undef
	],
	[#Rule 171
		 'filename', 3,
sub
#line 431 "Parser.yp"
{ "$_[1].$_[3]" }
	],
	[#Rule 172
		 'filename', 1, undef
	],
	[#Rule 173
		 'filepart', 1, undef
	],
	[#Rule 174
		 'filepart', 1, undef
	],
	[#Rule 175
		 'filepart', 1, undef
	],
	[#Rule 176
		 'quoted', 2,
sub
#line 445 "Parser.yp"
{ push(@{$_[1]}, $_[2]) 
				          if defined $_[2]; $_[1]         }
	],
	[#Rule 177
		 'quoted', 0,
sub
#line 447 "Parser.yp"
{ [ ]                                 }
	],
	[#Rule 178
		 'quotable', 1,
sub
#line 450 "Parser.yp"
{ $factory->ident($_[1])              }
	],
	[#Rule 179
		 'quotable', 1,
sub
#line 451 "Parser.yp"
{ $factory->text($_[1])               }
	],
	[#Rule 180
		 'quotable', 1,
sub
#line 452 "Parser.yp"
{ undef                               }
	]
];

1;
