# Generated by default/object.tt
package Paws::Kendra::ScoreAttributes;
  use Moose;
  has ScoreConfidence => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Kendra::ScoreAttributes

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Kendra::ScoreAttributes object:

  $service_obj->Method(Att1 => { ScoreConfidence => $value, ..., ScoreConfidence => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Kendra::ScoreAttributes object:

  $result = $service_obj->Method(...);
  $result->Att1->ScoreConfidence

=head1 DESCRIPTION

Provides a relative ranking that indicates how confident Amazon Kendra
is that the response matches the query.

=head1 ATTRIBUTES


=head2 ScoreConfidence => Str

A relative ranking for how well the response matches the query.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Kendra>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

