# Generated by default/object.tt
package Paws::SageMaker::ContextSummary;
  use Moose;
  has ContextArn => (is => 'ro', isa => 'Str');
  has ContextName => (is => 'ro', isa => 'Str');
  has ContextType => (is => 'ro', isa => 'Str');
  has CreationTime => (is => 'ro', isa => 'Str');
  has LastModifiedTime => (is => 'ro', isa => 'Str');
  has Source => (is => 'ro', isa => 'Paws::SageMaker::ContextSource');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::ContextSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::ContextSummary object:

  $service_obj->Method(Att1 => { ContextArn => $value, ..., Source => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::ContextSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->ContextArn

=head1 DESCRIPTION

Lists a summary of the properties of a context. A context provides a
logical grouping of other entities.

=head1 ATTRIBUTES


=head2 ContextArn => Str

The Amazon Resource Name (ARN) of the context.


=head2 ContextName => Str

The name of the context.


=head2 ContextType => Str

The type of the context.


=head2 CreationTime => Str

When the context was created.


=head2 LastModifiedTime => Str

When the context was last modified.


=head2 Source => L<Paws::SageMaker::ContextSource>

The source of the context.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

