/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.parameter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.parameter.DefaultParameterValueGroup;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.parameter.UnmodifiableParameterValue;
import org.apache.sis.parameter.Verifier;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.LenientComparable;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;

final class UnmodifiableParameterValueGroup
extends Parameters
implements LenientComparable,
Serializable {
    private static final long serialVersionUID = -7980778116268449513L;
    private final ParameterDescriptorGroup descriptor;
    private final List<GeneralParameterValue> values;

    private UnmodifiableParameterValueGroup(ParameterValueGroup parameterValueGroup, Map<ParameterValueGroup, Boolean> map) {
        if (map.put(parameterValueGroup, Boolean.TRUE) != null) {
            throw new IllegalArgumentException(Errors.format((short)18));
        }
        this.descriptor = parameterValueGroup.getDescriptor();
        List<GeneralParameterValue> list = parameterValueGroup.values();
        GeneralParameterValue[] generalParameterValueArray = new GeneralParameterValue[list.size()];
        for (int i = 0; i < generalParameterValueArray.length; ++i) {
            Cloneable cloneable = list.get(i);
            ArgumentChecks.ensureNonNullElement("values", i, cloneable);
            if (cloneable instanceof ParameterValue) {
                cloneable = UnmodifiableParameterValue.create(cloneable);
            } else if (cloneable instanceof ParameterValueGroup) {
                cloneable = new UnmodifiableParameterValueGroup((ParameterValueGroup)((Object)cloneable), map);
            }
            generalParameterValueArray[i] = cloneable;
        }
        this.values = UnmodifiableArrayList.wrap(generalParameterValueArray);
    }

    static UnmodifiableParameterValueGroup create(ParameterValueGroup parameterValueGroup) {
        if (parameterValueGroup == null || parameterValueGroup instanceof UnmodifiableParameterValueGroup) {
            return (UnmodifiableParameterValueGroup)parameterValueGroup;
        }
        return new UnmodifiableParameterValueGroup(parameterValueGroup, new IdentityHashMap<ParameterValueGroup, Boolean>(4));
    }

    @Override
    public ParameterDescriptorGroup getDescriptor() {
        return this.descriptor;
    }

    @Override
    public List<GeneralParameterValue> values() {
        return this.values;
    }

    @Override
    boolean isKnownImplementation() {
        return true;
    }

    @Override
    public ParameterValue<?> parameter(String string) throws ParameterNotFoundException {
        ArgumentChecks.ensureNonNull("name", string);
        ParameterValue<?> parameterValue = this.parameterIfExist(string);
        if (parameterValue != null) {
            return parameterValue;
        }
        throw new ParameterNotFoundException(Resources.format((short)61, Verifier.getDisplayName(this.descriptor), string), string);
    }

    @Override
    public List<ParameterValueGroup> groups(String string) throws ParameterNotFoundException {
        ArgumentChecks.ensureNonNull("name", string);
        ArrayList<ParameterValueGroup> arrayList = new ArrayList<ParameterValueGroup>(4);
        for (GeneralParameterValue generalParameterValue : this.values) {
            if (!(generalParameterValue instanceof ParameterValueGroup) || !IdentifiedObjects.isHeuristicMatchForName(generalParameterValue.getDescriptor(), string)) continue;
            arrayList.add((ParameterValueGroup)generalParameterValue);
        }
        if (arrayList.isEmpty() && !(this.descriptor.descriptor(string) instanceof ParameterDescriptorGroup)) {
            throw new ParameterNotFoundException(Resources.format((short)61, Verifier.getDisplayName(this.descriptor), string), string);
        }
        return arrayList;
    }

    @Override
    public ParameterValueGroup addGroup(String string) throws IllegalStateException {
        throw new UnsupportedOperationException(Errors.format((short)153, ParameterValueGroup.class));
    }

    @Override
    public Parameters clone() {
        DefaultParameterValueGroup defaultParameterValueGroup = new DefaultParameterValueGroup(this.descriptor);
        Parameters.copy(this, defaultParameterValueGroup);
        return defaultParameterValueGroup;
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (object != null) {
            if (comparisonMode == ComparisonMode.STRICT) {
                if (this.getClass() == object.getClass()) {
                    UnmodifiableParameterValueGroup unmodifiableParameterValueGroup = (UnmodifiableParameterValueGroup)object;
                    return Objects.equals(this.descriptor, unmodifiableParameterValueGroup.descriptor) && Objects.equals(this.values, unmodifiableParameterValueGroup.values);
                }
            } else if (object instanceof ParameterValueGroup) {
                return DefaultParameterValueGroup.equals(this, (ParameterValueGroup)object, comparisonMode);
            }
        }
        return false;
    }

    @Override
    public final boolean equals(Object object) {
        return this.equals(object, ComparisonMode.STRICT);
    }

    public int hashCode() {
        return this.descriptor.hashCode() ^ this.values.hashCode();
    }
}

