# Generated by default/object.tt
package Paws::Shield::AttackStatisticsDataItem;
  use Moose;
  has AttackCount => (is => 'ro', isa => 'Int', required => 1);
  has AttackVolume => (is => 'ro', isa => 'Paws::Shield::AttackVolume');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Shield::AttackStatisticsDataItem

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Shield::AttackStatisticsDataItem object:

  $service_obj->Method(Att1 => { AttackCount => $value, ..., AttackVolume => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Shield::AttackStatisticsDataItem object:

  $result = $service_obj->Method(...);
  $result->Att1->AttackCount

=head1 DESCRIPTION

A single attack statistics data record. This is returned by
DescribeAttackStatistics along with a time range indicating the time
period that the attack statistics apply to.

=head1 ATTRIBUTES


=head2 B<REQUIRED> AttackCount => Int

The number of attacks detected during the time period. This is always
present, but might be zero.


=head2 AttackVolume => L<Paws::Shield::AttackVolume>

Information about the volume of attacks during the time period. If the
accompanying C<AttackCount> is zero, this setting might be empty.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Shield>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

