# -*- cperl -*-
# ABSTRACT: LaTeX logarithm object


package SpeL::Object::Log;

use parent 'Exporter';
use Carp;

use SpeL::I18n;

use Data::Dumper;



sub read {
  my $self = shift;
  my ( $level ) = @_;

  # say STDERR Data::Dumper->Dump( [ $self ], [ 'self' ] );
  if( $self->{Op} eq 'log' ) {
      if( exists $self->{base} ) {
	  return $SpeL::I18n::lh->maketext( 'logn', $self->{base}->read( $level + 1 ) );
      }
      else {
	  return $SpeL::I18n::lh->maketext( 'log' );
      }
  }
  elsif( $self->{Op} eq 'ln' ) {
      return $SpeL::I18n::lh->maketext( 'ln' );
  }
  else {
      die( "Internal error in Log.pm");
  }
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

SpeL::Object::Log - LaTeX logarithm object

=head1 VERSION

version 20241023.0918

=head1 METHODS

=head2 new()

We keep the default method, as the object is generated by the parser.

=head2 read( level )

returns a string with the spoken version of the node

=over 4

=item level: parsing level

=back

=head1 SYNOPSYS

Represents a LaTeX logarithm

=head1 AUTHOR

Walter Daems <wdaems@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2024 by Walter Daems.

This is free software, licensed under:

  The GNU General Public License, Version 3, June 2007

=head1 CONTRIBUTOR

=for stopwords Paul Levrie

Paul Levrie

=cut
