package Net::Async::Spotify::Object::Generated::Track;

use strict;
use warnings;

our $VERSION = '0.001'; # VERSION
our $AUTHORITY = 'cpan:VNEALV'; # AUTHORITY

use mro;
use parent qw(Net::Async::Spotify::Object::Base);

=encoding utf8

=head1 NAME

Net::Async::Spotify::Object::Generated::Track - Package representing Spotify Track Object

=head1 DESCRIPTION

Autogenerated module.
Based on https://developer.spotify.com/documentation/web-api/reference/#objects-index
Check C<crawl-api-doc.pl> for more information.

=head1 PARAMETERS

Those are Spotify Track Object attributes:

=over 4

=item album

Type:SimplifiedAlbumObject
Description:The album on which the track appears. The album object includes a link in href to full information about the album.

=item artists

Type:Array[ArtistObject]
Description:The artists who performed the track. Each artist object includes a link in href to more detailed information about the artist.

=item available_markets

Type:Array[String]
Description:A list of the countries in which the track can be played, identified by their ISO 3166-1 alpha-2 code.

=item disc_number

Type:Integer
Description:The disc number (usually 1 unless the album consists of more than one disc).

=item duration_ms

Type:Integer
Description:The track length in milliseconds.

=item explicit

Type:Boolean
Description:Whether or not the track has explicit lyrics ( true = yes it does; false = no it does not OR unknown).

=item external_ids

Type:ExternalIdObject
Description:Known external IDs for the track.

=item external_urls

Type:ExternalUrlObject
Description:Known external URLs for this track.

=item href

Type:String
Description:A link to the Web API endpoint providing full details of the track.

=item id

Type:String
Description:The Spotify ID for the track.

=item is_local

Type:Boolean
Description:Whether or not the track is from a local file.

=item is_playable

Type:Boolean
Description:Part of the response when Track Relinking is applied. If true , the track is playable in the given market. Otherwise false.

=item linked_from

Type:
Description:Part of the response when Track Relinking is applied, and the requested track has been replaced with different track. The track in the linked_from object contains information about the originally requested track.

=item name

Type:String
Description:The name of the track.

=item popularity

Type:Integer
Description:The popularity of the track. The value will be between 0 and 100, with 100 being the most popular.The popularity of a track is a value between 0 and 100, with 100 being the most popular. The popularity is calculated by algorithm and is based, in the most part, on the total number of plays the track has had and how recent those plays are.Generally speaking, songs that are being played a lot now will have a higher popularity than songs that were played a lot in the past. Duplicate tracks (e.g. the same track from a single and an album) are rated independently. Artist and album popularity is derived mathematically from track popularity. Note that the popularity value may lag actual popularity by a few days: the value is not updated in real time.

=item preview_url

Type:String
Description:A link to a 30 second preview (MP3 format) of the track. Can be null

=item restrictions

Type:TrackRestrictionObject
Description:Included in the response when a content restriction is applied.
See Restriction Object for more details.

=item track_number

Type:Integer
Description:The number of the track. If an album has several discs, the track number is the number on the specified disc.

=item type

Type:String
Description:The object type: “track”.

=item uri

Type:String
Description:The Spotify URI for the track.

=back

=cut

sub new {
    my ($class, %args) = @_;

    my $fields = {
        album => 'SimplifiedAlbumObject',
        artists => 'Array[ArtistObject]',
        available_markets => 'Array[String]',
        disc_number => 'Integer',
        duration_ms => 'Integer',
        explicit => 'Boolean',
        external_ids => 'ExternalIdObject',
        external_urls => 'ExternalUrlObject',
        href => 'String',
        id => 'String',
        is_local => 'Boolean',
        is_playable => 'Boolean',
        linked_from => '',
        name => 'String',
        popularity => 'Integer',
        preview_url => 'String',
        restrictions => 'TrackRestrictionObject',
        track_number => 'Integer',
        type => 'String',
        uri => 'String',
    };

    my $obj = next::method($class, $fields, %args);

    return $obj;
}

1;
