use strict;
use warnings;
use ExtUtils::MakeMaker;

WriteMakefile(
	NAME          => 'SQL::Tokenizer',
	AUTHOR        => 'Igor Sutton Lopes <igor.sutton@gmail.com>',
	VERSION_FROM  => 'lib/SQL/Tokenizer.pm',
	ABSTRACT_FROM => 'lib/SQL/Tokenizer.pm',
	PL_FILES      => {},
	PREREQ_PM     => {
		'Test::More' => '0',
	},
	dist          => { COMPRESS => 'gzip -9f', SUFFIX => 'gz', },
	clean         => { FILES => 'SQL-Tokenizer-*' },
	META_MERGE => {
        'meta-spec' => { version => 2 },  # CPAN Meta Spec v2 :contentReference[oaicite:1]{index=1}
        resources => {
            license    => [ 'https://dev.perl.org/licenses/' ],
            repository => {
                type => 'git',
                url  => 'https://github.com/isutton/SQL-Tokenizer.git',
                web  => 'https://github.com/isutton/SQL-Tokenizer',
            },
            bugtracker => {
                web => 'https://github.com/isutton/SQL-Tokenizer',
            },
        },
    },
);
