#!perl -T
use 5.006;
use strict;
use warnings;
use Data::Dumper;
use Test::More tests => 8;

my $arr_ref = [];
my $hash_ref = {
        A => 'one',
        B => [ 'one', 'two' ],
        C => { 
            'one' => 1, 
            'two' => 2, 
            $arr_ref => 3
        },
};

ok( exists( $hash_ref->{'A'} ), q(Key 'A' is exists) );
ok( exists( $hash_ref->{'B'} ), q(Key 'B' is exists) );
ok( ref $hash_ref->{'B'} ne 'HASH', q(Value of key 'B' isn't 'HASH') );
ok( exists( $hash_ref->{'C'}{'one'} ), q(Key 'C'->'one' is exists) );
ok( exists( $hash_ref->{'C'}{$arr_ref} ), q(Key 'C'->$arr_ref is exists) );
ok( ! exists( $hash_ref->{'C'}{'three'} ), q(Key 'C'->'three' isn't exists) );
ok( ! exists( $hash_ref->{'C'}{'three'}{'PI'}{'0'} ), q(Key 'C'->'three'->'PI'->'0' isn't exists) );
like( Dumper( $hash_ref ), qr(PI), q(Subroutine create new keys) );


