# morph-ga.txt: Morphology rules for Irish.
# Copyright (C) 2004 Kevin P. Scannell <scannell@slu.edu>
#
# This is free software; see the file COPYING for copying conditions.  There
# is NO warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE.
#
#  with the exception of some of the non-standard verb endings,
#  each rule decreases number of caps or length => recursion will stop.
#
#  each substitution is applied globally (though this is only relevant
#  for the few rules that aren't anchored at ^ or $
#
#  There is no need to encode the regular inflectional morphology of 
#  Irish here because it is already handled by the C++ code that generates
#  the basic lexicon.   So if "imirceacha" is not in the lexicon (it is)
#  "imirceach" won't be either.   On the other hand it can be quite useful
#  to include *derivational* morphology; so if "gaimbneachas" is not
#  in the lexicon (it is) there is some hope that by stripping the 
#  "eachas" it will find the root "gaimbn".
^BP			bP		1	<.+>
^BHF			bhF		1	<.+>
^DT			dT		1	<.+>
^GC			gC		1	<.+>
^MB			mB		1	<.+>
^ND			nD		1	<.+>
^NG			nG		1	<.+>
^TS			tS		1	<.+>
^([A-Z])([A-Z'-]*[A-Z][A-Z'-]*)$	$1\L$2		-1	 <.+>	# GAELTACHT but not "D'" (after recursion)
^([A-Z])		\l$1		-1	<.+> 	# Promhach
(...)-([A-Z])	$1-\l$2		-1	<.+> 	# Promh-Aire
^b'([AEIOUF])	b'\l$1		-1	<.+>
^bP([A-Z'-]+)$	bp\L$1		-1	<.+>	# bPROMH-AIRE
^bP			bp		-1	<.+>	# bPromhach
^bhF([A-Z'-]+)$	bhf\L$1		-1	<.+>
^bhF			bhf		-1	<.+>
^d'([AEIOUF])	d'\l$1		-1	<.+>
^dT([A-Z'-]+)$	dt\L$1		-1	<.+>
^dT			dt		-1	<.+>
^gC([A-Z'-]+)$	gc\L$1		-1	<.+>
^gC			gc		-1	<.+>
^h([AEIOU])([A-Z'-]+)$	h$1\L$2	-1	<.+>	# hIREANN
^h([AEIOU])	h\l$1		-1	<.+>
^m'([AEIOUF])	m'\l$1		-1	<.+>
^mB([A-Z'-]+)$	mb\L$1		-1	<.+>
^mB			mb		-1	<.+>
^n([AEIOU])([A-Z'-]+)$	n$1\L$2	-1	<.+>
^n([AEIOU])	n-\l$1		-1	<.+>
^nD([A-Z'-]+)$	nd\L$1		-1	<.+>
^nD			nd		-1	<.+>
^nG([A-Z'-]+)$	ng\L$1		-1	<.+>
^nG			ng		-1	<.+>
^tS([A-Z'-]+)$	ts\L$1		-1	<.+>
^tS			ts		-1	<.+>
^t([AEIOU])([A-Z'-]+)$	t$1\L$2	-1	<N.*>	# tUASAL
^t([AEIOU])	t-\l$1		-1	<N.*>
# these aren't in aspell db by default; better to do early (mb'amhlaidh)
^mb'			b'		-1	<.+>
# hyphened prefixes, an-, dea-
^h?an-([bcfgmp]h)	$1		0	<[AN].*>
^h?an-([bcfgmp][^h])	$1		2	<[AN].*>
^h?an-([^bcfgmp][^h])	$1		0	<[AN].*>
^h?an-([^bcfgmp]h)	$1		2	<[AN].*>   # an-dhuine 
^dea-([bcdfgmpt]h)	$1		0	<[AN].*>
^dea-([bcdfgmpt][^h])	$1		2	<[AN].*>
^dea-(sh[aeioulnr])	$1	0	<[AN].*>
^dea-(s[aeioulnr])	$1		2	<[AN].*>
^dea-(s[^aeioulnrh])	$1	0	<[AN].*>   # dea-scal
^dea-([^bcdfgmpst])	$1		0	<[AN].*>
# other prefixes; most are not independent words (ath, comh, etc.)
# but several are -- these are worth including for several reasons:
# (1) efficiency; morph. analysis happens well before the check for
#  compounds/run-togethers (2) allows for a more refined check for
#  lenition of the prefixed word or other changes (comh-mh, comh->c, etc.)
^h?ain([deilnrst])	$1		0	<[AN].*>
^h?ain([bcfgmp]h)	$1		0	<[AN].*>
^h?ath([^bcdfgmpst-])	$1		0	<[ANV].*>
^h?ath([bcdfgmp]h)	$1		0	<[ANV].*>
^h?ath(sh[aeioulnr])	$1		0	<[ANV].*>
^h?ath(s[^aeioulnrh])	$1	0	<[ANV].*>
^h?ath-?th		at		1	<[ANV].*>
^h?ath-?th		th		1	<[ANV].*>
^comh([^bcdfgmnpst-])	$1		0	<[ANV].*>
^comh([bcdfgpt]h)	$1		0	<[ANV].*>
^comh(sh[aeioulnr])	$1	0	<[ANV].*>
^comh(s[^aeioulnrh])	$1	0	<[ANV].*>
^c(mh[aou])		$1		0	<[ANV].*>
^ci(mh[ei])		$1		0	<[ANV].*>
^c(n[aou])		$1		0	<[ANV].*>
^ci(n[ei])		$1		0	<[ANV].*>
^coimh-mh		cimh		1	<[ANV].*>
^comh-mh		mh		1	<[ANV].*>
^co(i?)mh-?n		c$1n		1	<[ANV].*>
^c-(..)		comh$1		1	<[ANV].*>
^c([bcdfgpt]h)		comh$1		1	<[ANV].*>
^do-([aeiou])	$1		0	<[AN].*>
# ^do([lnr]) BELOW
^do([bcdfgmpt]h)	$1		0	<[AN].*>
^do(sh[aeioulnr])	$1		0	<[AN].*>
^do(s[^aeioulnrh])	$1		0	<[AN].*>
^do-([aeiou])	$1		0	<[ANV].*>
^droch([^bcdfgmpst-])	$1		0	<[AN].*>
^droch-(ch)		$1		0	<[AN].*>
^droch([bdfgmpt]h)	$1		0	<[AN].*>
^droch(sh[aeioulnr])	$1		0	<[AN].*>
^droch(s[^aeioulnrh])	$1		0	<[AN].*>
^for([^bcdfgmprst-])	$1		0	<[ANV].*>
^for-(r)		$1		0	<[ANV].*>
^for([bcdfgmpt]h)	$1		0	<[ANV].*>
^for(sh[aeioulnr])	$1		0	<[ANV].*>
^for(s[^aeioulnrh])	$1		0	<[ANV].*>
^for([^bcdfgmprst-])	$1		0	<[ANV].*>
^for-(r)		$1		0	<[ANV].*>
^for([bcdfgmpt]h)	$1		0	<[ANV].*>
^for(sh[aeioulnr])	$1		0	<[ANV].*>
^for(s[^aeioulnrh])	$1		0	<[ANV].*>
^fo-([aeiou])	$1		0	<[ANV].*>
# ^fo([lnr]) BELOW
^fo([bcdfgmpt]h)	$1		0	<[ANV].*>
^fo(sh[aeioulnr])	$1		0	<[ANV].*>
^fo(s[^aeioulnrh])	$1		0	<[ANV].*>
^fo-(..)		$1		1	<[ANV].*>
^frith([^bcdfgmpst-])	$1		0	<[ANV].*>
^fri(t[^h])		$1		0	<[ANV].*>
^frith([bcdfgmp]h)	$1		0	<[ANV].*>
^frith(sh[aeioulnr])	$1		0	<[ANV].*>
^frith(s[^aeioulnrh])	$1		0	<[ANV].*>
^h?iar([^bcdfgmprst-])	$1		0	<[ANV].*>
^h?iar-(r)		$1		0	<[ANV].*>
^h?iar([bcdfgmpt]h)	$1		0	<[ANV].*>
^h?iar(sh[aeioulnr])	$1		0	<[ANV].*>
^h?iar(s[^aeioulnrh])	$1		0	<[ANV].*>
# ilsiamsa, ilsiollach, etc.  no special case
^h?il([^bcfgmp-]..)	$1		0	<[AN].*>
^h?il([bcfgmp]h.)	$1		0	<[AN].*>
^h?im([^bcdfghmpst-]..)	$1		0	<[ANV].*>
^h?im([bcdfgmpt]h.)	$1		0	<[ANV].*>
^h?im(sh[aeioulnr])	$1		0	<[ANV].*>
^h?im(s[^aeioulnrh].)	$1		0	<[ANV].*>
# ^in([^bcfgmp-]) BELOW
^h?in-(n)		$1		0	<[AN].*>
^h?in([bcfgmp]h..)	$1		0	<[AN].*>
^leas-(s)		$1		0	<[AN].*>
^leas([aeioud]..)	$1		0	<[AN].*>
^leas([bcfgm]h..)	$1		0	<[AN].*>
^m-([aeiou])	$1		0	<[ANV].*>
^m([aeiou]..)	$1		2	<[ANV].*>  # msid
^m([lnr]..)		$1		0	<[ANV].*>
^m([bcdfgmpt]h.)	$1		0	<[ANV].*>
^m(sh[aeioulnr])	$1		0	<[ANV].*>
^m(s[^aeioulnrh])	$1		0	<[ANV].*>
^neamh-?([aeiou])	$1		0	<[ANV].*>  # neamh-aistear but neamhaithne
^neamh([lnr])		$1		0	<[ANV].*>
^neamh([bcdfgpt]h)	$1		0	<[ANV].*>
^neamh-(mh)		$1		0	<[ANV].*>
^neamh(sh[aeioulnr])	$1	0	<[ANV].*>
^neamh(s[^aeioulnrh])	$1	0	<[ANV].*>
^promh([^bcdfgmpst-])	$1		0	<N.*>
^promh([bcdfgpt]h)	$1		0	<N.*>
^promh-(mh)		$1		0	<N.*>
^promh(sh[aeioulnr])	$1		0	<N.*>
^promh(s[^aeioulnrh])	$1		0	<N.*>
^ramh([^bcdfgmpst-])	$1		0	<[ANV].*>
^ramh([bcdfgpt]h)	$1		0	<[ANV].*>
^ramh-(mh)		$1		0	<[ANV].*>
^ramh(sh[aeioulnr])	$1		0	<[ANV].*>
^ramh(s[^aeioulnrh])	$1		0	<[ANV].*>
^r([lnr]..)		$1		0	<[ANV].*>
^r([bcdfgmpt]h.)	$1		0	<[ANV].*>
^r(sh[aeioulnr])	$1		0	<[ANV].*>
^r(s[^aeioulnrh])	$1		0	<[ANV].*>
^r-([aeiou]..)	$1		0	<[AN].*>
^r([aeiou]..)	$1		2	<[AN].*>
^r([lnr]..)		$1		0	<[AN].*>
^r([bcdfgmpt]h.)	$1		0	<[AN].*>
^r(sh[aeioulnr])	$1		0	<[AN].*>
^r(s[^aeioulnrh])	$1		0	<[AN].*>
^sain([^bcdfgmpst-])	$1		0	<[ANV].*>
^sain([bcdfgmpt]h)	$1		0	<[ANV].*>
^sain(sh[aeioulnr])	$1		0	<[ANV].*>
^sain(s[^aeioulnrh])	$1		0	<[ANV].*>
^so-([aeiou]..)	$1		0	<[AN].*>
^so([lnr]..)		$1		0	<[AN].*>
^so([bcdfgmpt]h.)	$1		0	<[AN].*>
^so(sh[aeioulnr].)	$1		0	<[AN].*>
^so(s[^aeioulnrh]..)	$1		0	<[AN].*>
^tras([^bcfghmnps-])	$1		0	<[ANV].*>   # leave "^trasn" alone
^tras([bcfgmp]h)	$1		0	<[ANV].*>
^tras-(s)		$1		0	<[ANV].*>
# next batch are non-words so really need to be here, but VERY infrequent
^(cil|gig|h?is|meig|micr|pic|teil)ea-?([^aeiou-]+[aou])	$2	0	 <.+>
^(cil|gig|h?is|meig|micr|pic|teil)i-?([^aeiou-]+[ei])	$2	0	 <.+>
^(h?ant|ft|nan|par|pol|h?ultr)a-?([^aeiou-]+[aou])		$2	0	 <.+>
^(h?ant|ft|nan|par|pol|h?ultr)ai-?([^aeiou-]+[ei])		$2	0	<.+>
^(h?eachtar|freas|h?os|neas|ralt|tob|h?uas|h?uath)-?([^-])		$2	0	 <.+>
#  derivational morphology
([ao])chai?s$		$1ch		0	<A pl="n" gnt="n".*>
acht$			ach		0	<A pl="n" gnt="n".*>
([ao])chta$		$1cht		1	<N pl="n" gnt="n".*>
ocht$			och		0	<A pl="n" gnt="n".*>
lachta?$		il		0	<A pl="n" gnt="n".*> # CO p.120
chi?n$				0	<N.*>
# but actually non-standard if it's gs or pp; general  uith -> aith below
uithe$					0	<N.*>
#############################################################################
################## CAIGHDEN OIFIGIIL SPELLING REFORMS #####################
#############################################################################
#   modernize prefixes (no need to trap mutated versions, stripped below
^h?aith			ath		1	<.+>
^h?eadar		idir		1	<.+>
^dh'			d'		1	<.+>
^h-			h		1	<.+>    # CO p.126
^n-([AEIOU])	n$1		1	<.+>    # CO p.125
^t-([AEIOU])	t$1		1	<.+>    # CO p.125
^h?ana-			an-		1	<.+>    # ana-eagraithe
^coimh			comh		1	<.+>    # coimhlonadh
^de[ai]gh		dea		1	<.+>
^dligh(i?)		dl		1	<.+>
^duibh			dubh		1	<.+>
^h?ion			in		1	<.+>
^maill			mall		1	<.+>
^nea-mb			neamhbh		1	<.+>
^nea-			neamh-		1	<.+>    # strip hyphen later
^nea([cdfgpt]h)		neamh$1		1	<.+>
^h?ig			g		1	<.+>
^prmh			promh		1	<.+>
^rimh			ramh		1	<.+>
^roimh			ramh		1	<.+>
^seana-			sean-		1	<.+>    # strip hyphen later
^tele([^aeiou]+[ei])	teili$1		1	<.+>    # OD77
^tele([^aeiou]+[aou])	teilea$1	1	<.+>
^h?uaith		uath		1	<.+>
^h?ir			r		1	<.+>
#   Now various general spelling reforms from CO handbook
ai(cht?n)		a$1		1	<.+>    # CO p.120, smaichtn
sg			sc		1	<.+>    # CO p.115
sb			sp		1	<.+>    # CO p.115
sd			st		1	<.+>    # CO p.115
dn			nn		1	<.+>    # CO p.114 cadna
(ir[ld])		e$1		1	<.+>    # CO p.123
(i?r[dlnr])		a$1		1	<.+>    # CO p.123-124
(i?r[dlnr])		o$1		1	<.+>    # CO p.123-124
(i?r[dlnr])		u$1		1	<.+>    # CO p.123-124
e			eo		1	<.+>    # go ler, etc.
eamhail$		iil		1	<[AN].*>    # dlightheamhail
eamhla			ila		1	<[AN].*>
([^e])amhail$		$1il		1	<[AN].*>    # CO p.102, a2+baril, etc.
([^e])amhla		$1la		1	<[AN].*>    # "-amhlachta?" too
ale$			aola		1	<.+>    # *3* decl.
aibh$			a		1	<.+>    # fearaibh, fiachaibh
([^a])ibh$		$1e		1	<.+>    # coinnibh, etc.
(.)eu			$1a		1	<.+>    # sgeul, ceudna, srl.
tch			t		1	<.+>    # CO p.103
i[dg]hea		o		1	<.+>    # CO p.105,107
i[dg]he					1	<.+>    # CO p.104,106
u([mto])		a$1		1	<.+>	# cialluonn, ionaduochta, leasutear, mionnum
uith			aith		1	<.+>    # rialuitheoir
adha					1	<.+>    # CO p.105
dh					1	<.+>    # dhbhar, rdh, etc.
[mb]hth			f		1	<.+>    # CO p.106
th[mb]h			f		1	<.+>    # CO p.106
ghai			a		1	<.+>    # CO p.107
thch			ch		1	<.+>    # CO p.108
tht			t		1	<.+>    # CO p.108
ll([rst])		l$1		1	<.+>    # CO p.112-113
nn([cdlrst])		n$1		1	<.+>    # CO p.114
ghail$			al		1	<N pl="n" gnt="n" gnd="f".*>
ghaile$			aola		1	<N pl="n" gnt="y" gnd="f".*>
ighil$			l		1	<N pl="n" gnt="n" gnd="f".*>
ighile$			ola		1	<N pl="n" gnt="y" gnd="f".*>
(ain|[ai]|iar)gc	$1g		1	<.+>    # CO p.109
([ai])dt		$1d		1	<.+>    # CO p.109
(dh??)omb		$1om		1	<.+>    # CO p.109
(ai?n)bhf		$1bh		1	<.+>    # CO p.109  ainbhfiosach
(..)u(i?s)$		$1a$2		1	<.+>    # solus, rus, etc.
#   some dialect/pre-standard noun/adjective inflections
([o]ga)$		$1		1	<N pl="y".*>   # duilleoga
nna$			nna		1	<N pl="y".*>   # ceisteanna
tha$			tha		1	<.+>    # glrtha, spartha
(..)dha$		$1tha		1	<.+>    # measardha, muinteardha
(..)dha$		$1a		1	<.+>    # stuamdha, promhdha
(.[a])igh$		$1ch		1	<N.*>	# nb2 -a genitives
(..)igh$		$1each		1	<N.*>   #  same
(..)aidh$		$1a		1	<.+>    # bhfgaidh
ig$			g		1	<N.*>   # nb2 
lainn$			lann		1	<N.*>   # nb2
ais$			ais		1	<N.*>   # cuntais, bronntanais
dth([ea])$		dt$1		1	<.+>    # goidthe
##################  NON/PRE-STANDARD VERB ENDINGS #########################
# future/conditional 2nd declension with -cha?- see CO p.103
e[o]cha(i?dh)$		eo$1		1	<V.*>
([^e])cha(i?dh)$	$1$2		1	<V.*>
e[o]chaimi([ds])$	eoimi$1		1	<V.*>
([^e])chaimi([ds])$	$1imi$2	1	<V.*>
e[o]chai(nn|ds)$	eoi$1		1	<V p="y" t="coinn">
([^e])chai(nn|ds)$	$1i$2		1	<V p="y" t="coinn">
#   2nd declension Dinneen-style endings
u(i?gh)			a$1		1	<.+>  # see next few
(..)ad$		$1aonn		1	<V p="y" t="lith"> # ciallud
aghadh					1	<N.*>  # broad and slender
i[dg]h(th?.)		i$1		1	<.+>  # marcaidhthe, masluighthe, beannuighth?ear
(..)thear$		$1tear		1	<V.*> # aut. present
ighim			m		1	<V.*>    # broad and slender
ighidh					1	<.+>    # subjunctive?
ighinn			nn		1	<.+>    # imperfect
# Future forms: see OS88 p.215 for these (fe?as, etc. on p.63), also CB p.145
#  socrid, dlseoid, 3rd plural forms in achtanna
fa[ds]$			faidh		1	<V p="y" t="fist">
fea[ds]$		fidh		1	<V p="y" t="fist">
i?[ds]$		idh		1	<V p="y" t="fist">
eoi?[ds]$		eoidh		1	<V p="y" t="fist">
# Common in achtanna to have -fidh,-fid ending on broad stem, lots of 
# other slender/broad mismatches:
([aou][^aeiou]*)f$	$1fa	1	<V p="n" t="coinn">
([aou][^aeiou]*)fidh?$	$1faidh	1	<V p="y" t="fist">
([ei][^aeiou]*)fa(r|dh)$	$1fea$2	1	<V p="." t="coinn">
([ei][^aeiou]*)tar$	$1tear	1	<V p="n" t="lith"> # * not + for chtar
# Future 2nd p., "r" forms noted on OS88 p.216;
# see achtanna for ocfaid/ocfa, bainfid/bainfe
fa$			faidh		1	<V p="y" t="fist">
fai[rsd]$		faidh		1	<V p="y" t="fist">
fe$			fidh		1	<V p="y" t="fist">
fi[rsd]$		fidh		1	<V p="y" t="fist">
is$			idh		1	<V p="y" t="fist">
eois$			eoidh		1	<V p="y" t="fist">
# Future/Cond autonomous; unwanted prefix h is common in achtanna
^h([aeiou].+fe?ar)$	$1	1	<V p="n" t="fist">
^h([aeiou].+fa?)$		$1	1	<V p="n" t="coinn">
# Past; also see Di27 (present).  "r" forms on p.216 (also CB p.145 present)
(...)eas$		$1		1	<V p="y" t="caite">
(..[^aeiou])as$	$1		1	<V p="y" t="caite">
(...)os$		$1igh		1	<V p="y" t="caite">
(...)ai[rs]$		$1		1	<V p="y" t="caite">
(..[^aeiou])i[rs]$	$1		1	<V p="y" t="caite">
(...)s$		$1igh		1	<V p="y" t="caite">
#  present
ains$			ann		1	<V p="y" t="lith">
ins$			eann		1	<V p="y" t="lith">
ns$			onn		1	<V p="y" t="lith">
#  OS88 p.126  present
anns$			ann		1	<V p="y" t="lith">
onns$			onn		1	<V p="y" t="lith">
#  corpus 
th(e|ear)$		t$1		1	<V.*>
(..)faims$		$1faimis	2	<V p="y" t="coinn">
#  various -il  endings should be broad, CO p.120
ilim$			laim		1	<V.*>
ileann$		lann		1	<V.*>
ilfidh$		lfaidh		1	<V.*>
ilfe$			lf		1	<V.*>
ilfear$		lfar		1	<V.*>
ilf$			lfa		1	<V.*>
i(lf?)eadh$		$1adh		1	<V.*>
i(lf?)im(i[sd])$	$1aim$2	1	<V.*>
ilig$			laig		1	<V.*>
ilea([dm]ar)$		la$1		1	<V.*>
i(lf?)ids$		$1aids	1	<V.*>
ltar$			iltear		1	<V.*>
lta$			ilte		1	<A.*>
lanna$			lacha		1	<N.*>  # nb3 pl
#############################################################################
#  emphatic suffixes
(.[aou])(san?|na)$	$1		0	<[NV].*>
(.[ei])(sean|[sn]e)$	$1		0	<[NV].*>
([aou][^aeiou-]*[^aeious-])san?$	$1	0	<[NV].*>
([aou][^aeiou-]*[^aeioun-])na$	$1	0	<[NV].*>
([ei][^aeiou-]*[^aeious-])se(an)?$	$1	0	<[NV].*>
([ei][^aeiou-]*[^aeioun-])ne$	$1	0	<[NV].*>
([aou][^aeiou-]*s)-san?$		$1	0	<[NV].*>
([aou][^aeiou-]*n)-na$			$1	0	<[NV].*>
([ei][^aeiou-]*s)-se(an)?$		$1	0	<[NV].*>
([ei][^aeiou-]*n)-ne$			$1	0	<[NV].*>
#############################################################################
#   common spelling errors
uil$			il		2	<A.*>
ula$			la		2	<A.*>
eail$			eil		2	<.+>    # common missing accent
u$					2	<N.*>
# i$					2	<.+>  # lotsa false compounds with this
#############################################################################
#  rules with somewhat lower probability (e.g. fo-, must be after non-stnd
#  verb endings to avoid "foluonn"  parsing as "fo+luonn"
^do([lnr]..)		$1		0	<[AN].*>
^fo([lnr]..)		$1		0	<[ANV].*>
^h?in([^bcfgmp-]..)	$1		0	<[AN].*>
# last resort for weird caps
([A-Z])		\l$1		2	<.+>	# pROMhach
([ei][^aeiou]+)n?$	$1		0	<.+>	# diminutive
([aou][^aeiou]+)n?$	$1		2	<.+>	# diminutive
([o])ign?$		$1g		0	<N.*>
#  the next rule handles a lot of stuff, including unwanted hyphens
#  after prefixes (since the prefix rules will apply after recursing)
#  and similarly unwanted hyphens before emphatic endings (CO p.126)
(.)-			$1		1	<.+>       # r-bheag / rbheag
# delenite, de-eclipse.  
# Only helps when we recurse and find a standard unmutated prefix above!
^bp([^h])		p$1		0	<[ANV].*>
^bhf([^h])		f$1		0	<[ANV].*>
^dt([^h])		t$1		0	<[ANV].*>
^gc([^h])		c$1		0	<[ANV].*>
^mb([^h])		b$1		0	<[ANV].*>
^nd([^h])		d$1		0	<[ANV].*>
^ng([^h])		g$1		0	<[ANV].*>
^ts([^h])		s$1		0	<[ANV].*>
^([bcdfgmpBCDFGMP])h	$1		0	<[ANVY].*>
^([Tt])h([^s])		$1$2		0	<[ANVY].*>   # luathscal danger
^([Ss])h([lnraeiou])	$1$2	0	<[ANVY].*>
^t'([AEIOUaeiou]|[Ff]h)	d'$1	1	<[ANVY].*>	# t'athair
^[bdm]'([AEIOUaeiou]|[Ff]h)	$1	0	<[ANVY].*>	# d'amonn too
^[nt]-([aeiou])	$1		0	<[ANV].*>
