# vim:set filetype=perl:
# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl 02_demeric.t'

#########################

use Test::More tests => 134;
use Carp;

BEGIN { use_ok 'Lingua::Zompist::Barakhinei', 'demeric' }

sub form_ok ($$$) {
    # croak 'usage: form_ok($verb, $is, $should)' unless @_ >= 3;
    my($verb, $is, $should) = @_;

    is($is->[0], $should->[0], "I.sg. of $verb");
    is($is->[1], $should->[1], "II.sg. of $verb");
    is($is->[2], $should->[2], "III.sg. of $verb");
    is($is->[3], $should->[3], "I.pl. of $verb");
    is($is->[4], $should->[4], "II.pl. of $verb");
    is($is->[5], $should->[5], "III.pl. of $verb");
}

form_ok('elir',  demeric('elir',  1), [ qw( elira elir  elir  eliru  eliru  elirn  ) ]);
form_ok('rikha',  demeric('rikha',  2), [ qw( rikh rikh  rikh  rikha  rikhu  rikhn  ) ]);
form_ok('lel',   demeric('lel',   3), [ qw( lel  lel   lel   lela   lelu   leln   ) ]);
form_ok('bshti', demeric('bshti', 4), [ qw( bch  bsht bshti bkchu bkchu bshtn ) ]);
form_ok('hab',   demeric('hab',   5), [ qw( hap   hab   hab   habu   habu   habun   ) ]);

form_ok('groch', demeric('groch', 1), [ qw( groga groch groch grogu  grogu  grogn  ) ]);
form_ok('foka',   demeric('foka',   2), [ qw( fok  foch  foch  foka   foku   fokn   ) ]);
form_ok('noch',  demeric('noch',  3), [ qw( nog  noch  noch  nocha  nochu  nochn  ) ]);
form_ok('faichi', demeric('faichi', 4), [ qw( faok  faoch faichi faoku  faoku  faichn ) ]);
form_ok('klach', demeric('klach', 5), [ qw( klak  klach klach klagu  klagu  klagun  ) ]);

form_ok('eza',     demeric('eza'    ), [ qw( s      s         eza     ezu     sn      ) ]);
form_ok('epeza',   demeric('epeza'  ), [ qw( z     z   ep   epeza   epezu   zn     ) ]);
form_ok('foli',    demeric('foli'   ), [ qw( ful     ful   fut   folu    folu    foln    ) ]);
form_ok('lhib',   demeric('lhib'  ), [ qw( lhua    lh   lhu   lhubu   lhubu   ln      ) ]);
form_ok('kedh',   demeric('kedh'  ), [ qw( kedh   kedh kedhu kedha   kedhu   kn      ) ]);
form_ok('nh',     demeric('nh'    ), [ qw( nhe     ni    ni    nheza   nhezu   nhn     ) ]);
form_ok('shkriv', demeric('shkriv'), [ qw( shkriva shkri shkri shkrivu shkrivu shkrivn ) ]);
form_ok('shtan',  demeric('shtan' ), [ qw( sht    sht  sht  shtana  shtanu  shtn    ) ]);
form_ok('fli',    demeric('fli'   ), [ qw( fl     fl   fl   flu    flu    fln    ) ]);
form_ok('hizi',    demeric('hizi'   ), [ qw( huz     hu    hut   hizu    hizu    hizn    ) ]);
form_ok('oi',      demeric('oi'     ), [ qw( oh      fi    fit   ou      ou      on      ) ]);

is(demeric('chura', 2)->[1], 'chir', 'II.sg of chura');
form_ok('sid', demeric('sid', 5), [ qw( sidh sid sid sidhu sidhu sidhun ) ]);
