
use strict;
use warnings;



use ExtUtils::MakeMaker 6.30;



my %WriteMakefileArgs = (
  "ABSTRACT" => "Represents a record of a SAM format file generated by BWA",
  "AUTHOR" => "Emmanouil \"Manolis\" Maragkakis <mns.marag\@gmail.com>",
  "BUILD_REQUIRES" => {},
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => "6.30"
  },
  "DISTNAME" => "GenOOx-Data-File-SAMbwa",
  "EXE_FILES" => [],
  "LICENSE" => "perl",
  "NAME" => "GenOOx::Data::File::SAMbwa",
  "PREREQ_PM" => {
    "GenOO::Data::File::SAM::Record" => 0,
    "Moose" => 0,
    "namespace::autoclean" => 0
  },
  "TEST_REQUIRES" => {
    "Modern::Perl" => 0,
    "Moose::Role" => 0,
    "Test::Class::Moose" => 0,
    "Test::Class::Moose::Load" => 0,
    "Test::Class::Moose::Role::AutoUse" => 0,
    "autodie" => 0
  },
  "VERSION" => "0.0.1",
  "test" => {
    "TESTS" => "t/*.t"
  }
);


my %FallbackPrereqs = (
  "GenOO::Data::File::SAM::Record" => 0,
  "Modern::Perl" => 0,
  "Moose" => 0,
  "Moose::Role" => 0,
  "Test::Class::Moose" => 0,
  "Test::Class::Moose::Load" => 0,
  "Test::Class::Moose::Role::AutoUse" => 0,
  "autodie" => 0,
  "namespace::autoclean" => 0
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);



