use v6;
#use lib '../gnome-gobject/lib';
use NativeCall;
use Test;

#use Gnome::Gtk3::Window;
use Gnome::Gtk3::Label;
use Gnome::Gtk3::Button;
use Gnome::Gtk3::Builder;
use Gnome::Glib::Error;
use Gnome::Glib::Quark;

#use Gnome::N::X;
#Gnome::N::debug(:on);

#-------------------------------------------------------------------------------
my Gnome::Gtk3::Label $l;
my Gnome::Gtk3::Button $b;
my Gnome::Glib::Error $e;
my Gnome::Gtk3::Builder $builder;

my Str $ui-file = 't/data/ui.glade';
my Gnome::Glib::Quark $quark .= new;

#-------------------------------------------------------------------------------
subtest 'Interface ...', {
  $l .= new(:text('text for a label'));
  is $l.get-name, 'GtkLabel', '.get-name(): default is GtkLabel';
  $l.set-name('buildable');
  is $l.get-name, 'buildable', '.set-name() / .get-name()';

  # explicitly use full name for interface
  $l.buildable-set-name("build-name");
  is $l.buildable-get-name, "build-name",
     '.buildable-set-name() / .buildable-get-name()';
  $l.set-name('widget-name');
  is $l.get-name, 'widget-name', '.set-name()';

  $builder .= new;
  $e = $builder.add-from-file($ui-file);
  nok $e.is-valid, "ui file added ok";
#note $e.message if $e.is-valid;

  # set name is used by Builder
  $l .= new(:build-id<my-label-1>);
  is $l.get-name, 'label-name-1', '.get-name(): label-name-1';
  is $l.buildable-get-name, 'my-label-1', '.buildable-get-name() ~~ id';

  $b .= new(:build-id<my-button-1>);
  is $b.get-name, 'button-name-1', '.get-name(): button-name-1';
  is $b.buildable-get-name, 'my-button-1', '.buildable-get-name()';
}


#-------------------------------------------------------------------------------
# set environment variable 'raku-test-all' if rest must be tested too.
unless %*ENV<raku_test_all>:exists {
  done-testing;
  exit;
}

#-------------------------------------------------------------------------------
done-testing;

=finish

#-------------------------------------------------------------------------------
subtest 'Manipulations', {
}

#-------------------------------------------------------------------------------
subtest 'Inherit Gnome::Gtk3::Buildable', {
  class MyClass is Gnome::Gtk3::Buildable {
    method new ( |c ) {
      self.bless( :GtkBuildable, |c);
    }

    submethod BUILD ( *%options ) {

    }
  }

  my MyClass $mgc .= new;
  isa-ok $mgc, Gnome::Gtk3::Buildable, 'MyClass.new()';
}

#-------------------------------------------------------------------------------
subtest 'Properties ...', {
  use Gnome::GObject::Value;
  use Gnome::GObject::Type;

  #my Gnome::Gtk3::Buildable $b .= new;

  sub test-property (
    $type, Str $prop, Str $routine, $value,
    Bool :$approx = False, Bool :$is-local = False
  ) {
    my Gnome::GObject::Value $gv .= new(:init($type));
    $b.get-property( $prop, $gv);
    my $gv-value = $gv."$routine"();
    if $approx {
      is-approx $gv-value, $value,
        "property $prop, value: " ~ $gv-value;
    }

    # dependency on local settings might result in different values
    elsif $is-local {
      if $gv-value ~~ /$value/ {
        like $gv-value, /$value/, "property $prop, value: " ~ $gv-value;
      }

      else {
        ok 1, "property $prop, value: " ~ $gv-value;
      }
    }

    else {
      is $gv-value, $value,
        "property $prop, value: " ~ $gv-value;
    }
    $gv.clear-object;
  }

  # example calls
  #test-property( G_TYPE_BOOLEAN, 'homogeneous', 'get-boolean', False);
  #test-property( G_TYPE_STRING, 'label', 'get-string', '...');
  #test-property( G_TYPE_FLOAT, 'xalign', 'get-float', 23e-2, :approx);
}

#-------------------------------------------------------------------------------
subtest 'Themes ...', {
}

#-------------------------------------------------------------------------------
subtest 'Signals ...', {
  use Gnome::Gtk3::Main;
  use Gnome::N::GlibToRakuTypes;

  my Gnome::Gtk3::Main $main .= new;

  class SignalHandlers {
    has Bool $!signal-processed = False;

    method ... (
      'any-args',
      Gnome::Gtk3::Buildable() :_native-object($_widget), gulong :$_handler-id
      # --> ...
    ) {

      isa-ok $_widget, Gnome::Gtk3::Buildable;
      $!signal-processed = True;
    }

    method signal-emitter ( Gnome::Gtk3::Buildable :$widget --> Str ) {

      while $main.gtk-events-pending() { $main.iteration-do(False); }

      $widget.emit-by-name(
        'signal',
      #  'any-args',
      #  :return-type(int32),
      #  :parameters([int32,])
      );
      is $!signal-processed, True, '\'...\' signal processed';

      while $main.gtk-events-pending() { $main.iteration-do(False); }

      #$!signal-processed = False;
      #$widget.emit-by-name(
      #  'signal',
      #  'any-args',
      #  :return-type(int32),
      #  :parameters([int32,])
      #);
      #is $!signal-processed, True, '\'...\' signal processed';

      while $main.gtk-events-pending() { $main.iteration-do(False); }
      sleep(0.4);
      $main.gtk-main-quit;

      'done'
    }
  }

  my Gnome::Gtk3::Buildable $b .= new;

  #my Gnome::Gtk3::Window $w .= new;
  #$w.add($m);

  my SignalHandlers $sh .= new;
  $b.register-signal( $sh, 'method', 'signal');

  my Promise $p = $b.start-thread(
    $sh, 'signal-emitter',
    # :!new-context,
    # :start-time(now + 1)
  );

  is $main.gtk-main-level, 0, "loop level 0";
  $main.gtk-main;
  #is $main.gtk-main-level, 0, "loop level is 0 again";

  is $p.result, 'done', 'emitter finished';
}
