# Generated by default/object.tt
package Paws::FraudDetector::DataValidationMetrics;
  use Moose;
  has FieldLevelMessages => (is => 'ro', isa => 'ArrayRef[Paws::FraudDetector::FieldValidationMessage]', request_name => 'fieldLevelMessages', traits => ['NameInRequest']);
  has FileLevelMessages => (is => 'ro', isa => 'ArrayRef[Paws::FraudDetector::FileValidationMessage]', request_name => 'fileLevelMessages', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::FraudDetector::DataValidationMetrics

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::FraudDetector::DataValidationMetrics object:

  $service_obj->Method(Att1 => { FieldLevelMessages => $value, ..., FileLevelMessages => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::FraudDetector::DataValidationMetrics object:

  $result = $service_obj->Method(...);
  $result->Att1->FieldLevelMessages

=head1 DESCRIPTION

The model training validation messages.

=head1 ATTRIBUTES


=head2 FieldLevelMessages => ArrayRef[L<Paws::FraudDetector::FieldValidationMessage>]

The field-specific model training validation messages.


=head2 FileLevelMessages => ArrayRef[L<Paws::FraudDetector::FileValidationMessage>]

The file-specific model training validation messages.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::FraudDetector>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

