package WARC::Index::Builder;					# -*- CPerl -*-

use strict;
use warnings;

our @ISA = qw();

require WARC; *WARC::Index::Builder::VERSION = \$WARC::VERSION;

=head1 NAME

WARC::Index::Builder - abstract base class for building indexes

=head1 SYNOPSIS

  use WARC::Index;

  $cdx_builder = build WARC::Index::File::CDX (...);
  $sdbm_builder = build WARC::Index::File::SDBM (...);

  $cdx_entry = $cdx_builder->add($record);
  $sdbm_builder->add($cdx_entry);

=head1 DESCRIPTION

C<WARC::Index::Builder> is an abstract base class for constructing indexes
on WARC files.  The interface is documented here, but implemented in
specialized classes for each index type.

=head2 Methods

=over

=item $entry = $builder-E<gt>add( ... )

Add an item to the growing index.  All index types accept both WARC records
and entries from other indexes, although only metaindex-capable formats use
the latter.  Any number of items may be added with a single call.

Returns the new index entry.

=back

=cut

1;
__END__

=head1 AUTHOR

Jacob Bachmeyer, E<lt>jcb@cpan.orgE<gt>

=head1 SEE ALSO

L<WARC>, L<WARC::Index>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2019 by Jacob Bachmeyer

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=cut
