package WARC::Date;						# -*- CPerl -*-

use strict;
use warnings;

our @ISA = qw();

require WARC; *WARC::Date::VERSION = \$WARC::VERSION;

=head1 NAME

WARC::Date - datestamp objects for WARC library

=head1 SYNOPSIS

  use WARC::Date;

  $datestamp = WARC::Date->now();		# construct from current time
  $datestamp = WARC::Date->from_epoch(time);	# likewise

  # construct from string
  $datestamp = parse WARC::Date ($text);	# full-featured
  $datestamp = WARC::Date->from_text($string);	# standard format only

  $time = $datestamp->as_epoch;		# as seconds since epoch
  $text = $datestamp->as_string;	# as "YYYY-MM-DDThh:mm:ssZ"

=head1 DESCRIPTION

C<WARC::Date> objects encapsulate the details of the required format for
timestamps in WARC headers.

=head2 Methods

=over

=item $datestamp = WARC::Date-E<gt>now

Construct a C<WARC::Date> object representing the current time.

=cut

sub now {
}

=item $datestamp = WARC::Date-E<gt>from_epoch( $timestamp )

Construct a C<WARC::Date> object representing the time indicated by an
epoch timestamp.

=cut

sub from_epoch {
}

=item $datestamp = WARC::Date-E<gt>from_text( $string )

Construct a C<WARC::Date> object representing the time indicated by a
string in the same format returned by the C<as_string> method.

=cut

sub from_text {
}

=item $datestamp = parse WARC::Date ($text)

Construct a C<WARC::Date> object from a textual representation.  If
L<HTTP::Date> is installed, accepts any input acceptable to
C<HTTP::Date::str2time>.  Otherwise, this method is equivalent to the
C<from_text> method.

=cut

sub parse {
}

=item $datestamp-E<gt>as_string

Return a string in the format specified by [W3C-NOTE-datetime] restricted
to 14 digits and UTC time zone, which is
"I<YYYY>-I<MM>-I<DD>B<T>I<hh>:I<mm>:I<ss>B<Z>".

=cut

sub as_string {
}

=back

=cut

1;
__END__

=head1 CAVEATS

C<WARC::Date> objects use epoch time internally and are therefore limited
by the range of Perl's integers.

=head1 AUTHOR

Jacob Bachmeyer, E<lt>jcb@cpan.orgE<gt>

=head1 SEE ALSO

L<WARC>, L<HTTP::Date>

[W3C-NOTE-datetime] "Date and Time Formats"
L<http://www.w3.org/TR/NOTE-datetime>.

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2019 by Jacob Bachmeyer

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=cut
