/*  vim:expandtab:shiftwidth=2:tabstop=2:smarttab:
 *
 *  libtest
 *
 *  Copyright (C) 2011 Data Differential, http://datadifferential.com/
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 3 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#ifndef __LIBTEST_RUNNER_H__
#define __LIBTEST_RUNNER_H__


namespace libtest {

/**
  Structure which houses the actual callers for the test cases contained in
  the collections.
*/
class Runner {
public:
  virtual test_return_t run(test_callback_fn* func, void *object);
  virtual test_return_t pre(test_callback_fn* func, void *object);
  virtual test_return_t post(test_callback_fn* func, void *object);

  Runner();

  virtual ~Runner() { }
};

} // namespace Runner

#endif /* __LIBTEST_RUNNER_H__ */
