use strict;
use warnings;
use utf8;

use FindBin;
use lib ("lib", "$FindBin::Bin/../blib/lib", "$FindBin::Bin/../blib/arch");

use Lingua::RU::Money::XS qw(rur2words);
use Test::Spec;

describe "Convert thousands of rubles to word, amount: " => sub {
	it "1000.00" => sub { is rur2words(1000.00), "одна тысяча рублей 00 копеек"; };
	it "2000.00" => sub { is rur2words(2000.00), "две тысячи рублей 00 копеек"; };
	it "3000.00" => sub { is rur2words(3000.00), "три тысячи рублей 00 копеек"; };
	it "4000.00" => sub { is rur2words(4000.00), "четыре тысячи рублей 00 копеек"; };
	it "5000.00" => sub { is rur2words(5000.00), "пять тысяч рублей 00 копеек"; };
	it "6000.00" => sub { is rur2words(6000.00), "шесть тысяч рублей 00 копеек"; };
	it "7000.00" => sub { is rur2words(7000.00), "семь тысяч рублей 00 копеек"; };
	it "8000.00" => sub { is rur2words(8000.00), "восемь тысяч рублей 00 копеек"; };
	it "9000.00" => sub { is rur2words(9000.00), "девять тысяч рублей 00 копеек"; };
	it "10000.00" => sub { is rur2words(10000.00), "десять тысяч рублей 00 копеек"; };
	it "11000.00" => sub { is rur2words(11000.00), "одиннадцать тысяч рублей 00 копеек"; };
	it "12000.00" => sub { is rur2words(12000.00), "двенадцать тысяч рублей 00 копеек"; };
	it "13000.00" => sub { is rur2words(13000.00), "тринадцать тысяч рублей 00 копеек"; };
	it "14000.00" => sub { is rur2words(14000.00), "четырнадцать тысяч рублей 00 копеек"; };
	it "15000.00" => sub { is rur2words(15000.00), "пятнадцать тысяч рублей 00 копеек"; };
	it "16000.00" => sub { is rur2words(16000.00), "шестнадцать тысяч рублей 00 копеек"; };
	it "17000.00" => sub { is rur2words(17000.00), "семнадцать тысяч рублей 00 копеек"; };
	it "18000.00" => sub { is rur2words(18000.00), "восемнадцать тысяч рублей 00 копеек"; };
	it "19000.00" => sub { is rur2words(19000.00), "девятнадцать тысяч рублей 00 копеек"; };
	it "20000.00" => sub { is rur2words(20000.00), "двадцать тысяч рублей 00 копеек"; };
	it "21000.00" => sub { is rur2words(21000.00), "двадцать одна тысяча рублей 00 копеек"; };
	it "22000.00" => sub { is rur2words(22000.00), "двадцать две тысячи рублей 00 копеек"; };
	it "23000.00" => sub { is rur2words(23000.00), "двадцать три тысячи рублей 00 копеек"; };
	it "24000.00" => sub { is rur2words(24000.00), "двадцать четыре тысячи рублей 00 копеек"; };
	it "25000.00" => sub { is rur2words(25000.00), "двадцать пять тысяч рублей 00 копеек"; };
	it "26000.00" => sub { is rur2words(26000.00), "двадцать шесть тысяч рублей 00 копеек"; };
	it "27000.00" => sub { is rur2words(27000.00), "двадцать семь тысяч рублей 00 копеек"; };
	it "28000.00" => sub { is rur2words(28000.00), "двадцать восемь тысяч рублей 00 копеек"; };
	it "29000.00" => sub { is rur2words(29000.00), "двадцать девять тысяч рублей 00 копеек"; };
	it "30000.00" => sub { is rur2words(30000.00), "тридцать тысяч рублей 00 копеек"; };
	it "31000.00" => sub { is rur2words(31000.00), "тридцать одна тысяча рублей 00 копеек"; };
	it "32000.00" => sub { is rur2words(32000.00), "тридцать две тысячи рублей 00 копеек"; };
	it "33000.00" => sub { is rur2words(33000.00), "тридцать три тысячи рублей 00 копеек"; };
	it "34000.00" => sub { is rur2words(34000.00), "тридцать четыре тысячи рублей 00 копеек"; };
	it "35000.00" => sub { is rur2words(35000.00), "тридцать пять тысяч рублей 00 копеек"; };
	it "36000.00" => sub { is rur2words(36000.00), "тридцать шесть тысяч рублей 00 копеек"; };
	it "37000.00" => sub { is rur2words(37000.00), "тридцать семь тысяч рублей 00 копеек"; };
	it "38000.00" => sub { is rur2words(38000.00), "тридцать восемь тысяч рублей 00 копеек"; };
	it "39000.00" => sub { is rur2words(39000.00), "тридцать девять тысяч рублей 00 копеек"; };
	it "40000.00" => sub { is rur2words(40000.00), "сорок тысяч рублей 00 копеек"; };
	it "41000.00" => sub { is rur2words(41000.00), "сорок одна тысяча рублей 00 копеек"; };
	it "42000.00" => sub { is rur2words(42000.00), "сорок две тысячи рублей 00 копеек"; };
	it "43000.00" => sub { is rur2words(43000.00), "сорок три тысячи рублей 00 копеек"; };
	it "44000.00" => sub { is rur2words(44000.00), "сорок четыре тысячи рублей 00 копеек"; };
	it "45000.00" => sub { is rur2words(45000.00), "сорок пять тысяч рублей 00 копеек"; };
	it "46000.00" => sub { is rur2words(46000.00), "сорок шесть тысяч рублей 00 копеек"; };
	it "47000.00" => sub { is rur2words(47000.00), "сорок семь тысяч рублей 00 копеек"; };
	it "48000.00" => sub { is rur2words(48000.00), "сорок восемь тысяч рублей 00 копеек"; };
	it "49000.00" => sub { is rur2words(49000.00), "сорок девять тысяч рублей 00 копеек"; };
	it "50000.00" => sub { is rur2words(50000.00), "пятьдесят тысяч рублей 00 копеек"; };
	it "51000.00" => sub { is rur2words(51000.00), "пятьдесят одна тысяча рублей 00 копеек"; };
	it "52000.00" => sub { is rur2words(52000.00), "пятьдесят две тысячи рублей 00 копеек"; };
	it "53000.00" => sub { is rur2words(53000.00), "пятьдесят три тысячи рублей 00 копеек"; };
	it "54000.00" => sub { is rur2words(54000.00), "пятьдесят четыре тысячи рублей 00 копеек"; };
	it "55000.00" => sub { is rur2words(55000.00), "пятьдесят пять тысяч рублей 00 копеек"; };
	it "56000.00" => sub { is rur2words(56000.00), "пятьдесят шесть тысяч рублей 00 копеек"; };
	it "57000.00" => sub { is rur2words(57000.00), "пятьдесят семь тысяч рублей 00 копеек"; };
	it "58000.00" => sub { is rur2words(58000.00), "пятьдесят восемь тысяч рублей 00 копеек"; };
	it "59000.00" => sub { is rur2words(59000.00), "пятьдесят девять тысяч рублей 00 копеек"; };
	it "60000.00" => sub { is rur2words(60000.00), "шестьдесят тысяч рублей 00 копеек"; };
	it "61000.00" => sub { is rur2words(61000.00), "шестьдесят одна тысяча рублей 00 копеек"; };
	it "62000.00" => sub { is rur2words(62000.00), "шестьдесят две тысячи рублей 00 копеек"; };
	it "63000.00" => sub { is rur2words(63000.00), "шестьдесят три тысячи рублей 00 копеек"; };
	it "64000.00" => sub { is rur2words(64000.00), "шестьдесят четыре тысячи рублей 00 копеек"; };
	it "65000.00" => sub { is rur2words(65000.00), "шестьдесят пять тысяч рублей 00 копеек"; };
	it "66000.00" => sub { is rur2words(66000.00), "шестьдесят шесть тысяч рублей 00 копеек"; };
	it "67000.00" => sub { is rur2words(67000.00), "шестьдесят семь тысяч рублей 00 копеек"; };
	it "68000.00" => sub { is rur2words(68000.00), "шестьдесят восемь тысяч рублей 00 копеек"; };
	it "69000.00" => sub { is rur2words(69000.00), "шестьдесят девять тысяч рублей 00 копеек"; };
	it "70000.00" => sub { is rur2words(70000.00), "семьдесят тысяч рублей 00 копеек"; };
	it "71000.00" => sub { is rur2words(71000.00), "семьдесят одна тысяча рублей 00 копеек"; };
	it "72000.00" => sub { is rur2words(72000.00), "семьдесят две тысячи рублей 00 копеек"; };
	it "73000.00" => sub { is rur2words(73000.00), "семьдесят три тысячи рублей 00 копеек"; };
	it "74000.00" => sub { is rur2words(74000.00), "семьдесят четыре тысячи рублей 00 копеек"; };
	it "75000.00" => sub { is rur2words(75000.00), "семьдесят пять тысяч рублей 00 копеек"; };
	it "76000.00" => sub { is rur2words(76000.00), "семьдесят шесть тысяч рублей 00 копеек"; };
	it "77000.00" => sub { is rur2words(77000.00), "семьдесят семь тысяч рублей 00 копеек"; };
	it "78000.00" => sub { is rur2words(78000.00), "семьдесят восемь тысяч рублей 00 копеек"; };
	it "79000.00" => sub { is rur2words(79000.00), "семьдесят девять тысяч рублей 00 копеек"; };
	it "80000.00" => sub { is rur2words(80000.00), "восемьдесят тысяч рублей 00 копеек"; };
	it "81000.00" => sub { is rur2words(81000.00), "восемьдесят одна тысяча рублей 00 копеек"; };
	it "82000.00" => sub { is rur2words(82000.00), "восемьдесят две тысячи рублей 00 копеек"; };
	it "83000.00" => sub { is rur2words(83000.00), "восемьдесят три тысячи рублей 00 копеек"; };
	it "84000.00" => sub { is rur2words(84000.00), "восемьдесят четыре тысячи рублей 00 копеек"; };
	it "85000.00" => sub { is rur2words(85000.00), "восемьдесят пять тысяч рублей 00 копеек"; };
	it "86000.00" => sub { is rur2words(86000.00), "восемьдесят шесть тысяч рублей 00 копеек"; };
	it "87000.00" => sub { is rur2words(87000.00), "восемьдесят семь тысяч рублей 00 копеек"; };
	it "88000.00" => sub { is rur2words(88000.00), "восемьдесят восемь тысяч рублей 00 копеек"; };
	it "89000.00" => sub { is rur2words(89000.00), "восемьдесят девять тысяч рублей 00 копеек"; };
	it "90000.00" => sub { is rur2words(90000.00), "девяносто тысяч рублей 00 копеек"; };
	it "91000.00" => sub { is rur2words(91000.00), "девяносто одна тысяча рублей 00 копеек"; };
	it "92000.00" => sub { is rur2words(92000.00), "девяносто две тысячи рублей 00 копеек"; };
	it "93000.00" => sub { is rur2words(93000.00), "девяносто три тысячи рублей 00 копеек"; };
	it "94000.00" => sub { is rur2words(94000.00), "девяносто четыре тысячи рублей 00 копеек"; };
	it "95000.00" => sub { is rur2words(95000.00), "девяносто пять тысяч рублей 00 копеек"; };
	it "96000.00" => sub { is rur2words(96000.00), "девяносто шесть тысяч рублей 00 копеек"; };
	it "97000.00" => sub { is rur2words(97000.00), "девяносто семь тысяч рублей 00 копеек"; };
	it "98000.00" => sub { is rur2words(98000.00), "девяносто восемь тысяч рублей 00 копеек"; };
	it "99000.00" => sub { is rur2words(99000.00), "девяносто девять тысяч рублей 00 копеек"; };
	it "100000.00" => sub { is rur2words(100000.00), "сто тысяч рублей 00 копеек"; };
	it "101000.00" => sub { is rur2words(101000.00), "сто одна тысяча рублей 00 копеек"; };
	it "102000.00" => sub { is rur2words(102000.00), "сто две тысячи рублей 00 копеек"; };
	it "103000.00" => sub { is rur2words(103000.00), "сто три тысячи рублей 00 копеек"; };
	it "104000.00" => sub { is rur2words(104000.00), "сто четыре тысячи рублей 00 копеек"; };
	it "105000.00" => sub { is rur2words(105000.00), "сто пять тысяч рублей 00 копеек"; };
	it "106000.00" => sub { is rur2words(106000.00), "сто шесть тысяч рублей 00 копеек"; };
	it "107000.00" => sub { is rur2words(107000.00), "сто семь тысяч рублей 00 копеек"; };
	it "108000.00" => sub { is rur2words(108000.00), "сто восемь тысяч рублей 00 копеек"; };
	it "109000.00" => sub { is rur2words(109000.00), "сто девять тысяч рублей 00 копеек"; };
	it "110000.00" => sub { is rur2words(110000.00), "сто десять тысяч рублей 00 копеек"; };
	it "111000.00" => sub { is rur2words(111000.00), "сто одиннадцать тысяч рублей 00 копеек"; };
	it "112000.00" => sub { is rur2words(112000.00), "сто двенадцать тысяч рублей 00 копеек"; };
	it "113000.00" => sub { is rur2words(113000.00), "сто тринадцать тысяч рублей 00 копеек"; };
	it "114000.00" => sub { is rur2words(114000.00), "сто четырнадцать тысяч рублей 00 копеек"; };
	it "115000.00" => sub { is rur2words(115000.00), "сто пятнадцать тысяч рублей 00 копеек"; };
	it "116000.00" => sub { is rur2words(116000.00), "сто шестнадцать тысяч рублей 00 копеек"; };
	it "117000.00" => sub { is rur2words(117000.00), "сто семнадцать тысяч рублей 00 копеек"; };
	it "118000.00" => sub { is rur2words(118000.00), "сто восемнадцать тысяч рублей 00 копеек"; };
	it "119000.00" => sub { is rur2words(119000.00), "сто девятнадцать тысяч рублей 00 копеек"; };
	it "120000.00" => sub { is rur2words(120000.00), "сто двадцать тысяч рублей 00 копеек"; };
	it "121000.00" => sub { is rur2words(121000.00), "сто двадцать одна тысяча рублей 00 копеек"; };
	it "122000.00" => sub { is rur2words(122000.00), "сто двадцать две тысячи рублей 00 копеек"; };
	it "123000.00" => sub { is rur2words(123000.00), "сто двадцать три тысячи рублей 00 копеек"; };
	it "124000.00" => sub { is rur2words(124000.00), "сто двадцать четыре тысячи рублей 00 копеек"; };
	it "125000.00" => sub { is rur2words(125000.00), "сто двадцать пять тысяч рублей 00 копеек"; };
	it "126000.00" => sub { is rur2words(126000.00), "сто двадцать шесть тысяч рублей 00 копеек"; };
	it "127000.00" => sub { is rur2words(127000.00), "сто двадцать семь тысяч рублей 00 копеек"; };
	it "128000.00" => sub { is rur2words(128000.00), "сто двадцать восемь тысяч рублей 00 копеек"; };
	it "129000.00" => sub { is rur2words(129000.00), "сто двадцать девять тысяч рублей 00 копеек"; };
	it "130000.00" => sub { is rur2words(130000.00), "сто тридцать тысяч рублей 00 копеек"; };
	it "131000.00" => sub { is rur2words(131000.00), "сто тридцать одна тысяча рублей 00 копеек"; };
	it "132000.00" => sub { is rur2words(132000.00), "сто тридцать две тысячи рублей 00 копеек"; };
	it "133000.00" => sub { is rur2words(133000.00), "сто тридцать три тысячи рублей 00 копеек"; };
	it "134000.00" => sub { is rur2words(134000.00), "сто тридцать четыре тысячи рублей 00 копеек"; };
	it "135000.00" => sub { is rur2words(135000.00), "сто тридцать пять тысяч рублей 00 копеек"; };
	it "136000.00" => sub { is rur2words(136000.00), "сто тридцать шесть тысяч рублей 00 копеек"; };
	it "137000.00" => sub { is rur2words(137000.00), "сто тридцать семь тысяч рублей 00 копеек"; };
	it "138000.00" => sub { is rur2words(138000.00), "сто тридцать восемь тысяч рублей 00 копеек"; };
	it "139000.00" => sub { is rur2words(139000.00), "сто тридцать девять тысяч рублей 00 копеек"; };
	it "140000.00" => sub { is rur2words(140000.00), "сто сорок тысяч рублей 00 копеек"; };
	it "141000.00" => sub { is rur2words(141000.00), "сто сорок одна тысяча рублей 00 копеек"; };
	it "142000.00" => sub { is rur2words(142000.00), "сто сорок две тысячи рублей 00 копеек"; };
	it "143000.00" => sub { is rur2words(143000.00), "сто сорок три тысячи рублей 00 копеек"; };
	it "144000.00" => sub { is rur2words(144000.00), "сто сорок четыре тысячи рублей 00 копеек"; };
	it "145000.00" => sub { is rur2words(145000.00), "сто сорок пять тысяч рублей 00 копеек"; };
	it "146000.00" => sub { is rur2words(146000.00), "сто сорок шесть тысяч рублей 00 копеек"; };
	it "147000.00" => sub { is rur2words(147000.00), "сто сорок семь тысяч рублей 00 копеек"; };
	it "148000.00" => sub { is rur2words(148000.00), "сто сорок восемь тысяч рублей 00 копеек"; };
	it "149000.00" => sub { is rur2words(149000.00), "сто сорок девять тысяч рублей 00 копеек"; };
	it "150000.00" => sub { is rur2words(150000.00), "сто пятьдесят тысяч рублей 00 копеек"; };
	it "151000.00" => sub { is rur2words(151000.00), "сто пятьдесят одна тысяча рублей 00 копеек"; };
	it "152000.00" => sub { is rur2words(152000.00), "сто пятьдесят две тысячи рублей 00 копеек"; };
	it "153000.00" => sub { is rur2words(153000.00), "сто пятьдесят три тысячи рублей 00 копеек"; };
	it "154000.00" => sub { is rur2words(154000.00), "сто пятьдесят четыре тысячи рублей 00 копеек"; };
	it "155000.00" => sub { is rur2words(155000.00), "сто пятьдесят пять тысяч рублей 00 копеек"; };
	it "156000.00" => sub { is rur2words(156000.00), "сто пятьдесят шесть тысяч рублей 00 копеек"; };
	it "157000.00" => sub { is rur2words(157000.00), "сто пятьдесят семь тысяч рублей 00 копеек"; };
	it "158000.00" => sub { is rur2words(158000.00), "сто пятьдесят восемь тысяч рублей 00 копеек"; };
	it "159000.00" => sub { is rur2words(159000.00), "сто пятьдесят девять тысяч рублей 00 копеек"; };
	it "160000.00" => sub { is rur2words(160000.00), "сто шестьдесят тысяч рублей 00 копеек"; };
	it "161000.00" => sub { is rur2words(161000.00), "сто шестьдесят одна тысяча рублей 00 копеек"; };
	it "162000.00" => sub { is rur2words(162000.00), "сто шестьдесят две тысячи рублей 00 копеек"; };
	it "163000.00" => sub { is rur2words(163000.00), "сто шестьдесят три тысячи рублей 00 копеек"; };
	it "164000.00" => sub { is rur2words(164000.00), "сто шестьдесят четыре тысячи рублей 00 копеек"; };
	it "165000.00" => sub { is rur2words(165000.00), "сто шестьдесят пять тысяч рублей 00 копеек"; };
	it "166000.00" => sub { is rur2words(166000.00), "сто шестьдесят шесть тысяч рублей 00 копеек"; };
	it "167000.00" => sub { is rur2words(167000.00), "сто шестьдесят семь тысяч рублей 00 копеек"; };
	it "168000.00" => sub { is rur2words(168000.00), "сто шестьдесят восемь тысяч рублей 00 копеек"; };
	it "169000.00" => sub { is rur2words(169000.00), "сто шестьдесят девять тысяч рублей 00 копеек"; };
	it "170000.00" => sub { is rur2words(170000.00), "сто семьдесят тысяч рублей 00 копеек"; };
	it "171000.00" => sub { is rur2words(171000.00), "сто семьдесят одна тысяча рублей 00 копеек"; };
	it "172000.00" => sub { is rur2words(172000.00), "сто семьдесят две тысячи рублей 00 копеек"; };
	it "173000.00" => sub { is rur2words(173000.00), "сто семьдесят три тысячи рублей 00 копеек"; };
	it "174000.00" => sub { is rur2words(174000.00), "сто семьдесят четыре тысячи рублей 00 копеек"; };
	it "175000.00" => sub { is rur2words(175000.00), "сто семьдесят пять тысяч рублей 00 копеек"; };
	it "176000.00" => sub { is rur2words(176000.00), "сто семьдесят шесть тысяч рублей 00 копеек"; };
	it "177000.00" => sub { is rur2words(177000.00), "сто семьдесят семь тысяч рублей 00 копеек"; };
	it "178000.00" => sub { is rur2words(178000.00), "сто семьдесят восемь тысяч рублей 00 копеек"; };
	it "179000.00" => sub { is rur2words(179000.00), "сто семьдесят девять тысяч рублей 00 копеек"; };
	it "180000.00" => sub { is rur2words(180000.00), "сто восемьдесят тысяч рублей 00 копеек"; };
	it "181000.00" => sub { is rur2words(181000.00), "сто восемьдесят одна тысяча рублей 00 копеек"; };
	it "182000.00" => sub { is rur2words(182000.00), "сто восемьдесят две тысячи рублей 00 копеек"; };
	it "183000.00" => sub { is rur2words(183000.00), "сто восемьдесят три тысячи рублей 00 копеек"; };
	it "184000.00" => sub { is rur2words(184000.00), "сто восемьдесят четыре тысячи рублей 00 копеек"; };
	it "185000.00" => sub { is rur2words(185000.00), "сто восемьдесят пять тысяч рублей 00 копеек"; };
	it "186000.00" => sub { is rur2words(186000.00), "сто восемьдесят шесть тысяч рублей 00 копеек"; };
	it "187000.00" => sub { is rur2words(187000.00), "сто восемьдесят семь тысяч рублей 00 копеек"; };
	it "188000.00" => sub { is rur2words(188000.00), "сто восемьдесят восемь тысяч рублей 00 копеек"; };
	it "189000.00" => sub { is rur2words(189000.00), "сто восемьдесят девять тысяч рублей 00 копеек"; };
	it "190000.00" => sub { is rur2words(190000.00), "сто девяносто тысяч рублей 00 копеек"; };
	it "191000.00" => sub { is rur2words(191000.00), "сто девяносто одна тысяча рублей 00 копеек"; };
	it "192000.00" => sub { is rur2words(192000.00), "сто девяносто две тысячи рублей 00 копеек"; };
	it "193000.00" => sub { is rur2words(193000.00), "сто девяносто три тысячи рублей 00 копеек"; };
	it "194000.00" => sub { is rur2words(194000.00), "сто девяносто четыре тысячи рублей 00 копеек"; };
	it "195000.00" => sub { is rur2words(195000.00), "сто девяносто пять тысяч рублей 00 копеек"; };
	it "196000.00" => sub { is rur2words(196000.00), "сто девяносто шесть тысяч рублей 00 копеек"; };
	it "197000.00" => sub { is rur2words(197000.00), "сто девяносто семь тысяч рублей 00 копеек"; };
	it "198000.00" => sub { is rur2words(198000.00), "сто девяносто восемь тысяч рублей 00 копеек"; };
	it "199000.00" => sub { is rur2words(199000.00), "сто девяносто девять тысяч рублей 00 копеек"; };
	it "200000.00" => sub { is rur2words(200000.00), "двести тысяч рублей 00 копеек"; };
	it "201000.00" => sub { is rur2words(201000.00), "двести одна тысяча рублей 00 копеек"; };
	it "202000.00" => sub { is rur2words(202000.00), "двести две тысячи рублей 00 копеек"; };
	it "203000.00" => sub { is rur2words(203000.00), "двести три тысячи рублей 00 копеек"; };
	it "204000.00" => sub { is rur2words(204000.00), "двести четыре тысячи рублей 00 копеек"; };
	it "205000.00" => sub { is rur2words(205000.00), "двести пять тысяч рублей 00 копеек"; };
	it "206000.00" => sub { is rur2words(206000.00), "двести шесть тысяч рублей 00 копеек"; };
	it "207000.00" => sub { is rur2words(207000.00), "двести семь тысяч рублей 00 копеек"; };
	it "208000.00" => sub { is rur2words(208000.00), "двести восемь тысяч рублей 00 копеек"; };
	it "209000.00" => sub { is rur2words(209000.00), "двести девять тысяч рублей 00 копеек"; };
	it "210000.00" => sub { is rur2words(210000.00), "двести десять тысяч рублей 00 копеек"; };
	it "211000.00" => sub { is rur2words(211000.00), "двести одиннадцать тысяч рублей 00 копеек"; };
	it "212000.00" => sub { is rur2words(212000.00), "двести двенадцать тысяч рублей 00 копеек"; };
	it "213000.00" => sub { is rur2words(213000.00), "двести тринадцать тысяч рублей 00 копеек"; };
	it "214000.00" => sub { is rur2words(214000.00), "двести четырнадцать тысяч рублей 00 копеек"; };
	it "215000.00" => sub { is rur2words(215000.00), "двести пятнадцать тысяч рублей 00 копеек"; };
	it "216000.00" => sub { is rur2words(216000.00), "двести шестнадцать тысяч рублей 00 копеек"; };
	it "217000.00" => sub { is rur2words(217000.00), "двести семнадцать тысяч рублей 00 копеек"; };
	it "218000.00" => sub { is rur2words(218000.00), "двести восемнадцать тысяч рублей 00 копеек"; };
	it "219000.00" => sub { is rur2words(219000.00), "двести девятнадцать тысяч рублей 00 копеек"; };
	it "220000.00" => sub { is rur2words(220000.00), "двести двадцать тысяч рублей 00 копеек"; };
	it "221000.00" => sub { is rur2words(221000.00), "двести двадцать одна тысяча рублей 00 копеек"; };
	it "222000.00" => sub { is rur2words(222000.00), "двести двадцать две тысячи рублей 00 копеек"; };
	it "223000.00" => sub { is rur2words(223000.00), "двести двадцать три тысячи рублей 00 копеек"; };
	it "224000.00" => sub { is rur2words(224000.00), "двести двадцать четыре тысячи рублей 00 копеек"; };
	it "225000.00" => sub { is rur2words(225000.00), "двести двадцать пять тысяч рублей 00 копеек"; };
	it "226000.00" => sub { is rur2words(226000.00), "двести двадцать шесть тысяч рублей 00 копеек"; };
	it "227000.00" => sub { is rur2words(227000.00), "двести двадцать семь тысяч рублей 00 копеек"; };
	it "228000.00" => sub { is rur2words(228000.00), "двести двадцать восемь тысяч рублей 00 копеек"; };
	it "229000.00" => sub { is rur2words(229000.00), "двести двадцать девять тысяч рублей 00 копеек"; };
	it "230000.00" => sub { is rur2words(230000.00), "двести тридцать тысяч рублей 00 копеек"; };
	it "231000.00" => sub { is rur2words(231000.00), "двести тридцать одна тысяча рублей 00 копеек"; };
	it "232000.00" => sub { is rur2words(232000.00), "двести тридцать две тысячи рублей 00 копеек"; };
	it "233000.00" => sub { is rur2words(233000.00), "двести тридцать три тысячи рублей 00 копеек"; };
	it "234000.00" => sub { is rur2words(234000.00), "двести тридцать четыре тысячи рублей 00 копеек"; };
	it "235000.00" => sub { is rur2words(235000.00), "двести тридцать пять тысяч рублей 00 копеек"; };
	it "236000.00" => sub { is rur2words(236000.00), "двести тридцать шесть тысяч рублей 00 копеек"; };
	it "237000.00" => sub { is rur2words(237000.00), "двести тридцать семь тысяч рублей 00 копеек"; };
	it "238000.00" => sub { is rur2words(238000.00), "двести тридцать восемь тысяч рублей 00 копеек"; };
	it "239000.00" => sub { is rur2words(239000.00), "двести тридцать девять тысяч рублей 00 копеек"; };
	it "240000.00" => sub { is rur2words(240000.00), "двести сорок тысяч рублей 00 копеек"; };
	it "241000.00" => sub { is rur2words(241000.00), "двести сорок одна тысяча рублей 00 копеек"; };
	it "242000.00" => sub { is rur2words(242000.00), "двести сорок две тысячи рублей 00 копеек"; };
	it "243000.00" => sub { is rur2words(243000.00), "двести сорок три тысячи рублей 00 копеек"; };
	it "244000.00" => sub { is rur2words(244000.00), "двести сорок четыре тысячи рублей 00 копеек"; };
	it "245000.00" => sub { is rur2words(245000.00), "двести сорок пять тысяч рублей 00 копеек"; };
	it "246000.00" => sub { is rur2words(246000.00), "двести сорок шесть тысяч рублей 00 копеек"; };
	it "247000.00" => sub { is rur2words(247000.00), "двести сорок семь тысяч рублей 00 копеек"; };
	it "248000.00" => sub { is rur2words(248000.00), "двести сорок восемь тысяч рублей 00 копеек"; };
	it "249000.00" => sub { is rur2words(249000.00), "двести сорок девять тысяч рублей 00 копеек"; };
	it "250000.00" => sub { is rur2words(250000.00), "двести пятьдесят тысяч рублей 00 копеек"; };
	it "251000.00" => sub { is rur2words(251000.00), "двести пятьдесят одна тысяча рублей 00 копеек"; };
	it "252000.00" => sub { is rur2words(252000.00), "двести пятьдесят две тысячи рублей 00 копеек"; };
	it "253000.00" => sub { is rur2words(253000.00), "двести пятьдесят три тысячи рублей 00 копеек"; };
	it "254000.00" => sub { is rur2words(254000.00), "двести пятьдесят четыре тысячи рублей 00 копеек"; };
	it "255000.00" => sub { is rur2words(255000.00), "двести пятьдесят пять тысяч рублей 00 копеек"; };
	it "256000.00" => sub { is rur2words(256000.00), "двести пятьдесят шесть тысяч рублей 00 копеек"; };
	it "257000.00" => sub { is rur2words(257000.00), "двести пятьдесят семь тысяч рублей 00 копеек"; };
	it "258000.00" => sub { is rur2words(258000.00), "двести пятьдесят восемь тысяч рублей 00 копеек"; };
	it "259000.00" => sub { is rur2words(259000.00), "двести пятьдесят девять тысяч рублей 00 копеек"; };
	it "260000.00" => sub { is rur2words(260000.00), "двести шестьдесят тысяч рублей 00 копеек"; };
	it "261000.00" => sub { is rur2words(261000.00), "двести шестьдесят одна тысяча рублей 00 копеек"; };
	it "262000.00" => sub { is rur2words(262000.00), "двести шестьдесят две тысячи рублей 00 копеек"; };
	it "263000.00" => sub { is rur2words(263000.00), "двести шестьдесят три тысячи рублей 00 копеек"; };
	it "264000.00" => sub { is rur2words(264000.00), "двести шестьдесят четыре тысячи рублей 00 копеек"; };
	it "265000.00" => sub { is rur2words(265000.00), "двести шестьдесят пять тысяч рублей 00 копеек"; };
	it "266000.00" => sub { is rur2words(266000.00), "двести шестьдесят шесть тысяч рублей 00 копеек"; };
	it "267000.00" => sub { is rur2words(267000.00), "двести шестьдесят семь тысяч рублей 00 копеек"; };
	it "268000.00" => sub { is rur2words(268000.00), "двести шестьдесят восемь тысяч рублей 00 копеек"; };
	it "269000.00" => sub { is rur2words(269000.00), "двести шестьдесят девять тысяч рублей 00 копеек"; };
	it "270000.00" => sub { is rur2words(270000.00), "двести семьдесят тысяч рублей 00 копеек"; };
	it "271000.00" => sub { is rur2words(271000.00), "двести семьдесят одна тысяча рублей 00 копеек"; };
	it "272000.00" => sub { is rur2words(272000.00), "двести семьдесят две тысячи рублей 00 копеек"; };
	it "273000.00" => sub { is rur2words(273000.00), "двести семьдесят три тысячи рублей 00 копеек"; };
	it "274000.00" => sub { is rur2words(274000.00), "двести семьдесят четыре тысячи рублей 00 копеек"; };
	it "275000.00" => sub { is rur2words(275000.00), "двести семьдесят пять тысяч рублей 00 копеек"; };
	it "276000.00" => sub { is rur2words(276000.00), "двести семьдесят шесть тысяч рублей 00 копеек"; };
	it "277000.00" => sub { is rur2words(277000.00), "двести семьдесят семь тысяч рублей 00 копеек"; };
	it "278000.00" => sub { is rur2words(278000.00), "двести семьдесят восемь тысяч рублей 00 копеек"; };
	it "279000.00" => sub { is rur2words(279000.00), "двести семьдесят девять тысяч рублей 00 копеек"; };
	it "280000.00" => sub { is rur2words(280000.00), "двести восемьдесят тысяч рублей 00 копеек"; };
	it "281000.00" => sub { is rur2words(281000.00), "двести восемьдесят одна тысяча рублей 00 копеек"; };
	it "282000.00" => sub { is rur2words(282000.00), "двести восемьдесят две тысячи рублей 00 копеек"; };
	it "283000.00" => sub { is rur2words(283000.00), "двести восемьдесят три тысячи рублей 00 копеек"; };
	it "284000.00" => sub { is rur2words(284000.00), "двести восемьдесят четыре тысячи рублей 00 копеек"; };
	it "285000.00" => sub { is rur2words(285000.00), "двести восемьдесят пять тысяч рублей 00 копеек"; };
	it "286000.00" => sub { is rur2words(286000.00), "двести восемьдесят шесть тысяч рублей 00 копеек"; };
	it "287000.00" => sub { is rur2words(287000.00), "двести восемьдесят семь тысяч рублей 00 копеек"; };
	it "288000.00" => sub { is rur2words(288000.00), "двести восемьдесят восемь тысяч рублей 00 копеек"; };
	it "289000.00" => sub { is rur2words(289000.00), "двести восемьдесят девять тысяч рублей 00 копеек"; };
	it "290000.00" => sub { is rur2words(290000.00), "двести девяносто тысяч рублей 00 копеек"; };
	it "291000.00" => sub { is rur2words(291000.00), "двести девяносто одна тысяча рублей 00 копеек"; };
	it "292000.00" => sub { is rur2words(292000.00), "двести девяносто две тысячи рублей 00 копеек"; };
	it "293000.00" => sub { is rur2words(293000.00), "двести девяносто три тысячи рублей 00 копеек"; };
	it "294000.00" => sub { is rur2words(294000.00), "двести девяносто четыре тысячи рублей 00 копеек"; };
	it "295000.00" => sub { is rur2words(295000.00), "двести девяносто пять тысяч рублей 00 копеек"; };
	it "296000.00" => sub { is rur2words(296000.00), "двести девяносто шесть тысяч рублей 00 копеек"; };
	it "297000.00" => sub { is rur2words(297000.00), "двести девяносто семь тысяч рублей 00 копеек"; };
	it "298000.00" => sub { is rur2words(298000.00), "двести девяносто восемь тысяч рублей 00 копеек"; };
	it "299000.00" => sub { is rur2words(299000.00), "двести девяносто девять тысяч рублей 00 копеек"; };
	it "300000.00" => sub { is rur2words(300000.00), "триста тысяч рублей 00 копеек"; };
	it "301000.00" => sub { is rur2words(301000.00), "триста одна тысяча рублей 00 копеек"; };
	it "302000.00" => sub { is rur2words(302000.00), "триста две тысячи рублей 00 копеек"; };
	it "303000.00" => sub { is rur2words(303000.00), "триста три тысячи рублей 00 копеек"; };
	it "304000.00" => sub { is rur2words(304000.00), "триста четыре тысячи рублей 00 копеек"; };
	it "305000.00" => sub { is rur2words(305000.00), "триста пять тысяч рублей 00 копеек"; };
	it "306000.00" => sub { is rur2words(306000.00), "триста шесть тысяч рублей 00 копеек"; };
	it "307000.00" => sub { is rur2words(307000.00), "триста семь тысяч рублей 00 копеек"; };
	it "308000.00" => sub { is rur2words(308000.00), "триста восемь тысяч рублей 00 копеек"; };
	it "309000.00" => sub { is rur2words(309000.00), "триста девять тысяч рублей 00 копеек"; };
	it "310000.00" => sub { is rur2words(310000.00), "триста десять тысяч рублей 00 копеек"; };
	it "311000.00" => sub { is rur2words(311000.00), "триста одиннадцать тысяч рублей 00 копеек"; };
	it "312000.00" => sub { is rur2words(312000.00), "триста двенадцать тысяч рублей 00 копеек"; };
	it "313000.00" => sub { is rur2words(313000.00), "триста тринадцать тысяч рублей 00 копеек"; };
	it "314000.00" => sub { is rur2words(314000.00), "триста четырнадцать тысяч рублей 00 копеек"; };
	it "315000.00" => sub { is rur2words(315000.00), "триста пятнадцать тысяч рублей 00 копеек"; };
	it "316000.00" => sub { is rur2words(316000.00), "триста шестнадцать тысяч рублей 00 копеек"; };
	it "317000.00" => sub { is rur2words(317000.00), "триста семнадцать тысяч рублей 00 копеек"; };
	it "318000.00" => sub { is rur2words(318000.00), "триста восемнадцать тысяч рублей 00 копеек"; };
	it "319000.00" => sub { is rur2words(319000.00), "триста девятнадцать тысяч рублей 00 копеек"; };
	it "320000.00" => sub { is rur2words(320000.00), "триста двадцать тысяч рублей 00 копеек"; };
	it "321000.00" => sub { is rur2words(321000.00), "триста двадцать одна тысяча рублей 00 копеек"; };
	it "322000.00" => sub { is rur2words(322000.00), "триста двадцать две тысячи рублей 00 копеек"; };
	it "323000.00" => sub { is rur2words(323000.00), "триста двадцать три тысячи рублей 00 копеек"; };
	it "324000.00" => sub { is rur2words(324000.00), "триста двадцать четыре тысячи рублей 00 копеек"; };
	it "325000.00" => sub { is rur2words(325000.00), "триста двадцать пять тысяч рублей 00 копеек"; };
	it "326000.00" => sub { is rur2words(326000.00), "триста двадцать шесть тысяч рублей 00 копеек"; };
	it "327000.00" => sub { is rur2words(327000.00), "триста двадцать семь тысяч рублей 00 копеек"; };
	it "328000.00" => sub { is rur2words(328000.00), "триста двадцать восемь тысяч рублей 00 копеек"; };
	it "329000.00" => sub { is rur2words(329000.00), "триста двадцать девять тысяч рублей 00 копеек"; };
	it "330000.00" => sub { is rur2words(330000.00), "триста тридцать тысяч рублей 00 копеек"; };
	it "331000.00" => sub { is rur2words(331000.00), "триста тридцать одна тысяча рублей 00 копеек"; };
	it "332000.00" => sub { is rur2words(332000.00), "триста тридцать две тысячи рублей 00 копеек"; };
	it "333000.00" => sub { is rur2words(333000.00), "триста тридцать три тысячи рублей 00 копеек"; };
	it "334000.00" => sub { is rur2words(334000.00), "триста тридцать четыре тысячи рублей 00 копеек"; };
	it "335000.00" => sub { is rur2words(335000.00), "триста тридцать пять тысяч рублей 00 копеек"; };
	it "336000.00" => sub { is rur2words(336000.00), "триста тридцать шесть тысяч рублей 00 копеек"; };
	it "337000.00" => sub { is rur2words(337000.00), "триста тридцать семь тысяч рублей 00 копеек"; };
	it "338000.00" => sub { is rur2words(338000.00), "триста тридцать восемь тысяч рублей 00 копеек"; };
	it "339000.00" => sub { is rur2words(339000.00), "триста тридцать девять тысяч рублей 00 копеек"; };
	it "340000.00" => sub { is rur2words(340000.00), "триста сорок тысяч рублей 00 копеек"; };
	it "341000.00" => sub { is rur2words(341000.00), "триста сорок одна тысяча рублей 00 копеек"; };
	it "342000.00" => sub { is rur2words(342000.00), "триста сорок две тысячи рублей 00 копеек"; };
	it "343000.00" => sub { is rur2words(343000.00), "триста сорок три тысячи рублей 00 копеек"; };
	it "344000.00" => sub { is rur2words(344000.00), "триста сорок четыре тысячи рублей 00 копеек"; };
	it "345000.00" => sub { is rur2words(345000.00), "триста сорок пять тысяч рублей 00 копеек"; };
	it "346000.00" => sub { is rur2words(346000.00), "триста сорок шесть тысяч рублей 00 копеек"; };
	it "347000.00" => sub { is rur2words(347000.00), "триста сорок семь тысяч рублей 00 копеек"; };
	it "348000.00" => sub { is rur2words(348000.00), "триста сорок восемь тысяч рублей 00 копеек"; };
	it "349000.00" => sub { is rur2words(349000.00), "триста сорок девять тысяч рублей 00 копеек"; };
	it "350000.00" => sub { is rur2words(350000.00), "триста пятьдесят тысяч рублей 00 копеек"; };
	it "351000.00" => sub { is rur2words(351000.00), "триста пятьдесят одна тысяча рублей 00 копеек"; };
	it "352000.00" => sub { is rur2words(352000.00), "триста пятьдесят две тысячи рублей 00 копеек"; };
	it "353000.00" => sub { is rur2words(353000.00), "триста пятьдесят три тысячи рублей 00 копеек"; };
	it "354000.00" => sub { is rur2words(354000.00), "триста пятьдесят четыре тысячи рублей 00 копеек"; };
	it "355000.00" => sub { is rur2words(355000.00), "триста пятьдесят пять тысяч рублей 00 копеек"; };
	it "356000.00" => sub { is rur2words(356000.00), "триста пятьдесят шесть тысяч рублей 00 копеек"; };
	it "357000.00" => sub { is rur2words(357000.00), "триста пятьдесят семь тысяч рублей 00 копеек"; };
	it "358000.00" => sub { is rur2words(358000.00), "триста пятьдесят восемь тысяч рублей 00 копеек"; };
	it "359000.00" => sub { is rur2words(359000.00), "триста пятьдесят девять тысяч рублей 00 копеек"; };
	it "360000.00" => sub { is rur2words(360000.00), "триста шестьдесят тысяч рублей 00 копеек"; };
	it "361000.00" => sub { is rur2words(361000.00), "триста шестьдесят одна тысяча рублей 00 копеек"; };
	it "362000.00" => sub { is rur2words(362000.00), "триста шестьдесят две тысячи рублей 00 копеек"; };
	it "363000.00" => sub { is rur2words(363000.00), "триста шестьдесят три тысячи рублей 00 копеек"; };
	it "364000.00" => sub { is rur2words(364000.00), "триста шестьдесят четыре тысячи рублей 00 копеек"; };
	it "365000.00" => sub { is rur2words(365000.00), "триста шестьдесят пять тысяч рублей 00 копеек"; };
	it "366000.00" => sub { is rur2words(366000.00), "триста шестьдесят шесть тысяч рублей 00 копеек"; };
	it "367000.00" => sub { is rur2words(367000.00), "триста шестьдесят семь тысяч рублей 00 копеек"; };
	it "368000.00" => sub { is rur2words(368000.00), "триста шестьдесят восемь тысяч рублей 00 копеек"; };
	it "369000.00" => sub { is rur2words(369000.00), "триста шестьдесят девять тысяч рублей 00 копеек"; };
	it "370000.00" => sub { is rur2words(370000.00), "триста семьдесят тысяч рублей 00 копеек"; };
	it "371000.00" => sub { is rur2words(371000.00), "триста семьдесят одна тысяча рублей 00 копеек"; };
	it "372000.00" => sub { is rur2words(372000.00), "триста семьдесят две тысячи рублей 00 копеек"; };
	it "373000.00" => sub { is rur2words(373000.00), "триста семьдесят три тысячи рублей 00 копеек"; };
	it "374000.00" => sub { is rur2words(374000.00), "триста семьдесят четыре тысячи рублей 00 копеек"; };
	it "375000.00" => sub { is rur2words(375000.00), "триста семьдесят пять тысяч рублей 00 копеек"; };
	it "376000.00" => sub { is rur2words(376000.00), "триста семьдесят шесть тысяч рублей 00 копеек"; };
	it "377000.00" => sub { is rur2words(377000.00), "триста семьдесят семь тысяч рублей 00 копеек"; };
	it "378000.00" => sub { is rur2words(378000.00), "триста семьдесят восемь тысяч рублей 00 копеек"; };
	it "379000.00" => sub { is rur2words(379000.00), "триста семьдесят девять тысяч рублей 00 копеек"; };
	it "380000.00" => sub { is rur2words(380000.00), "триста восемьдесят тысяч рублей 00 копеек"; };
	it "381000.00" => sub { is rur2words(381000.00), "триста восемьдесят одна тысяча рублей 00 копеек"; };
	it "382000.00" => sub { is rur2words(382000.00), "триста восемьдесят две тысячи рублей 00 копеек"; };
	it "383000.00" => sub { is rur2words(383000.00), "триста восемьдесят три тысячи рублей 00 копеек"; };
	it "384000.00" => sub { is rur2words(384000.00), "триста восемьдесят четыре тысячи рублей 00 копеек"; };
	it "385000.00" => sub { is rur2words(385000.00), "триста восемьдесят пять тысяч рублей 00 копеек"; };
	it "386000.00" => sub { is rur2words(386000.00), "триста восемьдесят шесть тысяч рублей 00 копеек"; };
	it "387000.00" => sub { is rur2words(387000.00), "триста восемьдесят семь тысяч рублей 00 копеек"; };
	it "388000.00" => sub { is rur2words(388000.00), "триста восемьдесят восемь тысяч рублей 00 копеек"; };
	it "389000.00" => sub { is rur2words(389000.00), "триста восемьдесят девять тысяч рублей 00 копеек"; };
	it "390000.00" => sub { is rur2words(390000.00), "триста девяносто тысяч рублей 00 копеек"; };
	it "391000.00" => sub { is rur2words(391000.00), "триста девяносто одна тысяча рублей 00 копеек"; };
	it "392000.00" => sub { is rur2words(392000.00), "триста девяносто две тысячи рублей 00 копеек"; };
	it "393000.00" => sub { is rur2words(393000.00), "триста девяносто три тысячи рублей 00 копеек"; };
	it "394000.00" => sub { is rur2words(394000.00), "триста девяносто четыре тысячи рублей 00 копеек"; };
	it "395000.00" => sub { is rur2words(395000.00), "триста девяносто пять тысяч рублей 00 копеек"; };
	it "396000.00" => sub { is rur2words(396000.00), "триста девяносто шесть тысяч рублей 00 копеек"; };
	it "397000.00" => sub { is rur2words(397000.00), "триста девяносто семь тысяч рублей 00 копеек"; };
	it "398000.00" => sub { is rur2words(398000.00), "триста девяносто восемь тысяч рублей 00 копеек"; };
	it "399000.00" => sub { is rur2words(399000.00), "триста девяносто девять тысяч рублей 00 копеек"; };
	it "400000.00" => sub { is rur2words(400000.00), "четыреста тысяч рублей 00 копеек"; };
	it "401000.00" => sub { is rur2words(401000.00), "четыреста одна тысяча рублей 00 копеек"; };
	it "402000.00" => sub { is rur2words(402000.00), "четыреста две тысячи рублей 00 копеек"; };
	it "403000.00" => sub { is rur2words(403000.00), "четыреста три тысячи рублей 00 копеек"; };
	it "404000.00" => sub { is rur2words(404000.00), "четыреста четыре тысячи рублей 00 копеек"; };
	it "405000.00" => sub { is rur2words(405000.00), "четыреста пять тысяч рублей 00 копеек"; };
	it "406000.00" => sub { is rur2words(406000.00), "четыреста шесть тысяч рублей 00 копеек"; };
	it "407000.00" => sub { is rur2words(407000.00), "четыреста семь тысяч рублей 00 копеек"; };
	it "408000.00" => sub { is rur2words(408000.00), "четыреста восемь тысяч рублей 00 копеек"; };
	it "409000.00" => sub { is rur2words(409000.00), "четыреста девять тысяч рублей 00 копеек"; };
	it "410000.00" => sub { is rur2words(410000.00), "четыреста десять тысяч рублей 00 копеек"; };
	it "411000.00" => sub { is rur2words(411000.00), "четыреста одиннадцать тысяч рублей 00 копеек"; };
	it "412000.00" => sub { is rur2words(412000.00), "четыреста двенадцать тысяч рублей 00 копеек"; };
	it "413000.00" => sub { is rur2words(413000.00), "четыреста тринадцать тысяч рублей 00 копеек"; };
	it "414000.00" => sub { is rur2words(414000.00), "четыреста четырнадцать тысяч рублей 00 копеек"; };
	it "415000.00" => sub { is rur2words(415000.00), "четыреста пятнадцать тысяч рублей 00 копеек"; };
	it "416000.00" => sub { is rur2words(416000.00), "четыреста шестнадцать тысяч рублей 00 копеек"; };
	it "417000.00" => sub { is rur2words(417000.00), "четыреста семнадцать тысяч рублей 00 копеек"; };
	it "418000.00" => sub { is rur2words(418000.00), "четыреста восемнадцать тысяч рублей 00 копеек"; };
	it "419000.00" => sub { is rur2words(419000.00), "четыреста девятнадцать тысяч рублей 00 копеек"; };
	it "420000.00" => sub { is rur2words(420000.00), "четыреста двадцать тысяч рублей 00 копеек"; };
	it "421000.00" => sub { is rur2words(421000.00), "четыреста двадцать одна тысяча рублей 00 копеек"; };
	it "422000.00" => sub { is rur2words(422000.00), "четыреста двадцать две тысячи рублей 00 копеек"; };
	it "423000.00" => sub { is rur2words(423000.00), "четыреста двадцать три тысячи рублей 00 копеек"; };
	it "424000.00" => sub { is rur2words(424000.00), "четыреста двадцать четыре тысячи рублей 00 копеек"; };
	it "425000.00" => sub { is rur2words(425000.00), "четыреста двадцать пять тысяч рублей 00 копеек"; };
	it "426000.00" => sub { is rur2words(426000.00), "четыреста двадцать шесть тысяч рублей 00 копеек"; };
	it "427000.00" => sub { is rur2words(427000.00), "четыреста двадцать семь тысяч рублей 00 копеек"; };
	it "428000.00" => sub { is rur2words(428000.00), "четыреста двадцать восемь тысяч рублей 00 копеек"; };
	it "429000.00" => sub { is rur2words(429000.00), "четыреста двадцать девять тысяч рублей 00 копеек"; };
	it "430000.00" => sub { is rur2words(430000.00), "четыреста тридцать тысяч рублей 00 копеек"; };
	it "431000.00" => sub { is rur2words(431000.00), "четыреста тридцать одна тысяча рублей 00 копеек"; };
	it "432000.00" => sub { is rur2words(432000.00), "четыреста тридцать две тысячи рублей 00 копеек"; };
	it "433000.00" => sub { is rur2words(433000.00), "четыреста тридцать три тысячи рублей 00 копеек"; };
	it "434000.00" => sub { is rur2words(434000.00), "четыреста тридцать четыре тысячи рублей 00 копеек"; };
	it "435000.00" => sub { is rur2words(435000.00), "четыреста тридцать пять тысяч рублей 00 копеек"; };
	it "436000.00" => sub { is rur2words(436000.00), "четыреста тридцать шесть тысяч рублей 00 копеек"; };
	it "437000.00" => sub { is rur2words(437000.00), "четыреста тридцать семь тысяч рублей 00 копеек"; };
	it "438000.00" => sub { is rur2words(438000.00), "четыреста тридцать восемь тысяч рублей 00 копеек"; };
	it "439000.00" => sub { is rur2words(439000.00), "четыреста тридцать девять тысяч рублей 00 копеек"; };
	it "440000.00" => sub { is rur2words(440000.00), "четыреста сорок тысяч рублей 00 копеек"; };
	it "441000.00" => sub { is rur2words(441000.00), "четыреста сорок одна тысяча рублей 00 копеек"; };
	it "442000.00" => sub { is rur2words(442000.00), "четыреста сорок две тысячи рублей 00 копеек"; };
	it "443000.00" => sub { is rur2words(443000.00), "четыреста сорок три тысячи рублей 00 копеек"; };
	it "444000.00" => sub { is rur2words(444000.00), "четыреста сорок четыре тысячи рублей 00 копеек"; };
	it "445000.00" => sub { is rur2words(445000.00), "четыреста сорок пять тысяч рублей 00 копеек"; };
	it "446000.00" => sub { is rur2words(446000.00), "четыреста сорок шесть тысяч рублей 00 копеек"; };
	it "447000.00" => sub { is rur2words(447000.00), "четыреста сорок семь тысяч рублей 00 копеек"; };
	it "448000.00" => sub { is rur2words(448000.00), "четыреста сорок восемь тысяч рублей 00 копеек"; };
	it "449000.00" => sub { is rur2words(449000.00), "четыреста сорок девять тысяч рублей 00 копеек"; };
	it "450000.00" => sub { is rur2words(450000.00), "четыреста пятьдесят тысяч рублей 00 копеек"; };
	it "451000.00" => sub { is rur2words(451000.00), "четыреста пятьдесят одна тысяча рублей 00 копеек"; };
	it "452000.00" => sub { is rur2words(452000.00), "четыреста пятьдесят две тысячи рублей 00 копеек"; };
	it "453000.00" => sub { is rur2words(453000.00), "четыреста пятьдесят три тысячи рублей 00 копеек"; };
	it "454000.00" => sub { is rur2words(454000.00), "четыреста пятьдесят четыре тысячи рублей 00 копеек"; };
	it "455000.00" => sub { is rur2words(455000.00), "четыреста пятьдесят пять тысяч рублей 00 копеек"; };
	it "456000.00" => sub { is rur2words(456000.00), "четыреста пятьдесят шесть тысяч рублей 00 копеек"; };
	it "457000.00" => sub { is rur2words(457000.00), "четыреста пятьдесят семь тысяч рублей 00 копеек"; };
	it "458000.00" => sub { is rur2words(458000.00), "четыреста пятьдесят восемь тысяч рублей 00 копеек"; };
	it "459000.00" => sub { is rur2words(459000.00), "четыреста пятьдесят девять тысяч рублей 00 копеек"; };
	it "460000.00" => sub { is rur2words(460000.00), "четыреста шестьдесят тысяч рублей 00 копеек"; };
	it "461000.00" => sub { is rur2words(461000.00), "четыреста шестьдесят одна тысяча рублей 00 копеек"; };
	it "462000.00" => sub { is rur2words(462000.00), "четыреста шестьдесят две тысячи рублей 00 копеек"; };
	it "463000.00" => sub { is rur2words(463000.00), "четыреста шестьдесят три тысячи рублей 00 копеек"; };
	it "464000.00" => sub { is rur2words(464000.00), "четыреста шестьдесят четыре тысячи рублей 00 копеек"; };
	it "465000.00" => sub { is rur2words(465000.00), "четыреста шестьдесят пять тысяч рублей 00 копеек"; };
	it "466000.00" => sub { is rur2words(466000.00), "четыреста шестьдесят шесть тысяч рублей 00 копеек"; };
	it "467000.00" => sub { is rur2words(467000.00), "четыреста шестьдесят семь тысяч рублей 00 копеек"; };
	it "468000.00" => sub { is rur2words(468000.00), "четыреста шестьдесят восемь тысяч рублей 00 копеек"; };
	it "469000.00" => sub { is rur2words(469000.00), "четыреста шестьдесят девять тысяч рублей 00 копеек"; };
	it "470000.00" => sub { is rur2words(470000.00), "четыреста семьдесят тысяч рублей 00 копеек"; };
	it "471000.00" => sub { is rur2words(471000.00), "четыреста семьдесят одна тысяча рублей 00 копеек"; };
	it "472000.00" => sub { is rur2words(472000.00), "четыреста семьдесят две тысячи рублей 00 копеек"; };
	it "473000.00" => sub { is rur2words(473000.00), "четыреста семьдесят три тысячи рублей 00 копеек"; };
	it "474000.00" => sub { is rur2words(474000.00), "четыреста семьдесят четыре тысячи рублей 00 копеек"; };
	it "475000.00" => sub { is rur2words(475000.00), "четыреста семьдесят пять тысяч рублей 00 копеек"; };
	it "476000.00" => sub { is rur2words(476000.00), "четыреста семьдесят шесть тысяч рублей 00 копеек"; };
	it "477000.00" => sub { is rur2words(477000.00), "четыреста семьдесят семь тысяч рублей 00 копеек"; };
	it "478000.00" => sub { is rur2words(478000.00), "четыреста семьдесят восемь тысяч рублей 00 копеек"; };
	it "479000.00" => sub { is rur2words(479000.00), "четыреста семьдесят девять тысяч рублей 00 копеек"; };
	it "480000.00" => sub { is rur2words(480000.00), "четыреста восемьдесят тысяч рублей 00 копеек"; };
	it "481000.00" => sub { is rur2words(481000.00), "четыреста восемьдесят одна тысяча рублей 00 копеек"; };
	it "482000.00" => sub { is rur2words(482000.00), "четыреста восемьдесят две тысячи рублей 00 копеек"; };
	it "483000.00" => sub { is rur2words(483000.00), "четыреста восемьдесят три тысячи рублей 00 копеек"; };
	it "484000.00" => sub { is rur2words(484000.00), "четыреста восемьдесят четыре тысячи рублей 00 копеек"; };
	it "485000.00" => sub { is rur2words(485000.00), "четыреста восемьдесят пять тысяч рублей 00 копеек"; };
	it "486000.00" => sub { is rur2words(486000.00), "четыреста восемьдесят шесть тысяч рублей 00 копеек"; };
	it "487000.00" => sub { is rur2words(487000.00), "четыреста восемьдесят семь тысяч рублей 00 копеек"; };
	it "488000.00" => sub { is rur2words(488000.00), "четыреста восемьдесят восемь тысяч рублей 00 копеек"; };
	it "489000.00" => sub { is rur2words(489000.00), "четыреста восемьдесят девять тысяч рублей 00 копеек"; };
	it "490000.00" => sub { is rur2words(490000.00), "четыреста девяносто тысяч рублей 00 копеек"; };
	it "491000.00" => sub { is rur2words(491000.00), "четыреста девяносто одна тысяча рублей 00 копеек"; };
	it "492000.00" => sub { is rur2words(492000.00), "четыреста девяносто две тысячи рублей 00 копеек"; };
	it "493000.00" => sub { is rur2words(493000.00), "четыреста девяносто три тысячи рублей 00 копеек"; };
	it "494000.00" => sub { is rur2words(494000.00), "четыреста девяносто четыре тысячи рублей 00 копеек"; };
	it "495000.00" => sub { is rur2words(495000.00), "четыреста девяносто пять тысяч рублей 00 копеек"; };
	it "496000.00" => sub { is rur2words(496000.00), "четыреста девяносто шесть тысяч рублей 00 копеек"; };
	it "497000.00" => sub { is rur2words(497000.00), "четыреста девяносто семь тысяч рублей 00 копеек"; };
	it "498000.00" => sub { is rur2words(498000.00), "четыреста девяносто восемь тысяч рублей 00 копеек"; };
	it "499000.00" => sub { is rur2words(499000.00), "четыреста девяносто девять тысяч рублей 00 копеек"; };
	it "500000.00" => sub { is rur2words(500000.00), "пятьсот тысяч рублей 00 копеек"; };
	it "501000.00" => sub { is rur2words(501000.00), "пятьсот одна тысяча рублей 00 копеек"; };
	it "502000.00" => sub { is rur2words(502000.00), "пятьсот две тысячи рублей 00 копеек"; };
	it "503000.00" => sub { is rur2words(503000.00), "пятьсот три тысячи рублей 00 копеек"; };
	it "504000.00" => sub { is rur2words(504000.00), "пятьсот четыре тысячи рублей 00 копеек"; };
	it "505000.00" => sub { is rur2words(505000.00), "пятьсот пять тысяч рублей 00 копеек"; };
	it "506000.00" => sub { is rur2words(506000.00), "пятьсот шесть тысяч рублей 00 копеек"; };
	it "507000.00" => sub { is rur2words(507000.00), "пятьсот семь тысяч рублей 00 копеек"; };
	it "508000.00" => sub { is rur2words(508000.00), "пятьсот восемь тысяч рублей 00 копеек"; };
	it "509000.00" => sub { is rur2words(509000.00), "пятьсот девять тысяч рублей 00 копеек"; };
	it "510000.00" => sub { is rur2words(510000.00), "пятьсот десять тысяч рублей 00 копеек"; };
	it "511000.00" => sub { is rur2words(511000.00), "пятьсот одиннадцать тысяч рублей 00 копеек"; };
	it "512000.00" => sub { is rur2words(512000.00), "пятьсот двенадцать тысяч рублей 00 копеек"; };
	it "513000.00" => sub { is rur2words(513000.00), "пятьсот тринадцать тысяч рублей 00 копеек"; };
	it "514000.00" => sub { is rur2words(514000.00), "пятьсот четырнадцать тысяч рублей 00 копеек"; };
	it "515000.00" => sub { is rur2words(515000.00), "пятьсот пятнадцать тысяч рублей 00 копеек"; };
	it "516000.00" => sub { is rur2words(516000.00), "пятьсот шестнадцать тысяч рублей 00 копеек"; };
	it "517000.00" => sub { is rur2words(517000.00), "пятьсот семнадцать тысяч рублей 00 копеек"; };
	it "518000.00" => sub { is rur2words(518000.00), "пятьсот восемнадцать тысяч рублей 00 копеек"; };
	it "519000.00" => sub { is rur2words(519000.00), "пятьсот девятнадцать тысяч рублей 00 копеек"; };
	it "520000.00" => sub { is rur2words(520000.00), "пятьсот двадцать тысяч рублей 00 копеек"; };
	it "521000.00" => sub { is rur2words(521000.00), "пятьсот двадцать одна тысяча рублей 00 копеек"; };
	it "522000.00" => sub { is rur2words(522000.00), "пятьсот двадцать две тысячи рублей 00 копеек"; };
	it "523000.00" => sub { is rur2words(523000.00), "пятьсот двадцать три тысячи рублей 00 копеек"; };
	it "524000.00" => sub { is rur2words(524000.00), "пятьсот двадцать четыре тысячи рублей 00 копеек"; };
	it "525000.00" => sub { is rur2words(525000.00), "пятьсот двадцать пять тысяч рублей 00 копеек"; };
	it "526000.00" => sub { is rur2words(526000.00), "пятьсот двадцать шесть тысяч рублей 00 копеек"; };
	it "527000.00" => sub { is rur2words(527000.00), "пятьсот двадцать семь тысяч рублей 00 копеек"; };
	it "528000.00" => sub { is rur2words(528000.00), "пятьсот двадцать восемь тысяч рублей 00 копеек"; };
	it "529000.00" => sub { is rur2words(529000.00), "пятьсот двадцать девять тысяч рублей 00 копеек"; };
	it "530000.00" => sub { is rur2words(530000.00), "пятьсот тридцать тысяч рублей 00 копеек"; };
	it "531000.00" => sub { is rur2words(531000.00), "пятьсот тридцать одна тысяча рублей 00 копеек"; };
	it "532000.00" => sub { is rur2words(532000.00), "пятьсот тридцать две тысячи рублей 00 копеек"; };
	it "533000.00" => sub { is rur2words(533000.00), "пятьсот тридцать три тысячи рублей 00 копеек"; };
	it "534000.00" => sub { is rur2words(534000.00), "пятьсот тридцать четыре тысячи рублей 00 копеек"; };
	it "535000.00" => sub { is rur2words(535000.00), "пятьсот тридцать пять тысяч рублей 00 копеек"; };
	it "536000.00" => sub { is rur2words(536000.00), "пятьсот тридцать шесть тысяч рублей 00 копеек"; };
	it "537000.00" => sub { is rur2words(537000.00), "пятьсот тридцать семь тысяч рублей 00 копеек"; };
	it "538000.00" => sub { is rur2words(538000.00), "пятьсот тридцать восемь тысяч рублей 00 копеек"; };
	it "539000.00" => sub { is rur2words(539000.00), "пятьсот тридцать девять тысяч рублей 00 копеек"; };
	it "540000.00" => sub { is rur2words(540000.00), "пятьсот сорок тысяч рублей 00 копеек"; };
	it "541000.00" => sub { is rur2words(541000.00), "пятьсот сорок одна тысяча рублей 00 копеек"; };
	it "542000.00" => sub { is rur2words(542000.00), "пятьсот сорок две тысячи рублей 00 копеек"; };
	it "543000.00" => sub { is rur2words(543000.00), "пятьсот сорок три тысячи рублей 00 копеек"; };
	it "544000.00" => sub { is rur2words(544000.00), "пятьсот сорок четыре тысячи рублей 00 копеек"; };
	it "545000.00" => sub { is rur2words(545000.00), "пятьсот сорок пять тысяч рублей 00 копеек"; };
	it "546000.00" => sub { is rur2words(546000.00), "пятьсот сорок шесть тысяч рублей 00 копеек"; };
	it "547000.00" => sub { is rur2words(547000.00), "пятьсот сорок семь тысяч рублей 00 копеек"; };
	it "548000.00" => sub { is rur2words(548000.00), "пятьсот сорок восемь тысяч рублей 00 копеек"; };
	it "549000.00" => sub { is rur2words(549000.00), "пятьсот сорок девять тысяч рублей 00 копеек"; };
	it "550000.00" => sub { is rur2words(550000.00), "пятьсот пятьдесят тысяч рублей 00 копеек"; };
	it "551000.00" => sub { is rur2words(551000.00), "пятьсот пятьдесят одна тысяча рублей 00 копеек"; };
	it "552000.00" => sub { is rur2words(552000.00), "пятьсот пятьдесят две тысячи рублей 00 копеек"; };
	it "553000.00" => sub { is rur2words(553000.00), "пятьсот пятьдесят три тысячи рублей 00 копеек"; };
	it "554000.00" => sub { is rur2words(554000.00), "пятьсот пятьдесят четыре тысячи рублей 00 копеек"; };
	it "555000.00" => sub { is rur2words(555000.00), "пятьсот пятьдесят пять тысяч рублей 00 копеек"; };
	it "556000.00" => sub { is rur2words(556000.00), "пятьсот пятьдесят шесть тысяч рублей 00 копеек"; };
	it "557000.00" => sub { is rur2words(557000.00), "пятьсот пятьдесят семь тысяч рублей 00 копеек"; };
	it "558000.00" => sub { is rur2words(558000.00), "пятьсот пятьдесят восемь тысяч рублей 00 копеек"; };
	it "559000.00" => sub { is rur2words(559000.00), "пятьсот пятьдесят девять тысяч рублей 00 копеек"; };
	it "560000.00" => sub { is rur2words(560000.00), "пятьсот шестьдесят тысяч рублей 00 копеек"; };
	it "561000.00" => sub { is rur2words(561000.00), "пятьсот шестьдесят одна тысяча рублей 00 копеек"; };
	it "562000.00" => sub { is rur2words(562000.00), "пятьсот шестьдесят две тысячи рублей 00 копеек"; };
	it "563000.00" => sub { is rur2words(563000.00), "пятьсот шестьдесят три тысячи рублей 00 копеек"; };
	it "564000.00" => sub { is rur2words(564000.00), "пятьсот шестьдесят четыре тысячи рублей 00 копеек"; };
	it "565000.00" => sub { is rur2words(565000.00), "пятьсот шестьдесят пять тысяч рублей 00 копеек"; };
	it "566000.00" => sub { is rur2words(566000.00), "пятьсот шестьдесят шесть тысяч рублей 00 копеек"; };
	it "567000.00" => sub { is rur2words(567000.00), "пятьсот шестьдесят семь тысяч рублей 00 копеек"; };
	it "568000.00" => sub { is rur2words(568000.00), "пятьсот шестьдесят восемь тысяч рублей 00 копеек"; };
	it "569000.00" => sub { is rur2words(569000.00), "пятьсот шестьдесят девять тысяч рублей 00 копеек"; };
	it "570000.00" => sub { is rur2words(570000.00), "пятьсот семьдесят тысяч рублей 00 копеек"; };
	it "571000.00" => sub { is rur2words(571000.00), "пятьсот семьдесят одна тысяча рублей 00 копеек"; };
	it "572000.00" => sub { is rur2words(572000.00), "пятьсот семьдесят две тысячи рублей 00 копеек"; };
	it "573000.00" => sub { is rur2words(573000.00), "пятьсот семьдесят три тысячи рублей 00 копеек"; };
	it "574000.00" => sub { is rur2words(574000.00), "пятьсот семьдесят четыре тысячи рублей 00 копеек"; };
	it "575000.00" => sub { is rur2words(575000.00), "пятьсот семьдесят пять тысяч рублей 00 копеек"; };
	it "576000.00" => sub { is rur2words(576000.00), "пятьсот семьдесят шесть тысяч рублей 00 копеек"; };
	it "577000.00" => sub { is rur2words(577000.00), "пятьсот семьдесят семь тысяч рублей 00 копеек"; };
	it "578000.00" => sub { is rur2words(578000.00), "пятьсот семьдесят восемь тысяч рублей 00 копеек"; };
	it "579000.00" => sub { is rur2words(579000.00), "пятьсот семьдесят девять тысяч рублей 00 копеек"; };
	it "580000.00" => sub { is rur2words(580000.00), "пятьсот восемьдесят тысяч рублей 00 копеек"; };
	it "581000.00" => sub { is rur2words(581000.00), "пятьсот восемьдесят одна тысяча рублей 00 копеек"; };
	it "582000.00" => sub { is rur2words(582000.00), "пятьсот восемьдесят две тысячи рублей 00 копеек"; };
	it "583000.00" => sub { is rur2words(583000.00), "пятьсот восемьдесят три тысячи рублей 00 копеек"; };
	it "584000.00" => sub { is rur2words(584000.00), "пятьсот восемьдесят четыре тысячи рублей 00 копеек"; };
	it "585000.00" => sub { is rur2words(585000.00), "пятьсот восемьдесят пять тысяч рублей 00 копеек"; };
	it "586000.00" => sub { is rur2words(586000.00), "пятьсот восемьдесят шесть тысяч рублей 00 копеек"; };
	it "587000.00" => sub { is rur2words(587000.00), "пятьсот восемьдесят семь тысяч рублей 00 копеек"; };
	it "588000.00" => sub { is rur2words(588000.00), "пятьсот восемьдесят восемь тысяч рублей 00 копеек"; };
	it "589000.00" => sub { is rur2words(589000.00), "пятьсот восемьдесят девять тысяч рублей 00 копеек"; };
	it "590000.00" => sub { is rur2words(590000.00), "пятьсот девяносто тысяч рублей 00 копеек"; };
	it "591000.00" => sub { is rur2words(591000.00), "пятьсот девяносто одна тысяча рублей 00 копеек"; };
	it "592000.00" => sub { is rur2words(592000.00), "пятьсот девяносто две тысячи рублей 00 копеек"; };
	it "593000.00" => sub { is rur2words(593000.00), "пятьсот девяносто три тысячи рублей 00 копеек"; };
	it "594000.00" => sub { is rur2words(594000.00), "пятьсот девяносто четыре тысячи рублей 00 копеек"; };
	it "595000.00" => sub { is rur2words(595000.00), "пятьсот девяносто пять тысяч рублей 00 копеек"; };
	it "596000.00" => sub { is rur2words(596000.00), "пятьсот девяносто шесть тысяч рублей 00 копеек"; };
	it "597000.00" => sub { is rur2words(597000.00), "пятьсот девяносто семь тысяч рублей 00 копеек"; };
	it "598000.00" => sub { is rur2words(598000.00), "пятьсот девяносто восемь тысяч рублей 00 копеек"; };
	it "599000.00" => sub { is rur2words(599000.00), "пятьсот девяносто девять тысяч рублей 00 копеек"; };
	it "600000.00" => sub { is rur2words(600000.00), "шестьсот тысяч рублей 00 копеек"; };
	it "601000.00" => sub { is rur2words(601000.00), "шестьсот одна тысяча рублей 00 копеек"; };
	it "602000.00" => sub { is rur2words(602000.00), "шестьсот две тысячи рублей 00 копеек"; };
	it "603000.00" => sub { is rur2words(603000.00), "шестьсот три тысячи рублей 00 копеек"; };
	it "604000.00" => sub { is rur2words(604000.00), "шестьсот четыре тысячи рублей 00 копеек"; };
	it "605000.00" => sub { is rur2words(605000.00), "шестьсот пять тысяч рублей 00 копеек"; };
	it "606000.00" => sub { is rur2words(606000.00), "шестьсот шесть тысяч рублей 00 копеек"; };
	it "607000.00" => sub { is rur2words(607000.00), "шестьсот семь тысяч рублей 00 копеек"; };
	it "608000.00" => sub { is rur2words(608000.00), "шестьсот восемь тысяч рублей 00 копеек"; };
	it "609000.00" => sub { is rur2words(609000.00), "шестьсот девять тысяч рублей 00 копеек"; };
	it "610000.00" => sub { is rur2words(610000.00), "шестьсот десять тысяч рублей 00 копеек"; };
	it "611000.00" => sub { is rur2words(611000.00), "шестьсот одиннадцать тысяч рублей 00 копеек"; };
	it "612000.00" => sub { is rur2words(612000.00), "шестьсот двенадцать тысяч рублей 00 копеек"; };
	it "613000.00" => sub { is rur2words(613000.00), "шестьсот тринадцать тысяч рублей 00 копеек"; };
	it "614000.00" => sub { is rur2words(614000.00), "шестьсот четырнадцать тысяч рублей 00 копеек"; };
	it "615000.00" => sub { is rur2words(615000.00), "шестьсот пятнадцать тысяч рублей 00 копеек"; };
	it "616000.00" => sub { is rur2words(616000.00), "шестьсот шестнадцать тысяч рублей 00 копеек"; };
	it "617000.00" => sub { is rur2words(617000.00), "шестьсот семнадцать тысяч рублей 00 копеек"; };
	it "618000.00" => sub { is rur2words(618000.00), "шестьсот восемнадцать тысяч рублей 00 копеек"; };
	it "619000.00" => sub { is rur2words(619000.00), "шестьсот девятнадцать тысяч рублей 00 копеек"; };
	it "620000.00" => sub { is rur2words(620000.00), "шестьсот двадцать тысяч рублей 00 копеек"; };
	it "621000.00" => sub { is rur2words(621000.00), "шестьсот двадцать одна тысяча рублей 00 копеек"; };
	it "622000.00" => sub { is rur2words(622000.00), "шестьсот двадцать две тысячи рублей 00 копеек"; };
	it "623000.00" => sub { is rur2words(623000.00), "шестьсот двадцать три тысячи рублей 00 копеек"; };
	it "624000.00" => sub { is rur2words(624000.00), "шестьсот двадцать четыре тысячи рублей 00 копеек"; };
	it "625000.00" => sub { is rur2words(625000.00), "шестьсот двадцать пять тысяч рублей 00 копеек"; };
	it "626000.00" => sub { is rur2words(626000.00), "шестьсот двадцать шесть тысяч рублей 00 копеек"; };
	it "627000.00" => sub { is rur2words(627000.00), "шестьсот двадцать семь тысяч рублей 00 копеек"; };
	it "628000.00" => sub { is rur2words(628000.00), "шестьсот двадцать восемь тысяч рублей 00 копеек"; };
	it "629000.00" => sub { is rur2words(629000.00), "шестьсот двадцать девять тысяч рублей 00 копеек"; };
	it "630000.00" => sub { is rur2words(630000.00), "шестьсот тридцать тысяч рублей 00 копеек"; };
	it "631000.00" => sub { is rur2words(631000.00), "шестьсот тридцать одна тысяча рублей 00 копеек"; };
	it "632000.00" => sub { is rur2words(632000.00), "шестьсот тридцать две тысячи рублей 00 копеек"; };
	it "633000.00" => sub { is rur2words(633000.00), "шестьсот тридцать три тысячи рублей 00 копеек"; };
	it "634000.00" => sub { is rur2words(634000.00), "шестьсот тридцать четыре тысячи рублей 00 копеек"; };
	it "635000.00" => sub { is rur2words(635000.00), "шестьсот тридцать пять тысяч рублей 00 копеек"; };
	it "636000.00" => sub { is rur2words(636000.00), "шестьсот тридцать шесть тысяч рублей 00 копеек"; };
	it "637000.00" => sub { is rur2words(637000.00), "шестьсот тридцать семь тысяч рублей 00 копеек"; };
	it "638000.00" => sub { is rur2words(638000.00), "шестьсот тридцать восемь тысяч рублей 00 копеек"; };
	it "639000.00" => sub { is rur2words(639000.00), "шестьсот тридцать девять тысяч рублей 00 копеек"; };
	it "640000.00" => sub { is rur2words(640000.00), "шестьсот сорок тысяч рублей 00 копеек"; };
	it "641000.00" => sub { is rur2words(641000.00), "шестьсот сорок одна тысяча рублей 00 копеек"; };
	it "642000.00" => sub { is rur2words(642000.00), "шестьсот сорок две тысячи рублей 00 копеек"; };
	it "643000.00" => sub { is rur2words(643000.00), "шестьсот сорок три тысячи рублей 00 копеек"; };
	it "644000.00" => sub { is rur2words(644000.00), "шестьсот сорок четыре тысячи рублей 00 копеек"; };
	it "645000.00" => sub { is rur2words(645000.00), "шестьсот сорок пять тысяч рублей 00 копеек"; };
	it "646000.00" => sub { is rur2words(646000.00), "шестьсот сорок шесть тысяч рублей 00 копеек"; };
	it "647000.00" => sub { is rur2words(647000.00), "шестьсот сорок семь тысяч рублей 00 копеек"; };
	it "648000.00" => sub { is rur2words(648000.00), "шестьсот сорок восемь тысяч рублей 00 копеек"; };
	it "649000.00" => sub { is rur2words(649000.00), "шестьсот сорок девять тысяч рублей 00 копеек"; };
	it "650000.00" => sub { is rur2words(650000.00), "шестьсот пятьдесят тысяч рублей 00 копеек"; };
	it "651000.00" => sub { is rur2words(651000.00), "шестьсот пятьдесят одна тысяча рублей 00 копеек"; };
	it "652000.00" => sub { is rur2words(652000.00), "шестьсот пятьдесят две тысячи рублей 00 копеек"; };
	it "653000.00" => sub { is rur2words(653000.00), "шестьсот пятьдесят три тысячи рублей 00 копеек"; };
	it "654000.00" => sub { is rur2words(654000.00), "шестьсот пятьдесят четыре тысячи рублей 00 копеек"; };
	it "655000.00" => sub { is rur2words(655000.00), "шестьсот пятьдесят пять тысяч рублей 00 копеек"; };
	it "656000.00" => sub { is rur2words(656000.00), "шестьсот пятьдесят шесть тысяч рублей 00 копеек"; };
	it "657000.00" => sub { is rur2words(657000.00), "шестьсот пятьдесят семь тысяч рублей 00 копеек"; };
	it "658000.00" => sub { is rur2words(658000.00), "шестьсот пятьдесят восемь тысяч рублей 00 копеек"; };
	it "659000.00" => sub { is rur2words(659000.00), "шестьсот пятьдесят девять тысяч рублей 00 копеек"; };
	it "660000.00" => sub { is rur2words(660000.00), "шестьсот шестьдесят тысяч рублей 00 копеек"; };
	it "661000.00" => sub { is rur2words(661000.00), "шестьсот шестьдесят одна тысяча рублей 00 копеек"; };
	it "662000.00" => sub { is rur2words(662000.00), "шестьсот шестьдесят две тысячи рублей 00 копеек"; };
	it "663000.00" => sub { is rur2words(663000.00), "шестьсот шестьдесят три тысячи рублей 00 копеек"; };
	it "664000.00" => sub { is rur2words(664000.00), "шестьсот шестьдесят четыре тысячи рублей 00 копеек"; };
	it "665000.00" => sub { is rur2words(665000.00), "шестьсот шестьдесят пять тысяч рублей 00 копеек"; };
	it "666000.00" => sub { is rur2words(666000.00), "шестьсот шестьдесят шесть тысяч рублей 00 копеек"; };
	it "667000.00" => sub { is rur2words(667000.00), "шестьсот шестьдесят семь тысяч рублей 00 копеек"; };
	it "668000.00" => sub { is rur2words(668000.00), "шестьсот шестьдесят восемь тысяч рублей 00 копеек"; };
	it "669000.00" => sub { is rur2words(669000.00), "шестьсот шестьдесят девять тысяч рублей 00 копеек"; };
	it "670000.00" => sub { is rur2words(670000.00), "шестьсот семьдесят тысяч рублей 00 копеек"; };
	it "671000.00" => sub { is rur2words(671000.00), "шестьсот семьдесят одна тысяча рублей 00 копеек"; };
	it "672000.00" => sub { is rur2words(672000.00), "шестьсот семьдесят две тысячи рублей 00 копеек"; };
	it "673000.00" => sub { is rur2words(673000.00), "шестьсот семьдесят три тысячи рублей 00 копеек"; };
	it "674000.00" => sub { is rur2words(674000.00), "шестьсот семьдесят четыре тысячи рублей 00 копеек"; };
	it "675000.00" => sub { is rur2words(675000.00), "шестьсот семьдесят пять тысяч рублей 00 копеек"; };
	it "676000.00" => sub { is rur2words(676000.00), "шестьсот семьдесят шесть тысяч рублей 00 копеек"; };
	it "677000.00" => sub { is rur2words(677000.00), "шестьсот семьдесят семь тысяч рублей 00 копеек"; };
	it "678000.00" => sub { is rur2words(678000.00), "шестьсот семьдесят восемь тысяч рублей 00 копеек"; };
	it "679000.00" => sub { is rur2words(679000.00), "шестьсот семьдесят девять тысяч рублей 00 копеек"; };
	it "680000.00" => sub { is rur2words(680000.00), "шестьсот восемьдесят тысяч рублей 00 копеек"; };
	it "681000.00" => sub { is rur2words(681000.00), "шестьсот восемьдесят одна тысяча рублей 00 копеек"; };
	it "682000.00" => sub { is rur2words(682000.00), "шестьсот восемьдесят две тысячи рублей 00 копеек"; };
	it "683000.00" => sub { is rur2words(683000.00), "шестьсот восемьдесят три тысячи рублей 00 копеек"; };
	it "684000.00" => sub { is rur2words(684000.00), "шестьсот восемьдесят четыре тысячи рублей 00 копеек"; };
	it "685000.00" => sub { is rur2words(685000.00), "шестьсот восемьдесят пять тысяч рублей 00 копеек"; };
	it "686000.00" => sub { is rur2words(686000.00), "шестьсот восемьдесят шесть тысяч рублей 00 копеек"; };
	it "687000.00" => sub { is rur2words(687000.00), "шестьсот восемьдесят семь тысяч рублей 00 копеек"; };
	it "688000.00" => sub { is rur2words(688000.00), "шестьсот восемьдесят восемь тысяч рублей 00 копеек"; };
	it "689000.00" => sub { is rur2words(689000.00), "шестьсот восемьдесят девять тысяч рублей 00 копеек"; };
	it "690000.00" => sub { is rur2words(690000.00), "шестьсот девяносто тысяч рублей 00 копеек"; };
	it "691000.00" => sub { is rur2words(691000.00), "шестьсот девяносто одна тысяча рублей 00 копеек"; };
	it "692000.00" => sub { is rur2words(692000.00), "шестьсот девяносто две тысячи рублей 00 копеек"; };
	it "693000.00" => sub { is rur2words(693000.00), "шестьсот девяносто три тысячи рублей 00 копеек"; };
	it "694000.00" => sub { is rur2words(694000.00), "шестьсот девяносто четыре тысячи рублей 00 копеек"; };
	it "695000.00" => sub { is rur2words(695000.00), "шестьсот девяносто пять тысяч рублей 00 копеек"; };
	it "696000.00" => sub { is rur2words(696000.00), "шестьсот девяносто шесть тысяч рублей 00 копеек"; };
	it "697000.00" => sub { is rur2words(697000.00), "шестьсот девяносто семь тысяч рублей 00 копеек"; };
	it "698000.00" => sub { is rur2words(698000.00), "шестьсот девяносто восемь тысяч рублей 00 копеек"; };
	it "699000.00" => sub { is rur2words(699000.00), "шестьсот девяносто девять тысяч рублей 00 копеек"; };
	it "700000.00" => sub { is rur2words(700000.00), "семьсот тысяч рублей 00 копеек"; };
	it "701000.00" => sub { is rur2words(701000.00), "семьсот одна тысяча рублей 00 копеек"; };
	it "702000.00" => sub { is rur2words(702000.00), "семьсот две тысячи рублей 00 копеек"; };
	it "703000.00" => sub { is rur2words(703000.00), "семьсот три тысячи рублей 00 копеек"; };
	it "704000.00" => sub { is rur2words(704000.00), "семьсот четыре тысячи рублей 00 копеек"; };
	it "705000.00" => sub { is rur2words(705000.00), "семьсот пять тысяч рублей 00 копеек"; };
	it "706000.00" => sub { is rur2words(706000.00), "семьсот шесть тысяч рублей 00 копеек"; };
	it "707000.00" => sub { is rur2words(707000.00), "семьсот семь тысяч рублей 00 копеек"; };
	it "708000.00" => sub { is rur2words(708000.00), "семьсот восемь тысяч рублей 00 копеек"; };
	it "709000.00" => sub { is rur2words(709000.00), "семьсот девять тысяч рублей 00 копеек"; };
	it "710000.00" => sub { is rur2words(710000.00), "семьсот десять тысяч рублей 00 копеек"; };
	it "711000.00" => sub { is rur2words(711000.00), "семьсот одиннадцать тысяч рублей 00 копеек"; };
	it "712000.00" => sub { is rur2words(712000.00), "семьсот двенадцать тысяч рублей 00 копеек"; };
	it "713000.00" => sub { is rur2words(713000.00), "семьсот тринадцать тысяч рублей 00 копеек"; };
	it "714000.00" => sub { is rur2words(714000.00), "семьсот четырнадцать тысяч рублей 00 копеек"; };
	it "715000.00" => sub { is rur2words(715000.00), "семьсот пятнадцать тысяч рублей 00 копеек"; };
	it "716000.00" => sub { is rur2words(716000.00), "семьсот шестнадцать тысяч рублей 00 копеек"; };
	it "717000.00" => sub { is rur2words(717000.00), "семьсот семнадцать тысяч рублей 00 копеек"; };
	it "718000.00" => sub { is rur2words(718000.00), "семьсот восемнадцать тысяч рублей 00 копеек"; };
	it "719000.00" => sub { is rur2words(719000.00), "семьсот девятнадцать тысяч рублей 00 копеек"; };
	it "720000.00" => sub { is rur2words(720000.00), "семьсот двадцать тысяч рублей 00 копеек"; };
	it "721000.00" => sub { is rur2words(721000.00), "семьсот двадцать одна тысяча рублей 00 копеек"; };
	it "722000.00" => sub { is rur2words(722000.00), "семьсот двадцать две тысячи рублей 00 копеек"; };
	it "723000.00" => sub { is rur2words(723000.00), "семьсот двадцать три тысячи рублей 00 копеек"; };
	it "724000.00" => sub { is rur2words(724000.00), "семьсот двадцать четыре тысячи рублей 00 копеек"; };
	it "725000.00" => sub { is rur2words(725000.00), "семьсот двадцать пять тысяч рублей 00 копеек"; };
	it "726000.00" => sub { is rur2words(726000.00), "семьсот двадцать шесть тысяч рублей 00 копеек"; };
	it "727000.00" => sub { is rur2words(727000.00), "семьсот двадцать семь тысяч рублей 00 копеек"; };
	it "728000.00" => sub { is rur2words(728000.00), "семьсот двадцать восемь тысяч рублей 00 копеек"; };
	it "729000.00" => sub { is rur2words(729000.00), "семьсот двадцать девять тысяч рублей 00 копеек"; };
	it "730000.00" => sub { is rur2words(730000.00), "семьсот тридцать тысяч рублей 00 копеек"; };
	it "731000.00" => sub { is rur2words(731000.00), "семьсот тридцать одна тысяча рублей 00 копеек"; };
	it "732000.00" => sub { is rur2words(732000.00), "семьсот тридцать две тысячи рублей 00 копеек"; };
	it "733000.00" => sub { is rur2words(733000.00), "семьсот тридцать три тысячи рублей 00 копеек"; };
	it "734000.00" => sub { is rur2words(734000.00), "семьсот тридцать четыре тысячи рублей 00 копеек"; };
	it "735000.00" => sub { is rur2words(735000.00), "семьсот тридцать пять тысяч рублей 00 копеек"; };
	it "736000.00" => sub { is rur2words(736000.00), "семьсот тридцать шесть тысяч рублей 00 копеек"; };
	it "737000.00" => sub { is rur2words(737000.00), "семьсот тридцать семь тысяч рублей 00 копеек"; };
	it "738000.00" => sub { is rur2words(738000.00), "семьсот тридцать восемь тысяч рублей 00 копеек"; };
	it "739000.00" => sub { is rur2words(739000.00), "семьсот тридцать девять тысяч рублей 00 копеек"; };
	it "740000.00" => sub { is rur2words(740000.00), "семьсот сорок тысяч рублей 00 копеек"; };
	it "741000.00" => sub { is rur2words(741000.00), "семьсот сорок одна тысяча рублей 00 копеек"; };
	it "742000.00" => sub { is rur2words(742000.00), "семьсот сорок две тысячи рублей 00 копеек"; };
	it "743000.00" => sub { is rur2words(743000.00), "семьсот сорок три тысячи рублей 00 копеек"; };
	it "744000.00" => sub { is rur2words(744000.00), "семьсот сорок четыре тысячи рублей 00 копеек"; };
	it "745000.00" => sub { is rur2words(745000.00), "семьсот сорок пять тысяч рублей 00 копеек"; };
	it "746000.00" => sub { is rur2words(746000.00), "семьсот сорок шесть тысяч рублей 00 копеек"; };
	it "747000.00" => sub { is rur2words(747000.00), "семьсот сорок семь тысяч рублей 00 копеек"; };
	it "748000.00" => sub { is rur2words(748000.00), "семьсот сорок восемь тысяч рублей 00 копеек"; };
	it "749000.00" => sub { is rur2words(749000.00), "семьсот сорок девять тысяч рублей 00 копеек"; };
	it "750000.00" => sub { is rur2words(750000.00), "семьсот пятьдесят тысяч рублей 00 копеек"; };
	it "751000.00" => sub { is rur2words(751000.00), "семьсот пятьдесят одна тысяча рублей 00 копеек"; };
	it "752000.00" => sub { is rur2words(752000.00), "семьсот пятьдесят две тысячи рублей 00 копеек"; };
	it "753000.00" => sub { is rur2words(753000.00), "семьсот пятьдесят три тысячи рублей 00 копеек"; };
	it "754000.00" => sub { is rur2words(754000.00), "семьсот пятьдесят четыре тысячи рублей 00 копеек"; };
	it "755000.00" => sub { is rur2words(755000.00), "семьсот пятьдесят пять тысяч рублей 00 копеек"; };
	it "756000.00" => sub { is rur2words(756000.00), "семьсот пятьдесят шесть тысяч рублей 00 копеек"; };
	it "757000.00" => sub { is rur2words(757000.00), "семьсот пятьдесят семь тысяч рублей 00 копеек"; };
	it "758000.00" => sub { is rur2words(758000.00), "семьсот пятьдесят восемь тысяч рублей 00 копеек"; };
	it "759000.00" => sub { is rur2words(759000.00), "семьсот пятьдесят девять тысяч рублей 00 копеек"; };
	it "760000.00" => sub { is rur2words(760000.00), "семьсот шестьдесят тысяч рублей 00 копеек"; };
	it "761000.00" => sub { is rur2words(761000.00), "семьсот шестьдесят одна тысяча рублей 00 копеек"; };
	it "762000.00" => sub { is rur2words(762000.00), "семьсот шестьдесят две тысячи рублей 00 копеек"; };
	it "763000.00" => sub { is rur2words(763000.00), "семьсот шестьдесят три тысячи рублей 00 копеек"; };
	it "764000.00" => sub { is rur2words(764000.00), "семьсот шестьдесят четыре тысячи рублей 00 копеек"; };
	it "765000.00" => sub { is rur2words(765000.00), "семьсот шестьдесят пять тысяч рублей 00 копеек"; };
	it "766000.00" => sub { is rur2words(766000.00), "семьсот шестьдесят шесть тысяч рублей 00 копеек"; };
	it "767000.00" => sub { is rur2words(767000.00), "семьсот шестьдесят семь тысяч рублей 00 копеек"; };
	it "768000.00" => sub { is rur2words(768000.00), "семьсот шестьдесят восемь тысяч рублей 00 копеек"; };
	it "769000.00" => sub { is rur2words(769000.00), "семьсот шестьдесят девять тысяч рублей 00 копеек"; };
	it "770000.00" => sub { is rur2words(770000.00), "семьсот семьдесят тысяч рублей 00 копеек"; };
	it "771000.00" => sub { is rur2words(771000.00), "семьсот семьдесят одна тысяча рублей 00 копеек"; };
	it "772000.00" => sub { is rur2words(772000.00), "семьсот семьдесят две тысячи рублей 00 копеек"; };
	it "773000.00" => sub { is rur2words(773000.00), "семьсот семьдесят три тысячи рублей 00 копеек"; };
	it "774000.00" => sub { is rur2words(774000.00), "семьсот семьдесят четыре тысячи рублей 00 копеек"; };
	it "775000.00" => sub { is rur2words(775000.00), "семьсот семьдесят пять тысяч рублей 00 копеек"; };
	it "776000.00" => sub { is rur2words(776000.00), "семьсот семьдесят шесть тысяч рублей 00 копеек"; };
	it "777000.00" => sub { is rur2words(777000.00), "семьсот семьдесят семь тысяч рублей 00 копеек"; };
	it "778000.00" => sub { is rur2words(778000.00), "семьсот семьдесят восемь тысяч рублей 00 копеек"; };
	it "779000.00" => sub { is rur2words(779000.00), "семьсот семьдесят девять тысяч рублей 00 копеек"; };
	it "780000.00" => sub { is rur2words(780000.00), "семьсот восемьдесят тысяч рублей 00 копеек"; };
	it "781000.00" => sub { is rur2words(781000.00), "семьсот восемьдесят одна тысяча рублей 00 копеек"; };
	it "782000.00" => sub { is rur2words(782000.00), "семьсот восемьдесят две тысячи рублей 00 копеек"; };
	it "783000.00" => sub { is rur2words(783000.00), "семьсот восемьдесят три тысячи рублей 00 копеек"; };
	it "784000.00" => sub { is rur2words(784000.00), "семьсот восемьдесят четыре тысячи рублей 00 копеек"; };
	it "785000.00" => sub { is rur2words(785000.00), "семьсот восемьдесят пять тысяч рублей 00 копеек"; };
	it "786000.00" => sub { is rur2words(786000.00), "семьсот восемьдесят шесть тысяч рублей 00 копеек"; };
	it "787000.00" => sub { is rur2words(787000.00), "семьсот восемьдесят семь тысяч рублей 00 копеек"; };
	it "788000.00" => sub { is rur2words(788000.00), "семьсот восемьдесят восемь тысяч рублей 00 копеек"; };
	it "789000.00" => sub { is rur2words(789000.00), "семьсот восемьдесят девять тысяч рублей 00 копеек"; };
	it "790000.00" => sub { is rur2words(790000.00), "семьсот девяносто тысяч рублей 00 копеек"; };
	it "791000.00" => sub { is rur2words(791000.00), "семьсот девяносто одна тысяча рублей 00 копеек"; };
	it "792000.00" => sub { is rur2words(792000.00), "семьсот девяносто две тысячи рублей 00 копеек"; };
	it "793000.00" => sub { is rur2words(793000.00), "семьсот девяносто три тысячи рублей 00 копеек"; };
	it "794000.00" => sub { is rur2words(794000.00), "семьсот девяносто четыре тысячи рублей 00 копеек"; };
	it "795000.00" => sub { is rur2words(795000.00), "семьсот девяносто пять тысяч рублей 00 копеек"; };
	it "796000.00" => sub { is rur2words(796000.00), "семьсот девяносто шесть тысяч рублей 00 копеек"; };
	it "797000.00" => sub { is rur2words(797000.00), "семьсот девяносто семь тысяч рублей 00 копеек"; };
	it "798000.00" => sub { is rur2words(798000.00), "семьсот девяносто восемь тысяч рублей 00 копеек"; };
	it "799000.00" => sub { is rur2words(799000.00), "семьсот девяносто девять тысяч рублей 00 копеек"; };
	it "800000.00" => sub { is rur2words(800000.00), "восемьсот тысяч рублей 00 копеек"; };
	it "801000.00" => sub { is rur2words(801000.00), "восемьсот одна тысяча рублей 00 копеек"; };
	it "802000.00" => sub { is rur2words(802000.00), "восемьсот две тысячи рублей 00 копеек"; };
	it "803000.00" => sub { is rur2words(803000.00), "восемьсот три тысячи рублей 00 копеек"; };
	it "804000.00" => sub { is rur2words(804000.00), "восемьсот четыре тысячи рублей 00 копеек"; };
	it "805000.00" => sub { is rur2words(805000.00), "восемьсот пять тысяч рублей 00 копеек"; };
	it "806000.00" => sub { is rur2words(806000.00), "восемьсот шесть тысяч рублей 00 копеек"; };
	it "807000.00" => sub { is rur2words(807000.00), "восемьсот семь тысяч рублей 00 копеек"; };
	it "808000.00" => sub { is rur2words(808000.00), "восемьсот восемь тысяч рублей 00 копеек"; };
	it "809000.00" => sub { is rur2words(809000.00), "восемьсот девять тысяч рублей 00 копеек"; };
	it "810000.00" => sub { is rur2words(810000.00), "восемьсот десять тысяч рублей 00 копеек"; };
	it "811000.00" => sub { is rur2words(811000.00), "восемьсот одиннадцать тысяч рублей 00 копеек"; };
	it "812000.00" => sub { is rur2words(812000.00), "восемьсот двенадцать тысяч рублей 00 копеек"; };
	it "813000.00" => sub { is rur2words(813000.00), "восемьсот тринадцать тысяч рублей 00 копеек"; };
	it "814000.00" => sub { is rur2words(814000.00), "восемьсот четырнадцать тысяч рублей 00 копеек"; };
	it "815000.00" => sub { is rur2words(815000.00), "восемьсот пятнадцать тысяч рублей 00 копеек"; };
	it "816000.00" => sub { is rur2words(816000.00), "восемьсот шестнадцать тысяч рублей 00 копеек"; };
	it "817000.00" => sub { is rur2words(817000.00), "восемьсот семнадцать тысяч рублей 00 копеек"; };
	it "818000.00" => sub { is rur2words(818000.00), "восемьсот восемнадцать тысяч рублей 00 копеек"; };
	it "819000.00" => sub { is rur2words(819000.00), "восемьсот девятнадцать тысяч рублей 00 копеек"; };
	it "820000.00" => sub { is rur2words(820000.00), "восемьсот двадцать тысяч рублей 00 копеек"; };
	it "821000.00" => sub { is rur2words(821000.00), "восемьсот двадцать одна тысяча рублей 00 копеек"; };
	it "822000.00" => sub { is rur2words(822000.00), "восемьсот двадцать две тысячи рублей 00 копеек"; };
	it "823000.00" => sub { is rur2words(823000.00), "восемьсот двадцать три тысячи рублей 00 копеек"; };
	it "824000.00" => sub { is rur2words(824000.00), "восемьсот двадцать четыре тысячи рублей 00 копеек"; };
	it "825000.00" => sub { is rur2words(825000.00), "восемьсот двадцать пять тысяч рублей 00 копеек"; };
	it "826000.00" => sub { is rur2words(826000.00), "восемьсот двадцать шесть тысяч рублей 00 копеек"; };
	it "827000.00" => sub { is rur2words(827000.00), "восемьсот двадцать семь тысяч рублей 00 копеек"; };
	it "828000.00" => sub { is rur2words(828000.00), "восемьсот двадцать восемь тысяч рублей 00 копеек"; };
	it "829000.00" => sub { is rur2words(829000.00), "восемьсот двадцать девять тысяч рублей 00 копеек"; };
	it "830000.00" => sub { is rur2words(830000.00), "восемьсот тридцать тысяч рублей 00 копеек"; };
	it "831000.00" => sub { is rur2words(831000.00), "восемьсот тридцать одна тысяча рублей 00 копеек"; };
	it "832000.00" => sub { is rur2words(832000.00), "восемьсот тридцать две тысячи рублей 00 копеек"; };
	it "833000.00" => sub { is rur2words(833000.00), "восемьсот тридцать три тысячи рублей 00 копеек"; };
	it "834000.00" => sub { is rur2words(834000.00), "восемьсот тридцать четыре тысячи рублей 00 копеек"; };
	it "835000.00" => sub { is rur2words(835000.00), "восемьсот тридцать пять тысяч рублей 00 копеек"; };
	it "836000.00" => sub { is rur2words(836000.00), "восемьсот тридцать шесть тысяч рублей 00 копеек"; };
	it "837000.00" => sub { is rur2words(837000.00), "восемьсот тридцать семь тысяч рублей 00 копеек"; };
	it "838000.00" => sub { is rur2words(838000.00), "восемьсот тридцать восемь тысяч рублей 00 копеек"; };
	it "839000.00" => sub { is rur2words(839000.00), "восемьсот тридцать девять тысяч рублей 00 копеек"; };
	it "840000.00" => sub { is rur2words(840000.00), "восемьсот сорок тысяч рублей 00 копеек"; };
	it "841000.00" => sub { is rur2words(841000.00), "восемьсот сорок одна тысяча рублей 00 копеек"; };
	it "842000.00" => sub { is rur2words(842000.00), "восемьсот сорок две тысячи рублей 00 копеек"; };
	it "843000.00" => sub { is rur2words(843000.00), "восемьсот сорок три тысячи рублей 00 копеек"; };
	it "844000.00" => sub { is rur2words(844000.00), "восемьсот сорок четыре тысячи рублей 00 копеек"; };
	it "845000.00" => sub { is rur2words(845000.00), "восемьсот сорок пять тысяч рублей 00 копеек"; };
	it "846000.00" => sub { is rur2words(846000.00), "восемьсот сорок шесть тысяч рублей 00 копеек"; };
	it "847000.00" => sub { is rur2words(847000.00), "восемьсот сорок семь тысяч рублей 00 копеек"; };
	it "848000.00" => sub { is rur2words(848000.00), "восемьсот сорок восемь тысяч рублей 00 копеек"; };
	it "849000.00" => sub { is rur2words(849000.00), "восемьсот сорок девять тысяч рублей 00 копеек"; };
	it "850000.00" => sub { is rur2words(850000.00), "восемьсот пятьдесят тысяч рублей 00 копеек"; };
	it "851000.00" => sub { is rur2words(851000.00), "восемьсот пятьдесят одна тысяча рублей 00 копеек"; };
	it "852000.00" => sub { is rur2words(852000.00), "восемьсот пятьдесят две тысячи рублей 00 копеек"; };
	it "853000.00" => sub { is rur2words(853000.00), "восемьсот пятьдесят три тысячи рублей 00 копеек"; };
	it "854000.00" => sub { is rur2words(854000.00), "восемьсот пятьдесят четыре тысячи рублей 00 копеек"; };
	it "855000.00" => sub { is rur2words(855000.00), "восемьсот пятьдесят пять тысяч рублей 00 копеек"; };
	it "856000.00" => sub { is rur2words(856000.00), "восемьсот пятьдесят шесть тысяч рублей 00 копеек"; };
	it "857000.00" => sub { is rur2words(857000.00), "восемьсот пятьдесят семь тысяч рублей 00 копеек"; };
	it "858000.00" => sub { is rur2words(858000.00), "восемьсот пятьдесят восемь тысяч рублей 00 копеек"; };
	it "859000.00" => sub { is rur2words(859000.00), "восемьсот пятьдесят девять тысяч рублей 00 копеек"; };
	it "860000.00" => sub { is rur2words(860000.00), "восемьсот шестьдесят тысяч рублей 00 копеек"; };
	it "861000.00" => sub { is rur2words(861000.00), "восемьсот шестьдесят одна тысяча рублей 00 копеек"; };
	it "862000.00" => sub { is rur2words(862000.00), "восемьсот шестьдесят две тысячи рублей 00 копеек"; };
	it "863000.00" => sub { is rur2words(863000.00), "восемьсот шестьдесят три тысячи рублей 00 копеек"; };
	it "864000.00" => sub { is rur2words(864000.00), "восемьсот шестьдесят четыре тысячи рублей 00 копеек"; };
	it "865000.00" => sub { is rur2words(865000.00), "восемьсот шестьдесят пять тысяч рублей 00 копеек"; };
	it "866000.00" => sub { is rur2words(866000.00), "восемьсот шестьдесят шесть тысяч рублей 00 копеек"; };
	it "867000.00" => sub { is rur2words(867000.00), "восемьсот шестьдесят семь тысяч рублей 00 копеек"; };
	it "868000.00" => sub { is rur2words(868000.00), "восемьсот шестьдесят восемь тысяч рублей 00 копеек"; };
	it "869000.00" => sub { is rur2words(869000.00), "восемьсот шестьдесят девять тысяч рублей 00 копеек"; };
	it "870000.00" => sub { is rur2words(870000.00), "восемьсот семьдесят тысяч рублей 00 копеек"; };
	it "871000.00" => sub { is rur2words(871000.00), "восемьсот семьдесят одна тысяча рублей 00 копеек"; };
	it "872000.00" => sub { is rur2words(872000.00), "восемьсот семьдесят две тысячи рублей 00 копеек"; };
	it "873000.00" => sub { is rur2words(873000.00), "восемьсот семьдесят три тысячи рублей 00 копеек"; };
	it "874000.00" => sub { is rur2words(874000.00), "восемьсот семьдесят четыре тысячи рублей 00 копеек"; };
	it "875000.00" => sub { is rur2words(875000.00), "восемьсот семьдесят пять тысяч рублей 00 копеек"; };
	it "876000.00" => sub { is rur2words(876000.00), "восемьсот семьдесят шесть тысяч рублей 00 копеек"; };
	it "877000.00" => sub { is rur2words(877000.00), "восемьсот семьдесят семь тысяч рублей 00 копеек"; };
	it "878000.00" => sub { is rur2words(878000.00), "восемьсот семьдесят восемь тысяч рублей 00 копеек"; };
	it "879000.00" => sub { is rur2words(879000.00), "восемьсот семьдесят девять тысяч рублей 00 копеек"; };
	it "880000.00" => sub { is rur2words(880000.00), "восемьсот восемьдесят тысяч рублей 00 копеек"; };
	it "881000.00" => sub { is rur2words(881000.00), "восемьсот восемьдесят одна тысяча рублей 00 копеек"; };
	it "882000.00" => sub { is rur2words(882000.00), "восемьсот восемьдесят две тысячи рублей 00 копеек"; };
	it "883000.00" => sub { is rur2words(883000.00), "восемьсот восемьдесят три тысячи рублей 00 копеек"; };
	it "884000.00" => sub { is rur2words(884000.00), "восемьсот восемьдесят четыре тысячи рублей 00 копеек"; };
	it "885000.00" => sub { is rur2words(885000.00), "восемьсот восемьдесят пять тысяч рублей 00 копеек"; };
	it "886000.00" => sub { is rur2words(886000.00), "восемьсот восемьдесят шесть тысяч рублей 00 копеек"; };
	it "887000.00" => sub { is rur2words(887000.00), "восемьсот восемьдесят семь тысяч рублей 00 копеек"; };
	it "888000.00" => sub { is rur2words(888000.00), "восемьсот восемьдесят восемь тысяч рублей 00 копеек"; };
	it "889000.00" => sub { is rur2words(889000.00), "восемьсот восемьдесят девять тысяч рублей 00 копеек"; };
	it "890000.00" => sub { is rur2words(890000.00), "восемьсот девяносто тысяч рублей 00 копеек"; };
	it "891000.00" => sub { is rur2words(891000.00), "восемьсот девяносто одна тысяча рублей 00 копеек"; };
	it "892000.00" => sub { is rur2words(892000.00), "восемьсот девяносто две тысячи рублей 00 копеек"; };
	it "893000.00" => sub { is rur2words(893000.00), "восемьсот девяносто три тысячи рублей 00 копеек"; };
	it "894000.00" => sub { is rur2words(894000.00), "восемьсот девяносто четыре тысячи рублей 00 копеек"; };
	it "895000.00" => sub { is rur2words(895000.00), "восемьсот девяносто пять тысяч рублей 00 копеек"; };
	it "896000.00" => sub { is rur2words(896000.00), "восемьсот девяносто шесть тысяч рублей 00 копеек"; };
	it "897000.00" => sub { is rur2words(897000.00), "восемьсот девяносто семь тысяч рублей 00 копеек"; };
	it "898000.00" => sub { is rur2words(898000.00), "восемьсот девяносто восемь тысяч рублей 00 копеек"; };
	it "899000.00" => sub { is rur2words(899000.00), "восемьсот девяносто девять тысяч рублей 00 копеек"; };
	it "900000.00" => sub { is rur2words(900000.00), "девятьсот тысяч рублей 00 копеек"; };
	it "901000.00" => sub { is rur2words(901000.00), "девятьсот одна тысяча рублей 00 копеек"; };
	it "902000.00" => sub { is rur2words(902000.00), "девятьсот две тысячи рублей 00 копеек"; };
	it "903000.00" => sub { is rur2words(903000.00), "девятьсот три тысячи рублей 00 копеек"; };
	it "904000.00" => sub { is rur2words(904000.00), "девятьсот четыре тысячи рублей 00 копеек"; };
	it "905000.00" => sub { is rur2words(905000.00), "девятьсот пять тысяч рублей 00 копеек"; };
	it "906000.00" => sub { is rur2words(906000.00), "девятьсот шесть тысяч рублей 00 копеек"; };
	it "907000.00" => sub { is rur2words(907000.00), "девятьсот семь тысяч рублей 00 копеек"; };
	it "908000.00" => sub { is rur2words(908000.00), "девятьсот восемь тысяч рублей 00 копеек"; };
	it "909000.00" => sub { is rur2words(909000.00), "девятьсот девять тысяч рублей 00 копеек"; };
	it "910000.00" => sub { is rur2words(910000.00), "девятьсот десять тысяч рублей 00 копеек"; };
	it "911000.00" => sub { is rur2words(911000.00), "девятьсот одиннадцать тысяч рублей 00 копеек"; };
	it "912000.00" => sub { is rur2words(912000.00), "девятьсот двенадцать тысяч рублей 00 копеек"; };
	it "913000.00" => sub { is rur2words(913000.00), "девятьсот тринадцать тысяч рублей 00 копеек"; };
	it "914000.00" => sub { is rur2words(914000.00), "девятьсот четырнадцать тысяч рублей 00 копеек"; };
	it "915000.00" => sub { is rur2words(915000.00), "девятьсот пятнадцать тысяч рублей 00 копеек"; };
	it "916000.00" => sub { is rur2words(916000.00), "девятьсот шестнадцать тысяч рублей 00 копеек"; };
	it "917000.00" => sub { is rur2words(917000.00), "девятьсот семнадцать тысяч рублей 00 копеек"; };
	it "918000.00" => sub { is rur2words(918000.00), "девятьсот восемнадцать тысяч рублей 00 копеек"; };
	it "919000.00" => sub { is rur2words(919000.00), "девятьсот девятнадцать тысяч рублей 00 копеек"; };
	it "920000.00" => sub { is rur2words(920000.00), "девятьсот двадцать тысяч рублей 00 копеек"; };
	it "921000.00" => sub { is rur2words(921000.00), "девятьсот двадцать одна тысяча рублей 00 копеек"; };
	it "922000.00" => sub { is rur2words(922000.00), "девятьсот двадцать две тысячи рублей 00 копеек"; };
	it "923000.00" => sub { is rur2words(923000.00), "девятьсот двадцать три тысячи рублей 00 копеек"; };
	it "924000.00" => sub { is rur2words(924000.00), "девятьсот двадцать четыре тысячи рублей 00 копеек"; };
	it "925000.00" => sub { is rur2words(925000.00), "девятьсот двадцать пять тысяч рублей 00 копеек"; };
	it "926000.00" => sub { is rur2words(926000.00), "девятьсот двадцать шесть тысяч рублей 00 копеек"; };
	it "927000.00" => sub { is rur2words(927000.00), "девятьсот двадцать семь тысяч рублей 00 копеек"; };
	it "928000.00" => sub { is rur2words(928000.00), "девятьсот двадцать восемь тысяч рублей 00 копеек"; };
	it "929000.00" => sub { is rur2words(929000.00), "девятьсот двадцать девять тысяч рублей 00 копеек"; };
	it "930000.00" => sub { is rur2words(930000.00), "девятьсот тридцать тысяч рублей 00 копеек"; };
	it "931000.00" => sub { is rur2words(931000.00), "девятьсот тридцать одна тысяча рублей 00 копеек"; };
	it "932000.00" => sub { is rur2words(932000.00), "девятьсот тридцать две тысячи рублей 00 копеек"; };
	it "933000.00" => sub { is rur2words(933000.00), "девятьсот тридцать три тысячи рублей 00 копеек"; };
	it "934000.00" => sub { is rur2words(934000.00), "девятьсот тридцать четыре тысячи рублей 00 копеек"; };
	it "935000.00" => sub { is rur2words(935000.00), "девятьсот тридцать пять тысяч рублей 00 копеек"; };
	it "936000.00" => sub { is rur2words(936000.00), "девятьсот тридцать шесть тысяч рублей 00 копеек"; };
	it "937000.00" => sub { is rur2words(937000.00), "девятьсот тридцать семь тысяч рублей 00 копеек"; };
	it "938000.00" => sub { is rur2words(938000.00), "девятьсот тридцать восемь тысяч рублей 00 копеек"; };
	it "939000.00" => sub { is rur2words(939000.00), "девятьсот тридцать девять тысяч рублей 00 копеек"; };
	it "940000.00" => sub { is rur2words(940000.00), "девятьсот сорок тысяч рублей 00 копеек"; };
	it "941000.00" => sub { is rur2words(941000.00), "девятьсот сорок одна тысяча рублей 00 копеек"; };
	it "942000.00" => sub { is rur2words(942000.00), "девятьсот сорок две тысячи рублей 00 копеек"; };
	it "943000.00" => sub { is rur2words(943000.00), "девятьсот сорок три тысячи рублей 00 копеек"; };
	it "944000.00" => sub { is rur2words(944000.00), "девятьсот сорок четыре тысячи рублей 00 копеек"; };
	it "945000.00" => sub { is rur2words(945000.00), "девятьсот сорок пять тысяч рублей 00 копеек"; };
	it "946000.00" => sub { is rur2words(946000.00), "девятьсот сорок шесть тысяч рублей 00 копеек"; };
	it "947000.00" => sub { is rur2words(947000.00), "девятьсот сорок семь тысяч рублей 00 копеек"; };
	it "948000.00" => sub { is rur2words(948000.00), "девятьсот сорок восемь тысяч рублей 00 копеек"; };
	it "949000.00" => sub { is rur2words(949000.00), "девятьсот сорок девять тысяч рублей 00 копеек"; };
	it "950000.00" => sub { is rur2words(950000.00), "девятьсот пятьдесят тысяч рублей 00 копеек"; };
	it "951000.00" => sub { is rur2words(951000.00), "девятьсот пятьдесят одна тысяча рублей 00 копеек"; };
	it "952000.00" => sub { is rur2words(952000.00), "девятьсот пятьдесят две тысячи рублей 00 копеек"; };
	it "953000.00" => sub { is rur2words(953000.00), "девятьсот пятьдесят три тысячи рублей 00 копеек"; };
	it "954000.00" => sub { is rur2words(954000.00), "девятьсот пятьдесят четыре тысячи рублей 00 копеек"; };
	it "955000.00" => sub { is rur2words(955000.00), "девятьсот пятьдесят пять тысяч рублей 00 копеек"; };
	it "956000.00" => sub { is rur2words(956000.00), "девятьсот пятьдесят шесть тысяч рублей 00 копеек"; };
	it "957000.00" => sub { is rur2words(957000.00), "девятьсот пятьдесят семь тысяч рублей 00 копеек"; };
	it "958000.00" => sub { is rur2words(958000.00), "девятьсот пятьдесят восемь тысяч рублей 00 копеек"; };
	it "959000.00" => sub { is rur2words(959000.00), "девятьсот пятьдесят девять тысяч рублей 00 копеек"; };
	it "960000.00" => sub { is rur2words(960000.00), "девятьсот шестьдесят тысяч рублей 00 копеек"; };
	it "961000.00" => sub { is rur2words(961000.00), "девятьсот шестьдесят одна тысяча рублей 00 копеек"; };
	it "962000.00" => sub { is rur2words(962000.00), "девятьсот шестьдесят две тысячи рублей 00 копеек"; };
	it "963000.00" => sub { is rur2words(963000.00), "девятьсот шестьдесят три тысячи рублей 00 копеек"; };
	it "964000.00" => sub { is rur2words(964000.00), "девятьсот шестьдесят четыре тысячи рублей 00 копеек"; };
	it "965000.00" => sub { is rur2words(965000.00), "девятьсот шестьдесят пять тысяч рублей 00 копеек"; };
	it "966000.00" => sub { is rur2words(966000.00), "девятьсот шестьдесят шесть тысяч рублей 00 копеек"; };
	it "967000.00" => sub { is rur2words(967000.00), "девятьсот шестьдесят семь тысяч рублей 00 копеек"; };
	it "968000.00" => sub { is rur2words(968000.00), "девятьсот шестьдесят восемь тысяч рублей 00 копеек"; };
	it "969000.00" => sub { is rur2words(969000.00), "девятьсот шестьдесят девять тысяч рублей 00 копеек"; };
	it "970000.00" => sub { is rur2words(970000.00), "девятьсот семьдесят тысяч рублей 00 копеек"; };
	it "971000.00" => sub { is rur2words(971000.00), "девятьсот семьдесят одна тысяча рублей 00 копеек"; };
	it "972000.00" => sub { is rur2words(972000.00), "девятьсот семьдесят две тысячи рублей 00 копеек"; };
	it "973000.00" => sub { is rur2words(973000.00), "девятьсот семьдесят три тысячи рублей 00 копеек"; };
	it "974000.00" => sub { is rur2words(974000.00), "девятьсот семьдесят четыре тысячи рублей 00 копеек"; };
	it "975000.00" => sub { is rur2words(975000.00), "девятьсот семьдесят пять тысяч рублей 00 копеек"; };
	it "976000.00" => sub { is rur2words(976000.00), "девятьсот семьдесят шесть тысяч рублей 00 копеек"; };
	it "977000.00" => sub { is rur2words(977000.00), "девятьсот семьдесят семь тысяч рублей 00 копеек"; };
	it "978000.00" => sub { is rur2words(978000.00), "девятьсот семьдесят восемь тысяч рублей 00 копеек"; };
	it "979000.00" => sub { is rur2words(979000.00), "девятьсот семьдесят девять тысяч рублей 00 копеек"; };
	it "980000.00" => sub { is rur2words(980000.00), "девятьсот восемьдесят тысяч рублей 00 копеек"; };
	it "981000.00" => sub { is rur2words(981000.00), "девятьсот восемьдесят одна тысяча рублей 00 копеек"; };
	it "982000.00" => sub { is rur2words(982000.00), "девятьсот восемьдесят две тысячи рублей 00 копеек"; };
	it "983000.00" => sub { is rur2words(983000.00), "девятьсот восемьдесят три тысячи рублей 00 копеек"; };
	it "984000.00" => sub { is rur2words(984000.00), "девятьсот восемьдесят четыре тысячи рублей 00 копеек"; };
	it "985000.00" => sub { is rur2words(985000.00), "девятьсот восемьдесят пять тысяч рублей 00 копеек"; };
	it "986000.00" => sub { is rur2words(986000.00), "девятьсот восемьдесят шесть тысяч рублей 00 копеек"; };
	it "987000.00" => sub { is rur2words(987000.00), "девятьсот восемьдесят семь тысяч рублей 00 копеек"; };
	it "988000.00" => sub { is rur2words(988000.00), "девятьсот восемьдесят восемь тысяч рублей 00 копеек"; };
	it "989000.00" => sub { is rur2words(989000.00), "девятьсот восемьдесят девять тысяч рублей 00 копеек"; };
	it "990000.00" => sub { is rur2words(990000.00), "девятьсот девяносто тысяч рублей 00 копеек"; };
	it "991000.00" => sub { is rur2words(991000.00), "девятьсот девяносто одна тысяча рублей 00 копеек"; };
	it "992000.00" => sub { is rur2words(992000.00), "девятьсот девяносто две тысячи рублей 00 копеек"; };
	it "993000.00" => sub { is rur2words(993000.00), "девятьсот девяносто три тысячи рублей 00 копеек"; };
	it "994000.00" => sub { is rur2words(994000.00), "девятьсот девяносто четыре тысячи рублей 00 копеек"; };
	it "995000.00" => sub { is rur2words(995000.00), "девятьсот девяносто пять тысяч рублей 00 копеек"; };
	it "996000.00" => sub { is rur2words(996000.00), "девятьсот девяносто шесть тысяч рублей 00 копеек"; };
	it "997000.00" => sub { is rur2words(997000.00), "девятьсот девяносто семь тысяч рублей 00 копеек"; };
	it "998000.00" => sub { is rur2words(998000.00), "девятьсот девяносто восемь тысяч рублей 00 копеек"; };
	it "999000.00" => sub { is rur2words(999000.00), "девятьсот девяносто девять тысяч рублей 00 копеек"; };
};

runtests unless caller;
