#ifndef LEX_AUXILIARY_H
#define LEX_AUXILIARY_H

#include "attrib.h"

typedef enum
{
   ETYPE_MACRODEF,              /* @string */
   ETYPE_TEXT,                  /* @comment or @preamble (I think) */
   ETYPE_STRUCTURED             /* anything else */
} entry_metatype_t;

extern entry_metatype_t EntryMetatype;

void lex_info (void);
void zzcr_attr (Attrib *, int, char *);
void newline_in_string (void);
void newline (void);
void open_entry (char start_char);
void close_entry (char end_char);
void start_string (char start_char);
void end_string (char end_char);
void open_brace (void);
void close_brace (void);
void quote_in_string (void);

#endif /* ! defined LEX_AUXILIARY_H */
