#!/usr/bin/env perl

use strict;
use warnings;

use Data::Dumper;
use FindBin qw($Bin);
use lib "$Bin/../lib";
use ImgurAPI::Client;

my $client = ImgurAPI::Client->new({
    client_id => $ENV{'CLIENT_ID'},
    client_secret => $ENV{'CLIENT_SECRET'},
    access_token => $ENV{'ACCESS_TOKEN'},
});


my $gallery = $client->gallery();
# print Dumper $gallery;

my $album_id = undef;
my $image_id = undef;

foreach my $item (@{$gallery->{'data'}}) {
    if ($item->{'is_album'}) {
        $album_id = $item->{'id'};
    }
}

=gallery
{
    'data' => [
        {
        'ad_config' => {
            'unsafe_flags' => [],
            'showAdLevel' => 2,
            'safeFlags' => [
                'album',
                'in_gallery',
                'gallery'
            ],
            'safe_flags' => [
                'album',
                'in_gallery',
                'gallery'
            ],
            'show_ad_level' => 2,
            'high_risk_flags' => [],
            'showsAds' => bless( do{\(my $o = 1)}, 'JSON::PP::Boolean' ),
            'wall_unsafe_flags' => [],
            'show_ads' => $VAR1->{'data'}[0]{'ad_config'}{'showsAds'},
            'nsfw_score' => 0,
            'wallUnsafeFlags' => [],
            'highRiskFlags' => [],
            'unsafeFlags' => []
        },
        'link' => 'https://imgur.com/a/2h3jEs0',
        'images_count' => 1,
        'is_ad' => bless( do{\(my $o = 0)}, 'JSON::PP::Boolean' ),
        'id' => '2h3jEs0',
        'title' => "So glad I\x{2019}m safe",
        'points' => 1546,
        'downs' => 6,
        'topic' => undef,
        'account_id' => 86895079,
        'ups' => 1552,
        'in_most_viral' => $VAR1->{'data'}[0]{'ad_config'}{'showsAds'},
        'in_gallery' => $VAR1->{'data'}[0]{'ad_config'}{'showsAds'},
        'tags' => [
            {
                'logo_destination_url' => undef,
                'description_annotations' => {},
                'following' => $VAR1->{'data'}[0]{'is_ad'},
                'display_name' => 'Funny',
                'background_is_animated' => $VAR1->{'data'}[0]{'is_ad'},
                'background_hash' => '9r1qCDq',
                'is_whitelisted' => $VAR1->{'data'}[0]{'is_ad'},
                'is_promoted' => $VAR1->{'data'}[0]{'is_ad'},
                'name' => 'funny',
                'followers' => 6780537,
                'thumbnail_is_animated' => $VAR1->{'data'}[0]{'is_ad'},
                'logo_hash' => undef,
                'accent' => '633875',
                'total_items' => 2554490,
                'description' => 'LOLs, ROFLs, LMAOs',
                'thumbnail_hash' => undef
            }
        ],
        'vote' => undef,
        'images' => [
            {
            'id' => 'dH9MeL3',
            'title' => undef,
            'width' => 1290,
            'has_sound' => $VAR1->{'data'}[0]{'is_ad'},
            'is_ad' => $VAR1->{'data'}[0]{'is_ad'},
            'link' => 'https://i.imgur.com/dH9MeL3.jpg',
            'height' => 1044,
            'bandwidth' => 3759937328,
            'description' => undef,
            'ups' => undef,
            'points' => undef,
            'downs' => undef,
            'account_id' => undef,
            'vote' => undef,
            'tags' => [],
            'in_most_viral' => $VAR1->{'data'}[0]{'is_ad'},
            'in_gallery' => $VAR1->{'data'}[0]{'is_ad'},
            'ad_type' => 0,
            'favorite' => $VAR1->{'data'}[0]{'is_ad'},
            'comment_count' => undef,
            'animated' => $VAR1->{'data'}[0]{'is_ad'},
            'views' => 26131,
            'nsfw' => undef,
            'favorite_count' => undef,
            'edited' => '0',
            'type' => 'image/jpeg',
            'ad_url' => '',
            'account_url' => undef,
            'datetime' => 1711486663,
            'score' => undef,
            'section' => undef,
            'size' => 143888
            }
        ],
        'cover_width' => 1290,
        'is_album' => $VAR1->{'data'}[0]{'ad_config'}{'showsAds'},
        'description' => undef,
        'favorite_count' => 159,
        'views' => 48726,
        'comment_count' => 148,
        'nsfw' => $VAR1->{'data'}[0]{'is_ad'},
        'include_album_ads' => $VAR1->{'data'}[0]{'is_ad'},
        'favorite' => $VAR1->{'data'}[0]{'is_ad'},
        'ad_type' => 0,
        'privacy' => 'hidden',
        'topic_id' => undef,
        'section' => '',
        'score' => 1570,
        'layout' => 'blog',
        'cover_height' => 1044,
        'cover' => 'dH9MeL3',
        'datetime' => 1711486669,
        'ad_url' => '',
        'account_url' => 'kidfromOKwiththetuckfromMB'
    },
    'success' => 1,
    'status' => 200
}
=cut

my $gallery_album = $client->gallery_album($album_id);
#print Dumper $gallery_album;

=gallery_album
    'data' => {
        'points' => 1577,
        'ad_url' => '',
        'topic' => undef,
        'vote' => undef,
        'ad_config' => {
            'wall_unsafe_flags' => [],
            'wallUnsafeFlags' => [],
            'show_ad_level' => 2,
            'high_risk_flags' => [],
            'show_ads' => bless( do{\(my $o = 1)}, 'JSON::PP::Boolean' ),
            'showAdLevel' => 2,
            'showsAds' => $VAR1->{'data'}{'ad_config'}{'show_ads'},
            'nsfw_score' => 0,
            'safe_flags' => [
                'album',
                'in_gallery',
                'gallery'
            ],
            'safeFlags' => [
                'album',
                'in_gallery',
                'gallery'
            ],
            'unsafeFlags' => [],
            'unsafe_flags' => [],
            'highRiskFlags' => []
        },
        'account_url' => 'kidfromOKwiththetuckfromMB',
        'in_gallery' => $VAR1->{'data'}{'ad_config'}{'show_ads'},
        'id' => '2h3jEs0',
        'cover_width' => 1290,
        'images_count' => 1,
        'include_album_ads' => bless( do{\(my $o = 0)}, 'JSON::PP::Boolean' ),
        'ups' => 1583,
        'description' => undef,
        'account_id' => 86895079,
        'score' => 1601,
        'tags' => [
            {
            'display_name' => 'Funny',
            'accent' => '633875',
            'logo_destination_url' => undef,
            'background_hash' => '9r1qCDq',
            'is_whitelisted' => $VAR1->{'data'}{'include_album_ads'},
            'thumbnail_hash' => undef,
            'logo_hash' => undef,
            'description_annotations' => {},
            'following' => $VAR1->{'data'}{'include_album_ads'},
            'total_items' => 2554490,
            'is_promoted' => $VAR1->{'data'}{'include_album_ads'},
            'name' => 'funny',
            'followers' => 6780538,
            'thumbnail_is_animated' => $VAR1->{'data'}{'include_album_ads'},
            'description' => 'LOLs, ROFLs, LMAOs',
            'background_is_animated' => $VAR1->{'data'}{'include_album_ads'}
            }
        ],
        'datetime' => 1711486669,
        'topic_id' => undef,
        'section' => '',
        'link' => 'https://imgur.com/a/2h3jEs0',
        'cover_height' => 1044,
        'layout' => 'blog',
        'downs' => 6,
        'in_most_viral' => $VAR1->{'data'}{'ad_config'}{'show_ads'},
        'is_album' => $VAR1->{'data'}{'ad_config'}{'show_ads'},
        'favorite' => $VAR1->{'data'}{'include_album_ads'},
        'privacy' => 'hidden',
        'comment_count' => 153,
        'is_ad' => $VAR1->{'data'}{'include_album_ads'},
        'images' => [
            {
                'ups' => undef,
                'description' => undef,
                'score' => undef,
                'account_id' => undef,
                'width' => 1290,
                'tags' => [],
                'datetime' => 1711486663,
                'points' => undef,
                'ad_url' => '',
                'bandwidth' => 3822384720,
                'vote' => undef,
                'account_url' => undef,
                'in_gallery' => $VAR1->{'data'}{'include_album_ads'},
                'id' => 'dH9MeL3',
                'favorite' => $VAR1->{'data'}{'include_album_ads'},
                'comment_count' => undef,
                'is_ad' => $VAR1->{'data'}{'include_album_ads'},
                'favorite_count' => undef,
                'edited' => '0',
                'height' => 1044,
                'title' => undef,
                'ad_type' => 0,
                'nsfw' => undef,
                'views' => 26565,
                'section' => undef,
                'type' => 'image/jpeg',
                'link' => 'https://i.imgur.com/dH9MeL3.jpg',
                'has_sound' => $VAR1->{'data'}{'include_album_ads'},
                'size' => 143888,
                'animated' => $VAR1->{'data'}{'include_album_ads'},
                'downs' => undef,
                'in_most_viral' => $VAR1->{'data'}{'include_album_ads'}
            }
        ],
        'favorite_count' => 161,
        'cover' => 'dH9MeL3',
        'title' => "So glad I\x{2019}m safe",
        'nsfw' => $VAR1->{'data'}{'include_album_ads'},
        'ad_type' => 0,
        'views' => 49634
    },
    'status' => 200,
    'success' => $VAR1->{'data'}{'ad_config'}{'show_ads'}
}
=cut

# my $gallery_image = $client->gallery_image($image_id);
# print Dumper $gallery_image;

=gallery_image
=cut


my $search_params = {
    q => 'ferrets',
    window => 'year',
};

my $gallery_search = $client->gallery_search($search_params);
# print Dumper $gallery_search;

=gallery_search
{
    'success' => bless( do{\(my $o = 1)}, 'JSON::PP::Boolean' ),
    'data' => [
        {
            'datetime' => 1708119689,
            'in_most_viral' => bless( do{\(my $o = 0)}, 'JSON::PP::Boolean' ),
            'is_album' => $VAR1->{'success'},
            'layout' => 'blog',
            'ad_config' => {
                'safe_flags' => [
                    'album',
                    'in_gallery'
                ],
                'show_ads' => $VAR1->{'success'},
                'unsafe_flags' => [],
                'wall_unsafe_flags' => [],
                'show_ad_level' => 2,
                'wallUnsafeFlags' => [],
                'showsAds' => $VAR1->{'success'},
                'unsafeFlags' => [],
                'showAdLevel' => 2,
                'safeFlags' => [
                    'album',
                    'in_gallery'
                ],
                'highRiskFlags' => [],
                'high_risk_flags' => [],
                'nsfw_score' => 0
            },
            'cover_width' => 1536,
            'views' => 2002,
            'topic' => undef,
            'favorite_count' => 1,
            'images_count' => 5,
            'cover' => 'Zi49cTA',
            'is_ad' => $VAR1->{'data'}[0]{'in_most_viral'},
            'link' => 'https://imgur.com/a/MEEZEM7',
            'vote' => undef,
            'ups' => 48,
            'account_id' => 173922685,
            'tags' => [
                {
                    'followers' => 664,
                    'thumbnail_is_animated' => $VAR1->{'data'}[0]{'in_most_viral'},
                    'accent' => '5A3D74',
                    'display_name' => 'ferrets',
                    'is_promoted' => $VAR1->{'data'}[0]{'in_most_viral'},
                    'background_hash' => 'CXErE2G',
                    'logo_destination_url' => undef,
                    'total_items' => 481,
                    'name' => 'ferrets',
                    'description_annotations' => {},
                    'is_whitelisted' => $VAR1->{'data'}[0]{'in_most_viral'},
                    'description' => '',
                    'following' => $VAR1->{'data'}[0]{'in_most_viral'},
                    'thumbnail_hash' => undef,
                    'logo_hash' => undef,
                    'background_is_animated' => $VAR1->{'data'}[0]{'in_most_viral'}
                },
                {
                    'thumbnail_hash' => undef,
                    'following' => $VAR1->{'data'}[0]{'in_most_viral'},
                    'background_is_animated' => $VAR1->{'data'}[0]{'in_most_viral'},
                    'logo_hash' => undef,
                    'description' => 'all things animal',
                    'is_whitelisted' => $VAR1->{'data'}[0]{'in_most_viral'},
                    'description_annotations' => {},
                    'name' => 'pets',
                    'logo_destination_url' => undef,
                    'total_items' => 49971,
                    'background_hash' => 'A3E5z2R',
                    'is_promoted' => $VAR1->{'data'}[0]{'in_most_viral'},
                    'followers' => 1076995,
                    'display_name' => 'pets',
                    'accent' => '24565E',
                    'thumbnail_is_animated' => $VAR1->{'data'}[0]{'in_most_viral'}
                }
            ],
            'ad_url' => '',
            'privacy' => 'hidden',
            'in_gallery' => $VAR1->{'success'},
            'id' => 'MEEZEM7',
            'cover_height' => 2048,
            'points' => 46,
            'score' => 46,
            'account_url' => 'ozawaonline',
            'description' => undef,
            'downs' => 2,
            'title' => 'I miss my noodles',
            'nsfw' => $VAR1->{'data'}[0]{'in_most_viral'},
            'comment_count' => 1,
            'section' => '',
            'images' => [
                {
                    'downs' => undef,
                    'title' => undef,
                    'nsfw' => undef,
                    'comment_count' => undef,
                    'type' => 'image/jpeg',
                    'section' => undef,
                    'ad_type' => 0,
                    'favorite' => $VAR1->{'data'}[0]{'in_most_viral'},
                    'in_gallery' => $VAR1->{'data'}[0]{'in_most_viral'},
                    'width' => 1536,
                    'id' => 'Zi49cTA',
                    'animated' => $VAR1->{'data'}[0]{'in_most_viral'},
                    'points' => undef,
                    'has_sound' => $VAR1->{'data'}[0]{'in_most_viral'},
                    'score' => undef,
                    'size' => 224599,
                    'account_url' => undef,
                    'description' => undef,
                    'height' => 2048,
                    'bandwidth' => 279176557,
                    'is_ad' => $VAR1->{'data'}[0]{'in_most_viral'},
                    'link' => 'https://i.imgur.com/Zi49cTA.jpg',
                    'ups' => undef,
                    'vote' => undef,
                    'tags' => [],
                    'account_id' => undef,
                    'edited' => '0',
                    'ad_url' => '',
                    'in_most_viral' => $VAR1->{'data'}[0]{'in_most_viral'},
                    'datetime' => 1708119686,
                    'views' => 1243,
                    'favorite_count' => undef
                },
                {
                    'size' => 243360,
                    'score' => undef,
                    'account_url' => undef,
                    'description' => undef,
                    'height' => 1143,
                    'bandwidth' => 262342080,
                    'in_gallery' => $VAR1->{'data'}[0]{'in_most_viral'},
                    'width' => 2048,
                    'id' => 'XEP39Hl',
                    'animated' => $VAR1->{'data'}[0]{'in_most_viral'},
                    'has_sound' => $VAR1->{'data'}[0]{'in_most_viral'},
                    'points' => undef,
                    'ad_type' => 0,
                    'favorite' => $VAR1->{'data'}[0]{'in_most_viral'},
                    'downs' => undef,
                    'title' => undef,
                    'nsfw' => undef,
                    'comment_count' => undef,
                    'section' => undef,
                    'type' => 'image/jpeg',
                    'views' => 1078,
                    'favorite_count' => undef,
                    'in_most_viral' => $VAR1->{'data'}[0]{'in_most_viral'},
                    'datetime' => 1708119688,
                    'account_id' => undef,
                    'tags' => [],
                    'edited' => '0',
                    'ad_url' => '',
                    'is_ad' => $VAR1->{'data'}[0]{'in_most_viral'},
                    'link' => 'https://i.imgur.com/XEP39Hl.jpg',
                    'vote' => undef,
                    'ups' => undef
                },
                {
                    'bandwidth' => 93889345,
                    'height' => 1792,
                    'size' => 155189,
                    'score' => undef,
                    'account_url' => undef,
                    'description' => undef,
                    'animated' => $VAR1->{'data'}[0]{'in_most_viral'},
                    'points' => undef,
                    'has_sound' => $VAR1->{'data'}[0]{'in_most_viral'},
                    'width' => 902,
                    'id' => 'Zk3NopI',
                    'in_gallery' => $VAR1->{'data'}[0]{'in_most_viral'},
                    'ad_type' => 0,
                    'favorite' => $VAR1->{'data'}[0]{'in_most_viral'},
                    'type' => 'image/jpeg',
                    'section' => undef,
                    'nsfw' => undef,
                    'comment_count' => undef,
                    'title' => undef,
                    'downs' => undef,
                    'favorite_count' => undef,
                    'views' => 605,
                    'in_most_viral' => $VAR1->{'data'}[0]{'in_most_viral'},
                    'datetime' => 1708119684,
                    'ad_url' => '',
                    'tags' => [],
                    'account_id' => undef,
                    'edited' => '0',
                    'link' => 'https://i.imgur.com/Zk3NopI.jpg',
                    'vote' => undef,
                    'ups' => undef,
                    'is_ad' => $VAR1->{'data'}[0]{'in_most_viral'}
                }
            ],
            'ad_type' => 0,
            'favorite' => $VAR1->{'data'}[0]{'in_most_viral'},
            'include_album_ads' => $VAR1->{'data'}[0]{'in_most_viral'},
            'topic_id' => undef
        }
    ],
    'status' => 200
}
=cut

my $gallery_subreddit = $client->gallery_subreddit('programming');
# print Dumper $gallery_subreddit;

=gallery_subreddit
{
    'data' => [
        {
            'account_id' => undef,
            'favorite' => $VAR1->{'data'}[0]{'animated'},
            'title' => 'Never interrupt a programmer',
            'favorite_count' => undef,
            'tags' => [],
            'in_most_viral' => $VAR1->{'data'}[0]{'animated'},
            'type' => 'image/jpeg',
            'vote' => undef,
            'is_ad' => $VAR1->{'data'}[0]{'animated'},
            'views' => 175070,
            'points' => undef,
            'is_album' => $VAR1->{'data'}[0]{'animated'},
            'datetime' => 1392822963,
            'bandwidth' => '25397404900',
            'has_sound' => $VAR1->{'data'}[0]{'animated'},
            'ad_config' => {
                'wall_unsafe_flags' => [],
                'showAdLevel' => 2,
                'nsfw_score' => 0,
                'show_ad_level' => 2,
                'show_ads' => bless( do{\(my $o = 1)}, 'JSON::PP::Boolean' ),
                'unsafeFlags' => [],
                'wallUnsafeFlags' => [],
                'showsAds' => $VAR1->{'data'}[1]{'ad_config'}{'show_ads'},
                'safeFlags' => [
                    'in_gallery',
                    'subreddit'
                ],
                'highRiskFlags' => [],
                'safe_flags' => [
                    'in_gallery',
                    'subreddit'
                ],
                'high_risk_flags' => [],
                'unsafe_flags' => []
            },
            'ups' => undef,
            'nsfw' => $VAR1->{'data'}[0]{'animated'},
            'description' => undef,
            'score' => 154166,
            'link' => 'https://i.imgur.com/3uyRWGJ.jpg',
            'edited' => 0,
            'animated' => $VAR1->{'data'}[0]{'animated'},
            'in_gallery' => $VAR1->{'data'}[0]{'animated'},
            'downs' => undef,
            'height' => 2073,
            'ad_url' => '',
            'ad_type' => 0,
            'id' => '3uyRWGJ',
            'comment_count' => undef,
            'width' => 540,
            'account_url' => undef,
            'size' => 145070,
            'section' => 'programming'
        },
    ]
    'status' => 200,
    'success' => $VAR1->{'data'}[1]{'ad_config'}{'show_ads'}
}
=cut

my $subreddit_image_id = $gallery_subreddit->{'data'}->[0]->{'id'};
my $gallery_subreddit_image = $client->gallery_subreddit_image('programming', $subreddit_image_id);
# print Dumper $gallery_subreddit_image;

=gallery_subreddit_image
{
    'success' => bless( do{\(my $o = 1)}, 'JSON::PP::Boolean' ),
    'status' => 200,
    'data' => {
        'ups' => undef,
        'datetime' => 1399607763,
        'in_gallery' => bless( do{\(my $o = 0)}, 'JSON::PP::Boolean' ),
        'width' => 484,
        'is_album' => $VAR1->{'data'}{'in_gallery'},
        'views' => 2232,
        'link' => 'https://i.imgur.com/ccLYTtL.png',
        'size' => 164711,
        'section' => 'programming',
        'account_url' => undef,
        'in_most_viral' => $VAR1->{'data'}{'in_gallery'},
        'has_sound' => $VAR1->{'data'}{'in_gallery'},
        'bandwidth' => 367634952,
        'account_id' => undef,
        'nsfw' => $VAR1->{'data'}{'in_gallery'},
        'ad_url' => '',
        'score' => 51678,
        'description' => undef,
        'title' => 'Web development explained with butt analogies',
        'id' => 'ccLYTtL',
        'vote' => undef,
        'ad_config' => {
            'showsAds' => $VAR1->{'data'}{'in_gallery'},
            'safe_flags' => [
                'not_in_gallery',
                'subreddit'
            ],
            'nsfw_score' => '0.9',
            'wallUnsafeFlags' => [
                'onsfw_mod_unsafe_wall'
            ],
            'showAdLevel' => 0,
            'safeFlags' => [
                'not_in_gallery',
                'subreddit'
            ],
            'unsafeFlags' => [
                'onsfw_mod_unsafe'
            ],
            'highRiskFlags' => [],
            'unsafe_flags' => [
                'onsfw_mod_unsafe'
            ],
            'wall_unsafe_flags' => [
                'onsfw_mod_unsafe_wall'
            ],
            'high_risk_flags' => [],
            'show_ad_level' => 0,
            'show_ads' => $VAR1->{'data'}{'in_gallery'}
        },
        'is_ad' => $VAR1->{'data'}{'in_gallery'},
        'points' => undef,
        'favorite' => $VAR1->{'data'}{'in_gallery'},
        'ad_type' => 0,
        'animated' => $VAR1->{'data'}{'in_gallery'},
        'height' => 650,
        'edited' => 0,
        'tags' => [],
        'downs' => undef,
        'type' => 'image/png',
        'comment_count' => undef,
        'favorite_count' => undef
    }
}
=cut


my $gallery_tag = $client->gallery_tag('theoffice');
# print Dumper $gallery_tag;

=gallery_tab
{
    'data' => {
        'display_name' => 'theoffice',
        'background_hash' => '5uFU9FR',
        'description' => '',
        'following' => bless( do{\(my $o = 0)}, 'JSON::PP::Boolean' ),
        'is_whitelisted' => bless( do{\(my $o = 1)}, 'JSON::PP::Boolean' ),
        'thumbnail_is_animated' => $VAR1->{'data'}{'following'},
        'background_is_animated' => $VAR1->{'data'}{'following'},
        'followers' => 3432,
        'logo_destination_url' => undef,
        'total_items' => 1893,
        'thumbnail_hash' => undef,
        'is_promoted' => $VAR1->{'data'}{'following'},
        'items' => [
            {
                'cover_height' => 445,
                'account_id' => 178806661,
                'description' => undef,
                'account_url' => 'TRFRADIO',
                'section' => '',
                'topic_id' => undef,
                'id' => '6YTszNe',
                'layout' => 'blog',
                'nsfw' => $VAR1->{'data'}{'following'},
                'score' => 9,
                'vote' => undef,
                'privacy' => 'hidden',
                'in_most_viral' => $VAR1->{'data'}{'following'},
                'favorite' => $VAR1->{'data'}{'following'},
                'views' => 1030,
                'favorite_count' => 0,
                'tags' => [
                    {
                    'total_items' => 8842,
                    'is_promoted' => $VAR1->{'data'}{'following'},
                    'thumbnail_hash' => undef,
                    'description_annotations' => {},
                    'logo_hash' => undef,
                    'name' => 'birthday',
                    'accent' => '2E6197',
                    'display_name' => 'birthday',
                    'background_hash' => 'eWY7qg5',
                    'description' => '',
                    'following' => $VAR1->{'data'}{'following'},
                    'is_whitelisted' => $VAR1->{'data'}{'following'},
                    'thumbnail_is_animated' => $VAR1->{'data'}{'following'},
                    'background_is_animated' => $VAR1->{'data'}{'following'},
                    'logo_destination_url' => undef,
                    'followers' => 2094
                    },
                    {
                    'background_hash' => 'R1dEESs',
                    'description' => '',
                    'display_name' => 'tantric',
                    'is_whitelisted' => $VAR1->{'data'}{'following'},
                    'background_is_animated' => $VAR1->{'data'}{'following'},
                    'thumbnail_is_animated' => $VAR1->{'data'}{'following'},
                    'logo_destination_url' => undef,
                    'followers' => 3,
                    'following' => $VAR1->{'data'}{'following'},
                    'thumbnail_hash' => undef,
                    'is_promoted' => $VAR1->{'data'}{'following'},
                    'total_items' => 2,
                    'logo_hash' => undef,
                    'accent' => '5E58CB',
                    'name' => 'tantric',
                    'description_annotations' => {}
                    },
                    {
                    'is_whitelisted' => $VAR1->{'data'}{'following'},
                    'background_is_animated' => $VAR1->{'data'}{'following'},
                    'thumbnail_is_animated' => $VAR1->{'data'}{'following'},
                    'logo_destination_url' => undef,
                    'followers' => 15,
                    'following' => $VAR1->{'data'}{'following'},
                    'background_hash' => '5uFU9FR',
                    'description' => '',
                    'display_name' => 'walkhard',
                    'logo_hash' => undef,
                    'accent' => 'B85E44',
                    'name' => 'walkhard',
                    'description_annotations' => {},
                    'thumbnail_hash' => undef,
                    'is_promoted' => $VAR1->{'data'}{'following'},
                    'total_items' => 19
                    },
                    {
                    'accent' => 'B85E44',
                    'name' => 'theoffice',
                    'logo_hash' => undef,
                    'description_annotations' => {},
                    'thumbnail_hash' => undef,
                    'is_promoted' => $VAR1->{'data'}{'following'},
                    'total_items' => 1891,
                    'logo_destination_url' => undef,
                    'followers' => 3432,
                    'is_whitelisted' => $VAR1->{'data'}{'following'},
                    'background_is_animated' => $VAR1->{'data'}{'following'},
                    'thumbnail_is_animated' => $VAR1->{'data'}{'following'},
                    'following' => $VAR1->{'data'}{'following'},
                    'description' => '',
                    'background_hash' => '5uFU9FR',
                    'display_name' => 'theoffice'
                    },
                    {
                    'display_name' => 'game of thrones',
                    'background_hash' => 'jFCTPdP',
                    'description' => 'spoilers within',
                    'following' => $VAR1->{'data'}{'following'},
                    'background_is_animated' => $VAR1->{'data'}{'following'},
                    'thumbnail_is_animated' => $VAR1->{'data'}{'following'},
                    'is_whitelisted' => $VAR1->{'data'}{'following'},
                    'followers' => 35748,
                    'logo_destination_url' => undef,
                    'total_items' => 23804,
                    'thumbnail_hash' => undef,
                    'is_promoted' => $VAR1->{'data'}{'following'},
                    'description_annotations' => {},
                    'logo_hash' => undef,
                    'name' => 'game_of_thrones',
                    'accent' => 'a18060'
                    }
                ],
                'include_album_ads' => $VAR1->{'data'}{'following'},
                'ad_url' => '',
                'ad_config' => {
                    'safe_flags' => [
                                    'album',
                                    'in_gallery',
                                    'gallery'
                                    ],
                    'unsafeFlags' => [],
                    'show_ad_level' => 2,
                    'wall_unsafe_flags' => [],
                    'highRiskFlags' => [],
                    'showAdLevel' => 2,
                    'show_ads' => $VAR1->{'data'}{'is_whitelisted'},
                    'safeFlags' => [
                                    'album',
                                    'in_gallery',
                                    'gallery'
                                    ],
                    'wallUnsafeFlags' => [],
                    'unsafe_flags' => [],
                    'nsfw_score' => '0.1',
                    'showsAds' => $VAR1->{'data'}{'is_whitelisted'},
                    'high_risk_flags' => []
                },
                'images' => [
                    {
                        'ups' => undef,
                        'has_sound' => $VAR1->{'data'}{'following'},
                        'ad_type' => 0,
                        'edited' => '0',
                        'in_gallery' => $VAR1->{'data'}{'following'},
                        'is_ad' => $VAR1->{'data'}{'following'},
                        'title' => undef,
                        'link' => 'https://i.imgur.com/o2MkiGB.png',
                        'height' => 445,
                        'datetime' => 1709825003,
                        'comment_count' => undef,
                        'downs' => undef,
                        'bandwidth' => 331739158,
                        'points' => undef,
                        'animated' => $VAR1->{'data'}{'following'},
                        'id' => 'o2MkiGB',
                        'size' => 475271,
                        'section' => undef,
                        'description' => undef,
                        'account_url' => undef,
                        'width' => 1200,
                        'account_id' => undef,
                        'ad_url' => '',
                        'type' => 'image/png',
                        'tags' => [],
                        'favorite_count' => undef,
                        'in_most_viral' => $VAR1->{'data'}{'following'},
                        'favorite' => $VAR1->{'data'}{'following'},
                        'views' => 698,
                        'score' => undef,
                        'vote' => undef,
                        'nsfw' => undef
                    }
                    ],
                'title' => 'Mar 7 birthdays',
                'is_ad' => $VAR1->{'data'}{'following'},
                'in_gallery' => $VAR1->{'data'}{'is_whitelisted'},
                'ad_type' => 0,
                'images_count' => 1,
                'ups' => 13,
                'cover' => 'o2MkiGB',
                'topic' => undef,
                'points' => 9,
                'downs' => 4,
                'comment_count' => 1,
                'is_album' => $VAR1->{'data'}{'is_whitelisted'},
                'datetime' => 1709825120,
                'link' => 'https://imgur.com/a/6YTszNe',
                'cover_width' => 1200
            },
        ],
        'description_annotations' => {},
        'logo_hash' => undef,
        'accent' => 'B85E44',
        'name' => 'theoffice'
    },
    'status' => 200,
    'success' => $VAR1->{'data'}{'is_whitelisted'}
}
=cut


my $gallery_tag_info = $client->gallery_tag_info('baseball');
# print Dumper $gallery_tag_info;

=gallery_tag_info
{
    'data' => {
        'display_name' => 'baseball',
        'background_is_animated' => bless( do{\(my $o = 0)}, 'JSON::PP::Boolean' ),
        'description' => '',
        'thumbnail_is_animated' => $VAR1->{'data'}{'background_is_animated'},
        'following' => $VAR1->{'data'}{'background_is_animated'},
        'logo_destination_url' => undef,
        'thumbnail_hash' => undef,
        'background_hash' => '7bemn9H',
        'logo_hash' => undef,
        'name' => 'baseball',
        'description_annotations' => {},
        'is_whitelisted' => bless( do{\(my $o = 1)}, 'JSON::PP::Boolean' ),
        'followers' => 7690,
        'accent' => '51535A',
        'total_items' => 5144,
        'tag_follow' => {
            'status' => $VAR1->{'data'}{'background_is_animated'}
        },
        'is_promoted' => $VAR1->{'data'}{'background_is_animated'}
    },
    'status' => 200,
    'success' => $VAR1->{'data'}{'is_whitelisted'}
}
=cut


my $gallery_tags = $client->gallery_tags();
# print Dumper $gallery_tags;

=gallery_tags
{
    'status' => 200,
    'data' => {
        'galleries' => [
            {
                'topPost' => {
                    'ad_url' => '',
                    'views' => 25248,
                    'cover_height' => 340,
                    'favorite_count' => 21,
                    'account_url' => 'blank666man',
                    'score' => 725,
                    'in_gallery' => bless( do{\(my $o = 1)}, 'JSON::PP::Boolean' ),
                    'description' => undef,
                    'downs' => 12,
                    'favorite' => undef,
                    'id' => '4hiqbWb',
                    'vote' => undef,
                    'is_ad' => bless( do{\(my $o = 0)}, 'JSON::PP::Boolean' ),
                    'title' => "Of course it is.\x{a0} Why are you even suggesting something different ....",
                    'tags' => [],
                    'datetime' => 1711655146,
                    'topic_id' => undef,
                    'layout' => 'blog',
                    'images_count' => 1,
                    'privacy' => 'hidden',
                    'section' => '',
                    'link' => 'https://imgur.com/a/4hiqbWb',
                    'nsfw' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'ad_type' => 0,
                    'images' => [
                        {
                        'views' => 12556,
                        'ad_url' => '',
                        'account_url' => undef,
                        'score' => undef,
                        'favorite_count' => undef,
                        'in_gallery' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                        'description' => undef,
                        'downs' => undef,
                        'vote' => undef,
                        'has_sound' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                        'height' => 340,
                        'favorite' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                        'id' => 'n2mrsXf',
                        'title' => undef,
                        'is_ad' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                        'type' => 'image/png',
                        'tags' => [],
                        'datetime' => 1711655109,
                        'bandwidth' => 432478864,
                        'link' => 'https://i.imgur.com/n2mrsXf.png',
                        'section' => undef,
                        'ad_type' => 0,
                        'nsfw' => undef,
                        'ups' => undef,
                        'points' => undef,
                        'animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                        'in_most_viral' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                        'account_id' => undef,
                        'width' => 562,
                        'size' => 34444,
                        'edited' => '0',
                        'comment_count' => undef
                        }
                    ],
                    'ups' => 725,
                    'topic' => undef,
                    'points' => 713,
                    'cover_width' => 562,
                    'in_most_viral' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'include_album_ads' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'account_id' => 37060427,
                    'is_album' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'comment_count' => 61,
                    'cover' => 'n2mrsXf'
                },
                'id' => 0,
                'description' => 'Today\'s most popular posts',
                'name' => 'Most Viral'
            },
            {
                'id' => 1,
                'description' => 'Brand new posts shared in real time',
                'name' => 'User Submitted',
                'topPost' => {
                            'layout' => 'blog',
                            'images_count' => 1,
                            'privacy' => 'hidden',
                            'section' => '',
                            'link' => 'https://imgur.com/a/PZD6H2B',
                            'nsfw' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                            'ad_type' => 0,
                            'images' => [
                                            {
                                            'description' => 'The Joe Biden flag has 13 stripes and 50 stars',
                                            'downs' => undef,
                                            'views' => 257,
                                            'ad_url' => '',
                                            'score' => undef,
                                            'account_url' => undef,
                                            'favorite_count' => undef,
                                            'in_gallery' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                                            'tags' => [],
                                            'type' => 'image/jpeg',
                                            'datetime' => 1711665130,
                                            'has_sound' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                                            'vote' => undef,
                                            'height' => 755,
                                            'favorite' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                                            'id' => 'GhBFbxk',
                                            'title' => undef,
                                            'is_ad' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                                            'ad_type' => 0,
                                            'nsfw' => undef,
                                            'ups' => undef,
                                            'bandwidth' => 23980413,
                                            'link' => 'https://i.imgur.com/GhBFbxk.jpg',
                                            'section' => undef,
                                            'edited' => '0',
                                            'comment_count' => undef,
                                            'points' => undef,
                                            'animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                                            'in_most_viral' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                                            'account_id' => undef,
                                            'width' => 1080,
                                            'size' => 93309
                                            }
                                        ],
                            'ups' => 59,
                            'topic' => undef,
                            'points' => 58,
                            'in_most_viral' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                            'cover_width' => 1080,
                            'include_album_ads' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                            'account_id' => 159236285,
                            'is_album' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                            'comment_count' => 2,
                            'cover' => 'GhBFbxk',
                            'ad_url' => '',
                            'views' => 347,
                            'cover_height' => 755,
                            'score' => 58,
                            'favorite_count' => 0,
                            'account_url' => 'rockyandchloe',
                            'in_gallery' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                            'description' => undef,
                            'downs' => 1,
                            'favorite' => undef,
                            'id' => 'PZD6H2B',
                            'vote' => undef,
                            'is_ad' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                            'title' => 'Ya can\'t fix Stupid...',
                            'datetime' => 1711665131,
                            'tags' => [
                                        {
                                            'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                                            'followers' => 333,
                                            'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                                            'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                                            'logo_destination_url' => undef,
                                            'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                                            'background_hash' => '7bemn9H',
                                            'display_name' => 'bible',
                                            'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                                            'total_items' => 1729,
                                            'description' => '',
                                            'name' => 'bible',
                                            'accent' => '51535A',
                                            'logo_hash' => undef,
                                            'description_annotations' => {},
                                            'thumbnail_hash' => undef
                                        }
                                        ],
                            'topic_id' => undef
                            }
            },
            {
                'topPost' => {
                            'is_ad' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                            'mp4' => 'https://i.imgur.com/HgghCPg.mp4',
                            'title' => 'Try to sneak up on a german shepard',
                            'id' => 'HgghCPg',
                            'favorite' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                            'has_sound' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                            'height' => 426,
                            'vote' => undef,
                            'hls' => 'https://i.imgur.com/HgghCPg.m3u8',
                            'mp4_size' => 1156829,
                            'topic_id' => 0,
                            'tags' => [
                                        {
                                            'description_annotations' => {},
                                            'thumbnail_hash' => undef,
                                            'logo_hash' => undef,
                                            'accent' => '60AEBB',
                                            'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                                            'total_items' => 695011,
                                            'description' => 'The cutest and most adorable things on the internet',
                                            'name' => 'aww',
                                            'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                                            'background_hash' => 'avRBRpN',
                                            'display_name' => 'Aww',
                                            'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                                            'logo_destination_url' => undef,
                                            'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                                            'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                                            'followers' => 3745549
                                        }
                                        ],
                            'type' => 'image/gif',
                            'datetime' => 1464782416,
                            'account_url' => 'bonermoaner',
                            'score' => 16690,
                            'favorite_count' => 7226,
                            'in_gallery' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                            'ad_url' => '',
                            'views' => 1927554,
                            'downs' => 178,
                            'description' => 'Front page edit: I never end up here but today i have 2 MOAHAHH, also send nudes.',
                            'width' => 426,
                            'size' => 45983711,
                            'account_id' => 9833465,
                            'points' => 15731,
                            'animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                            'in_most_viral' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                            'is_album' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                            'comment_count' => 228,
                            'looping' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                            'edited' => 0,
                            'section' => 'rarepuppers',
                            'link' => 'http://i.imgur.com/HgghCPgh.gif',
                            'bandwidth' => '88636086072894',
                            'ups' => 15909,
                            'topic' => undef,
                            'gifv' => 'https://i.imgur.com/HgghCPg.gifv',
                            'nsfw' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                            'ad_type' => 0
                            },
                'id' => 2,
                'description' => 'A mix from the Imgur archives',
                'name' => 'Random'
            },
            {
                'topPost' => {
                            'section' => '',
                            'link' => 'https://imgur.com/a/CqbbpdL',
                            'layout' => 'blog',
                            'privacy' => 'hidden',
                            'images_count' => 1,
                            'ups' => 1646,
                            'topic' => undef,
                            'nsfw' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                            'images' => [
                                            {
                                            'description' => 'Lizards, amphibians, and other reptiles shed their skin and eat it to avoid wasting any nutrients.',
                                            'downs' => undef,
                                            'processing' => {
                                                                'status' => 'completed'
                                                            },
                                            'views' => 295208,
                                            'ad_url' => '',
                                            'in_gallery' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                                            'score' => undef,
                                            'account_url' => undef,
                                            'favorite_count' => undef,
                                            'type' => 'video/mp4',
                                            'tags' => [],
                                            'datetime' => 1711641424,
                                            'mp4_size' => 3828960,
                                            'hls' => 'https://i.imgur.com/eWtzdLQ.m3u8',
                                            'has_sound' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                                            'vote' => undef,
                                            'height' => 854,
                                            'id' => 'eWtzdLQ',
                                            'favorite' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                                            'title' => undef,
                                            'mp4' => 'https://i.imgur.com/eWtzdLQ.mp4',
                                            'is_ad' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                                            'ad_type' => 0,
                                            'nsfw' => undef,
                                            'gifv' => 'https://i.imgur.com/eWtzdLQ.gifv',
                                            'ups' => undef,
                                            'bandwidth' => '1130339623680',
                                            'link' => 'https://i.imgur.com/eWtzdLQ.mp4',
                                            'section' => undef,
                                            'edited' => '0',
                                            'comment_count' => undef,
                                            'animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                                            'in_most_viral' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                                            'points' => undef,
                                            'account_id' => undef,
                                            'size' => 3828960,
                                            'width' => 480
                                            }
                                        ],
                            'ad_type' => 0,
                            'account_id' => 65930195,
                            'include_album_ads' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                            'in_most_viral' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                            'cover_width' => 480,
                            'points' => 1638,
                            'comment_count' => 62,
                            'is_album' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                            'cover' => 'eWtzdLQ',
                            'in_gallery' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                            'account_url' => 'ExistentialDreadPirateRoberts',
                            'favorite_count' => 607,
                            'score' => 1666,
                            'ad_url' => '',
                            'cover_height' => 854,
                            'views' => 56246,
                            'downs' => 8,
                            'description' => undef,
                            'is_ad' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                            'title' => 'Newts...',
                            'favorite' => undef,
                            'id' => 'CqbbpdL',
                            'vote' => undef,
                            'topic_id' => undef,
                            'tags' => [
                                        {
                                            'followers' => 95967,
                                            'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                                            'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                                            'logo_destination_url' => undef,
                                            'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                                            'background_hash' => 'gbuk2AN',
                                            'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                                            'display_name' => 'animals',
                                            'description' => '',
                                            'name' => 'animals',
                                            'total_items' => 127305,
                                            'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                                            'accent' => '4D549A',
                                            'logo_hash' => undef,
                                            'thumbnail_hash' => undef,
                                            'description_annotations' => {}
                                        },
                                        {
                                            'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                                            'background_hash' => 'DbQMO3A',
                                            'display_name' => 'staff picks',
                                            'description' => 'Imgur\'s Favorites',
                                            'name' => 'staff_picks',
                                            'total_items' => 7253,
                                            'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                                            'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                                            'followers' => 2404185,
                                            'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                                            'logo_destination_url' => undef,
                                            'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                                            'logo_hash' => undef,
                                            'thumbnail_hash' => undef,
                                            'description_annotations' => {},
                                            'accent' => '132D31'
                                        }
                                        ],
                            'datetime' => 1711641560
                            },
                'name' => 'Staff Picks',
                'description' => 'Great posts picked by Imgur staff',
                'id' => 3
            }
        ],
        'tags' => [
                    {
                    'accent' => '60AEBB',
                    'thumbnail_hash' => undef,
                    'description_annotations' => {},
                    'logo_hash' => undef,
                    'logo_destination_url' => undef,
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 3745549,
                    'name' => 'aww',
                    'description' => 'The cutest and most adorable things on the internet',
                    'total_items' => 695013,
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'background_hash' => 'avRBRpN',
                    'display_name' => 'Aww'
                    },
                    {
                    'logo_hash' => undef,
                    'thumbnail_hash' => undef,
                    'description_annotations' => {},
                    'accent' => undef,
                    'name' => 'mental_health',
                    'description' => 'Mental Health matters, and so do you. ',
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'total_items' => 15742,
                    'background_hash' => 'Rq2O8Ga',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'display_name' => 'Mental Health',
                    'logo_destination_url' => undef,
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 7524,
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'}
                    },
                    {
                    'total_items' => 292395,
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'name' => 'gaming',
                    'description' => 'combat and adventure',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'background_hash' => 'nrFCOUB',
                    'display_name' => 'gaming',
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'logo_destination_url' => undef,
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 6614969,
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'logo_hash' => undef,
                    'thumbnail_hash' => undef,
                    'description_annotations' => {},
                    'accent' => '2B1A5A'
                    },
                    {
                    'background_hash' => 'tUX1dpv',
                    'display_name' => 'Unmuted',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'description' => 'The best videos with sound',
                    'name' => 'unmuted',
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'total_items' => 18307,
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 2498340,
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'logo_destination_url' => undef,
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'description_annotations' => {},
                    'thumbnail_hash' => 'tUX1dpv',
                    'logo_hash' => undef,
                    'accent' => '263BA7'
                    },
                    {
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 2263575,
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'logo_destination_url' => undef,
                    'display_name' => 'cosplay',
                    'background_hash' => 'E1CMJey',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'total_items' => 39507,
                    'name' => 'cosplay',
                    'description' => 'character costumes',
                    'accent' => '762828',
                    'description_annotations' => {},
                    'thumbnail_hash' => undef,
                    'logo_hash' => undef
                    },
                    {
                    'background_hash' => 'aJKwi96',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'display_name' => 'inspiring',
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'total_items' => 77559,
                    'description' => 'your spirits, lifted',
                    'name' => 'inspiring',
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 14941,
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'logo_destination_url' => undef,
                    'description_annotations' => {},
                    'thumbnail_hash' => undef,
                    'logo_hash' => undef,
                    'accent' => '81B057'
                    },
                    {
                    'accent' => '9E8BE6',
                    'thumbnail_hash' => undef,
                    'description_annotations' => {},
                    'logo_hash' => undef,
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'logo_destination_url' => undef,
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 1502630,
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'total_items' => 33038,
                    'name' => 'nostalgia',
                    'description' => 'Blast from the past!',
                    'background_hash' => 'IpEvTZs',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'display_name' => 'Nostalgia'
                    },
                    {
                    'accent' => '132D31',
                    'logo_hash' => undef,
                    'thumbnail_hash' => undef,
                    'description_annotations' => {},
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 2404185,
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'logo_destination_url' => undef,
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'background_hash' => 'DbQMO3A',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'display_name' => 'staff picks',
                    'name' => 'staff_picks',
                    'description' => 'Imgur\'s Favorites',
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'total_items' => 7251
                    },
                    {
                    'description' => 'Creative Creations',
                    'name' => 'art',
                    'total_items' => 305533,
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'background_hash' => '07cWFIo',
                    'display_name' => 'Art',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'logo_destination_url' => undef,
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 1503814,
                    'thumbnail_hash' => undef,
                    'description_annotations' => {},
                    'logo_hash' => undef,
                    'accent' => '9DCEC9'
                    },
                    {
                    'background_hash' => 'cqJ1tS4',
                    'display_name' => 'Food',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'name' => 'food',
                    'description' => '',
                    'total_items' => 78576,
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 82284,
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'logo_destination_url' => undef,
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'logo_hash' => undef,
                    'description_annotations' => {},
                    'thumbnail_hash' => undef,
                    'accent' => '2EA799'
                    },
                    {
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 1979110,
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'logo_destination_url' => undef,
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'background_hash' => 'LClCb8C',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'display_name' => 'anime',
                    'name' => 'anime',
                    'description' => 'japanese animation',
                    'total_items' => 77603,
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'accent' => '30814A',
                    'logo_hash' => undef,
                    'description_annotations' => {},
                    'thumbnail_hash' => undef
                    },
                    {
                    'logo_hash' => undef,
                    'description_annotations' => {},
                    'thumbnail_hash' => undef,
                    'accent' => 'D5590F',
                    'name' => 'gifs',
                    'description' => '',
                    'total_items' => 9149,
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'background_hash' => 'UuJ7clu',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'display_name' => 'GIFs',
                    'logo_destination_url' => undef,
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 43130,
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'}
                    },
                    {
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 83807,
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'logo_destination_url' => undef,
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'background_hash' => '1fDftsZ',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'display_name' => 'Comic Book Day',
                    'description' => 'September 25th is Comic Book Day!',
                    'name' => 'comic',
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'total_items' => 66634,
                    'accent' => '027B89',
                    'logo_hash' => undef,
                    'thumbnail_hash' => undef,
                    'description_annotations' => {}
                    },
                    {
                    'accent' => undef,
                    'thumbnail_hash' => '07uj52u',
                    'description_annotations' => {},
                    'logo_hash' => undef,
                    'logo_destination_url' => undef,
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 9927,
                    'description' => '',
                    'name' => 'cheese',
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'total_items' => 6259,
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'background_hash' => '07uj52u',
                    'display_name' => 'cheese'
                    },
                    {
                    'followers' => 6158,
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'logo_destination_url' => undef,
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'background_hash' => 'HMZMNek',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'display_name' => 'Plants',
                    'name' => 'plants',
                    'description' => 'The Home of Horticulture!',
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'total_items' => 11517,
                    'accent' => undef,
                    'logo_hash' => undef,
                    'description_annotations' => {},
                    'thumbnail_hash' => undef
                    },
                    {
                    'logo_destination_url' => undef,
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 263,
                    'name' => 'show_and_tell',
                    'description' => 'Share something you\'re excited about from 1/22 - 1/24 to earn a limited-time trophy! ',
                    'total_items' => 843,
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'background_hash' => 'k7wKBMt',
                    'display_name' => 'show and tell',
                    'accent' => undef,
                    'description_annotations' => {},
                    'thumbnail_hash' => undef,
                    'logo_hash' => undef
                    },
                    {
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 32474,
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'logo_destination_url' => undef,
                    'background_hash' => 'qaYq4fG',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'display_name' => 'dnd',
                    'total_items' => 24343,
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'description' => '',
                    'name' => 'dnd',
                    'accent' => '51535A',
                    'description_annotations' => {},
                    'thumbnail_hash' => undef,
                    'logo_hash' => undef
                    },
                    {
                    'logo_hash' => undef,
                    'description_annotations' => {},
                    'thumbnail_hash' => undef,
                    'accent' => '55B6C0',
                    'description' => '',
                    'name' => 'fashion',
                    'total_items' => 7194,
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'background_hash' => 'lewZBhq',
                    'display_name' => 'fashion',
                    'logo_destination_url' => undef,
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 14022,
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'}
                    },
                    {
                    'logo_hash' => undef,
                    'thumbnail_hash' => undef,
                    'description_annotations' => {},
                    'accent' => undef,
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'background_hash' => 'qXgoMzQ',
                    'display_name' => 'fireworks',
                    'total_items' => 2559,
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'description' => '',
                    'name' => 'fireworks',
                    'followers' => 2009,
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'logo_destination_url' => undef
                    },
                    {
                    'thumbnail_hash' => undef,
                    'description_annotations' => {},
                    'logo_hash' => undef,
                    'accent' => '9748B6',
                    'description' => 'that one time...',
                    'name' => 'storytime',
                    'total_items' => 100349,
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'background_hash' => 'pXmzlGx',
                    'display_name' => 'Storytime',
                    'logo_destination_url' => undef,
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 38367,
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'}
                    },
                    {
                    'accent' => undef,
                    'thumbnail_hash' => 'UZ42WEx',
                    'description_annotations' => {},
                    'logo_hash' => undef,
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 7520,
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'logo_destination_url' => undef,
                    'background_hash' => 'UZ42WEx',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'display_name' => 'writing',
                    'total_items' => 3879,
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'name' => 'writing',
                    'description' => ''
                    },
                    {
                    'accent' => '6A6E57',
                    'thumbnail_hash' => undef,
                    'description_annotations' => {},
                    'logo_hash' => undef,
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 26101,
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'logo_destination_url' => undef,
                    'background_hash' => 'xeEIpAn',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'display_name' => 'Caturday',
                    'total_items' => 60824,
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'name' => 'caturday',
                    'description' => ''
                    },
                    {
                    'description' => 'no limits',
                    'name' => 'creativity',
                    'total_items' => 445189,
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'background_hash' => 'BFfAJEN',
                    'display_name' => 'creativity',
                    'logo_destination_url' => undef,
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 2117538,
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'logo_hash' => undef,
                    'thumbnail_hash' => 'BFfAJEN',
                    'description_annotations' => {},
                    'accent' => '746A95'
                    },
                    {
                    'accent' => '5B62A5',
                    'description_annotations' => {},
                    'thumbnail_hash' => undef,
                    'logo_hash' => undef,
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 361,
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'logo_destination_url' => undef,
                    'background_hash' => 'iN4Gb0k',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'display_name' => 'beans',
                    'total_items' => 1213,
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'name' => 'beans',
                    'description' => ''
                    },
                    {
                    'logo_hash' => undef,
                    'thumbnail_hash' => undef,
                    'description_annotations' => {},
                    'accent' => '383C64',
                    'name' => 'coffee',
                    'description' => 'light roast or dark?',
                    'total_items' => 9471,
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'background_hash' => 'TYs43eJ',
                    'display_name' => 'Coffee',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'logo_destination_url' => undef,
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 1058184,
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'}
                    },
                    {
                    'accent' => '51535A',
                    'logo_hash' => undef,
                    'thumbnail_hash' => undef,
                    'description_annotations' => {},
                    'followers' => 4617,
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'logo_destination_url' => undef,
                    'display_name' => 'snake',
                    'background_hash' => 'gmFssAG',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'total_items' => 7508,
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'name' => 'snake',
                    'description' => ''
                    },
                    {
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'total_items' => 801,
                    'description' => 'Jan 15 is World Hat Day!',
                    'name' => 'hat',
                    'background_hash' => 'GEpMqov',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'display_name' => 'hat',
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'logo_destination_url' => undef,
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 165,
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'description_annotations' => {},
                    'thumbnail_hash' => undef,
                    'logo_hash' => undef,
                    'accent' => '1E5F43'
                    },
                    {
                    'logo_hash' => undef,
                    'thumbnail_hash' => undef,
                    'description_annotations' => {},
                    'accent' => '24565E',
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'total_items' => 22325,
                    'name' => 'sketch',
                    'description' => '',
                    'background_hash' => 'OHK1wWY',
                    'display_name' => 'sketch',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'logo_destination_url' => undef,
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 9316,
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'}
                    },
                    {
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 499,
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'logo_destination_url' => undef,
                    'background_hash' => '4bOlFT2',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'display_name' => 'cards',
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'total_items' => 1903,
                    'name' => 'cards',
                    'description' => 'Trading Card Day - Feb. 24th',
                    'accent' => '4D549A',
                    'logo_hash' => undef,
                    'description_annotations' => {},
                    'thumbnail_hash' => undef
                    },
                    {
                    'background_hash' => 'T79OvmE',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'display_name' => 'IronGIF',
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'total_items' => 553,
                    'description' => 'Welcome to the IronGIF Competition',
                    'name' => 'irongif',
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 5626,
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'logo_destination_url' => undef,
                    'logo_hash' => undef,
                    'thumbnail_hash' => 'T79OvmE',
                    'description_annotations' => {},
                    'accent' => '193E44'
                    },
                    {
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'logo_destination_url' => undef,
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 4037,
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'total_items' => 10467,
                    'name' => 'artcrawl',
                    'description' => 'Join the 2024 Imgur Art Crawl',
                    'background_hash' => 'jWuN8LR',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'display_name' => 'artcrawl',
                    'accent' => 'FF51BA',
                    'logo_hash' => undef,
                    'thumbnail_hash' => undef,
                    'description_annotations' => {}
                    },
                    {
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'background_hash' => 'W5yeBvr',
                    'display_name' => 'Wholesome',
                    'name' => 'wholesome',
                    'description' => '',
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'total_items' => 40127,
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 59991,
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'logo_destination_url' => undef,
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'thumbnail_hash' => undef,
                    'description_annotations' => {},
                    'logo_hash' => undef,
                    'accent' => '5D85C3'
                    },
                    {
                    'name' => 'eat_what_you_want',
                    'description' => 'food and recipes',
                    'total_items' => 66065,
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'display_name' => 'Eat What You Want',
                    'background_hash' => 'I4fcJtP',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'logo_destination_url' => undef,
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 1864577,
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'description_annotations' => {},
                    'thumbnail_hash' => undef,
                    'logo_hash' => undef,
                    'accent' => 'D6707C'
                    },
                    {
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 936,
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'logo_destination_url' => undef,
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'background_hash' => 'KywZDY4',
                    'display_name' => 'Leap Day',
                    'name' => 'leap_day',
                    'description' => 'How are you spending your extra day?',
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'total_items' => 1208,
                    'accent' => '20bee8',
                    'thumbnail_hash' => undef,
                    'description_annotations' => {},
                    'logo_hash' => undef
                    },
                    {
                    'display_name' => 'the great outdoors',
                    'background_hash' => 'SVm9n13',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'description' => 'go outside',
                    'name' => 'the_great_outdoors',
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'total_items' => 53869,
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 110508,
                    'logo_destination_url' => undef,
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'thumbnail_hash' => undef,
                    'description_annotations' => {},
                    'logo_hash' => undef,
                    'accent' => '436864'
                    },
                    {
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 2049,
                    'logo_destination_url' => undef,
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'display_name' => 'Superb Owl',
                    'background_hash' => '8uK7G2e',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'name' => 'superb_owl',
                    'description' => 'Happy Superb Owl Sunday!',
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'total_items' => 1415,
                    'accent' => '964B00',
                    'description_annotations' => {},
                    'thumbnail_hash' => undef,
                    'logo_hash' => undef
                    },
                    {
                    'background_hash' => '4JLa40c',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'display_name' => 'Valentine\'s Day',
                    'name' => 'valentines_day',
                    'description' => '',
                    'total_items' => 10666,
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 5953,
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'logo_destination_url' => undef,
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'logo_hash' => undef,
                    'thumbnail_hash' => undef,
                    'description_annotations' => {},
                    'accent' => 'C93535'
                    },
                    {
                    'accent' => '1E5F43',
                    'description_annotations' => {},
                    'thumbnail_hash' => undef,
                    'logo_hash' => undef,
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'logo_destination_url' => undef,
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 2487,
                    'total_items' => 3765,
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'description' => 'Spring has sprung! ',
                    'name' => 'spring',
                    'background_hash' => 'GEpMqov',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'display_name' => 'spring'
                    },
                    {
                    'background_hash' => 'IkZeAAy',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'display_name' => 'museum',
                    'total_items' => 1518,
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'description' => '',
                    'name' => 'museum',
                    'followers' => 594,
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'logo_destination_url' => undef,
                    'logo_hash' => undef,
                    'thumbnail_hash' => undef,
                    'description_annotations' => {},
                    'accent' => '4070B5'
                    },
                    {
                    'thumbnail_hash' => undef,
                    'description_annotations' => {},
                    'logo_hash' => undef,
                    'accent' => undef,
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'background_hash' => 'LxnM4Kd',
                    'display_name' => 'new years resolution',
                    'name' => 'new_years_resolution',
                    'description' => 'Happy 2024! New Year, New Me. (But seriously this time.)',
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'total_items' => 1140,
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 832,
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'logo_destination_url' => undef,
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'}
                    },
                    {
                    'accent' => 'BC56B2',
                    'logo_hash' => undef,
                    'description_annotations' => {},
                    'thumbnail_hash' => undef,
                    'logo_destination_url' => undef,
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 5377,
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'description' => '',
                    'name' => 'oldschoolcool',
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'total_items' => 5282,
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'background_hash' => '5uFU9FR',
                    'display_name' => 'oldschoolcool'
                    },
                    {
                    'accent' => '2084B0',
                    'description_annotations' => {},
                    'thumbnail_hash' => undef,
                    'logo_hash' => undef,
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 2177093,
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'logo_destination_url' => undef,
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'background_hash' => 'JdeWoaA',
                    'display_name' => 'movies and tv',
                    'total_items' => 64870,
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'name' => 'movies_and_tv',
                    'description' => 'start your binge'
                    },
                    {
                    'description_annotations' => {},
                    'thumbnail_hash' => undef,
                    'logo_hash' => undef,
                    'accent' => '4D549A',
                    'background_hash' => '4bOlFT2',
                    'display_name' => 'vacation',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'description' => 'Jan. 30th is National Escape Day!',
                    'name' => 'vacation',
                    'total_items' => 2657,
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 1284,
                    'logo_destination_url' => undef,
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'}
                    },
                    {
                    'logo_hash' => undef,
                    'description_annotations' => {},
                    'thumbnail_hash' => undef,
                    'accent' => '5B62A5',
                    'display_name' => 'imgurstickers',
                    'background_hash' => 'iN4Gb0k',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'description' => 'Jan 13 is National Sticker Day! For your chance to win some Imgur stickers, share a photo of where you\'d put them.',
                    'name' => 'imgurstickers',
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'total_items' => 344,
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 450,
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'logo_destination_url' => undef,
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'}
                    },
                    {
                    'background_hash' => 'nvBUSjG',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'display_name' => 'fitness',
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'total_items' => 13419,
                    'description' => 'getting swole',
                    'name' => 'fitness',
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 1347706,
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'logo_destination_url' => undef,
                    'description_annotations' => {},
                    'thumbnail_hash' => undef,
                    'logo_hash' => undef,
                    'accent' => 'F17B62'
                    },
                    {
                    'description_annotations' => {},
                    'thumbnail_hash' => undef,
                    'logo_hash' => undef,
                    'accent' => '0B714D',
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'total_items' => 9130,
                    'name' => 'dragon',
                    'description' => '',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'background_hash' => '6POSyuF',
                    'display_name' => 'dragon',
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'logo_destination_url' => undef,
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 7090
                    },
                    {
                    'accent' => '4D5799',
                    'description_annotations' => {},
                    'thumbnail_hash' => undef,
                    'logo_hash' => undef,
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'logo_destination_url' => undef,
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 1873312,
                    'total_items' => 39553,
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'description' => 'Fresh beats and hot jams',
                    'name' => 'music',
                    'background_hash' => 'unNHCfV',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'display_name' => 'Music'
                    },
                    {
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 7689,
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'logo_destination_url' => undef,
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'background_hash' => '7bemn9H',
                    'display_name' => 'baseball',
                    'description' => '',
                    'name' => 'baseball',
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'total_items' => 5140,
                    'accent' => '51535A',
                    'logo_hash' => undef,
                    'thumbnail_hash' => undef,
                    'description_annotations' => {}
                    },
                    {
                    'total_items' => 3928,
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'name' => 'potato',
                    'description' => '',
                    'background_hash' => 'iN4Gb0k',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'display_name' => 'potato',
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'logo_destination_url' => undef,
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 956,
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'logo_hash' => undef,
                    'description_annotations' => {},
                    'thumbnail_hash' => undef,
                    'accent' => '5B62A5'
                    },
                    {
                    'accent' => '8472BD',
                    'logo_hash' => undef,
                    'thumbnail_hash' => undef,
                    'description_annotations' => {},
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 1583239,
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'logo_destination_url' => undef,
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'background_hash' => '4kmYoey',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'display_name' => 'awesome',
                    'name' => 'awesome',
                    'description' => 'neat and amazing',
                    'total_items' => 708468,
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'}
                    },
                    {
                    'description_annotations' => {},
                    'thumbnail_hash' => undef,
                    'logo_hash' => undef,
                    'accent' => undef,
                    'description' => 'Showcasing the best of Science Fiction. Share your favorite Sci-Fi moments and memorabilia January 2nd-4th for a limited-time trophy!',
                    'name' => 'sci_fi',
                    'total_items' => 9707,
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'background_hash' => '5T0MyKm',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'display_name' => 'Sci-Fi',
                    'logo_destination_url' => undef,
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 9024
                    },
                    {
                    'background_hash' => 'gbuk2AN',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'display_name' => 'animals',
                    'total_items' => 127249,
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'name' => 'animals',
                    'description' => '',
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 95967,
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'logo_destination_url' => undef,
                    'description_annotations' => {},
                    'thumbnail_hash' => undef,
                    'logo_hash' => undef,
                    'accent' => '4D549A'
                    },
                    {
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 688892,
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'logo_destination_url' => undef,
                    'background_hash' => 'hbGXLre',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'display_name' => 'pizza',
                    'total_items' => 15578,
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'name' => 'pizza',
                    'description' => 'slices of joy',
                    'accent' => '00B2B3',
                    'thumbnail_hash' => undef,
                    'description_annotations' => {},
                    'logo_hash' => undef
                    },
                    {
                    'accent' => '20A4AD',
                    'description_annotations' => {},
                    'thumbnail_hash' => undef,
                    'logo_hash' => undef,
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'logo_destination_url' => undef,
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 2605867,
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'total_items' => 110275,
                    'name' => 'nature',
                    'description' => 'the great outdoors',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'background_hash' => 'HMZMNek',
                    'display_name' => 'nature'
                    },
                    {
                    'name' => 'cool',
                    'description' => '',
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'total_items' => 37761,
                    'background_hash' => 'MzGWCAw',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'display_name' => 'cool',
                    'logo_destination_url' => undef,
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 67474,
                    'description_annotations' => {},
                    'thumbnail_hash' => undef,
                    'logo_hash' => undef,
                    'accent' => '34629F'
                    },
                    {
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'logo_destination_url' => undef,
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 73551,
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'total_items' => 78239,
                    'name' => 'puppy',
                    'description' => 'Nothing beats puppies',
                    'background_hash' => 'lkYeYSq',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'display_name' => 'Puppy',
                    'accent' => '6694DC',
                    'logo_hash' => undef,
                    'thumbnail_hash' => undef,
                    'description_annotations' => {}
                    },
                    {
                    'total_items' => 40742,
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'name' => 'history',
                    'description' => 'learn from the past',
                    'background_hash' => 'asua4R3',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'display_name' => 'history',
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'logo_destination_url' => undef,
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 1437926,
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'description_annotations' => {},
                    'thumbnail_hash' => 'asua4R3',
                    'logo_hash' => undef,
                    'accent' => '613C21'
                    },
                    {
                    'total_items' => 38031,
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'description' => '',
                    'name' => 'science',
                    'background_hash' => 'PjlmLGa',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'display_name' => 'Science',
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'logo_destination_url' => undef,
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 47170,
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'logo_hash' => undef,
                    'description_annotations' => {},
                    'thumbnail_hash' => undef,
                    'accent' => '159559'
                    },
                    {
                    'background_hash' => '1z4dgZT',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'display_name' => 'memes',
                    'description' => 'the freshest memes',
                    'name' => 'memes',
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'total_items' => 551779,
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 2812259,
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'logo_destination_url' => undef,
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'logo_hash' => undef,
                    'description_annotations' => {},
                    'thumbnail_hash' => undef,
                    'accent' => 'ba519f'
                    },
                    {
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 1280451,
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'logo_destination_url' => undef,
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'background_hash' => '2SY3iGT',
                    'display_name' => 'Star Wars',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'description' => 'a galaxy far, far away',
                    'name' => 'star_wars',
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'total_items' => 73519,
                    'accent' => '5A6677',
                    'logo_hash' => undef,
                    'thumbnail_hash' => undef,
                    'description_annotations' => {}
                    },
                    {
                    'thumbnail_hash' => undef,
                    'description_annotations' => {},
                    'logo_hash' => undef,
                    'accent' => 'C56579',
                    'total_items' => 51573,
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'name' => 'pokemon',
                    'description' => 'Gotta catch \'em all',
                    'background_hash' => '6Hxkaw9',
                    'display_name' => 'Pokemon',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'logo_destination_url' => undef,
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 925095,
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'}
                    },
                    {
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 136998,
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'logo_destination_url' => undef,
                    'display_name' => 'Mildly Interesting',
                    'background_hash' => 'oAtvuB2',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'total_items' => 96566,
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'description' => 'Things to make you go "hmm." ',
                    'name' => 'mildly_interesting',
                    'accent' => '16A943',
                    'logo_hash' => undef,
                    'thumbnail_hash' => undef,
                    'description_annotations' => {}
                    },
                    {
                    'logo_destination_url' => undef,
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 11731,
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'description' => '',
                    'name' => 'technology',
                    'total_items' => 10558,
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'background_hash' => 'Ikykl3U',
                    'display_name' => 'technology',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'accent' => '008261',
                    'logo_hash' => undef,
                    'description_annotations' => {},
                    'thumbnail_hash' => undef
                    },
                    {
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'background_hash' => 'yWpvDy6',
                    'display_name' => 'games',
                    'description' => 'December 20th is International Games Day!',
                    'name' => 'games',
                    'total_items' => 15494,
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 9924,
                    'logo_destination_url' => undef,
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'description_annotations' => {},
                    'thumbnail_hash' => undef,
                    'logo_hash' => undef,
                    'accent' => undef
                    },
                    {
                    'thumbnail_hash' => undef,
                    'description_annotations' => {},
                    'logo_hash' => undef,
                    'accent' => '2E6197',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'background_hash' => 'eWY7qg5',
                    'display_name' => 'environment',
                    'total_items' => 1999,
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'description' => 'Jan 26th is International Environmental Education Day!j',
                    'name' => 'environment',
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 1186,
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'logo_destination_url' => undef
                    },
                    {
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'total_items' => 6836,
                    'description' => '',
                    'name' => 'oddly_satisfying',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'background_hash' => 'R1dEESs',
                    'display_name' => 'oddly satisfying',
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'logo_destination_url' => undef,
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 46940,
                    'description_annotations' => {},
                    'thumbnail_hash' => undef,
                    'logo_hash' => undef,
                    'accent' => '5E58CB'
                    },
                    {
                    'description' => 'March 10th is Mar10 Day! ',
                    'name' => 'mario',
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'total_items' => 5662,
                    'background_hash' => 'gmFssAG',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'display_name' => 'mario',
                    'logo_destination_url' => undef,
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 3219,
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'logo_hash' => undef,
                    'thumbnail_hash' => undef,
                    'description_annotations' => {},
                    'accent' => '51535A'
                    },
                    {
                    'accent' => '155C71',
                    'thumbnail_hash' => undef,
                    'description_annotations' => {},
                    'logo_hash' => undef,
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 23766,
                    'logo_destination_url' => undef,
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'background_hash' => 'LjiOCqJ',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'display_name' => 'ocean',
                    'description' => '',
                    'name' => 'ocean',
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'total_items' => 6413
                    },
                    {
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 502394,
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'logo_destination_url' => undef,
                    'background_hash' => 'FH6o1Tp',
                    'display_name' => 'star trek',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'total_items' => 17503,
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'description' => 'live long and prosper',
                    'name' => 'star_trek',
                    'accent' => undef,
                    'thumbnail_hash' => undef,
                    'description_annotations' => {},
                    'logo_hash' => undef
                    },
                    {
                    'thumbnail_hash' => undef,
                    'description_annotations' => {},
                    'logo_hash' => undef,
                    'accent' => '4070B5',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'background_hash' => 'IkZeAAy',
                    'display_name' => 'relatable',
                    'name' => 'relatable',
                    'description' => '',
                    'total_items' => 5917,
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 7754,
                    'logo_destination_url' => undef,
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'}
                    },
                    {
                    'logo_destination_url' => undef,
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 18748,
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'description' => 'Inspiring innovations ',
                    'name' => 'engineering',
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'total_items' => 5315,
                    'background_hash' => 'c9WHHFu',
                    'display_name' => 'Engineering',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'accent' => '83898E',
                    'logo_hash' => undef,
                    'description_annotations' => {},
                    'thumbnail_hash' => undef
                    },
                    {
                    'thumbnail_hash' => undef,
                    'description_annotations' => {},
                    'logo_hash' => undef,
                    'accent' => '136D5D',
                    'total_items' => 31772,
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'name' => 'cars',
                    'description' => 'Motorheads unite!',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'background_hash' => 'QYuu3Cf',
                    'display_name' => 'cars',
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'logo_destination_url' => undef,
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 34170
                    },
                    {
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'background_hash' => 'cHaxWH1',
                    'display_name' => 'the more you know',
                    'description' => 'March 14th is International Genius Day! ',
                    'name' => 'the_more_you_know',
                    'total_items' => 274738,
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 1690319,
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'logo_destination_url' => undef,
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'logo_hash' => undef,
                    'description_annotations' => {},
                    'thumbnail_hash' => undef,
                    'accent' => '21B86E'
                    },
                    {
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 23716,
                    'logo_destination_url' => undef,
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'background_hash' => 'Z7iodQm',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'display_name' => 'birds',
                    'name' => 'birds',
                    'description' => 'Jan. 5 is National Bird Day! ',
                    'total_items' => 23413,
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'accent' => '225956',
                    'description_annotations' => {},
                    'thumbnail_hash' => undef,
                    'logo_hash' => undef
                    },
                    {
                    'logo_hash' => undef,
                    'thumbnail_hash' => undef,
                    'description_annotations' => {},
                    'accent' => 'B85E44',
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'total_items' => 7368,
                    'name' => 'water',
                    'description' => 'World Water Day is March 22nd, 2024',
                    'background_hash' => '5uFU9FR',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'display_name' => 'Water',
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'logo_destination_url' => undef,
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 4474,
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'}
                    },
                    {
                    'accent' => '008261',
                    'logo_hash' => undef,
                    'description_annotations' => {},
                    'thumbnail_hash' => undef,
                    'followers' => 3614,
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'logo_destination_url' => undef,
                    'background_hash' => 'Ikykl3U',
                    'display_name' => 'Math',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'total_items' => 4688,
                    'name' => 'math',
                    'description' => ''
                    },
                    {
                    'logo_hash' => undef,
                    'thumbnail_hash' => undef,
                    'description_annotations' => {},
                    'accent' => '83898E',
                    'background_hash' => 'c9WHHFu',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'display_name' => 'magic',
                    'description' => '',
                    'name' => 'magic',
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'total_items' => 5655,
                    'followers' => 7785,
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'logo_destination_url' => undef,
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'}
                    },
                    {
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 899733,
                    'logo_destination_url' => undef,
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'display_name' => 'lego',
                    'background_hash' => 'gHbtPSY',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'description' => 'build from bricks',
                    'name' => 'lego',
                    'total_items' => 18450,
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'accent' => undef,
                    'thumbnail_hash' => undef,
                    'description_annotations' => {},
                    'logo_hash' => undef
                    },
                    {
                    'accent' => '008261',
                    'logo_hash' => undef,
                    'thumbnail_hash' => undef,
                    'description_annotations' => {},
                    'logo_destination_url' => undef,
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 5335,
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'name' => 'aliens',
                    'description' => 'Extra-Terrestrial Activity!',
                    'total_items' => 6913,
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'background_hash' => 'Ikykl3U',
                    'display_name' => 'Aliens',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'}
                    },
                    {
                    'logo_destination_url' => undef,
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 6780611,
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'name' => 'funny',
                    'description' => 'LOLs, ROFLs, LMAOs',
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'total_items' => 2554441,
                    'background_hash' => '9r1qCDq',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'},
                    'display_name' => 'Funny',
                    'accent' => '633875',
                    'logo_hash' => undef,
                    'description_annotations' => {},
                    'thumbnail_hash' => undef
                    },
                    {
                    'accent' => undef,
                    'logo_hash' => undef,
                    'description_annotations' => {
                        'hashtag' => [
                            {
                                'indices' => [
                                    44,
                                    51
                                ],
                                'tag' => 'ticket'
                            }
                        ]
                    },
                    'thumbnail_hash' => undef,
                    'is_promoted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'followers' => 14,
                    'following' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'thumbnail_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'logo_destination_url' => undef,
                    'background_hash' => 'RYlk7RJ',
                    'is_whitelisted' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'display_name' => 'ticket',
                    'total_items' => 75,
                    'background_is_animated' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'is_ad'},
                    'description' => 'The Carnival is in town! Tag your post with #ticket to see what mysteries await you.',
                    'name' => 'ticket'
                    }
                ],
        'featured' => 'baseball'
    },
    'success' => $VAR1->{'data'}{'galleries'}[0]{'topPost'}{'in_gallery'}
}
=cut
